# 音视频开发概述


OpenHarmony音视频包括音视频播放和录制。


- OpenHarmony音视频播放模块支持音视频播放业务的开发，主要包括音视频文件和音视频流播放、音量和播放进度控制等。

- OpenHarmony录制模块支持音视频录制业务的开发，提供音视频录制相关的功能，包括设置录制视频画面尺寸、音视频编码码率、编码器类型、视频帧率、音频采样率、录制文件输出格式等。


## 基本概念

在进行应用的开发OpenHarmony前，开发者应了解以下基本概念：

- 流媒体技术
  流媒体技术是把连续的影像和声音信息进行编码处理后放在网络服务器上，让浏览者一边下载、一边观看与收听，而不需要等整个多媒体文件下载完成就可以即时观看、收听的技术。

- 视频帧率
  帧率是用于测量显示帧数的度量，帧数就是在每秒钟时间里传输的图片数量。每秒钟帧数 (FPS) 越多，所显示的画面就会越流畅。

- 码率
  码率就是数据传输时单位时间传送的数据位数，常用单位是kbps即千位每秒。

- 采样率
  采样率为每秒从连续信号中提取并组成离散信号的采样个数，单位用赫兹（Hz）来表示。


## 编解码规格

OpenHarmony音视频编解码能力取决于具体设备类型，以当前已支持的开发板为例，规格见下表：

  **表1** 不同开发板编解码规格

| 设备类型 | 开发板类型 | 解码规格 | 编码规格 | 
| -------- | -------- | -------- | -------- |
| 带屏摄像头类产品 | Hi3516 | -&nbsp;音频解码：支持MPEG-4&nbsp;AAC&nbsp;Profile&nbsp;(AAC&nbsp;LC)格式解码，支持单/双声道，支持MPEG-4(.mp4，.m4a)容器格式。<br/>-&nbsp;视频解码：支持H.265&nbsp;HEVC/H.264&nbsp;AVC格式解码（限自身编码码流），支持MPEG-4(.mp4)容器格式。 | -&nbsp;音频编码：支持音频AAC_LC编码，支持单/双声道，支持MPEG-4(.mp4)容器格式。<br/>-&nbsp;视频编码：支持视频H.264/H.265编码，支持MPEG-4(.mp4)容器格式。 | 
| 无屏摄像头类产品 | Hi3518 | -&nbsp;音频解码：支持MPEG-4&nbsp;AAC&nbsp;Profile&nbsp;(AAC&nbsp;LC)格式解码，支持单/双声道，支持MPEG-4(.mp4，.m4a)容器格式。<br/>-&nbsp;视频解码：- | -&nbsp;音频编码：支持音频AAC_LC编码，支持单/双声道，支持MPEG-4(.mp4)容器格式。<br/>-&nbsp;视频编码：支持视频H.264/H.265编码，支持MPEG-4(.mp4)容器格式。 | 
| WLAN连接类设备 | Hi3861 | - | - | 

Hi3516和Hi3518更多详细的编解码规格请参考开发板自带的资料。
