# OpenHarmony 3.1 Release


## Version Description

OpenHarmony 3.1 Release provides the following enhancements over OpenHarmony 3.1 Beta:

**Enhanced basic capabilities for the standard system**

Local basic audio/video playback capabilities, video hardware codecs, basic camera preview and photographing capabilities.

RenderService framework, 2D/3D drawing, and new animation and display effect framework.

A new window management framework, which provides more flexible window framework capabilities and supports full-screen, split-screen, window modes, and cross-window content dragging.

Display management capability that supports split-screen display, enhanced screen-on/off management, and window animation and effect.

Basic functions of the mouse, keyboard, and touchpad, and basic capabilities of common sensors such as acceleration sensors, gyroscope sensors, Hall effect sensors, and vibrators.

Locale selection, new and enhanced internationalization features, system resources, and rawfile resources.

Management for time and time zone synchronization, pasteboard, lock screen, static wallpaper, and downloading.

System service status monitoring, cross-device oncall (cross-device FA startup), continuous tasks, transient tasks, and Work Scheduler.

Enhanced memory management, basic power management, and enhanced process scheduling.

Local accounts, binding of domain accounts and local accounts, distributed account ID derivation and status management, local application permission management, and distributed permission management.

Basic capabilities and JS APIs related to Wi-Fi Station (STA), Access Point (AP), and Point-to-Point (P2P); Capabilities and JS APIs related to Bluetooth Basic Rate (BR), Bluetooth Serial Port Profile (SPP), and Bluetooth Low Energy (BLE); new location subsystem that provides the location service framework capability.

**Enhanced distributed capabilities for the standard system**

DSoftBus network switching, P2P connection, streaming, and Bluetooth.

Enhanced hardware collaboration and resource sharing: mirroring and extended projection.

Enhanced device online/offline and personal identification number (PIN) authentication functions, storage management, application sandbox isolation, public data sandbox isolation, distributed databases, distributed data objects, local database access, and cross-application database access.

**Enhanced application framework capabilities for the standard system**

ArkUI custom drawing, Lottie animations, and keyboard and mouse interaction.

Declarative **\<Web>** and **XComponent** components.

Widget capabilities, including adding, deleting, and updating widgets.

Multi-user capability: multi-device basic JS toolchain and runtime capability; basic functions such as multi-HAP installation, implicit query, multi-user, and permission management; distributed notification and notification templates.

**Enhanced application capabilities for the standard system**

More system applications, including the Home Screen, System UI, Settings, Camera, Gallery, Call, Contacts, Messaging, Notepad, File Selector, and Input Method.


## Version Mapping

  **Table 1** Version mapping of software and tools

| Software/Tool| Version| Remarks|
| -------- | -------- | -------- |
| OpenHarmony | 3.1&nbsp;Release | NA |
| SDK | Ohos_sdk 3.1 Release (API Version 8 Beta)| NA |
| (Optional) HUAWEI DevEco Studio| 3.0&nbsp;Beta3&nbsp;for&nbsp;OpenHarmony | Recommended for developing OpenHarmony applications|
| (Optional) HUAWEI DevEco Device Tool| 3.0&nbsp;Release | Recommended for developing OpenHarmony smart devices|


## Source Code Acquisition


### Prerequisites

1. Register your account with Gitee.

2. Register an SSH public key for access to Gitee.

3. Install the [git client](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) and [git-lfs](https://gitee.com/vcs-all-in-one/git-lfs?_from=gitee_search#downloading), and configure user information.
  
   ```
   git config --global user.name "yourname"
   git config --global user.email "your-email-address"
   git config --global credential.helper store
   ```

4. Run the following commands to install the **repo** tool:
  
   ```
   curl -s https://gitee.com/oschina/repo/raw/fork_flow/repo-py3 > /usr/local/bin/repo  # If you do not have the permission, download it to another directory and configure it as an environment variable by running the chmod a+x /usr/local/bin/repo command.
   pip3 install -i https://repo.huaweicloud.com/repository/pypi/simple requests
   ```


### Acquiring Source Code Using the repo Tool

**Method 1 (recommended)**

Use the **repo** tool to download the source code over SSH. (You must have an SSH public key for access to Gitee.)


```
repo init -u git@gitee.com:openharmony/manifest.git -b refs/tags/OpenHarmony-v3.1-Release --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
```

**Method 2**

Use the **repo** tool to download the source code over HTTPS.


```
repo init -u https://gitee.com/openharmony/manifest.git -b refs/tags/OpenHarmony-v3.1-Release --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
```

### Acquiring Source Code from Mirrors

**Table 2** Mirrors for acquiring source code

| Source Code                               | Version| Mirror                                                | SHA-256 Checksum                                            |
| --------------------------------------- | ------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| Full code base (for mini, small, and standard systems)       | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/code-v3.1-Release.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/code-v3.1-Release.tar.gz.sha256)|
| Hi3516 standard system solution (binary)       | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/standard_hi3516.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/standard_hi3516.tar.gz.sha256)|
| RK3568 standard system solution (binary)       | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/standard_rk3568.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/standard_rk3568.tar.gz.sha256)|
| Hi3861 mini system solution (binary)       | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_pegasus.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_pegasus.tar.gz.sha256)|
| Hi3516 mini system solution - LiteOS (binary)| 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_taurus.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_taurus.tar.gz.sha256)|
| Hi3516 mini system solution - Linux (binary) | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_taurus_linux.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/hispark_taurus_linux.tar.gz.sha256)|
| Standard system SDK package (macOS)                   | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/ohos-sdk-mac.tar.gz)| [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/ohos-sdk-mac.tar.gz.sha256)|
| Standard system SDK package (Windows/Linux)         | 3.1 Release  | [Download](https://repo.huaweicloud.com/harmonyos/os/3.1-Release/ohos-sdk.tar.gz)| [Download]((https://repo.huaweicloud.com/harmonyos/os/3.1-Release/ohos-sdk.tar.gz.sha256)|
| Compiler toolchain                     | -            | [Download](https://repo.huaweicloud.com/harmonyos/os/2.0/tool_chain/)| -                                                            |




## What's New

This version has the following updates to OpenHarmony 3.1 Beta.


### Feature Updates

**Table 3** Feature updates

| Subsystem| Standard System| Mini and Small Systems|
| -------- | -------- | -------- |
| Resource scheduling| - Continuous tasks, transient tasks, and Work Scheduler are added.<br>- Reminder agents are added.<br>The following requirements are involved:<br>I4QT41 [New feature] Reminder agent management<br>I4QU0W [New feature] Transient task management<br>I4QT3S [New feature] Continuous task management<br>I4QU0P [New feature] Work Scheduler<br>I4QT45 [New feature] Querying historical application usage statistics within a given time range| NA |
| Multimodal input| - The basic functions of the mouse, keyboard, and touchpad are supported.<br>- Subscription to full-screen gesture events is supported.<br>The following requirements are involved:<br>I4WWRZ [Multimodal] Mouse button functions<br>I4WWS0 [Multimodal] Mouse wheel function<br>I4WWSR [Multimodal] Basic keyboard functions<br>I4WWT8 [Multimodal] Basic touchpad functions<br>I4WWSN [Multimodal] Subscription of single-system key events| NA |
| System service management| - The function of system service status monitoring is added.<br>- The function of dynamically loading local system services is added.<br>- The functions of adding, deleting, modifying, querying, and synchronizing device profiles are added.<br>- The function of registering device profile events is added.<br>- An ability continuation framework is added to supports continuation of distributed objects and application stack information on another device.<br>- Cross-device oncall (remote FA startup) is added.<br>- The capability of obtaining remote device missions and mission snapshots in real time is added.<br>The following requirements are involved:<br>I4MBRV [Samgr] System service status monitoring<br>I4MBRY [Samgr] System service process management<br>I4NY1T [device_profile] Subscription of profile changes.<br>I4NY1W [device_profile] Profile synchronization<br>I4NY1X [device_profile] Remote device profile query<br>I4OGD1 [New feature] [DMS] Cross-device oncall<br>I4OGCK [Enhanced feature] Returning the continuation result after the distributed object synchronization is complete<br>I4OGCL [Enhanced feature] [Framework] Data storage for ability continuation<br>I4OGCN [Enhanced feature] [DMS] Initiating ability continuation by device and receiving the continuation result<br>I4OGCM [New feature] [Task management] APIs for real-time mission retrieval| I4TS0Z [New feature] Remote service management by mini-system Samgr|
| Distributed hardware| - The distributed hardware subsystem is added, which involves three code repositories: distributed hardware management framework, distributed camera, and distributed screen.<br>- The following device management functions are added: peripheral device discovery, device online/offline, and PIN authentication.<br>The following requirements are involved:<br>I4PZE7 [Enhanced feature] Discovery of peripheral untrusted devices<br>I4PZDZ [Enhanced feature] PIN authentication for account-irrelevant devices<br>I4PZDY [Enhanced feature] Query of the trusted device list and device online/offline monitoring<br>I4WVOC [New feature] Distributed hardware enabling/disabling and dynamic loading<br>I4WVMX [New feature] Distributed hardware access management<br>I4WW6U [New feature] Mirroring and extended display of distributed screens| I4XSUZ [New feature] Basic device management for the mini system|
| Power management|  <br>Power management, battery management, thermal management, and power consumption statistics are supported.<br>The following requirements are involved:<br>I40IRO [Power management] Hibernation and hybrid sleep modes<br>I412F4 [Power management] Power saving mode<br>I4MBRL [Power management] Display-related power consumption adjustment<br>I4MBRM [Power management] Proximity sensor lock: During a call, the screen can be turned on or off by using the proximity sensor.<br>I4OEOZ [Power management] Monitoring of input screen-on events and turning on or off the screen based on the events<br>I4OEQT [Power management] Screen-off detection<br>I4QGI0 [Power management] Pressing and holding the **Power** button to display the shutdown screen<br>I410YD [Battery management] Charging while the device is shut down<br>I410Y1 [battery management] Shutdown due to abnormal battery temperature<br>I4GY9U [Thermal management] Kernel temperature control<br>I4GYAF [Thermal management] User layer and service temperature control<br>I4GYBV [Thermal management] Temperature monitoring API<br>I4GYCD [Power consumption statistics] Software power consumption statistics<br>I4GYCN [Power consumption statistics] Hardware power consumption statistics<br>I4GYDQ [Power consumption statistics] Power consumption details| NA |
| Account| - The lifecycle of local accounts (also called system accounts) can be managed, including creating, switching, deleting, subscribing to, querying, and modifying local accounts.<br>- Distributed account ID derivation and status management are supported. When a distributed account logs in, a unique account ID is derived and bound to the local account. When the distributed account logs out or the token expires, the binding between the distributed account and the local account is removed.<br>- The function of binding a domain account to a local account is added. A local account is automatically created based on the passed domain account and bound to the domain account.<br>- The **acm** command is added for local account management. You can run the **acm create/delete/switch/dump** command to add, delete, modify, or query local accounts, and the **acm --help** command to view the command description.<br>I4JBFB Account status management in a distributed network<br>I4JBEK Account ID derivation in a distributed network<br>I4IU6N Local multi-user basic information management<br>I4IU5W Local multi-user lifecycle management of the **os_account_standard** component<br>I4IU5G Local multi-user auxiliary management tool<br>I4IU3V Mappings between domain accounts and local accounts<br>I4IU3B Local multi-user start, stop, and switching<br>I4IU33 Local multi-user function setting and content modification| NA |
| Kernel| - Memory management enhancement features, including Continuous Memory Allocator (CMA), shared memory, and enhanced memory swapping, are added to improve memory usage efficiency.<br>- Process scheduling enhancement features, including CPU hotplug, lightweight isolation, and preferential supply for frame drawing threads, are added to improve CPU usage and enhance resource supply in sliding scenarios.<br>- The latest kernel security vulnerability patch and other security hardening mechanisms, such as token ID configuration and query, are supported.<br>The following requirements are involved:<br>I4MBTN [New feature] CMA<br>I4MBTO [New feature] Memory usage query by category<br>I4LKQ0 [New feature] Decoupling between cpuset and CPU hotplug<br>I4QE9K [New feature] Kernel sharing between the kernel-mode driver and the user-mode driver, and between a pair of user-mode drivers<br>I4LRGQ [New feature] OpenHarmony kernel baseline enablement<br>I4RXQ3 [New feature] Basic memory management features<br>I4TEGS [New feature] Performance optimization for F2FS when there is little storage space available<br>I4SRVK [New feature] Lightweight CPU isolation<br>I4SE2N [New feature] User-specific memory resource management<br>I4VMGZ [New feature] Basic Frame Per Second (FPS) awareness scheduling<br>I4U089 [New feature] Preferential supply for frame drawing threads<br>I4OWTZ [External dependency] Token ID setting for processes| NA |
| Bundle management framework| - Multi-HAP installation, implicit query, multi-user management, and authority management are supported.<br>- Distributed capabilities such as Database Management System (DBMS) and cross-device synchronization are added.<br>- The zlib native SDK is supported.<br>The following requirements are involved:<br>I4MBSD [New feature] Multi-HAP installation<br>I4MBSG [Enhanced feature] Installation package information query<br>I4PKY7 [New feature] Cross-device information synchronization<br>I4PKY8 [New feature] Cross-device information query<br>I4PKYK [Enhanced feature] Scanning<br>I4PKYI [New feature] Data clearing<br>I4PKYM [New feature] Multi-user creation<br>I4QA3D [Enhanced feature] Native APIs (NAPIs) for zlib compression and decompression<br>I4SIH9 [New feature] Application permission management| NA |
| Location| - The location subsystem is added to provide the location service framework capability.<br>- The location subsystem provides services such as Global Navigation Satellite System (GNSS) based positioning, GNSS geofencing, GNSS Batching, network positioning, and geocoding.<br>The following requirements are involved:<br>I4XXIH [location_gnss] Auxiliary information request and injection related to GNSS performance improvement<br>I4XXIG [location_gnss] GNSS hardware power consumption statistics and power consumption optimization<br>I4XXIF [location_gnss] GNSS based positioning<br>I4XXIC [location_gnss] GNSS Batching<br>I4XXIB [location_gnss] GNSS parameter setting and information reporting<br>I4XXI8 [location_locator] Security management of the location service<br>I4XXI7 [location_locator] Security assurance for location privacy<br>I4XXI5 [location_locator] Management of multiple location requests<br>I4XXI4 [location_locator] Location management<br>I4XXI3 [location_geofence] GNSS geofencing<br>I4XXI0 [location_geocode] Conversion between geographic coordinates (like longitudes and latitudes) and addresses<br>I4XXHZ [location_network] Network positioning<br>I4XXHW [location_gnss] GNSS auxiliary information protocol support| NA |
| Communication| - The Wi-Fi STA, AP, and P2P basic capabilities and related JS APIs are added. Experience for STA, AP, and P2P connections is enhanced.<br>- The Bluetooth BR, SPP, and BLE capabilities and related JS APIs are added.<br>The following requirements are involved:<br>**Wi-Fi**<br>I4XXFG [New feature] Wi-Fi power consumption statistics and power consumption optimization<br>I4XXFF [New feature] Basic Wi-Fi P2P capabilities<br>I4XXFB [New feature] P2P magic link<br>I4XXF7 [New feature] SoftAP 5G and automatic channel selection<br>I4MBRI [New feature] Basic SoftAP features<br>I4MBRH [New feature] Basic STA features<br>**Bluetooth**<br>I4XXGC [bluetooth_standard] Bluetooth BR/Enhanced Data Rate (EDR)<br>I4XXFT [bluetooth_standard] Advanced Audio Distribution Profile (A2DP) capabilities and related JS APIs<br>I4XXFP [bluetooth_standard] Basic BLE capabilities<br>I4XXFL [bluetooth_standard] Bluetooth SPP and BR data transmission<br>| NA |
| Ability management framework| - The widget capability is added. The zidl tool supports automatic generation of C++ server/client code. The ability test framework is provided, and the command line tool capabilities are enhanced.<br>- The following capabilities are added: multi-user, mission stack reconstruction, ability-based decoupling, application resident process, application exception detection enhancement, and environment change notifications.<br>The following requirements are involved:<br>I4PCM4 [New feature] Application/HAP/Ability information query in the context module<br>I4PCPP [New feature] Multi-user in the context module<br>I4PCPV [New feature] System interface for user-specific ability start<br>I4PCQP [New feature] Single-user running mode<br>I4PCQU [New feature] Default user initialization<br>I4PCGY [Enhanced feature] Widget development base class<br>I4PCH9 [Enhanced feature] Widget configuration through configuration files<br>I4PCLL [New feature] Application-level JS context<br>I4PCLN [New feature] Ability status recovery<br>I4PCP1 [New feature] Application running information query<br>I4PCPG [Enhanced feature] System environment change notifications<br>I4PCR8 [Enhanced feature] Resident process upon system boot<br>I4PCV4 [New feature] Mission switching<br>I4PCVZ [New feature] Ability startup by display ID<br>I4PCW3 [Enhanced feature] Pending want for cross-device ability startup<br>I4PCH4 [New feature] Multi-user widget<br>I4PCM1 [New feature] CE/DE-level context<br>I4PCVN [New feature] Obtaining and updating mission snapshots<br>I4PPW6 [Enhanced feature] Ability startup in specified window mode<br>I4PC3R [New feature] Basic widget development capabilities<br>I4PQ0M [Enhanced feature] Message sending and monitoring provided by the context module<br>II4PQ13 [Enhanced feature] Permission verification and application APIs provided by the context module<br>I4PQ1E [Enhanced feature] Resident process recovery from exceptions<br>I4PQ1O [New Feature] New want<br>I4PCPI [Enhanced feature] System environment information query<br>I4PCRL [New feature] Ability test framework<br>I4PCVU [New feature] Ability call| NA |
| Accessibility| - The internal implementation of UI information exchange is added.<br>- The function of reading accessibility configuration is added.<br>The following requirements are involved:<br>I4X2EM [New feature & information exchange mechanism] Key interception<br>I4X2EN [New feature & information exchange mechanism] Reporting of window node information<br>I4X2ET [New feature & information exchange mechanism] Reporting of control node information<br>I4X2EV [New feature & information exchange mechanism] Focus query<br>I4X2EY [New feature & information exchange mechanism] Accessibility event list<br>I4X2EZ [New feature & information exchange mechanism] Accessibility event information<br>I4X2F0 [New feature & information exchange mechanism] Accessibility action initiation<br>I4X2F1 [New feature & information exchange mechanism] Auxiliary application list query<br>I4X2F2 [New feature & information exchange mechanism] Auxiliary application status query and monitoring<br>I4X2F3 [New feature & information exchange mechanism] Gesture simulation<br>I4X2F4 [New feature & information exchange mechanism] Touchpad interception<br>I4X2EO [New feature & accessibility service management] Target application connection<br>I4X2EP [New feature & accessibility service management] Assistance application connection<br>I4X2ER [New feature & accessibility service management] Assistance application update<br>I4X2ES [New feature & accessibility service management] Accessibility caption configuration| NA |
| Multimedia| - The local basic audio/video playback capabilities, video hardware codecs, and mainstream audio/video codecs and encapsulation formats are supported.<br>- The basic camera preview, photographing, and distributed camera functions are provided.<br>The following requirements are involved:<br>I4WYPP [audio_standard] Bluetooth audio playback<br>I4WYK8 [audio_standard] OpenSL ES basic playback interfaces<br>I4WYW4 [Enhanced feature] Camera session management<br>I4WYVE [Enhanced feature] Basic photographing functions<br>I4WZ8G [New feature] Basic image decoding framework<br>I4X5E1 [New feature] Video software decoding<br>I4X552 [New feature] Local audio/video playback<br>I4X5Q9 [New feature] Distributed media library - thumbnail synchronization<br>I4X5L5 [New feature] Basic media database| NA |
| Graphics| - A new graphics rendering framework RenderService is provided.<br>- 2D/3D drawing is supported.<br>- A new animation framework is provided.<br>The following requirements are involved:<br>I4MBTY [render_service] [New feature] Background rendering feature for the UI framework<br>I4RKT3 [composer] Combination and display<br>I4ZCGG [drawing] Graphics native SDK<br>I4RKSW [drawing] 3D and graphics capabilities, and native SDK capabilities<br>I4MBTW [animation] Basic animation framework| NA |
| Window Manager| - A new window management framework is provided, which offers more flexible window framework capabilities and supports full-screen, split-screen, window modes, and cross-window content dragging.<br>- The display management capability is provided, which supports split-screen display and enhanced screen-on/off management.<br>The following requirements are involved:<br>I4R308 [Enhanced feature] Application window creation and management: Multiple primary windows can be created for multiple ability instances of a single application.<br>I4R309 [Enhanced feature] Application window creation and management: The window display policy can be set when a window is started. The window display policy status (split screen, full screen, or free window) is provided for applications.<br>I4R30D [New feature] Free window display, tile layout, and cascade layout of the application's primary window.<br>I4R9P0 [New specification] Enhanced features:<br>1. Display management<br>2. Creating and destroying a display by inserting or removing a physical screen<br>3. Multi-display mapping management<br>I4ZEKH [New feature] Screen on/off process<br>1. Sleep, wake-up, screen-on, and screen-off requests initiated from the power management module<br>2. Calling of the RenderServer interface to turn the screen on/off or adjust the screen brightness as requested| NA |
| Network management| I4XXHU [Enhanced feature] TCP/UDP socket<br>I4XXHT [Enhanced feature] Support for HTTP 1.1/HTTPS/HTTP 2<br>I4XXHS [Enhanced feature] Wi-Fi/Cellular network connection management and handover<br>I4XXHP [Enhanced feature] Domain Name System (DNS) resolution and configuration<br>I4XXHN [Enhanced feature] Network connection status query and status change notification<br>I4XXHH [WPA_supplicant] Wi-Fi Protected Access (WPA) and P2P capabilities based on nl80211<br>I4XXHG [WPA_supplicant] Magic link| NA |
| MSDP| I4WWRO [MSDP] device_status component standardization| NA |
| Globalization| - Locale selection is added.<br>- The following internationalization features are supported: single and plural rules, string sorting, phone number processing, calendar and local calendar, measurement units and formatting, time segment formatting, alphabet retrieval, Unicode character attributes, wrapping and line feed.<br>- System resources are supported.<br>- rawfile resources are supported.<br>The following requirements are involved:<br>I4MBR0 [Enhanced feature] Locale representation and attributes<br>I4MBR1 [Enhanced feature] Singular and plural rules<br>I4MBR2 [Enhanced feature] String sorting<br>I4MBR3 [Enhanced feature] Phone number processing<br>I4MBR7 [New feature] Calendar and local calendar<br>I4MBR5 [New feature] Measurement units and formatting<br>I4MBQZ [Enhanced feature] Time segment formatting<br>I4MBR4 [New feature] Alphabet retrieval<br>I4MBR8 [Enhanced feature] Unicode character attribute<br>I4MBR9 [Enhanced feature] Wrapping and line feed<br>I4MBRA [New feature] System resource management<br>I4MBRB [New feature] rawfile resource management<br>I4R2YA [New feature] Native SDK for resource management| NA |
| DSoftBus| - Network switching is supported.<br>- Bluetooth is supported.<br>- Bluetooth file transfer is supported.<br>- Streaming is supported.<br>- P2P connection is supported.<br>- P2P-based file transfer and streaming are supported.<br>The following requirements are involved:<br>I4MBS0 [New feature] [Networking] Network switching<br>I4XXEL [Enhanced feature] Bluetooth<br>I4XXEX [Transmission] File transfer over Bluetooth<br>I4XXEO [Enhanced feature] [Transmission] Enhanced file transfer (NSTACK component capability)<br>I4XXEV [New feature] [Transmission] Enhanced streaming (NSTACK component capability enhancement)<br>I4XXEN [New feature] [Networking] P2P connection<br>I4XXEP [New feature] [Connection] P2P connection<br>I4XXES [New feature] [Transmission] P2P file transfer<br>I4XXET [New feature] [Transmission] P2P streaming| NA |
| ArkUI| - Keyboard and mouse interaction is supported.<br>- The declarative **\<Web>** component is added.<br>- The declarative **XComponent** is added.<br>- The declarative **Canvas2D** and **OffscreenCanvas** capabilities are added.<br>- Rich text display is supported.<br>- Multiple functional components are added.<br>- The customization capabilities of multiple components are enhanced.<br>- Debugging is enhanced.<br>The following requirements are involved:<br>I4MBV7 [New specification] Scroll bar style customization<br>I4MBVO [New feature] Content customization specifications for the **\<Popup>** component.<br>I4MBVP [New feature] Canvas drawing<br>I4MBVR [New feature] Touch hot zone setting<br>I4MBVS [New feature] Lottie animations<br>I4MBVU [New feature] Content customization specifications for the **\<Menu>** component.<br>I4MBVV [New feature] Swipe gesture<br>I4MBV9 [New specification] **\<TabBar>** content customization specifications for the **\<Tabs>** component<br>I4MBVA [New specification] Title bar setting specification for the **\<Navigation>** component<br>I4MBVC [New specification] Content customization specification for the **\<TabBar>** component<br>I4WTQY [New feature] Linear proportion display component<br>I4MBV3 [New specification] Component polymorphic style specifications<br>I4MBV5 [New specification] Prompt menu content specifications for the **\<AlphabetIndexer>** component<br>I4WTQ2 [New specification] Content dragging specification for the **\<List>** component<br>I4WTQ4 [New specification] Content dragging specification for the **\<Grid>** component<br>I4WYNA [New specification] Enhanced **\<Dialog>** component: dialog box displayed at the user-specified location<br>I4WTQX [New feature] **\<PatternLock>** component<br>I4QC4N [New specification] **\<Select>** component<br>I4QC4O [New specification] Enhanced **\<TextInput>** component<br>I4WTPY [New specification] Mouse dragging for text selection for the **\<Text>** component<br>I4WTRS [New feature] Declarative paradigm specifications for the **XComponent**<br>I4WTR9 [New feature] Mouse button and scroll wheel events<br>I4WTQI [New specification] Mouse dragging specification<br>I4RCRC [New feature] Style status compilation and conversion<br>I4WTPS [New specification] Touch event that supports multi-touch information<br>I4RCRF [New feature] Access to child component data by custom components<br>I4X27K [New feature] **\<Sidebar>** component<br>I4RA0G [New specification] Mouse pointer hover events on widgets<br>I4WTQV [New feature] Scenario-specific data storage <br>I4RCRK [DFX] Timeout detection<br>I4RCJ8 [IDE support] Print of time consumed by the rendering pipeline<br>I4RCRM [IDE Tool Support] Print of time required for interaction event callbacks<br>I4WTR7 [New feature] **\<Web>** component<br>I4WTRA [New feature] Routing information continuation in the distributed network<br>I4X29K [New feature] **\<ContextMenu>** component<br>I4WTQJ [New specification] Keyboard shortcuts of the **\<Input>** component<br>I4WTQK [New feature] Double-click for word selection<br>I4WTPG [New specification] Enhanced parameter configuration of the basic animations<br>I4X26M [New specification] **\<List>** component that supports selection by the mouse operation alone and the combination of keyboard and mouse operations<br>I4X26Y [New specification] **\<GridItem>** component that supports selection by the mouse operation alone and the combination of keyboard and mouse operations<br>I4WTR8 [New feature] Focus setting <br>I4U5XM [New specification] Conditional compilation of JS files by ArkUI Loader<br>I4WTQN [New feature] **RichText** label| NA |
| Program access control| - The functions of defining, managing, authorizing, querying, and authenticating local application permissions are added.<br>- The functions of managing, querying, authenticating, and synchronizing distributed permissions are added.<br>The following requirements are involved:<br>I4WVMH [New specification] Predefined system application permission initialization<br>I4WVO9 [New specification] Application permission request query<br>I4WVPH [New specification] Basic framework of the AT synchronization service<br>I4WVPV [New specification] Local permission verification interface and mechanism<br>I4WVQT [New specification] Native token creation and update mechanism<br>I4WVR3 [New specification] Application permission setting interface and mechanism<br>I4WVRG [New specification] Basic framework of the AT management service<br>I4WVRR [New specification] Token query interface for HAP applications<br>I4WVS6 [New specification] Token deletion for HAP applications<br>I4WVSI [New specification] Token creation and update for HAP applications<br>I4TYDA [New specification] Cross-device token information synchronization<br>I4TYCV [New specification] Token information synchronization for the native process upon device online<br>I4V02K [New specification] Application authorization status update and synchronization<br>I4V02Y [New specification] Application uninstall synchronization<br>I4V032 [New specification] Implementation of the application permission management page<br>I4V038 [New specification] Application permission setting on the application permission management page<br>I4TYCK [New specification] Distributed permission verification interface and mechanism<br>I4TYDO [New specification] Token deletion upon device offline<br>I4SEZD [New specification] Dynamic permission request<br>I4SEZ7 [Dynamic permission setting] Dynamic permission authorization| NA |
| Multi-language runtime| - Language compilation and runtime: A multi-device basic JS toolchain and runtime are provided, and the JS engine on the device side is provided to support application running.<br>- TS/JS Utils: The TS/JS Utils provides basic functions and supports TS/JS multi-thread.<br>- TS/JS/C/C++ toolchain: The basic requirements for development, debugging, and optimization are met.<br>- Lite Actor: This model shares bytecode and Virtual Machine (VM) internal infrastructure, optimizes the implementation of the JS engine and the memory usage, and improves the startup performance.<br>- High Perf Partial GC: ArkUI Garbage Collector (GC) supports concurrent mark, parallel mark, and lazy free, reducing the GC pause time by 50% and improving user experience.<br>  The following requirements are involved:<br>  I4W7ZR [New specification] Memory management, allocation, and reclamation/HPP GC performance optimization<br>  I4P7F7 [language compilation and runtime, graphics, DRF] Native SDK integration<br>  I4WWKK [Enhanced feature] Lite Actor 1.0| NA |
| Update| - The components of the update subsystem are standardized.<br>- The SysCap mechanism is supported.<br>The following requirements are involved:<br>I4WXHW [Component-based] Component standardization<br>I4XXH6 [SysCap] SysCap support| NA |
| Misc services| - Management of time and time zone synchronization is supported.<br>- The capabilities of querying, setting, deleting, and replacing pasteboard data items are added.<br>- Lock screen management is supported.<br>- Static wallpaper management is supported.<br>- Downloading management is supported.<br>The following requirements are involved:<br>I4U2WR [New feature] Time and time zone synchronization management<br>I4ZTTE [New feature] Pasteboard data items - Forcible conversion from pasteboard data items to text<br>I4ZTTO [New feature] Pasteboard data - Obtaining, deleting, and replacing pasteboard data items, and querying and setting pasteboard data attributes<br>I4ZTTZ [New feature] System pasteboard - Obtaining, clearing, and querying pasteboard data, and sending pasteboard content change notifications<br>I4ZTZC [New feature] Lock screen management - Multi-user scenario<br>I4ZTZT [New feature] Lock screen management - System startup and screen on/off scenarios<br>I4ZU1S [New feature] Static wallpaper<br>I4ZTXT [request] Downloading management, including creating, deleting, modifying, querying, pausing, and resuming download tasks, monitoring download task progress, and sending download status change notifications. The downloading management service provides Data abilities for system download management, persists download task data, checks the application interface permission, performs HTTP download, and handles download exceptions.| NA |
| Light kernel| NA | For the mini system:<br>I4RD3H POSIX interfaces such as **signal**, **pipe**, **poll**, and **select** for the LiteOS-M kernel<br>I4Q9OQ Cortex-M55 architecture<br>I4Q9F2 Dynamic loading<br>I4RD2M Kernel componentization|
| File management| - The basic file system Ext4 and F2FS capabilities and related tools are supported. Cross-device file access of the distributed file system is provided.<br>- Device storage management functions are provided, including file encryption, space management and statistics, multi-user space management, and external card mount management.<br>- Application data protection is enhanced by supporting application sandbox isolation. User data management is optimized, including security hardening for user data sandbox isolation as well as user file access framework and interfaces.<br>- Basic file operation APIs are provided, including statfs usage statistics and asynchronous file access APIs.<br>The following requirements are involved:<br>I4RDNG [New feature] [local_file_system] User-mode tools such as Ext4 and F2FS<br>I4RFBD [New feature] [local_file_system] Pluggable file systems such as File Allocation Table (FAT), Extensible FAT (exFAT), and New Technology File System (NTFS)<br>I4TTN8 [New feature] Basic functions of the distributed file system<br>I4TTNG [New feature] Data classification, device grade, and data hopping specification control<br>I4TTGR [New feature] [storage_manager] File encryption<br>I4TTHQ [New feature] External storage access<br>I4TTJN [New feature] Event distribution of external cards<br>I4TTJV [New feature] Volume information query and management<br>I4XXIR [New feature] Creation and deletion of user directories by responding to multi-user requests<br>I4XXIY [New feature] Application space statistics<br>I4SNSU [New feature] Application sandbox isolation<br>I4XXIX [New feature] JS APIs for file picker<br>I4MBS2 [New feature] statfs APIs| NA |
| Common event and notification| - Multi-user is supported.<br>- Distributed notifications are supported.<br>- Notification templates are provided.<br>The following requirements are involved:<br>I4PBOK [New feature] Multi-user notification<br>I4PBP7 [New feature] Sending of template notifications (debugging capability)<br>I4PBPE [New feature] Progress bar notification<br>I4PBPM [Enhanced feature] Traffic control for distributed notifications<br>I4PBRM [New feature] Clicking notifications on another device and redirection on the local device<br>I4PBRW [New feature] Device-level distributed notification enabling control<br>I4PBSE [New feature] Notification management application setting and query of the application-level distributed notification enabling status<br>I4PBSP [New feature] Enabling/Disabling distributed notifications for applications<br>I4PBT7 [New feature] Distributed notification synchronization<br>I4PBU3 [New feature] Distributed notification linkage cancellation<br>I4PBUU [New specification] Static configuration of common events in **config.json**, and static start of subscribers using Wok Scheduler<br>I4PBV9 [New specification] Static subscriber management<br>I4WTGK [New feature] Template notification registration, query, and sending<br>I4PBSZ [New feature] Notification sending based on the device status<br>I4PBBV [New feature] EventRunner timeout detection<br>I4PD0O [Enhanced feature] Enhanced notification sending enabling<br>I4PBQ1 [Enhanced feature] dump command for distributed notifications<br>I4PBR0 [New feature] Clicking a notification on one device and redirection on another device<br>I4PC2S [New feature] Multi-user for common events| NA |
| Pan-sensor| - Data reporting by common sensors, such as acceleration, gyroscope, and Hall effect sensors, is supported.<br>- The basic functions of vibrators are supported.<br>- The general algorithms and geomagnetic field algorithms are supported.<br>The following requirements are involved:<br>I4WWTG [miscdevice] Peripheral dependency support by miscdevice<br>I4WWTF [Sensor] Peripheral dependency support by sensor<br>I4WWTD [Sensor] Common algorithm interfaces<br>I4MBRQ [sensor] Horizontal intensity and total intensity of the magnetic field<br>I4MBRP (sensor component) Magnetic declination and dip| NA |
| Distributed data management| - Memory JS objects can now be treated as distributed data objects; Distributed relational data management is provided to support data synchronization based on relational tables.<br>- Condition-based data synchronization and subscription capabilities are supported, making data synchronization more accurate.<br>- File upload is supported.<br>- Data encryption and security tiering are supported, and security control is optimized for data transfer. Multi-user synchronization and isolation are supported.<br>The following requirements are involved:<br>I4IBPH [distributed_kv_store] Supplemented the functions of the distributed data service<br>I4MBRS [distributed_kv_store] Cross-device synchronization and subscription of database records based on predicates<br>I4MBRU [RDB] Database encryption<br>I4NZVP [distributed_kv_store] Distributed database JS APIs<br>I4HAMI [data_share_ability] Subscription of cross-application database changes<br>I4NZP6 [RDB] Multi-table query<br>I4FZ6B [RDB] Transaction<br>I4HAMI [data_share_ability] Subscription of cross-application database changes<br>I4PNX7 [Distributed RDB] Data storage<br>I4HAMD [data_share_ability] Data access modes<br>I4H4FH [distributed_kv_store] Data classification and tiering for the distributed database<br>I4H3M8 [New feature] Complex type of distributed data objects<br>I4HAMD [data_share_ability] Data access modes<br>I4PO00 [Distributed RDB] Data synchronization<br>I4OTW6 [distributed_kv_store] InKeys predicate for the distributed database<br>I4RGFY [DataShare] Reconstruction based on the Extension ability and cross-application data sharing on a single device<br>I4H4FR [distributed_kv_store] Multi-user data isolation and sharing<br>I4RGFY [DataShare] Reconstruction based on the Extension ability and cross-application data sharing on a single device<br>I4XXGF [request] File upload| For the mini and small systems:<br>Distributed data objects are now available to small-system devices.<br>The following requirements are involved:<br>I4H3JJ: Distributed objects for small-system devices|
| DFX| Watchdog detection for the system and application is provided. Log collection for native crashes and JS crashes is supported.<br>Abnormal behavior detection is provided for JS applications.<br>System and process status information can be exported. JS applications can obtain the bottom-layer memory, CPU, and VM information.<br>Distributed tracing and debugging are supported.<br>Log, system event, and application event capabilities are enhanced.<br>The following requirements are involved:<br>I4PJE3 [New feature] Hidumper framework and tool for the standard system<br>I4MBRE [hiperf] Performance statistics<br>I4U0KP [profiler] CPU profiler<br>I4PJE5 [New feature] JS application debugging and optimization based on native memory information<br>I4Q6AQ [New feature] Watchdog<br>I4U0JZ [New feature] hisysevent management<br>I4Q6B6 [Enhanced feature] HiTrace JS APIs<br>I4Q6AY [New feature] Detection mode framework and basic detection basic functions| NA |
| Driver| -& Enhanced Hardware Driver Foundation (HDF) capabilities are provided, including HDF Configuration Source (HCS) configuration parsing and power management.<br>- The shared memory queue and on-demand hardware device interface (HDI) service startup are added to the HDI management framework.<br>- The user-mode platform interfaces are provided for user-mode driver development.<br>- More than 200 HDI interfaces are defined for peripheral modules such as display, audio, camera, sensor, power supply, and USB. The number of device interfaces exceeds 600, providing more hardware access capabilities.<br>The following requirements are involved:<br>I4HPR7 [Enhanced feature] HCS macro parsing interface<br>I4LZZF [Enhanced feature] Synchronous/Asynchronous power management invocation<br>I4QEKH [New feature] Shared memory HDIs<br>I4QEKI [New feature] Driver development tool for standard-system driver development<br>I4QEKZ [New feature] User-mode platform driver interfaces<br>I4QEKL [New feature] Unified platform driver object model built on the HDF<br>I4QELC [New feature] On-demand UHDF process startup<br>I4QEKJ [New feature] HDI adaptation for the Linux-input driver<br>I4QEKM [New feature] Power HDIs<br>I4QEKK [New feature] HDF-based hardware timer driver<br>I4QEKP [New feature] HDF-based light driver<br>I4MBTP [Enhanced feature] Enhanced sensor driver model<br>I4MBTQ [Enhanced feature] Enhanced sensor driver<br>I4MBTR [Enhanced feature] Display HDI reference implementation for the standard system<br>I4MBTS [New feature] More HDF input device capabilities<br>I4QEKP [New feature] HDF based light driver<br>I4QEKQ [New feature] Service-oriented display HDI implementation<br>I4QEL2 [Enhanced feature] Enhanced vibrator driver model<br>I4XXGZ [New feature] HDF based pedometer sensor driver| For the mini and small systems:<br>HCS macro parsing interfaces are provided to reduce the memory usage during compilation.<br>The following requirements are involved:<br>I4TFTB [New feature] HCS macro parsing interfaces for the mini system|
| USB| - A complete USB service management framework is built, including the host and device modules.<br>- Port switching is supported for switching between different function modes.<br>- USB JS APIs are provided for application development.<br>- USB HDIs are defined and implemented, and standard interfaces for USB driver access are provided.<br>The following requirements are involved:<br>I4MBRK [New feature] JS API implementation for the USB service<br>I4QEKV [New feature] HDI implementation for the USB service<br>I4QEKN [New feature] USB device implementation<br>I4QEKO [New feature] USB host implementation<br>I4QEL6 [New feature] USB port implementation| NA |
| Compilation and building| - Normalized component definition and compilation are added.<br>- A unified compilation framework is provided, including the unified gn template, component configuration, product configuration, build commands, and build process.<br>- Native SDK compilation and release are supported.<br>- The Kconfig framework is supported.<br>- The hb capabilities are enhanced, including using the hb compilation entry in a unified manner, displaying build logs by level, and supporting hb command installation, integration, and extension.<br>- gn coding specifications and best practice are provided.| The feature changes for the mini and small systems are the same as those for the standard system.|
| Test| - The automated test framework is added to support the compilation and running of basic unit/UI test scripts.<br>- The wukong tool is provided to support pressure testing of random event injection at the level of the entire system or a single application.<br>-& The SmartPerf tool is added to collect and display basic performance data such as FPS, CPU, and memory data.<br>- The test scheduling framework is enhanced to support automatic case execution configuration and execution configuration management.<br>- The DCTS compatibility test suite is provided to support the DSoftBus and distributed data compatibility test.<br>-& The ACTS and HATS compatibility test suites are enhanced, covering external public JS APIs and HDF APIs in OpenHarmony 3.1 Release.<br>The following requirements are involved:<br>I4XXCR [Test framework] UI automation test<br>I4XXCV [Test framework] TS developer test framework<br>I4XXCW [Test framework] JS application developer test framework<br>I4XXD0 [Test framework] Executor device management<br>I4XXCX [Test framework] Test pipeline test suite execution report<br>I4XXCZ [Test framework] Test case configuration management<br>I4XXD0 [Test framework] Executor device management<br>I4XGLQ [New feature] UI random pressure test tool<br>I4XXD7 [Authentication test] DCTS 3.1 distributed compatibility test suite| NA |
| Startup| - Process grouping and concurrent startup are supported.<br>- The SA and UHDF services can be started as required or based on hotplug events.<br>- The functions of creating a socket for a service and holding a file descriptor (FD) for a process that exits are added.<br>- **begetctl** is used as the unified init maintenance command.<br>- The recycling policy after process exit is optimized to support core process restart after exit. Non-core processes can be isolated when they are frequently suspended.<br>The following requirements are involved:<br>I4UTCF [New feature] Process grouping and parallel startup basic framework<br>I4UGE9 Bootchart function<br>I4UP28 SELinux label adaptation for dynamic files<br>I4UTCO [Enhanced feature] Enhanced application process incubation<br>I4UTCY [Enhanced feature] Recycling of incubated application processes by appspawn<br>I4RXJ2 [New specification] Unified init maintenance command<br>I4RXJ9 [New feature] On-demand service process startup<br>I4TNBV [New specification] Enhanced process startup configuration<br>I4PD3K Enhanced recycling policy configuration after process exit| NA |
| User IAM| - The multi-user identity management and user identity authentication functions are added.<br>- A unified user identity authentication framework is added to manage various authentication modes.<br>- Password authentication is added.<br>- Facial authentication is added.<br>The following requirements are involved:<br>I4RG55 [New specification] [user_idm] Query of local authentication credential information of users<br>I4RG5R [New specification] [user_idm] Deletion of the identity authentication credential when a user is deleted<br>I4RG8W [New specification] [pin_auth] Input of local passwords<br>I4RG91 [New specification] [pin_auth] Local password authentication<br>I4RGWU [New specification] [pin_auth] Local password deletion<br>I4TSK7 [New specification] [face_auth] Local facial information deletion<br>I4TSJE [New specification] [face_auth] Local face recording<br>I4TSJY [New specification] [face_auth] Local facial authentication| NA |
| Security| - The device security level management framework is added to support security level query for a specified device.<br>- Management policies for cross-device data migration are added to provide a basis for data security management during internal data processing and service hopping.<br>- A unified key management service is added to manage the full lifecycle of local keys for system applications and upper-layer services.<br>- The device mutual trust authentication capability is added to secure device connections.<br>The following requirements are involved:<br>I4RTYU [New feature] [Service] Devices on the network can query their own security levels.<br>I4RTYW [New feature] [Service] Devices can query the security level of their own or others.<br>I4TJFZ [Enhanced feature] DeviceAuth supports multi-user isolation for trust relationship authentication between devices. The trust relationship managed by a specified system user is used for authentication.<br>I4TJG1 [Enhanced feature] DeviceAuth implements multiple instances of trusted group data and supports data query of a specified user.<br>I4TJG3 [Enhanced feature] DeviceAuth supports the establishment and cancellation of account-irrelevant P2P trust relationships between multiple users.<br>I4TT8L [New specification] HUKS provides a three-segment key management interface.<br>I4TYEM [New specification] HUKS supports import, issuing, and verification of security level credentials.<br>I4TYFI [New specification] When a subuser is deleted from HUKS, the related key data must be deleted.<br>I4TYFR [New specification] When an application is deleted from HUKS, the related key data must be deleted.<br>I4TYFA [New specification] HUKS supports application UID-based access isolation for key applications.<br>I4TYF1 [New specification] HUKS supports key attestation and ID attestation.<br>I4SAI0 [New feature] DataTransitMgrLib is provided to support management policies for cross-device data migration.| NA |
| Application| Some system applications that are applicable to the standard system are provided, such as Home Screen, System UI, and Settings. Specific examples are provided for developers to build applications that can be run on all standard-system devices.<br>- Home Screen: acts as a main entry for all applications and provides UIs for display and human-machine interactions of installed applications.<br>- System UI: consists of the navigation bar and system status bar. The navigation bar provides page navigation, and the status bar displays the system status, such as the time and charging status.<br>- Settings: provides functions such as device management, application management, and brightness setting.<br>- Contacts: provides functions such as the dialer, call log viewing/deletion, contact list, contact details viewing, and contact creation.<br>- Messaging: provides functions such as viewing, sending, receiving, and deleting SMS messages, and sending SMS delivery reports.<br>- Call: provides functions such as answering and ending voice calls and enabling/disabling mobile data.<br>- Camera: provides functions such as preview, photographing, thumbnail display, and original image browsing.<br>- Gallery: provides functions such as managing, browsing, displaying, and editing photos, videos, and albums.<br>- Input Method: provides functions such as hard keyboard input, text change in the edit box, and cursor position change feedback.<br>Note: In OpenHarmony 3.1 Release, only the Gallery system application code can be compiled in the released IDE and SDK.| NA |


For details, see the following:


*[JS API Differences](api-change/v3.1-Release/js-apidiff-v3.1-release.md)*


*[Native API Differences](api-change/v3.1-Release/native-apidiff-v3.1-release.md)*


### Chip and Development Board Adaptation

For details about the adaptation status, see [SIG-Devboard](https://gitee.com/openharmony/community/blob/master/sig/sig-devboard/sig_devboard.md).

### Samples & Codelabs

#### New Samples

**Table 4** New samples

| Subsystem name| Sample Name| Introduction| Programming Language|
| -------- | -------- | -------- | -------- |
| Telephony| [SMS](https://gitee.com/openharmony/app_samples/tree/master/Telephony/Message)| This sample shows how to send SMS messages.| eTS |
| Telephony| [Radio](https://gitee.com/openharmony/app_samples/tree/master/Telephony/RadioTech)| This sample shows how to use the radio function of the telephony service in eTS to obtain information, including the radio access technology, network status, network selection mode, ISO country code, signal strength list, and whether the radio function is enabled.| eTS |
| Device management| [Power Management](https://gitee.com/openharmony/app_samples/tree/master/common/PowerManager)| This sample shows how to power off a device, restart the system, and check the screen status.| eTS |
| Device management| [Sensor](https://gitee.com/openharmony/app_samples/tree/master/device/SenSor)| This sample uses the orientation sensor APIs to implement the compass effect.| eTS |
| Device management| [Device Management](https://gitee.com/openharmony/app_samples/tree/master/device/DeviceManager)| This sample shows the use of the **DeviceManager** API in eTS, including obtaining the trusted device list, scanning for devices, authenticating devices, and subscribing to device status changes.| eTS |
| Account management| [Application Account Management](https://gitee.com/openharmony/app_samples/tree/master/Account/AppAccountManager)| This sample shows how to register/log in to an application and set the account information to demonstrate application account management.| eTS |
| ArkUI | [web](https://gitee.com/openharmony/app_samples/tree/master/ETSUI/Web)| This sample shows the function pages of the **\<Web>** component.| eTS |
| ArkUI | [Drag](https://gitee.com/openharmony/app_samples/tree/master/ETSUI/Drag)| This sample shows the drag operation function.| eTS |
| ArkUI | [Animation](https://gitee.com/openharmony/app_samples/tree/master/ETSUI/ArkUIAnimation)| This sample demonstrates the effect of the **AnimatorProperty** and **Explicit Animation**.| eTS |
| Data management| [Querying the DDM Result Set](https://gitee.com/openharmony/app_samples/tree/master/data/DDMQuery)| This sample shows how to create a query object to query data in a key-value (KV) store and obtain the result set in distributed data management (DDM).| eTS |
| Data management| [eTS RDB](https://gitee.com/openharmony/app_samples/tree/master/data/Rdb)| This sample shows how to use a relational database (RDB) in eTS, including adding, deleting, modifying, and querying data.| eTS |
| Common event and notification| [Reminder Agent](https://gitee.com/openharmony/app_samples/tree/master/Notification/AlarmClock)| This sample shows how to use the reminder agent by simulating an alarm clock.| eTS |
| Common event and notification| [Event notification](https://gitee.com/openharmony/app_samples/tree/master/Notification/Emitter)| This sample shows the in-process event notification. After a user selects an offering and submits an order, the selected offering is displayed in the order list.| eTS |
| Connectivity| [RPC](https://gitee.com/openharmony/app_samples/tree/master/Communication/RPC)| This sample shows the data exchange between the frontend and backend of a device. After the offering and quantity are selected at the frontend, the backend calculates the result and displays it at the frontend.| eTS |
| Connectivity| [WLAN](https://gitee.com/openharmony/app_samples/tree/master/Communication/Wlan) | This sample shows how to use WLAN with eTS, including disabling and enabling the WLAN, scanning the WLAN and obtaining the scanning result, listening for WLAN status and Wi-Fi connection status, obtaining the IP address, country code, and checking whether the device supports WLAN features.| eTS |
| Multimedia| [Recorder](https://gitee.com/openharmony/app_samples/tree/master/media/Recorder)| This sample shows how to use audio recording and playback of the media service.| eTS |
| Multimedia| [Multimedia](https://gitee.com/openharmony/app_samples/tree/master/media/MultiMedia)| This demo shows how to invoke the camera to take photos in eTS and how to use the **MediaLibrary** APIs to add, delete, modify, and query media files.| eTS |

For more information, visit [Samples](https://gitee.com/openharmony/app_samples).

#### New Codelabs

**Table 5** New codelabs

| Codelab Name                                                    | Introduction                                                        | Programming Language|
| ------------------------------------------------------------ | ------------------------------------------------------------ | -------- |
| [Distributed Authentication](https://gitee.com/openharmony/codelabs/tree/master/Distributed/GameAuthOpenH)| This codelab shows how to develop a distributed game authentication application in JS and how to use the distributed startup, **DeviceManager** objects, and device attribute display interfaces.| JS       |
| [Distributed Game Controller](https://gitee.com/openharmony/codelabs/tree/master/Distributed/HandleGameApplication)| This codelab shows how to develop a game controller in eTS. By leveraging the distributed capabilities, one development board is used as the game controller, and another development board is used as the game server.| eTS      |
| [Distributed Jigsaw Puzzle](https://gitee.com/openharmony/codelabs/tree/master/Distributed/OpenHarmonyPictureGame)| This codelab shows how to develop a jigsaw puzzle. In this development, the RPC is used for cross-device communication, and **CommonEvent** is used to implement communication between the Service ability and FA.| eTS      |
| [Distributed Control](https://gitee.com/openharmony/codelabs/tree/master/Distributed/RemoteControllerETS)| This codelab shows how to develop a distributed control in eTS. By leveraging the distributed capabilities, one development board is used as the TV, and another development board is used as as the remote control.| eTS      |
| [Audio Recording](https://gitee.com/openharmony/codelabs/tree/master/Media/Audio_OH_ETS)| This codelab shows how to use **AudioRecorder** to record an audio file and use **AudioPlayer** to play the recorded audio.| eTS      |
| [Notepad](https://gitee.com/openharmony/codelabs/tree/master/Data/NotePad_OH_ETS)| This codelab shows how to develop a notepad in eTS. You can create, delete, and favorite notes, and use the lightweight database to store data persistently.| eTS      |
| [Distributed Mail Editing](https://gitee.com/openharmony/codelabs/tree/master/Distributed/OHMailETS)| This codelab shows how to develop the distributed email editing function. By leveraging the distributed capabilities, a remote device in the same LAN and with the same login account can be started, and email editing can be continued on the remote device.| eTS      |
| [Third-party Library](https://gitee.com/openharmony/codelabs/tree/master/ThirdPartyComponents/VCardDemo)| This codelab shows how to use vcard, a third-party library used in OpenHarmony to write and read contact data in a specified format (file with the extension name **vcard**).| eTS      |


## Resolved Issues

**Table 6** Resolved issues

| Issue No.| Description|
| -------- | -------- |
| [I4MGJM](https://gitee.com/openharmony/drivers_peripheral/issues/I4MGJM) | [HDF/Camera] The case fails when the RK3568 board runs the camera HDI tests.|
| [I4OECR](https://gitee.com/openharmony/ark_js_runtime/issues/I4OECR) | An Ark stack exception occurs during XTS running (low probability).|
| [I4OBTW](https://gitee.com/openharmony/aafwk_standard/issues/I4OBTW) | After all XTS cases are executed and the application is installed, aa start failures occur, affecting the pipeline stability test.|
| [I4OLHF](https://gitee.com/openharmony/ark_js_runtime/issues/I4OLHF?from=project-issue) | [ArkUI subsystem] The test process is abnormal due to the com.amsst.amsMissionSnapshotTest process.|
| [I4OLUK](https://gitee.com/openharmony/ark_js_runtime/issues/I4OLUK) | [ArkUI subsystem] The process stack is abnormal due to the com.ohos.systemui process.|


## Known Issues

**Table 7** Known issues

| Issue No.| Description| Impact| To Be Resolved On|
| -------- | -------- | -------- | -------- |
| [I4NRS5](https://gitee.com/openharmony/kernel_linux_5.10/issues/I4NRS5) | [Kernel subsystem] A CVE vulnerability exists.| No patch has been released for the Linux kernel. The kernel will be updated after the patch is released in the community.| Depending on the patch release in the community|
| [I4UUFR](https://gitee.com/openharmony/third_party_e2fsprogs/issues/I4UUFR) | Local image compilation and build may fail for the Hi3516 development board.| Compilation occasionally fails on the Hi3516 development board. This issue can be resolved by downloading the code.| 2022-04-30 |
| [I4RJU8](https://e.gitee.com/open_harmony/issues/list?issue=I4RJU8) | A black screen occurs during camera preview on the Hi3516 development board of a standard-system device.| The preview function is affected.| 2022-05-30 |
| [I4Z3G9](https://e.gitee.com/open_harmony/issues/list?issue=I4Z3G9) | [Graphics subsystem] [RK3568] Screen flickering occurs when the secondary window is opened in the immersive primary window.| User experience is adversely affected.| 2022-04-15 |
| [I50EBB](https://gitee.com/openharmony/docs/issues/I50EBB?from=project-issue) | [Hi3516 burning] Images of the Hi3516 development board on a standard-system device cannot be burnt by using the IDE.| The burning fails only in the Ubuntu environment of the IDE.<br>**Workaround**: Use the remote mode to burn the image on Windows.<br>**Solution**:<br>The Windows + Ubuntu hybrid mode will be used. Remote Ubuntu development, compilation, and debugging are performed on Windows, and burning is automatically performed on Windows.| 2022-04-30 |
