#  Subsystems

- [Compilation and Building](subsys-build.md)
  - [Building Guidelines for Mini and Small Systems](subsys-build-mini-lite.md)
  - [Building Guidelines for the Standard System](subsys-build-standard-large.md)
  - [Build System Coding Specifications and Best Practices](subsys-build-gn-coding-style-and-best-practice.md)
  - [Building the Kconfig Visual Configuration](subsys-build-gn-kconfig-visual-config-guid.md)
- [Distributed Remote Startup](subsys-remote-start.md)
- [Graphics](subsys-graphics.md)
  - [Graphics](subsys-graphics-overview.md)
  - [Development Guidelines on Container Components](subsys-graphics-container-guide.md)
  - [Development Guidelines on Layout Container Components](subsys-graphics-layout-guide.md)
  - [Development Guidelines on Common Components](subsys-graphics-common-guide.md)
  - [Development Guidelines on Animators](subsys-graphics-animation-guide.md)
- [Multimedia](subsys-multimedia.md)
  - [Camera](subsys-multimedia-camera.md)
    - [Overview](subsys-multimedia-camera-overview.md)
    - [Development Guidelines on Photographing](subsys-multimedia-camera-photo-guide.md)
    - [Development Guidelines on Video Recording](subsys-multimedia-camera-record-guide.md)
    - [Development Guidelines on Previewing](subsys-multimedia-camera-preview-guide.md)
  - [Audio/Video](subsys-multimedia-video.md)
    - [Overview](subsys-multimedia-video-overview.md)
    - [Development Guidelines on Media Playback](subsys-multimedia-video-play-guide.md)
    - [Development Guidelines on Media Recording](subsys-multimedia-video-record-guide.md)
- [Utils](subsys-utils.md)
  - [Utils Overview](subsys-utils-overview.md)
  - [Utils Development Guidelines](subsys-utils-guide.md)
  - [Utils FAQ](subsys-utils-faqs.md)
- [AI Framework](subsys-aiframework.md)
  - [AI Engine Framework](subsys-aiframework-guide.md)
  - [Development Environment](subsys-aiframework-envbuild.md)
  - [Technical Specifications](subsys-aiframework-tech.md)
    - [Code Management](subsys-aiframework-tech-codemanage.md)
    - [Naming](subsys-aiframework-tech-name.md)
    - [API Development](subsys-aiframework-tech-interface.md)
  - [Development Guidelines](subsys-aiframework-devguide.md)
    - [SDK](subsys-aiframework-devguide-sdk.md)
    - [Plug-in](subsys-aiframework-devguide-plugin.md)
    - [Configuration File](subsys-aiframework-devguide-conf.md)
  - [Development Examples](subsys-aiframework-demo.md)
    - [KWS SDK](subsys-aiframework-demo-sdk.md)
    - [KWS Plug-in](subsys-aiframework-demo-plugin.md)
    - [KWS Configuration File](subsys-aiframework-demo-conf.md)
- [Data Management](subsys-data.md)
  - [RDB](subsys-data-relational-database.md)
    - [RDB Overview](subsys-data-relational-database-overview.md)
    - [RDB Development](subsys-data-relational-database-guide.md)
  - [Lightweight Data Store](subsys-data-storage.md)
    - [Lightweight Data Store Overview](subsys-data-storage-overview.md)
    - [Lightweight Data Store Development](subsys-data-storage-guide.md)
- [Sensor](subsys-sensor.md)
  - [Sensor Overview](subsys-sensor-overview.md)
  - [Sensor Usage Guidelines](subsys-sensor-guide.md)
  - [Sensor Usage Example](subsys-sensor-demo.md)
- [USB](subsys-usbservice.md)
  - [[USB Overview](subsys-usbservice-overview.md)
  - [USB Usage Guidelines](subsys-usbservice-guide.md)
  - [USB Usage Example](subsys-usbservice-demo.md)
- [Application Framework](subsys-application-framework.md)
  - [Overview](subsys-application-framework-overview.md)
  - [Setting Up a Development Environment](subsys-application-framework-envbuild.md)
  - [Development Guidelines](subsys-application-framework-guide.md)
  - [Development Example](subsys-application-framework-demo.md)
- [OTA Upgrade](subsys-ota-guide.md)
- [Telephony ](subsys-tel.md)
  - [Telephony Overview](subsys-tel-overview.md)
  - [Telephony Development](subsys-tel-guide.md)
- [Security](subsys-security.md)
  - [Overview](subsys-security-overview.md)
  - [Development on Application Signature Verification](subsys-security-sigverify.md)
  - [Development on Application Permission Management](subsys-security-rightmanagement.md)
  - [Development on IPC Authentication](subsys-security-communicationverify.md)
  - [Development on Device Security Level Management](subsys-security-devicesecuritylevel.md)
- [Startup](subsys-boot.md)
  - [Startup](subsys-boot-overview.md)
  - [init Module](subsys-boot-init.md)
  - [appspawn Module](subsys-boot-appspawn.md)
  - [appspawn Module for the Standard System](subsys-boot-appspawn-standard.md)
  - [bootstrap Module](subsys-boot-bootstrap.md)
  - [syspara Module](subsys-boot-syspara.md)
  - [FAQs](subsys-boot-faqs.md)
  - [Reference](subsys-boot-ref.md)
- [Testing](subsys-testguide-test.md)
- [DFX](subsys-dfx.md)
  - [DFX](subsys-dfx-overview.md)
  - [HiLog Development](subsys-dfx-hilog-rich.md)
  - [HiLog\_Lite Development](subsys-dfx-hilog-lite.md)
  - [HiTrace Development](subsys-dfx-hitrace.md)
  - [HiCollie Development](subsys-dfx-hicollie.md)
  - [HiSysEvent Development](subsys-dfx-hisysevent.md)
    - [HiSysEvent Logging Configuration](subsys-dfx-hisysevent-logging-config.md)
    - [HiSysEvent Logging](subsys-dfx-hisysevent-logging.md)
    - [HiSysEvent Listening](subsys-dfx-hisysevent-listening.md)
    - [HiSysEvent Query](subsys-dfx-hisysevent-query.md)
    - [HiSysEvent Tool Usage](subsys-dfx-hisysevent-tool.md)
- [R&D Tools](subsys-toolchain.md)
  - [bytrace Usage Guidelines](subsys-toolchain-bytrace-guide.md)
  - [hdc\_std Usage Guidelines](subsys-toolchain-hdc-guide.md)
  - [hiperf Usage Guidelines](subsys-toolchain-hiperf.md)
- [XTS](subsys-xts-guide.md)