# Built-in Enums


## Alignment Enums

  | Name | Description | 
| -------- | -------- |
| TopStart | Top start. | 
| Top | Horizontally centered on the top. | 
| TopEnd | Top end. | 
| Start | Vertically centered start. | 
| Center | Horizontally and vertically centered. | 
| End | Vertically centered end. | 
| BottomStart | Bottom start. | 
| Bottom | Horizontally centered on the bottom. | 
| BottomEnd | Bottom end. | 


## Axis Enums

  | Name | Description | 
| -------- | -------- |
| Vertical | Vertical direction. | 
| Horizontal | Horizontal direction. | 


## ItemAlign Enums

  | Name | Description | 
| -------- | -------- |
| Auto | The default configuration in the Flex container is used. | 
| Start | The elements are in the Flex container, top-aligned in the cross-axis direction | 
| Center | The elements are in the Flex container, centered in the cross-axis direction. | 
| End | The elements are in the Flex container, bottom-aligned in the cross-axis direction. | 
| Stretch | The elements are in the Flex container, stretched and padded in the cross-axis direction. If the size is not set, the elements are stretched to the container size. | 
| Baseline | The elements are in the Flex container, text baseline aligned in the cross-axis direction. | 


## LineCapStyle Enums

  | Name | Description | 
| -------- | -------- |
| Butt | The ends of dividing lines are square. | 
| Round | The ends of dividing lines are rounded. | 
| Square | The ends of dividing lines are square. | 


## PlayMode Enums

  | Name | Description | 
| -------- | -------- |
| Normal | The animation is played normally. | 
| Reverse | The animation is played reversely. | 
| Alternate | The animation is played normally for an odd number of times (1, 3, 5...) and reversely for an even number of times (2, 4, 6...). | 
| AlternateReverse | The animation is played reversely for an odd number of times (1, 3, 5...) and normally for an even number of times (2, 4, 6...). | 


## ImageRepeat Enums

  | Name | Description | 
| -------- | -------- |
| X | Images are repeatedly drawn only on the horizontal axis. | 
| Y | Images are repeatedly drawn only on the vertical axis. | 
| XY | Images are repeatedly drawn on both axes. | 
| NoRepeat | Images are not repeatedly drawn. | 


## TextDecorationType Enums

  | Name | Description | 
| -------- | -------- |
| Underline | Line under the text. | 
| LineThrough | Line through the text. | 
| Overline | Line over the text. | 
| None | No decorative lines. | 


## TextCase Enums

  | Name | Description | 
| -------- | -------- |
| Normal | Normal case. | 
| LowerCase | All lowercase. | 
| UpperCase | All uppercase. | 


## BarState Enums

  | Name | Description | 
| -------- | -------- |
| Off | Hide. | 
| On | Display. | 
| Auto | Display on demand (displays when the screen is touched and disappears after 2s). | 

## LayoutDirection Enums

| Name          | Description                                                  |
| ------------- | ------------------------------------------------------------ |
| Row           | The child components are arranged in the same direction as the main axis runs along the rows. |
| Column        | The child components are arranged in the same direction as the main axis runs down the columns. |
| RowReverse    | The child components are arranged opposite to the **Row** direction. |
| ColumnReverse | The child components are arranged opposite to the **Column** direction. |

