# Page Routing

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**
>
> - The APIs of this module are no longer maintained since API version 8. You are advised to use [`@ohos.router`](js-apis-router.md) instead.
>
>
> - The initial APIs of this module are supported since API version 3. Newly added APIs will be marked with a superscript to indicate their earliest API version.


## Modules to Import


```
import router from '@system.router';
```

## router.push

push(options: RouterOptions): void

Navigates to a specified page in the application.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Parameters**

| Name    | Type                             | Mandatory  | Description                        |
| ------- | ------------------------------- | ---- | -------------------------- |
| options | [RouterOptions](#routeroptions) | Yes   | Page routing parameters. For details, see **RouterOptions**.|

**Example**

```
// Current page
export default {
  pushPage() {
    router.push({
      uri: 'pages/routerpage2/routerpage2',
      params: {
        data1: 'message',
        data2: {
          data3: [123, 456, 789]
	},
      },
    });
  }
}
```


```
// routerpage2 page
export default {
  data: {
    data1: 'default',
    data2: {
      data3: [1, 2, 3]
    }
  },
  onInit() {
    console.info('showData1:' + this.data1);
    console.info('showData3:' + this.data2.data3);
  }
}
```

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**
> The page routing stack supports a maximum of 32 pages.


## router.replace

replace(options: RouterOptions): void

Replaces the current page with another one in the application and destroys the current page.

**System capability**: SystemCapability.ArkUI.ArkUI.Lite

**Parameters**

| Name    | Type                             | Mandatory  | Description                        |
| ------- | ------------------------------- | ---- | -------------------------- |
| options | [RouterOptions](#routeroptions) | Yes   | Page routing parameters. For details, see **RouterOptions**.|

**Example**

```
// Current page
export default {
  replacePage() {
    router.replace({
      uri: 'pages/detail/detail',
      params: {
        data1: 'message',
      },
    });
  }
}
```


```
// detail page
export default {
  data: {
    data1: 'default'
  },
  onInit() {
    console.info('showData1:' + this.data1)
  }
}
```

## router.back

back(options?: BackRouterOptions): void

Returns to the previous page or a specified page.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Parameters**

| Name    | Type                                     | Mandatory  | Description                     |
| ------- | --------------------------------------- | ---- | ----------------------- |
| options | [BackRouterOptions](#backrouteroptions) | Yes   | For details, see **BackRouterOptions**.|

**Example**

```
// index page
export default {    
  indexPushPage() {        
    router.push({            
      uri: 'pages/detail/detail',        
    });        
  }
}
```


```
// detail page
export default {    
  detailPushPage() {        
    router.push({            
      uri: 'pages/mall/mall',        
    });    
  }
}
```


```
// Navigate from the mall page to the detail page through router.back().
export default {    
  mallBackPage() {        
    router.back();    
  }
}
```


```
// Navigate from the detail page to the index page through router.back().
export default {    
  defaultBack() {        
    router.back();    
  }
}
```


```
// Return to the detail page through router.back().
export default {    
  backToDetail() {        
    router.back({uri:'pages/detail/detail'});    
  }
}
```

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**
> In the example, the **uri** field indicates the page route, which is specified by the **pages** list in the **config.json** file.

## router.getParams

getParams(): ParamsInterface

Obtains parameter information about the current page.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Return value**

| Type                                 | Description                   |
| ----------------------------------- | --------------------- |
| [ParamsInterface](#paramsinterface) | For details, see **ParamsInterface**.|

## router.clear

clear(): void

Clears all historical pages in the stack and retains only the current page at the top of the stack.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Example**

```
export default {    
  clearPage() {        
    router.clear();    
  }
}
```

## router.getLength

getLength(): string

Obtains the number of pages in the current stack.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Return value**

| Type    | Description                |
| ------ | ------------------ |
| string | Number of pages in the stack. The maximum value is **32**.|

**Example**

```
export default {     
  getLength() {        
    var size = router.getLength();        
    console.log('pages stack size = ' + size);    
  }
}
```

## router.getState

getState(): RouterState

Obtains state information about the current page.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Return value**

| Type                       | Description               |
| --------------------------- | ----------------- |
| [RouterState](#routerstate) | For details, see **RouterState**.|

**Example**

```
export default {     
  getState() {        
    var page = router.getState();
    console.log('current index = ' + page.index);
    console.log('current name = ' + page.name);
    console.log('current path = ' + page.path);
  }
}
```

## router.enableAlertBeforeBackPage<sup>6+</sup>

enableAlertBeforeBackPage(options: EnableAlertBeforeBackPageOptions): void

Enables the display of a confirm dialog box before returning to the previous page.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Parameters**

| Name    | Type                                      | Mandatory  | Description                                    |
| ------- | ---------------------------------------- | ---- | -------------------------------------- |
| options | [EnableAlertBeforeBackPageOptions](#enablealertbeforebackpageoptions6) | Yes   | For details, see **EnableAlertBeforeBackPageOptions**.|

**Example**

```
export default {    
  enableAlertBeforeBackPage() {        
    router.enableAlertBeforeBackPage({            
      message: 'Message Info',            
      success: function() {                
        console.log('success');            
      },            
      fail: function() {                
        console.log('fail');            
      },        
    });    
  }
}
```

## router.disableAlertBeforeBackPage<sup>6+</sup>

disableAlertBeforeBackPage(options?: DisableAlertBeforeBackPageOptions): void

Disables the display of a confirm dialog box before returning to the previous page.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

**Parameters**

| Name    | Type                                      | Mandatory  | Description                                     |
| ------- | ---------------------------------------- | ---- | --------------------------------------- |
| options | [DisableAlertBeforeBackPageOptions](#disablealertbeforebackpageoptions6) | No   | For details, see **DisableAlertBeforeBackPageOptions**.|

**Example**

```
export default {    
  disableAlertBeforeBackPage() {        
    router.disableAlertBeforeBackPage({            
      success: function() {                
        console.log('success');            
      },            
      fail: function() {                
        console.log('fail');            
      },        
    });    
  }
}
```

## RouterOptions

Defines the page routing parameters.

**System capability**: SystemCapability.ArkUI.ArkUI.Lite

| Name    | Type  | Mandatory  | Description                                      |
| ------ | ------ | ---- | ---------------------------------------- |
| uri    | string | Yes   | URI of the destination page, in either of the following formats:<br>1. Absolute path, which is provided by the **pages** list in the **config.json** file. Example:<br>- pages/index/index<br> -pages/detail/detail<br>2. Specific path. If the URI is a slash (/), the home page is displayed.|
| params | Object | No   | Data that needs to be passed to the destination page during redirection. After the destination page is displayed, it can use the passed data, for example, **this.data1** (**data1** is a key in **params**). If there is the same key (for example, **data1**) on the destination page, the passed **data1** value will replace the original value on the destination page.|


## BackRouterOptions

Defines the parameters for routing back.

**System capability**: The items in the table below require different system capabilities. For details, see the table.

| Name    | Type  | Mandatory  | Description                                      |
| ------ | ------ | ---- | ---------------------------------------- |
| uri    | string | No   | URI of the page to return to. If the specified page does not exist in the page stack, the application does not respond. If this parameter is not set, the application returns to the previous page.<br>**System capability**: SystemCapability.ArkUI.ArkUI.Full|
| params | Object | No   | Data that needs to be passed to the destination page during redirection.<br>**System capability**: SystemCapability.ArkUI.ArkUI.Lite|

## RouterState

Defines the page state.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

| Name   | Type  | Mandatory  | Description                                |
| ----- | ------ | ---- | ---------------------------------- |
| index | number | Yes   | Index of the current page in the stack. The index starts from 1 from the bottom to the top of the stack.|
| name  | string | Yes   | Name of the current page, that is, the file name.                 |
| path  | string | Yes   | Path of the current page.                        |

## EnableAlertBeforeBackPageOptions<sup>6+</sup>

Defines the **EnableAlertBeforeBackPage** parameters.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

| Name      | Type                    | Mandatory  | Description                       |
| -------- | ------------------------ | ---- | ------------------------- |
| message  | string                   | Yes   | Content displayed in the confirm dialog box.                 |
| success  | (errMsg: string) => void | No   | Called when a dialog box is displayed. **errMsg** indicates the returned information.   |
| fail     | (errMsg: string) => void | No   | Called when the API fails to be called. **errMsg** indicates the returned information.|
| complete | () => void               | No   | Called when the API call is complete.             |

## DisableAlertBeforeBackPageOptions<sup>6+</sup>

Define the **DisableAlertBeforeBackPage** parameters.

**System capability**: SystemCapability.ArkUI.ArkUI.Full

| Name      | Type                    | Mandatory  | Description                       |
| -------- | ------------------------ | ---- | ------------------------- |
| success  | (errMsg: string) => void | No   | Called when a dialog box is displayed. **errMsg** indicates the returned information.   |
| fail     | (errMsg: string) => void | No   | Called when the API fails to be called. **errMsg** indicates the returned information.|
| complete | () => void               | No   | Called when the API call is complete.             |

## ParamsInterface

| Name           | Type  | Description     |
| ------------- | ------ | ------- |
| [key: string] | Object | List of routing parameters.|
