# 子系统<a name="ZH-CN_TOPIC_0000001162422291"></a>

-   [简介](#section104mcpsimp)
-   [目录](#section119mcpsimp)
-   [使用说明](#section128mcpsimp)
    -   [接收指定网络的状态变化通知](#section1458213210369)
    -   [发起网络请求](#section750135512369)

-   [相关仓](#section152mcpsimp)

## 简介<a name="section104mcpsimp"></a>

网络管理子系统，作为设备联网的必备组件，提供了对不同类型网络连接的统一管理，并提供了网络协议栈能力。应用可以通过调用API来获取数据网络的连接信息，查询和订阅数据网络的连接状态等，并可通过网络协议栈进行数据传输。

各个部件主要作用如下：

-   基础网络连接管理部件：主要功能是提供基础网络连接管理和对应的JS/Native API，包括不同网络连接优先级管理、网络连接信息查询、网络连接状态变化、DNS解析以及物理网络管理等。
-   网络协议栈部件：主要功能是提供基础的网络协议栈和对应的JS API，包括HTTP、HTTPS、TCP、UDP等基础网络协议栈能力。

**图 1**   子系统架构图

![](figures/zh-cn_architecture-of-netmanager-subsystem.png)

## 目录<a name="section119mcpsimp"></a>

```
foundation/communication/
├── netmanager_base            # 基础网络连接管理
└── netstack                   # 网络协议栈
```

## 使用说明<a name="section128mcpsimp"></a>

### 接收指定网络的状态变化通知<a name="section1458213210369"></a>

1. 从@ohos.net.connection.d.ts中导入connection命名空间。

2. 调用createNetConnection方法，指定网络能力、网络类型和超时时间（可选，如不传入代表默认网络），创建一个NetConnection对象。

3. 调用该对象的on方法，传入type和callback，订阅关心的事件。

4. 调用该对象的register方法，订阅指定网络状态变化的通知。

5. 当网络可用时，会收到netAvailable事件的回调。

6. 当不使用该网络时，可以调用该对象的unregister方法，取消订阅。

   ```
   // 引入包名
   import connection from '@ohos.net.connection'
   
   let netCap = {
       // 指定网络类型为蜂窝网络
       bearerTypes: [connection.NetBearType.BEARER_CELLULAR],
       // 指定网络能力为Internet
       networkCap: [connection.NetCap.NET_CAPABILITY_INTERNET],
   };
   let netSpec = {
       netCapabilities: netCap,
   };
   // 指定超时时间为10s
   let timeout = 10 * 1000;
   // 创建NetConnection对象
   let conn = connection.createNetConnection(netSpec, timeout);
   // 订阅事件，以on_netAvailable为例
   conn.on('netAvailable', (data=> {
       console.log("net is available, netId is " + data.netId);
   }));
   // 订阅指定网络状态变化的通知
   conn.register((err, data) => {});
   // 当不使用该网络时，可以调用该对象的unregister方法，取消订阅
   conn.unregister((err, data) => {});
   ```


### 发起网络请求<a name="section750135512369"></a>

1. 从@ohos.net.http.d.ts中导入http命名空间。
2. 调用createHttp方法，创建一个HttpRequest对象。
3. 调用该对象的on方法，订阅http响应头，此接口会比request请求先返回。可以根据业务需要订阅此消息。
4. 调用该对象的request方法，传入http请求的url地址和可选参数，发起网络请求。
5. 开发者按照实际业务需要，解析返回结果。
6. 当该请求使用完毕时，调用destroy方法主动销毁。

```
// 引入包名
import http from '@ohos.net.http';

// 每一个httpRequest对应一个http请求任务，不可复用
let httpRequest = http.createHttp();
// 用于订阅http响应头，此接口会比request请求先返回。可以根据业务需要订阅此消息
httpRequest.on('headersReceive', (data) => {
    console.info('header: ' + data.header);
});
httpRequest.request(
    // 填写http请求的url地址，可以带参数也可以不带参数。URL地址需要开发者自定义。GET请求的参数可以在extraData中指定
    "EXAMPLE_URL",
    {
        method: 'POST', // 可选，默认为“GET”
        // 开发者根据自身业务需要添加header字段
        header: {
            'Content-Type': 'application/json'
        },
        // 当使用POST请求时此字段用于传递内容
        extraData: {
            "data": "data to send",
        },
        connectTimeout: 60000, // 可选，默认为60s
        readTimeout: 60000, // 可选，默认为60s
    },(err, data) => {
        if (!err) {
            // data.result为http响应内容，可根据业务需要进行解析
            console.info('Result:' + data.result);
            console.info('code:' + data.responseCode);
            // data.header为http响应头，可根据业务需要进行解析
            console.info('header:' + data.header);
            console.info('header:' + data.cookies);
        } else {
            console.info('error:' + err);
        }
        // 当该请求使用完毕时，调用destroy方法主动销毁。
        httpRequest.destroy();
    }
);
```


## 相关仓<a name="section152mcpsimp"></a>

**网络管理子系统**

[communication_netmanager_base](https://gitee.com/openharmony/communication_netmanager_base/blob/master/README_zh.md)

[communication_netstack](https://gitee.com/openharmony/communication_netstack/blob/master/README_zh.md)