# USB管理

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 本模块首批接口从API version 8开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。

## 导入模块

```
import usb from "@ohos.usb";
```

## usb.getDevices

usb.getDevices(): Array&lt;Readonly&lt;USBDevice&gt;&gt;

获取USB设备列表。

**系统能力**: SystemCapability.USB.USBManager

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Array&lt;Readonly&lt;[USBDevice](#usbdevice)&gt;&gt; | 设备信息列表。 |

- 示例：
  ```
  let devicesList = usb.getDevices();
  console.log(`devicesList = ${JSON.stringify(devicesList)}`);
  //devicesList  返回的数据结构
  //此处提供一个简单的示例，如下
  [
    {
      name: "1-1",
      serial: "",
      manufacturerName: "",
      productName: "",
      version: "",
      vendorId: 7531,
      productId: 2,
      clazz: 9,
      subclass: 0,
      protocol: 1,
      devAddress: 1,
      busNum: 1,
      configs: [
        {
          id: 1,
          attributes: 224,
          isRemoteWakeup: true,
          isSelfPowered: true,
          maxPower: 0,
          name: "1-1",
          interfaces: [
            {
              id: 0,
              protocol: 0,
              clazz: 9,
              subclass: 0,
              alternateSetting: 0,
              name: "1-1",
              endpoints: [
                {
                  address: 129,
                  attributes: 3,
                  interval: 12,
                  maxPacketSize: 4,
                  direction: 128,
                  number: 1,
                  type: 3,
                  interfaceId: 0,
                },
              ],
            },
          ],
        },
      ],
    },
  ]
  ```


## usb.connectDevice

usb.connectDevice(device: USBDevice): Readonly&lt;USBDevicePipe&gt;

打开USB设备。

需要调用[usb.getDevices](#usbgetdevices)获取设备信息以及device；再调用[usb.requestRight](#usbrequestright)获取设备请求权限。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | device | [USBDevice](#usbdevice) | 是 | USB设备信息。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Readonly&lt;[USBDevicePipe](#usbdevicepipe)&gt; | 指定的传输通道对象。 |

- 示例：
  ```
  let devicepipe= usb.connectDevice(device);
  console.log(`devicepipe = ${JSON.stringify(devicepipe)}`);
  ```


## usb.hasRight

usb.hasRight(deviceName: string): boolean

判断是否有权访问该设备。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | deviceName | string | 是 | 设备名称。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | boolean | true表示有访问设备的权限，false表示没有访问设备的权限。 |

- 示例：
  ```
  let divicesName="1-1";
  let bool = usb.hasRight(divicesName);
  console.log(bool);
  ```


## usb.requestRight

usb.requestRight(deviceName: string): Promise&lt;boolean&gt;

请求软件包的临时权限以访问设备。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | deviceName | string | 是 | 设备名称。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Promise&lt;boolean&gt; | 获取到true则表示软件包的临时权限已访问成功，&nbsp;获取到false则表示软件包的临时权限已访问失败。 |

- 示例：
  ```
  let divicesName="1-1";
  usb.requestRight(divicesName).then((ret) => {
    console.log(`requestRight = ${JSON.stringify(ret)}`);
  });
  ```


## usb.claimInterface

usb.claimInterface(pipe: USBDevicePipe, iface: USBInterface, force?: boolean): number

注册通信接口。

需要调用[usb.getDevices](#usbgetdevices)获取设备信息以及interfaces；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)接口得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |
  | iface | [USBInterface](#usbinterface) | 是 | 用于确定需要获取接口的索引。 |
  | force | boolean | 否 | 可选参数，是否强制获取。默认值false&nbsp;，表示不强制获取。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 注册通信接口成功返回0；注册通信接口失败返回其他错误码。 |

- 示例：
  ```
  let ret = usb.claimInterface(devicepipe, interfaces);
  console.log(`claimInterface = ${ret}`);
  ```


## usb.releaseInterface

usb.releaseInterface(pipe: USBDevicePipe, iface: USBInterface): number

释放注册过的通信接口。

需要调用[usb.claimInterface](#usbclaiminterface)先获取接口，才能使用此方法释放接口。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |
  | iface | [USBInterface](#usbinterface) | 是 | 用于确定需要释放接口的索引。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 释放接口成功返回0；释放接口失败返回其他错误码。 |

- 示例：
  ```
  let ret = usb.releaseInterface(devicepipe, interfaces);
  console.log(`releaseInterface = ${ret}`);
  ```


## usb.setConfiguration

usb.setConfiguration(pipe: USBDevicePipe, config: USBConfig): number

设置设备配置。

需要调用[usb.getDevices](#usbgetdevices)获取设备信息以及config；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |
  | config | [USBConfig](#usbconfig) | 是 | 用于确定需要设置的配置。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 设置设备配置成功返回0；设置设备配置失败返回其他错误码。 |

- 示例：
  ```
  let ret = usb.setConfiguration(devicepipe, config);
  console.log(`setConfiguration = ${ret}`);
  ```


## usb.setInterface

usb.setInterface(pipe: USBDevicePipe, iface: USBInterface): number

设置设备接口。

需要调用[usb.getDevices](#usbgetdevices)获取设备列表以及interfaces；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |
  | iface | [USBInterface](#usbinterface) | 是 | 用于确定需要设置的接口。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 设置设备接口成功返回0；设置设备接口失败返回其他错误码。 |

- 示例：
  ```
  let ret = usb.setInterface(devicepipe, interfaces);
  console.log(`setInterface = ${ret}`);
  ```


## usb.getRawDescriptor

usb.getRawDescriptor(pipe: USBDevicePipe): Uint8Array

获取原始的USB描述符。

需要调用[usb.getDevices](#usbgetdevices)获取设备列表；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)接口得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Uint8Array | 返回获取的原始数据。 |

- 示例：
  ```
  let ret = usb.getRawDescriptor(devicepipe);
  ```


## usb.getFileDescriptor

usb.getFileDescriptor(pipe: USBDevicePipe): number

获取文件描述符。

需要调用[usb.getDevices](#usbgetdevices)获取设备列表；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)接口得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定总线号和设备地址。 |

- 返回值:
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 返回设备对应的文件描述符。 |

- 示例：
  ```
  let ret = usb.getFileDescriptor(devicepipe);
  ```


## usb.controlTransfer

usb.controlTransfer(pipe: USBDevicePipe, contrlparam: USBControlParams, timeout?: number): Promise&lt;number&gt;

控制传输。

需要调用[usb.getDevices](#usbgetdevices)获取设备列表；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)接口得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定设备。 |
  | contrlparam | [USBControlParams](#usbcontrolparams) | 是 | 控制传输参数。 |
  | timeout | number | 否 | 超时时间，可选参数，默认为0不超时。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Promise&lt;number&gt; | 获取传输或接收到的数据块大小，&nbsp;获取到-1则表示异常。 |

- 示例：
  ```
  usb.controlTransfer(devicepipe, USBControlParams).then((ret) => {
   console.log(`controlTransfer = ${JSON.stringify(ret)}`);
  })
  ```


## usb.bulkTransfer

usb.bulkTransfer(pipe: USBDevicePipe, endpoint: USBEndpoint, buffer: Uint8Array, timeout?: number): Promise&lt;number&gt;

批量传输。

需要调用[usb.getDevices](#usbgetdevices)获取设备信息列表以及endpoint；再调用[usb.requestRight](#usbrequestright)获取设备请求权限；然后调用[usb.connectDevice](#usbconnectdevice)接口得到返回数据devicepipe之后，再次获取接口[usb.claimInterface](#usbclaiminterface)；再调用usb.bulkTransfer接口。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定设备。 |
  | endpoint | [USBEndpoint](#usbendpoint) | 是 | 用于确定传输的端口。 |
  | buffer | Uint8Array | 是 | 用于写入或读取的缓冲区。 |
  | timeout | number | 否 | 超时时间，可选参数，默认为0不超时。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | Promise&lt;number&gt; | 获取传输或接收到的数据块大小，&nbsp;获取到-1则表示异常。 |

- 示例：
  ```
  //usb.getDevices 接口返回数据集合，取其中一个设备对象，并获取权限 。
  //把获取到的设备对象作为参数传入usb.connectDevice;当usb.connectDevice接口成功返回之后；
  //才可以调用第三个接口usb.claimInterface.当usb.claimInterface 调用成功以后,再调用该接口。
  usb.bulkTransfer(devicepipe, endpoint, buffer).then((ret) => {
   console.log(`bulkTransfer = ${JSON.stringify(ret)}`);
  });
  ```


## usb.closePipe

usb.closePipe(pipe: USBDevicePipe): number

关闭设备消息控制通道。

需要调用[usb.getDevices](#usbgetdevices)获取设备列表；调用[usb.requestRight](#usbrequestright)获取设备请求权限；调用[usb.connectDevice](#usbconnectdevice)得到devicepipe作为参数。

**系统能力**: SystemCapability.USB.USBManager

- 参数：
  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | pipe | [USBDevicePipe](#usbdevicepipe) | 是 | 用于确定USB设备消息控制通道。 |

- 返回值：
  | 类型 | 说明 |
  | -------- | -------- |
  | number | 关闭设备消息控制通道成功返回0；关闭设备消息控制通道失败返回其他错误码。 |

- 示例：
  ```
  let ret = usb.closePipe(devicepipe);
  console.log(`closePipe = ${ret}`);
  ```


## USBEndpoint

通过USB发送和接收数据的端口。通过[USBInterface](#usbinterface)获取。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| address | number | 端点地址。<br>**系统能力**: SystemCapability.USB.USBManager |
| attributes | number | 端点属性。<br>**系统能力**: SystemCapability.USB.USBManager |
| interval | number | 端点间隔。<br>**系统能力**: SystemCapability.USB.USBManager |
| maxPacketSize | number | 端点最大数据包大小。<br>**系统能力**: SystemCapability.USB.USBManager |
| direction | [USBRequestDirection](#usbrequestdirection) | 端点的方向。<br>**系统能力**: SystemCapability.USB.USBManager |
| number | number | 端点号。<br>**系统能力**: SystemCapability.USB.USBManager |
| type | number | 端点类型。<br>**系统能力**: SystemCapability.USB.USBManager |
| interfaceId | number | 端点所属的接口的唯一标识。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBInterface

一个[USBConfig](#usbconfig)中可以含有多个USBInterface，每个USBInterface提供一个功能。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| id | number | 接口的唯一标识。<br>**系统能力**: SystemCapability.USB.USBManager |
| protocol | number | 接口的协议。<br>**系统能力**: SystemCapability.USB.USBManager |
| clazz | number | 设备类型。<br>**系统能力**: SystemCapability.USB.USBManager |
| subClass | number | 设备子类。<br>**系统能力**: SystemCapability.USB.USBManager |
| alternateSetting | number | 在同一个接口中的多个描述符中进行切换设置。<br>**系统能力**: SystemCapability.USB.USBManager |
| name | string | 接口名称。<br>**系统能力**: SystemCapability.USB.USBManager |
| endpoints | Array&lt;[USBEndpoint](#usbendpoint)&gt; | 当前接口所包含的端点。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBConfig

USB配置，一个[USBDevice](#usbdevice)中可以含有多个配置。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| id | number | 配置的唯一标识。<br>**系统能力**: SystemCapability.USB.USBManager |
| attributes | number | 配置的属性。<br>**系统能力**: SystemCapability.USB.USBManager |
| maxPower | number | 最大功耗，以毫安为单位。<br>**系统能力**: SystemCapability.USB.USBManager |
| name | string | 配置的名称，可以为空。<br>**系统能力**: SystemCapability.USB.USBManager |
| isRemoteWakeup | boolean | 检查当前配置是否支持远程唤醒。<br>**系统能力**: SystemCapability.USB.USBManager |
| isSelfPowered | boolean | 检查当前配置是否支持独立电源。<br>**系统能力**: SystemCapability.USB.USBManager |
| interfaces | Array&nbsp;&lt;[USBInterface](#usbinterface)&gt; | 配置支持的接口属性。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBDevice

USB设备信息。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| busNum | number | 总线地址。<br>**系统能力**: SystemCapability.USB.USBManager |
| devAddress | number | 设备地址。<br>**系统能力**: SystemCapability.USB.USBManager |
| serial | string | 序列号。<br>**系统能力**: SystemCapability.USB.USBManager |
| name | string | 设备名字。<br>**系统能力**: SystemCapability.USB.USBManager |
| manufacturerName | string | 产商信息。<br>**系统能力**: SystemCapability.USB.USBManager |
| productName | string | 产品信息。<br>**系统能力**: SystemCapability.USB.USBManager |
| version | string | 版本。<br>**系统能力**: SystemCapability.USB.USBManager |
| vendorId | number | 厂商ID。<br>**系统能力**: SystemCapability.USB.USBManager |
| productId | number | 产品ID。<br>**系统能力**: SystemCapability.USB.USBManager |
| clazz | number | 设备类。<br>**系统能力**: SystemCapability.USB.USBManager |
| subClass | number | 设备子类。<br>**系统能力**: SystemCapability.USB.USBManager |
| protocol | number | 设备协议码。<br>**系统能力**: SystemCapability.USB.USBManager |
| configs | Array&lt;[USBConfig](#usbconfig)&gt; | 设备配置描述符信息。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBDevicePipe

USB设备消息传输通道，用于确定设备。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| busNum | number | 总线地址。<br>**系统能力**: SystemCapability.USB.USBManager |
| devAddress | number | 设备地址。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBControlParams

控制传输参数。

| 名称 | 参数类型 | 说明 |
| -------- | -------- | -------- |
| request | number | 请求类型。 |
| target | [USBRequestTargetType](#usbrequesttargettype) | 请求目标类型。<br>**系统能力**: SystemCapability.USB.USBManager |
| reqType | [USBControlRequestType](#usbcontrolrequesttype) | 请求控制类型。<br>**系统能力**: SystemCapability.USB.USBManager |
| value | number | 请求参数。<br>**系统能力**: SystemCapability.USB.USBManager |
| index | number | 请求参数value对应的索引值。<br>**系统能力**: SystemCapability.USB.USBManager |
| data | Uint8Array | 用于写入或读取的缓冲区。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBRequestTargetType

请求目标类型。


| 名称 | 默认值 | 说明 |
| -------- | -------- | -------- |
| USB_REQUEST_TARGET_DEVICE | 0 | 设备。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TARGET_INTERFACE | 1 | 接口。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TARGET_ENDPOINT | 2 | 端点。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TARGET_OTHER | 3 | 其他。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBControlRequestType

控制请求类型。

| 名称 | 默认值 | 说明 |
| -------- | -------- | -------- |
| USB_REQUEST_TYPE_STANDARD | 0 | 标准。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TYPE_CLASS | 1 | 类。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TYPE_VENDOR | 2 | 厂商。<br>**系统能力**: SystemCapability.USB.USBManager |


## USBRequestDirection

请求方向。

| 名称 | 默认值 | 说明 |
| -------- | -------- | -------- |
| USB_REQUEST_TYPE_STANDARD | 0 | 写数据，主设备往从设备。<br>**系统能力**: SystemCapability.USB.USBManager |
| USB_REQUEST_TYPE_CLASS | 0x80 | 读数据，从设备往主设备。<br>**系统能力**: SystemCapability.USB.USBManager |

| 名称 | 默认值 | 说明 |
| -------- | -------- | -------- |
| NONE | 0 | 无。<br>**系统能力**: SystemCapability.USB.USBManager |
| ACM | 1 | 串口设备。<br>**系统能力**: SystemCapability.USB.USBManager |
| ECM | 2 | 网口设备。<br>**系统能力**: SystemCapability.USB.USBManager |
| HDC | 4 | HDC设备。<br>**系统能力**: SystemCapability.USB.USBManager |
