# 关系型数据库概述

关系型数据库（Relational Database，RDB）是一种基于关系模型来管理数据的数据库。关系型数据库基于SQLite组件提供了一套完整的对本地数据库进行管理的机制，对外提供了一系列的增、删、改、查等接口，也可以直接运行用户输入的SQL语句来满足复杂的场景需要。

## 基本概念

- **关系型数据库**

  基于关系模型来管理数据的数据库，以行和列的形式存储数据。

- **谓词**

  数据库中用来代表数据实体的性质、特征或者数据实体之间关系的词项，主要用来定义数据库的操作条件。

- **结果集**

  指用户查询之后的结果集合，可以对数据进行访问。结果集提供了灵活的数据访问方式，可以更方便的拿到用户想要的数据。

- **SQLite数据库**

  一款遵守ACID的轻型开源关系型数据库管理系统。

## 运作机制

关系型数据库对外提供通用的操作接口，底层使用SQLite作为持久化存储引擎，支持SQLite具有的所有数据库特性，包括但不限于事务、索引、视图、触发器、外键、参数化查询和预编译SQL语句。

**图1** 关系型数据库运作机制

![how-rdb-works](figures/how-rdb-works.png)

## 默认配置

- 如果不指定数据库的日志模式，那么系统默认日志方式是WAL（Write Ahead Log）模式。
- 如果不指定数据库的落盘模式，那么系统默认落盘方式是FULL模式。
- OpenHarmony数据库使用的共享内存默认大小是2MB。

## 约束与限制

- 数据库中连接池的最大数量是4个，用以管理用户的读操作。

- 为保证数据的准确性，数据库同一时间只能支持一个写操作。