#  Kernel

- [Kernel for Mini Systems](kernel-mini.md)
  - [Kernel Overview](kernel-mini-overview.md)
  - [Basic Kernel](kernel-mini-basic.md)
    - [Interrupt Management](kernel-mini-basic-interrupt.md)
    - [Task Management](kernel-mini-basic-task.md)
    - [Memory Management](kernel-mini-basic-memory.md)
      - [Basic Concepts](kernel-mini-basic-memory-basic.md)
      - [Static Memory](kernel-mini-basic-memory-static.md)
      - [Dynamic Memory](kernel-mini-basic-memory-dynamic.md)
    - [Kernel Communication Mechanisms](kernel-mini-basic-ipc.md)
      - [Event](kernel-mini-basic-ipc-event.md)
      - [Mutex](kernel-mini-basic-ipc-mutex.md)
      - [Queue](kernel-mini-basic-ipc-queue.md)
      - [Semaphore](kernel-mini-basic-ipc-sem.md)
    - [Time Management](kernel-basic-mini-time.md)
    - [Software Timer](kernel-mini-basic-soft.md)
  - [Extended Components](kernel-mini-extend.md)
    - [C++ Support](kernel-mini-extend-support.md)
    - [CPUP](kernel-mini-extend-cpup.md)
    - [Dynamic Loading](kernel-mini-extend-dynamic-loading.md)
    - [File System](kernel-mini-extend-file.md)
      - [FAT](kernel-mini-extend-file-fat.md)
      - [LittleFS](kernel-mini-extend-file-lit.md)
  - [Kernel Debugging](kernel-mini-debug.md)
    - [Memory Debugging](kernel-mini-memory-debug.md)
      - [Memory Information Statistics](kernel-mini-memory-debug-mes.md)
      - [Memory Leak Check](kernel-mini-imemory-debug-det.md)
      - [Memory Corruption Check](kernel-mini-memory-debug-cet.md)
    - [Exception Debugging](kernel-mini-memory-exception.md)
    - [Trace](kernel-mini-memory-trace.md)
    - [LMS](kernel-mini-memory-lms.md)
  - [Appendix](kernel-mini-app.md)
    - [Kernel Coding Specification](kernel-mini-appx-code.md)
    - [Basic Data Structure](kernel-mini-appx-data.md)
      - [Doubly Linked List](kernel-mini-appx-data-list.md)
    - [Standard Libraries](kernel-mini-appx-lib.md)
      - [CMSIS Support](kernel-mini-appx-lib-cmsis.md)
      - [POSIX Support](kernel-mini-appx-lib-posix.md)
- [Kernel for Small Systems](kernel-small.md)
  - [Kernel Overview](kernel-small-overview.md)
  - [Kernel Startup](kernel-small-start.md)
    - [Startup in Kernel Space](kernel-small-start-kernel.md)
    - [Startup in User Space](kernel-small-start-user.md)
  - [Basic Kernel](kernel-small-basics.md)
    - [Interrupt and Exception Handling](kernel-small-basic-interrupt.md)
    - [Process Management](kernel-small-basic-process.md)
      - [Process](kernel-small-basic-process-process.md)
      - [Task](kernel-small-basic-process-thread.md)
      - [Scheduler](kernel-small-basic-process-scheduler.md)
    - [Memory Management](kernel-small-basic-memory.md)
      - [Heap Memory Management](kernel-small-basic-memory-heap.md)
      - [Physical Memory Management](kernel-small-basic-memory-physical.md)
      - [Virtual Memory Management](kernel-small-basic-memory-virtual.md)
      - [Virtual-to-Physical Mapping](kernel-small-basic-inner-reflect.md)
    - [Kernel Communication Mechanisms](kernel-small-basic-trans.md)
      - [Event](kernel-small-basic-trans-event.md)
      - [Semaphore](kernel-small-basic-trans-semaphore.md)
      - [Mutex](kernel-small-basic-trans-mutex.md)
      - [Queue](kernel-small-basic-trans-queue.md)
      - [RW Lock](kernel-small-basic-trans-rwlock.md)
      - [Futex](kernel-small-basic-trans-user-mutex.md)
      - [Signal](kernel-small-basic-trans-user-signal.md)
    - [Time Management](kernel-small-basic-time.md)
    - [Software Timer](kernel-small-basic-softtimer.md)
    - [Atomic Operation](kernel-small-basic-atomic.md)
  - [Extension Components](kernel-small-bundles.md)
    - [System Call](kernel-small-bundles-system.md)
    - [Dynamic Loading and Linking](kernel-small-bundles-linking.md)
    - [Virtual Dynamic Shared Object](kernel-small-bundles-share.md)
    - [LiteIPC](kernel-small-bundles-ipc.md)
    - [File Systems](kernel-small-bundles-fs.md)
      - [Virtual File System](kernel-small-bundles-fs-virtual.md)
      - [Supported File Systems](kernel-small-bundles-fs-support.md)
        - [FAT](kernel-small-bundles-fs-support-fat.md)
        - [JFFS2](kernel-small-bundles-fs-support-jffs2.md)
        - [NFS](kernel-small-bundles-fs-support-nfs.md)
        - [Ramfs](kernel-small-bundles-fs-support-ramfs.md)
        - [procfs](kernel-small-bundles-fs-support-procfs.md)
      - [File System Adaptation](kernel-small-bundles-fs-new.md)
  - [Debugging and Tools](kernel-small-debug.md)
    - [Shell](kernel-small-debug-shell.md)
      - [Introduction to the Shell](kernel-small-debug-shell-overview.md)
      - [Shell Command Development Guidelines](kernel-small-debug-shell-guide.md)
      - [Shell Command Programming Example](kernel-small-debug-shell-build.md)
      - [Shell Command Reference](kernel-small-debug-shell-details.md)
        - [System Commands](kernel-small-debug-shell-cmd.md)
          - [cpup](kernel-small-debug-shell-cmd-cpup.md)
          - [date](kernel-small-debug-shell-cmd-date.md)
          - [dmesg](kernel-small-debug-shell-cmd-dmesg.md)
          - [exec](kernel-small-debug-shell-cmd-exec.md)
          - [free](kernel-small-debug-shell-cmd-free.md)
          - [help](kernel-small-debug-shell-cmd-help.md)
          - [hwi](kernel-small-debug-shell-cmd-hwi.md)
          - [kill](kernel-small-debug-shell-cmd-kill.md)
          - [log](kernel-small-debug-shell-cmd-log.md)
          - [memcheck](kernel-small-debug-shell-cmd-memcheck.md)
          - [oom](kernel-small-debug-shell-cmd-oom.md)
          - [pmm](kernel-small-debug-shell-cmd-pmm.md)
          - [reset](kernel-small-debug-shell-cmd-reset.md)
          - [sem](kernel-small-debug-shell-cmd-sem.md)
          - [stack](kernel-small-debug-shell-cmd-stack.md)
          - [su](kernel-small-debug-shell-cmd-su.md)
          - [swtmr](kernel-small-debug-shell-cmd-swtmr.md)
          - [systeminfo](kernel-small-debug-shell-cmd-sysinfo.md)
          - [task](kernel-small-debug-shell-cmd-task.md)
          - [uname](kernel-small-debug-shell-cmd-uname.md)
          - [vmm](kernel-small-debug-shell-cmd-vmm.md)
          - [watch](kernel-small-debug-shell-cmd-watch.md)
        - [File Commands](kernel-small-debug-shell-file.md)
          - [cat](kernel-small-debug-shell-file-cat.md)
          - [cd](kernel-small-debug-shell-file-cd.md)
          - [chgrp](kernel-small-debug-shell-file-chgrp.md)
          - [chmod](kernel-small-debug-shell-file-chmod.md)
          - [chown](kernel-small-debug-shell-file-chown.md)
          - [cp](kernel-small-debug-shell-file-cp.md)
          - [format](kernel-small-debug-shell-file-format.md)
          - [ls](kernel-small-debug-shell-file-ls.md)
          - [lsfd](kernel-small-debug-shell-file-lsfd.md)
          - [mkdir](kernel-small-debug-shell-file-mkdir.md)
          - [mount](kernel-small-debug-shell-file-mount.md)
          - [partinfo](kernel-small-debug-shell-file-partinfo.md)
          - [partition](kernel-small-debug-shell-file-partition.md)
          - [pwd](kernel-small-debug-shell-file-pwd.md)
          - [rm](kernel-small-debug-shell-file-rm.md)
          - [rmdir](kernel-small-debug-shell-file-rmdir.md)
          - [statfs](kernel-small-debug-shell-file-statfs.md)
          - [sync](kernel-small-debug-shell-file-sync.md)
          - [touch](kernel-small-debug-shell-file-touch.md)
          - [writeproc](kernel-small-debug-shell-file-write.md)
          - [umount](kernel-small-debug-shell-file-umount.md)
        - [Network Commands](kernel-small-debug-shell-net.md)
          - [arp](kernel-small-debug-shell-net-arp.md)
          - [dhclient](kernel-small-debug-shell-net-dhclient.md)
          - [ifconfig](kernel-small-debug-shell-net-ifconfig.md)
          - [ipdebug](kernel-small-debug-shell-net-ipdebug.md)
          - [netstat](kernel-small-debug-shell-net-netstat.md)
          - [ntpdate](kernel-small-debug-shell-net-ntpdate.md)
          - [ping](kernel-small-debug-shell-net-ping.md)
          - [ping6](kernel-small-debug-shell-net-ping6.md)
          - [telnet](kernel-small-debug-shell-net-telnet.md)
          - [tftp](kernel-small-debug-shell-net-tftp.md)
      - [Magic Key](kernel-small-debug-shell-magickey.md)
      - [User-Space Exception Information](kernel-small-debug-shell-error.md)
    - [Trace](kernel-small-debug-trace.md)
    - [perf](kernel-mini-memory-perf)
    - [LMS](kernel-small-memory-lms)
    - [Process Commissioning](kernel-small-debug-process.md)
      - [CPUP](kernel-small-debug-process-cpu.md)
    - [Memory Debugging](kernel-small-debug-memory.md)
      - [Memory Information Statistics](kernel-small-debug-memory-info.md)
      - [Memory Leak Check](kernel-small-debug-memory-leak.md)
      - [Memory Corruption Check](kernel-small-debug-memory-corrupt.md)
    - [User-Mode Memory Debugging](kernel-small-debug-user.md)
      - [Basic Concepts](kernel-small-debug-user-concept.md)
      - [Working Principles](kernel-small-debug-user-function.md)
      - [Usage](kernel-small-debug-user-guide.md)
        - [API Description](kernel-small-debug-user-guide-api.md)
        - [How to Use](kernel-small-debug-user-guide-use.md)
          - [Calling APIs](kernel-small-debug-user-guide-use-api.md)
          - [Using the CLI](kernel-small-debug-user-guide-use-cli.md)
      - [Typical Memory Problems](kernel-small-debug-user-faqs.md)
    - [Other Kernel Debugging Methods](kernel-small-debug-other.md)
      - [Dying Gasp](kernel-small-debug-trace-other-lastwords.md)
      - [Common Fault Locating Methods](kernel-small-debug-trace-other-faqs.md)
  - [Appendix](kernel-small-apx.md)
    - [Basic Data Structure](kernel-small-apx-structure.md)
      - [Doubly Linked List](kernel-small-apx-dll.md)
      - [Bitwise Operation](kernel-small-apx-bitwise.md)
    - [Standard Library](kernel-small-apx-library.md)

- [Kernel for Standard Systems](kernel-standard.md)
  - [Linux Kernel Overview](kernel-standard-overview.md)
  - [Applying Patches on OpenHarmony Development Boards](kernel-standard-patch.md)
  - [Guidelines for Building the Linux Kernel](kernel-standard-build.md)