# Panel<a name="EN-US_TOPIC_0000001192755104"></a>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>This component is supported since API version 7. Updates will be marked with a superscript to indicate their earliest API version.

The  **<Panel\>**  component is a slidable panel that presents lightweight content with flexible sizes. It is a pop-up component.

## Required Permissions<a name="section36946188511"></a>

None

## Child Components<a name="section897517591357"></a>

This component can contain child components.

## APIs<a name="section14655428254"></a>

Panel\(value:\{show:boolean\}\)

-   Parameter

    <a name="table10719114169"></a>
    <table><thead align="left"><tr id="row1571913410610"><th class="cellrowborder" valign="top" width="16.11%" id="mcps1.1.6.1.1"><p id="p87202043618"><a name="p87202043618"></a><a name="p87202043618"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="16.580000000000002%" id="mcps1.1.6.1.2"><p id="p5720441466"><a name="p5720441466"></a><a name="p5720441466"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="9.67%" id="mcps1.1.6.1.3"><p id="p147201241662"><a name="p147201241662"></a><a name="p147201241662"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="21.42%" id="mcps1.1.6.1.4"><p id="p187201141967"><a name="p187201141967"></a><a name="p187201141967"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="36.22%" id="mcps1.1.6.1.5"><p id="p127201740612"><a name="p127201740612"></a><a name="p127201740612"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row12720249611"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p07201441569"><a name="p07201441569"></a><a name="p07201441569"></a>show</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.580000000000002%" headers="mcps1.1.6.1.2 "><p id="p1528013403185"><a name="p1528013403185"></a><a name="p1528013403185"></a>boolean</p>
    </td>
    <td class="cellrowborder" valign="top" width="9.67%" headers="mcps1.1.6.1.3 "><p id="p16720134166"><a name="p16720134166"></a><a name="p16720134166"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.42%" headers="mcps1.1.6.1.4 "><p id="p2357916185414"><a name="p2357916185414"></a><a name="p2357916185414"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="36.22%" headers="mcps1.1.6.1.5 "><p id="p137201841366"><a name="p137201841366"></a><a name="p137201841366"></a>Whether the panel is shown or hidden.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Attributes<a name="section1398913481251"></a>

<a name="table2515mcpsimp"></a>
<table><thead align="left"><tr id="row2522mcpsimp"><th class="cellrowborder" valign="top" width="18.81188118811881%" id="mcps1.1.5.1.1"><p id="p2524mcpsimp"><a name="p2524mcpsimp"></a><a name="p2524mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="18.81188118811881%" id="mcps1.1.5.1.2"><p id="p2526mcpsimp"><a name="p2526mcpsimp"></a><a name="p2526mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="14.85148514851485%" id="mcps1.1.5.1.3"><p id="p2528mcpsimp"><a name="p2528mcpsimp"></a><a name="p2528mcpsimp"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="47.52475247524753%" id="mcps1.1.5.1.4"><p id="p2530mcpsimp"><a name="p2530mcpsimp"></a><a name="p2530mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2531mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2533mcpsimp"><a name="p2533mcpsimp"></a><a name="p2533mcpsimp"></a>type</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2535mcpsimp"><a name="p2535mcpsimp"></a><a name="p2535mcpsimp"></a><a href="#li188691730162810">PanelType</a></p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2537mcpsimp"><a name="p2537mcpsimp"></a><a name="p2537mcpsimp"></a>Foldable</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2539mcpsimp"><a name="p2539mcpsimp"></a><a name="p2539mcpsimp"></a>Type of the panel.</p>
</td>
</tr>
<tr id="row2540mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2542mcpsimp"><a name="p2542mcpsimp"></a><a name="p2542mcpsimp"></a>mode</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2544mcpsimp"><a name="p2544mcpsimp"></a><a name="p2544mcpsimp"></a><a href="#li1476011321286">PanelMode</a></p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2546mcpsimp"><a name="p2546mcpsimp"></a><a name="p2546mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2548mcpsimp"><a name="p2548mcpsimp"></a><a name="p2548mcpsimp"></a>Initial status of the panel.</p>
</td>
</tr>
<tr id="row2549mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2551mcpsimp"><a name="p2551mcpsimp"></a><a name="p2551mcpsimp"></a>dragBar</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2553mcpsimp"><a name="p2553mcpsimp"></a><a name="p2553mcpsimp"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2555mcpsimp"><a name="p2555mcpsimp"></a><a name="p2555mcpsimp"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2557mcpsimp"><a name="p2557mcpsimp"></a><a name="p2557mcpsimp"></a>Whether to enable a drag bar. The value <strong id="b175914863823932"><a name="b175914863823932"></a><a name="b175914863823932"></a>true</strong> means that the drag bar will be displayed, and <strong id="b6558009423932"><a name="b6558009423932"></a><a name="b6558009423932"></a>false</strong> means the opposite.</p>
</td>
</tr>
<tr id="row2558mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2560mcpsimp"><a name="p2560mcpsimp"></a><a name="p2560mcpsimp"></a>fullHeight</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2562mcpsimp"><a name="p2562mcpsimp"></a><a name="p2562mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2564mcpsimp"><a name="p2564mcpsimp"></a><a name="p2564mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2566mcpsimp"><a name="p2566mcpsimp"></a><a name="p2566mcpsimp"></a>Panel height in the <strong id="b214616923110"><a name="b214616923110"></a><a name="b214616923110"></a>PanelMode.Full</strong> mode.</p>
</td>
</tr>
<tr id="row2567mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2569mcpsimp"><a name="p2569mcpsimp"></a><a name="p2569mcpsimp"></a>halfHeight</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2571mcpsimp"><a name="p2571mcpsimp"></a><a name="p2571mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2573mcpsimp"><a name="p2573mcpsimp"></a><a name="p2573mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2575mcpsimp"><a name="p2575mcpsimp"></a><a name="p2575mcpsimp"></a>Panel height in the <strong id="b134761647023932"><a name="b134761647023932"></a><a name="b134761647023932"></a>PanelMode.Half</strong> mode. The default value is half of the screen height.</p>
</td>
</tr>
<tr id="row2576mcpsimp"><td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.1 "><p id="p2578mcpsimp"><a name="p2578mcpsimp"></a><a name="p2578mcpsimp"></a>miniHeight</p>
</td>
<td class="cellrowborder" valign="top" width="18.81188118811881%" headers="mcps1.1.5.1.2 "><p id="p2580mcpsimp"><a name="p2580mcpsimp"></a><a name="p2580mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="14.85148514851485%" headers="mcps1.1.5.1.3 "><p id="p2582mcpsimp"><a name="p2582mcpsimp"></a><a name="p2582mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="47.52475247524753%" headers="mcps1.1.5.1.4 "><p id="p2584mcpsimp"><a name="p2584mcpsimp"></a><a name="p2584mcpsimp"></a>Panel height in the <strong id="b1772605453110"><a name="b1772605453110"></a><a name="b1772605453110"></a>PanelMode.Mini</strong> mode.</p>
</td>
</tr>
</tbody>
</table>

-   <a name="li188691730162810"></a>PanelType enums

    <a name="table3452114216394"></a>
    <table><thead align="left"><tr id="row245219426397"><th class="cellrowborder" valign="top" width="22.919999999999998%" id="mcps1.1.3.1.1"><p id="p545244283914"><a name="p545244283914"></a><a name="p545244283914"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="77.08%" id="mcps1.1.3.1.2"><p id="p2452114203917"><a name="p2452114203917"></a><a name="p2452114203917"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row6452144218390"><td class="cellrowborder" valign="top" width="22.919999999999998%" headers="mcps1.1.3.1.1 "><p id="p34529427398"><a name="p34529427398"></a><a name="p34529427398"></a>Minibar</p>
    </td>
    <td class="cellrowborder" valign="top" width="77.08%" headers="mcps1.1.3.1.2 "><p id="p1245211421393"><a name="p1245211421393"></a><a name="p1245211421393"></a>A minibar panel displays content in the minibar area or a large (fullscreen-like) area.</p>
    </td>
    </tr>
    <tr id="row12452184217398"><td class="cellrowborder" valign="top" width="22.919999999999998%" headers="mcps1.1.3.1.1 "><p id="p54523425398"><a name="p54523425398"></a><a name="p54523425398"></a>Foldable</p>
    </td>
    <td class="cellrowborder" valign="top" width="77.08%" headers="mcps1.1.3.1.2 "><p id="p745215426391"><a name="p745215426391"></a><a name="p745215426391"></a>A foldable panel displays permanent content in a large (fullscreen-like), medium-sized (halfscreen-like), or small area.</p>
    </td>
    </tr>
    <tr id="row9452134213392"><td class="cellrowborder" valign="top" width="22.919999999999998%" headers="mcps1.1.3.1.1 "><p id="p510719111403"><a name="p510719111403"></a><a name="p510719111403"></a>Temporary</p>
    </td>
    <td class="cellrowborder" valign="top" width="77.08%" headers="mcps1.1.3.1.2 "><p id="p154533425394"><a name="p154533425394"></a><a name="p154533425394"></a>A temporary panel displays content in a large (fullscreen-like) or medium-sized (halfscreen-like) area.</p>
    </td>
    </tr>
    </tbody>
    </table>


-   <a name="li1476011321286"></a>PanelMode enums

    <a name="table69681541193718"></a>
    <table><thead align="left"><tr id="row10968541133712"><th class="cellrowborder" valign="top" width="25.2%" id="mcps1.1.3.1.1"><p id="p119681141133713"><a name="p119681141133713"></a><a name="p119681141133713"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="74.8%" id="mcps1.1.3.1.2"><p id="p796884115375"><a name="p796884115375"></a><a name="p796884115375"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row18968184183719"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p196834112378"><a name="p196834112378"></a><a name="p196834112378"></a>Mini</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p1196854193717"><a name="p1196854193717"></a><a name="p1196854193717"></a>Displays a <strong id="b689235153219"><a name="b689235153219"></a><a name="b689235153219"></a>minibar</strong> or <strong id="b689295113214"><a name="b689295113214"></a><a name="b689295113214"></a>foldable</strong> panel in its minimum size. This attribute does not take effect for <strong id="b8893115113323"><a name="b8893115113323"></a><a name="b8893115113323"></a>temporary</strong> panels.</p>
    </td>
    </tr>
    <tr id="row15968204153711"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p29681841163712"><a name="p29681841163712"></a><a name="p29681841163712"></a>Half</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p79681841193711"><a name="p79681841193711"></a><a name="p79681841193711"></a>Displays a <strong id="b296919595326"><a name="b296919595326"></a><a name="b296919595326"></a>foldable</strong> or <strong id="b10969559193213"><a name="b10969559193213"></a><a name="b10969559193213"></a>temporary</strong> panel in a medium-sized (halfscreen-like) area. This attribute does not take effect for <strong id="b11969195919328"><a name="b11969195919328"></a><a name="b11969195919328"></a>minibar</strong> panels.</p>
    </td>
    </tr>
    <tr id="row149682414374"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p1196914173710"><a name="p1196914173710"></a><a name="p1196914173710"></a>Full</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p1496974111379"><a name="p1496974111379"></a><a name="p1496974111379"></a>Displays a panel in a large (fullscreen-like) area.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Events<a name="section142174333711"></a>

<a name="table2605mcpsimp"></a>
<table><thead align="left"><tr id="row2611mcpsimp"><th class="cellrowborder" colspan="2" valign="top" id="mcps1.1.4.1.1"><p id="p2615mcpsimp"><a name="p2615mcpsimp"></a><a name="p2615mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" id="mcps1.1.4.1.2"><p id="p2617mcpsimp"><a name="p2617mcpsimp"></a><a name="p2617mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2618mcpsimp"><td class="cellrowborder" colspan="2" valign="top" headers="mcps1.1.4.1.1 "><p id="p2620mcpsimp"><a name="p2620mcpsimp"></a><a name="p2620mcpsimp"></a>onChange(callback: (width: number, height: number, mode: PanelMode) =&gt; void)</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.1.4.1.2 "><p id="p2624mcpsimp"><a name="p2624mcpsimp"></a><a name="p2624mcpsimp"></a>Triggered when the status of the panel changes. The returned height value is the height of the content area. When the value of <strong id="b1464175023311"><a name="b1464175023311"></a><a name="b1464175023311"></a>dragbar</strong> is <strong id="b10868652163316"><a name="b10868652163316"></a><a name="b10868652163316"></a>true</strong>, the height of the panel is the dragbar height plus the height of the content area.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section758722018820"></a>

```
@Entry
@Component
struct PanelExample {
  @State show: boolean = false

  build() {
    Column() {
      Text('2021-09-30    Today Calendar: 1.afternoon......Click for details')
        .width('90%').height(50).borderRadius(10)
        .backgroundColor(0xFFFFFF).padding({ left: 20 })
        .onClick(() => {
          this.show = !this.show
        })
      Panel(this.show) { // Display the agenda.
        Column() {
          Text('Today Calendar')
          Divider()
          Text('1. afternoon 4:00 The project meeting')
        }
      }
      .type(PanelType.Foldable).mode(PanelMode.Half)
      .dragBar(true) // The dragbar is enabled by default.
      .halfHeight(500) // Half of the height by default
      .onChange((value: any) => {
        console.info(`width:${value.width},height:${value.height},mode:${value.mode}`)
      })
    }.width('100%').height('100%').backgroundColor(0xDCDCDC).padding({ top: 5 })
  }
}
```

![](figures/panel.gif)

