# 升级子系统<a name="ZH-CN_TOPIC_0000001149909821"></a>

-   [简介](#section184mcpsimp)
-   [目录](#section212mcpsimp)
-   [相关仓](#section251mcpsimp)

## 简介<a name="section184mcpsimp"></a>

OpenHarmony升级子系统用来支持OpenHarmony设备的OTA\(Over The Air\)升级。整个升级子系统包括如下几块：

1.  升级包制作工具

    升级包制作工具是使用python开发，运行在PC端用来制作升级包的工具。它首先会打包各个升级镜像，然后对升级包进行签名，同时生成升级包执行脚本，最后制作出升级包。工具生成升级脚本，设备侧解析执行脚本。最终完成所有的升级动作。

    升级包里面有两个文件，包括build\_tools.zip 和update.bin。

    -   build\_tools.zip：用来辅助升级的工具，包括升级的可执行文件和升级脚本
    -   update.bin：TLV编码的文件，所有的升级内容按照TLV格式序列化存储，最终生成update.bin

    工具对update.bin 和最终生成的升级包\(zip 压缩文件\)分别进行签名。

2.  升级服务

    升级服务是用来搜索，下载和触发升级。

3.  升级包安装

    升级包安装是升级子系统的核心功能，主要包括：

    1.  从misc分区获取升级命令，根据不同的命令执行不同的任务。
    2.  对升级包进行解压和合法性效验。
    3.  启动升级进程，并解析出升级脚本。
    4.  根据升级脚本安装各个组件包。
    5.  完成升级后，进行后处理。如清理升级包，记录升级状态等。

4.  升级客户端

    升级客户端是用来触发搜包和下载的app。


在进行应用的开发前，开发者应了解以下基本概念：

-   OTA

    Over The Air 的缩写。 OTA 是无线升级的一种方式。升级包通过网络下载到设备中。由设备通过升级子系统进行升级。

-   全量包

    全量包是完整的镜像，由升级子系统将全量包写到分区，达到更新分区的目的。

-   差分包

    根据两个特定版本\(源版本，目标版本\)之间的差异，使用bsdiff生成差分数据，升级子系统根据差分数据制作差分包。


## 目录<a name="section212mcpsimp"></a>

```
base/update             # 升级子系统仓
├── app         		# 升级客户端应用代码
├── packaging_tools     # 升级包制作工具代码
├── updater    			# 升级包安装代码
│   ├── interfaces  	# 对外模块接口定义
│   ├── resources 		# 升级子系统用户界面图片资源，包括动画，进度条图片等
│   ├── services  		# 升级包安装组件逻辑代码
│   └── utils  			# 升级子系统通用代码，包括字符串处理函数，文件处理函数
└── updateservice 		# 升级服务引擎代码   
```

## 相关仓<a name="section251mcpsimp"></a>

**升级子系统**

update\_app

update\_updateservice

update\_updater

update\_packaging\_tools

