# 内核子系统<a name="ZH-CN_TOPIC_0000001077309884"></a>

-   [简介](#section11660541593)
-   [LiteOS](#section6253122153515)
-   [Linux](#section143373618411)
-   [目录](#section21571344112)
-   [约束](#section19647171710417)
-   [使用](#section1393789267)
    -   [LiteOS使用说明](#section118811457303)
    -   [linux使用说明](#section1352114469620)

-   [以hi3516dv300开源开发板+ubuntu x86主机开发环境为例](#section19369206113115)
    -   [场景1：版本级编译原生方式](#section1025111193220)
    -   [场景2：单独编译修改后的内核](#section17446652173211)

-   [相关仓](#section27639463106)

## 简介<a name="section11660541593"></a>

OpenHarmony针对不同量级的系统，分别使用了不同形态的内核，分别为LiteOS和Linux。在轻量系统、小型系统和标准系统上，可以选用LiteOS；在标准系统上，可以选用Linux。

**表 1** 

<a name="table91002058194612"></a>
<table><thead align="left"><tr id="row010015589464"><th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.1"><p id="p310015824612"><a name="p310015824612"></a><a name="p310015824612"></a>系统级别</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.2"><p id="p910013586463"><a name="p910013586463"></a><a name="p910013586463"></a>轻量系统</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.3"><p id="p14100858164615"><a name="p14100858164615"></a><a name="p14100858164615"></a>小型系统</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.4"><p id="p191001158154610"><a name="p191001158154610"></a><a name="p191001158154610"></a>标准系统</p>
</th>
</tr>
</thead>
<tbody><tr id="row18100165894619"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p110055824611"><a name="p110055824611"></a><a name="p110055824611"></a>LiteOS</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.2 "><p id="p3100175815461"><a name="p3100175815461"></a><a name="p3100175815461"></a>√</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.3 "><p id="p15762194124714"><a name="p15762194124714"></a><a name="p15762194124714"></a>√</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.4 "><p id="p647872125416"><a name="p647872125416"></a><a name="p647872125416"></a>√</p>
</td>
</tr>
<tr id="row15104331164711"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p15104163120477"><a name="p15104163120477"></a><a name="p15104163120477"></a>Linux</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.2 ">&nbsp;&nbsp;</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.3 ">&nbsp;&nbsp;</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.4 "><p id="p4251543134711"><a name="p4251543134711"></a><a name="p4251543134711"></a>√</p>
</td>
</tr>
</tbody>
</table>

## LiteOS<a name="section6253122153515"></a>

OpenHarmonyLiteOS内核是面向IoT领域的实时操作系统内核，它同时具备RTOS轻快和Linux易用的特点。

OpenHarmonyLiteOS内核主要包括进程和线程调度、内存管理、IPC机制、timer管理等内核基本功能。

OpenHarmonyLiteOS内核的源代码分为 kernel\_liteos\_a 和 kernel\_liteos\_m 这2个代码仓库，其中kernel\_liteos\_a主要针对小型系统（small system）和标准系统（standard system），而kernel\_liteos\_m则主要针对轻量系统（mini system），下面主要针对kernel\_liteos\_a代码仓库进行介绍。图1为OpenHarmony LiteOS-A内核架构图：

**图 1**  OpenHarmony LiteOS-A内核架构图<a name="fig225412228353"></a>  
![](figures/OpenHarmony-LiteOS-A内核架构图.png "OpenHarmony-LiteOS-A内核架构图")

## Linux<a name="section143373618411"></a>

OpenHarmony的Linux内核基于开源Linux内核LTS 4.19.y分支演进，为满足不同的内核场景诉求，以内核 + patch的形式开展，其中内核在LTS 4.19内核的基础上合入CVE补丁  + OpenHarmony特性作为Common内核基线，针对性打上vendor厂商提供的板级芯片驱动补丁从而构成完整的内核。

Linux社区LTS 4.19.y分支信息请查看[kernel官网](https://git.kernel.org/pub/scm/linux/kernel/git/stable/linux.git/log/?h=linux-4.19.y)。

内核组成模块，以开源Linux内核为基线， 合入了公共补丁：CVE补丁/OpenHarmony特性，在编译构建流程中针对具体芯片平台合入对应的架构驱动代码进行编译对应的内核镜像。所有补丁来源均遵守GPL-2.0协议。

1.  CVE补丁

    补丁所涉及的CVE\(Common Vulnerabilities and Exposures\)安全漏洞是通过NVD \([https://nvd.nist.gov](内核子系统.md)/\)官方机构收集，且补丁已经进入LTS 4.19.y分支或主线，主要涉及存储\(btrfs/scsi/\)、网络\(net/bpf/mwifiex\) 、驱动\(xen/nfc\)，对应CVE列表参考commit信息中CVE字段信息。


1.  OpenHarmony特性

    HDF驱动、binder ipc转发功能等特性支持。

2.  特定芯片架构驱动补丁（比如Hi3516DV300）

    vendor厂商提供的特定芯片架构驱动代码：

    hisi\_linux-4.19\_hos\_l2.patch: 在Hi3516DV300芯片上支持arm架构的内核启动（DTS等）及对应的drm/mmc等驱动的支持。


## 目录<a name="section21571344112"></a>

```
kernel/
├── linux-4.19                  # 4.19内核基线代码
├── linux/config/linux-4.19    # 内核config
│   └── standard_common_defconfig                         # 标准系统的内核的common defconfig
│   └── hi3516dv300_emmc_smp_hos_l2_defconfig             # 厂商Hisilicon对应的开源开发板Hi3516dv300标准系统的defconfig
├── linux/patches/linux-4.19          # 内核patch及编译脚本
└── liteos_a                    # liteos内核基线代码
     ├── apps                   # 用户态的init和shell应用程序
     ├── arch                   # 体系架构的目录，如arm等
     │   └── arm                # arm架构代码
     ├── bsd                    # freebsd相关的驱动和适配层模块代码引入，例如USB等
     ├── compat                 # 内核接口兼容性目录
     │   └── posix              # posix相关接口
     ├── drivers                # 内核驱动
     │   └── char               # 字符设备
     │       ├── mem            # 访问物理IO设备驱动
     │       ├── quickstart     # 系统快速启动接口目录
     │       ├── random         # 随机数设备驱动
     │       └── video          # framebuffer驱动框架
     ├── fs                     # 文件系统模块，主要来源于NuttX开源项目
     │   ├── fat                # fat文件系统
     │   ├── jffs2              # jffs2文件系统
     │   ├── include            # 对外暴露头文件存放目录
     │   ├── nfs                # nfs文件系统
     │   ├── proc               # proc文件系统
     │   ├── ramfs              # ramfs文件系统
     │   └── vfs                # vfs层
     ├── kernel                 # 进程、内存、IPC等模块
     │   ├── base               # 基础内核，包括调度、内存等模块
     │   ├── common             # 内核通用组件
     │   ├── extended           # 扩展内核，包括动态加载、vdso、liteipc等模块
     │   ├── include            # 对外暴露头文件存放目录
     │   └── user               # 加载init进程
     ├── lib                    # 内核的lib库
     ├── net                    # 网络模块，主要来源于lwip开源项目
     ├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
     │   ├── hw                 # 时钟与中断相关逻辑代码
     │   ├── include            # 对外暴露头文件存放目录
     │   └── uart               # 串口相关逻辑代码
     ├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
     ├── security               # 安全特性相关的代码，包括进程权限管理和虚拟id映射管理
     ├── syscall                # 系统调用
     └── tools                  # 构建工具及相关配置和代码
```

## 约束<a name="section19647171710417"></a>

LiteOS：

Hi3518EV300默认使用jffs2文件系统，Hi3516DV300默认使用FAT文件系统。若要使用其他文件系统，需要新增适配。

## 使用<a name="section1393789267"></a>

### LiteOS使用说明<a name="section118811457303"></a>

参见LiteOS-A内核[README](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)和LiteOS-M内核[README](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)的“使用说明”章节。

### linux使用说明<a name="section1352114469620"></a>

如需使用上述patch，需要在内核代码完成对应芯片平台驱动补丁进行合入。

1.  合入芯片平台驱动补丁

    针对不同芯片平台合入对应的patch，以上述Hi3516DV300为例：

    ```
    patch -p1 < device/hisilicon/hi3516dv300/sdk_linux/open_source/linux/hisi_linux-4.19_hos_l2.patch
    ```

    >![](public_sys-resources/icon-notice.gif) **须知：** 
    >由于OpenHarmony工程的编译构建流程中会拷贝kernel/linux-4.19的代码环境后进行打补丁动作，在使用OpenHarmony的版本级编译命令前，需要kernel/linux-4.19保持原代码环境。


## 以hi3516dv300开源开发板+ubuntu x86主机开发环境为例<a name="section19369206113115"></a>

### 场景1：版本级编译原生方式<a name="section1025111193220"></a>

使用工程的全量编译命令，编译生成uImage内核镜像

```
./build.sh --product-name Hi3516DV300 # 编译hi3516dv300的uImage内核镜像
```

### 场景2：单独编译修改后的内核<a name="section17446652173211"></a>

1.  准备工作

    准备编译环境，可以使用开源arm clang/gcc编译器，或者使用工程自带编译器。

    进入工程主目录配置环境变量：

    ```
    export PATH=`pwd`/prebuilts/clang/host/linux-x86/clang-r353983c/bin:`pwd`/prebuilts/gcc/linux-x86/arm/gcc-linaro-7.5.0-arm-linux-gnueabi/bin/:$PATH # 配置编译环境
    MAKE_OPTIONES="ARCH=arm CROSS_COMPILE=arm-linux-gnueabi- CC=clang HOSTCC=clang" # 使用工程项目自带的clang环境
    ```

2.  修改内核代码或内核config （OpenHarmony提供对应平台的defconfig供参考）。
3.  创建编译目录及生成内核.config。

    ```
    make ${MAKE_OPTIONES} hi3516dv300_emmc_smp_hos_l2_defconfig # 使用自带的默认config 构建内核
    ```

4.  编译生成对应的内核Image。

    ```
    make ${MAKE_OPTIONES} -j32 uImage # 编译uImage内核镜像
    ```


## 相关仓<a name="section27639463106"></a>

**内核子系统**

LiteOS：

[drivers\_liteos](https://gitee.com/openharmony/drivers_liteos/blob/master/README_zh.md)

[kernel\_liteos\_a](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)

[kernel\_liteos\_m](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)

[device\_qemu](https://gitee.com/openharmony/device_qemu/blob/master/README_zh.md)

[prebuilts\_lite\_sysroot](https://gitee.com/openharmony/prebuilts_lite_sysroot/blob/master/README_zh.md)

Linux：

<u>kernel\_linux\_patches</u>

<u>device\_hisilicon\_hi3516dv300</u>

<u>kernel\_linux\_config</u>

<u>kernel\_linux-4.19</u>

