# 内核使用指南

- [轻量和小型系统内核](kernel-lite.md)

    - [轻量系统内核](kernel-lite-mini.md)
      - [内核概述](kernel-lite-mini-m.md)
      - [基础内核](kernel-lite-mini-basic.md)
        - [中断管理](kernel-lite-mini-basic-interrupt.md)
          - [基本概念](kernel-lite-mini-basic-interrupt-concept.md)
          - [开发指导](kernel-lite-mini-basic-interrupt-guide.md)
        - [任务管理](kernel-lite-mini-basic-task.md)
          - [基本概念](kernel-lite-mini-basic-task-basic.md)
          - [开发指导](kernel-lite-mini-basic-task-guide.md)
        - [内存管理](kernel-lite-mini-basic-memory.md)
          - [基本概念](kernel-lite-mini-basic-memory-basic.md)
          - [静态内存](kernel-lite-mini-basic-memory-static.md)
          - [动态内存](kernel-lite-mini-basic-memory-dynamic.md)
        - [内核通信机制](kernel-lite-mini-basic-ipc.md)
          - [事件](kernel-lite-mini-basic-ipc-event.md)
            - [基本概念](kernel-lite-mini-basic-ipc-event-guide.md)
            - [开发指导](kernel-lite-mini-basic-ipc-event-basic.md)
          - [互斥锁](kernel-lite-mini-basic-ipc-mutex.md)
            - [基本概念](kernel-lite-mini-basic-ipc-mutex-basic.md)
            - [开发指导](kernel-lite-mini-basic-ipc-mutex-guide.md)
          - [消息队列](kernel-lite-mini-basic-ipc-queue.md)
            - [基本概念](kernel-lite-mini-basic-ipc-queue-basic.md)
            - [开发指导](kernel-lite-mini-basic-ipc-queue-guide.md)
          - [信号量](kernel-lite-mini-basic-ipc-sem.md)
            - [基本概念](kernel-lite-mini-basic-ipc-sem-basic.md)
            - [开发指导](kernel-lite-mini-basic-ipc-sem-guide.md)
        - [时间管理](kernel-lite-basic-mini-time.md)
          - [基本概念](kernel-lite-mini-basic-time-basic.md)
          - [开发指导](kernel-lite-mini-basic-time-guide.md)
        - [软件定时器](kernel-lite-mini-basic-soft.md)
          - [基本概念](kernel-lite-mini-basic-soft-basic.md)
          - [开发指导](kernel-lite-mini-basic-soft-guide.md)
      - [扩展组件](kernel-lite-mini-extend.md)
        - [C++支持](kernel-lite-mini-extend-support.md)
        - [CPU占用率](kernel-lite-mini-extend-cpup.md)
          - [基本概念](kernel-lite-mini-extend-cpup-basic.md)
          - [开发指导](kernel-lite-mini-extend-cpup-guide.md)
        - [文件系统](kernel-lite-mini-extend-file.md)
          - [FAT](kernel-lite-mini-extend-file-fat.md)
          - [LittleFS](kernel-lite-mini-extend-file-lit.md)
            - [基本概念](kernel-lite-mini-extend-file-lit-basic.md)
            - [开发指导](kernel-lite-mini-extend-file-lit-guide.md)
      - [内核调测](kernel-lite-mini-inner.md)
        - [内存调测](kernel-lite-mini-inner-debug.md)
          - [内存信息统计](kernel-lite-mini-inner-debug-mes.md)
          - [内存泄漏检测](kernel-lite-mini-inner-debug-det.md)
          - [踩内存检测](kernel-lite-mini-inner-debug-cet.md)
        - [异常调测](kernel-lite-mini-inner-exception.md)
        - [Trace调测](kernel-lite-mini-inner-trace.md)
      - [附录](kernel-lite-mini-app.md)
        - [内核编码规范](kernel-lite-mini-app-code.md)
        - [基本数据结构](kernel-lite-mini-app-data.md)
          - [双向链表](kernel-lite-mini-app-data-list.md)
        - [标准库支持](kernel-lite-mini-app-lib.md)
          - [CMSIS支持](kernel-lite-mini-app-lib-cmsis.md)
          - [POSIX支持](kernel-lite-mini-app-lib-posix.md)

    -   [小型系统内核](kernel-lite-small.md)
        -   [基础内核](kernel-lite-small-basic.md)
            -   [进程](kernel-lite-small-process.md)
            -   [线程](kernel-lite-small-thread.md)
            -   [内存](kernel-lite-small-memory.md)
            -   [网络](kernel-lite-small-net.md)

        -   [文件系统](kernel-lite-small-file.md)
            -   [VFS](kernel-lite-small-file-vfs.md)
            -   [NFS](kernel-lite-small-file-nfs.md)
            -   [RAMFS](kernel-lite-small-file-ramfs.md)
            -   [FAT](kernel-lite-small-file-fat.md)
            -   [JFFS2](kernel-lite-small-file-jffs.md)

        -   [标准库](kernel-lite-small-lib.md)
            -   [标准库](kernel-lite-small-lib-standard.md)
            -   [与Linux标准库的差异](kernel-lite-small-lib-differ.md)

        -   [调测](kernel-lite-small-shell.md)
            -   [Shell介绍](kernel-lite-small-shell-des.md)
            -   [Shell命令开发指导](kernel-lite-small-shell-guide.md)
            -   [Shell命令编程实例](kernel-lite-small-shell-sample.md)
            -   [Shell命令使用详解](kernel-lite-small-shell-cmd.md)
                -   [系统命令](kernel-lite-small-shell-cmd-sys.md)
                    -   [cpup](kernel-lite-small-shell-cmd-sys-cpup.md)
                    -   [date](kernel-lite-small-shell-cmd-sys-date.md)
                    -   [dmesg](kernel-lite-small-shell-cmd-sys-demsg.md)
                    -   [exec](kernel-lite-small-shell-cmd-sys-exec.md)
                    -   [free](kernel-lite-small-shell-cmd-sys-free.md)
                    -   [help](kernel-lite-small-shell-cmd-sys-help.md)
                    -   [hwi](kernel-lite-small-shell-cmd-sys-hwi.md)
                    -   [kill](kernel-lite-small-shell-cmd-sys-kill.md)
                    -   [log](kernel-lite-small-shell-cmd-sys-log.md)
                    -   [memcheck](kernel-lite-small-shell-cmd-sys-mem.md)
                    -   [oom](kernel-lite-small-shell-cmd-sys-oom.md)
                    -   [pmm](kernel-lite-small-shell-cmd-sys-pmm.md)
                    -   [reset](kernel-lite-small-shell-cmd-sys-reset.md)
                    -   [sem](kernel-lite-small-shell-cmd-sys-sem.md)
                    -   [stack](kernel-lite-small-shell-cmd-sys-stack.md)
                    -   [su](kernel-lite-small-shell-cmd-sys-su.md)
                    -   [swtmr](kernel-lite-small-shell-cmd-sys-swymr.md)
                    -   [systeminfo](kernel-lite-small-shell-cmd-sys-sys.md)
                    -   [task](kernel-lite-small-shell-cmd-sys-task.md)
                    -   [uname](kernel-lite-small-shell-cmd-sys-uname.md)
                    -   [vmm](kernel-lite-small-shell-cmd-sys-vmm.md)
                    -   [watch](kernel-lite-small-shell-cmd-sys-watch.md)

                -   [文件命令](kernel-lite-small-shell-cmd-file.md)
                    -   [cat](kernel-lite-small-shell-cmd-file-cat.md)
                    -   [cd](kernel-lite-small-shell-cmd-file-cd.md)
                    -   [chgrp](kernel-lite-small-shell-cmd-file-chgrp.md)
                    -   [chmod](kernel-lite-small-shell-cmd-file-chmod.md)
                    -   [chown](kernel-lite-small-shell-cmd-file-chown.md)
                    -   [cp](kernel-lite-small-shell-cmd-file-cp.md)
                    -   [format](kernel-lite-small-shell-cmd-file-format.md)
                    -   [ls](kernel-lite-small-shell-cmd-file-is.md)
                    -   [lsfd](kernel-lite-small-shell-cmd-file-isfd.md)
                    -   [mkdir](kernel-lite-small-shell-cmd-file-mkdir.md)
                    -   [mount](kernel-lite-small-shell-cmd-file-mount.md)
                    -   [partinfo](kernel-lite-small-shell-cmd-file-part.md)
                    -   [partition](kernel-lite-small-shell-cmd-file-partion.md)
                    -   [pwd](kernel-lite-small-shell-cmd-file-pwd.md)
                    -   [rm](kernel-lite-small-shell-cmd-file-rm.md)
                    -   [rmdir](kernel-lite-small-shell-cmd-file-rmdir.md)
                    -   [statfs](kernel-lite-small-shell-cmd-file-sta.md)
                    -   [sync](kernel-lite-small-shell-cmd-file-sync.md)
                    -   [touch](kernel-lite-small-shell-cmd-file-touch.md)
                    -   [writeproc](kernel-lite-small-shell-cmd-file-write.md)
                    -   [umount](kernel-lite-small-shell-cmd-file-umount.md)

                -   [网络命令](kernel-lite-small-shell-cmd-net.md)
                    -   [arp](kernel-lite-small-shell-cmd-net-arp.md)
                    -   [dhclient](kernel-lite-small-shell-cmd-net-dh.md)
                    -   [dns](kernel-lite-small-shell-cmd-net-dns.md)
                    -   [ifconfig](kernel-lite-small-shell-cmd-net-ipc.md)
                    -   [ipdebug](kernel-lite-small-shell-cmd-net-ipd.md)
                    -   [netstat](kernel-lite-small-shell-cmd-net-net.md)
                    -   [ntpdate](kernel-lite-small-shell-cmd-net-ntp.md)
                    -   [ping](kernel-lite-small-shell-cmd-net-ping.md)
                    -   [ping6](kernel-lite-small-shell-cmd-net-ping6.md)
                    -   [telnet](kernel-lite-small-shell-cmd-net-tel.md)
                    -   [tftp](kernel-lite-small-shell-cmd-net-tftp.md)

            -   [魔法键使用方法](kernel-lite-small-shell-cmd-mag.md)
            -   [用户态异常信息说明](kernel-lite-small-shell-cmd-abn.md)

- [标准系统内核](kernel-standard.md)
    -   [Linux内核概述](kernel-standard-des.md)
    -   [OpenHarmony开发板Patch使用指导](kernel-standard-patch.md)
    -   [Linux内核编译与构建指导](kernel-standard-build.md)

