# 应用打点<a name="ZH-CN_TOPIC_0000001162414647"></a>

-   [导入模块](#zh-cn_topic_0000001150092213_s56d19203690d4782bfc74069abb6bd71)
-   [权限](#zh-cn_topic_0000001150092213_section11257113618419)
-   [方法](#zh-cn_topic_0000001150092213_section125675489541)
-   [write\(string, EventType, any..., AsyncCallback<number\>\)](#zh-cn_topic_0000001150092213_section192192415554)
-   [write\(string, EventType, any...\)](#zh-cn_topic_0000001150092213_section1696563334210)
-   [writeJson\(string, EventType, object, AsyncCallback<number\>\)](#zh-cn_topic_0000001150092213_section570630172512)
-   [writeJson\(string, EventType, object\)](#zh-cn_topic_0000001150092213_section0857164934517)
-   [枚举](#zh-cn_topic_0000001150092213_section1978842154715)
-   [EventType](#zh-cn_topic_0000001150092213_section099619567453)

## 导入模块<a name="zh-cn_topic_0000001150092213_s56d19203690d4782bfc74069abb6bd71"></a>

```
import hiappevent from '@ohos.hiappevent';
```

## 权限<a name="zh-cn_topic_0000001150092213_section11257113618419"></a>

无

## 方法<a name="zh-cn_topic_0000001150092213_section125675489541"></a>

## write\(string, EventType, any..., AsyncCallback<number\>\)<a name="zh-cn_topic_0000001150092213_section192192415554"></a>

应用事件打点，将事件信息写入到当天的事件文件中，可接收类型为不定参数的事件参数，使用callback方式作为异步方法。

**参数：**

<a name="zh-cn_topic_0000001150092213_table1051173843112"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row551638113119"><th class="cellrowborder" valign="top" width="13.969999999999999%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001150092213_p2512384316"><a name="zh-cn_topic_0000001150092213_p2512384316"></a><a name="zh-cn_topic_0000001150092213_p2512384316"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="13.389999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001150092213_p1551113810318"><a name="zh-cn_topic_0000001150092213_p1551113810318"></a><a name="zh-cn_topic_0000001150092213_p1551113810318"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="8.23%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001150092213_p3519387317"><a name="zh-cn_topic_0000001150092213_p3519387317"></a><a name="zh-cn_topic_0000001150092213_p3519387317"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="64.41%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001150092213_p1351123815315"><a name="zh-cn_topic_0000001150092213_p1351123815315"></a><a name="zh-cn_topic_0000001150092213_p1351123815315"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row13511538183119"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p1551838113117"><a name="zh-cn_topic_0000001150092213_p1551838113117"></a><a name="zh-cn_topic_0000001150092213_p1551838113117"></a>eventName</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p1051133893111"><a name="zh-cn_topic_0000001150092213_p1051133893111"></a><a name="zh-cn_topic_0000001150092213_p1051133893111"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p155183816314"><a name="zh-cn_topic_0000001150092213_p155183816314"></a><a name="zh-cn_topic_0000001150092213_p155183816314"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p1551173863113"><a name="zh-cn_topic_0000001150092213_p1551173863113"></a><a name="zh-cn_topic_0000001150092213_p1551173863113"></a>应用事件名称。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row18516388310"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p3511938103117"><a name="zh-cn_topic_0000001150092213_p3511938103117"></a><a name="zh-cn_topic_0000001150092213_p3511938103117"></a>eventType</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p55183820313"><a name="zh-cn_topic_0000001150092213_p55183820313"></a><a name="zh-cn_topic_0000001150092213_p55183820313"></a>EventType</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p13511138123117"><a name="zh-cn_topic_0000001150092213_p13511138123117"></a><a name="zh-cn_topic_0000001150092213_p13511138123117"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p75213386311"><a name="zh-cn_topic_0000001150092213_p75213386311"></a><a name="zh-cn_topic_0000001150092213_p75213386311"></a>应用事件类型。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row05293803113"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p1452193814313"><a name="zh-cn_topic_0000001150092213_p1452193814313"></a><a name="zh-cn_topic_0000001150092213_p1452193814313"></a>params</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p185283815313"><a name="zh-cn_topic_0000001150092213_p185283815313"></a><a name="zh-cn_topic_0000001150092213_p185283815313"></a>any...</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p25283811312"><a name="zh-cn_topic_0000001150092213_p25283811312"></a><a name="zh-cn_topic_0000001150092213_p25283811312"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p552193863115"><a name="zh-cn_topic_0000001150092213_p552193863115"></a><a name="zh-cn_topic_0000001150092213_p552193863115"></a>应用事件的参数，按顺序输入事件的参数名与参数值。参数名的类型只能为string类型，参数值的类型只能为string、number、boolean、Array（数组数据类型只能为string、number、boolean）。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row13838183316719"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p28393335711"><a name="zh-cn_topic_0000001150092213_p28393335711"></a><a name="zh-cn_topic_0000001150092213_p28393335711"></a>callback</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p48396339719"><a name="zh-cn_topic_0000001150092213_p48396339719"></a><a name="zh-cn_topic_0000001150092213_p48396339719"></a>AsyncCallback&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p1783913331671"><a name="zh-cn_topic_0000001150092213_p1783913331671"></a><a name="zh-cn_topic_0000001150092213_p1783913331671"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p9749191318299"><a name="zh-cn_topic_0000001150092213_p9749191318299"></a><a name="zh-cn_topic_0000001150092213_p9749191318299"></a>回调函数，可以在回调函数中处理接口返回值。</p>
<a name="zh-cn_topic_0000001150092213_ul988644310291"></a><a name="zh-cn_topic_0000001150092213_ul988644310291"></a><ul id="zh-cn_topic_0000001150092213_ul988644310291"><li>返回值为0表示事件参数校验成功，事件正常异步写入事件文件；</li><li>大于0表示事件存在异常参数，事件在忽略异常参数后再异步写入事件文件；</li><li>小于0表示事件校验失败，不执行事件异步打点操作。</li></ul>
</td>
</tr>
</tbody>
</table>

**示例：**

```
hiappevent.write("testEvent", hiappevent.EventType.FAULT, "intData", 100, "strData", "strValue", (err, value) => {
    if (err) {
        // 事件写入异常：事件存在异常参数或者事件校验失败不执行写入
        console.error(`failed to write event because ${err}`);
        return;
    }

    // 事件写入正常
    console.log(`success to write event: ${value}`);
});
```

## write\(string, EventType, any...\)<a name="zh-cn_topic_0000001150092213_section1696563334210"></a>

应用事件打点，将事件信息写入到当天的事件文件中，可接收类型为不定参数的事件参数，使用promise方式作为异步方法。

**参数：**

<a name="zh-cn_topic_0000001150092213_table1096583374216"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row1296612339427"><th class="cellrowborder" valign="top" width="13.969999999999999%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001150092213_p696663354219"><a name="zh-cn_topic_0000001150092213_p696663354219"></a><a name="zh-cn_topic_0000001150092213_p696663354219"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="13.389999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001150092213_p179660332421"><a name="zh-cn_topic_0000001150092213_p179660332421"></a><a name="zh-cn_topic_0000001150092213_p179660332421"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="8.23%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001150092213_p11966143312427"><a name="zh-cn_topic_0000001150092213_p11966143312427"></a><a name="zh-cn_topic_0000001150092213_p11966143312427"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="64.41%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001150092213_p596610331427"><a name="zh-cn_topic_0000001150092213_p596610331427"></a><a name="zh-cn_topic_0000001150092213_p596610331427"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row6966113310425"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p796623344217"><a name="zh-cn_topic_0000001150092213_p796623344217"></a><a name="zh-cn_topic_0000001150092213_p796623344217"></a>eventName</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p596683319422"><a name="zh-cn_topic_0000001150092213_p596683319422"></a><a name="zh-cn_topic_0000001150092213_p596683319422"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p17966193374218"><a name="zh-cn_topic_0000001150092213_p17966193374218"></a><a name="zh-cn_topic_0000001150092213_p17966193374218"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p19661533194218"><a name="zh-cn_topic_0000001150092213_p19661533194218"></a><a name="zh-cn_topic_0000001150092213_p19661533194218"></a>应用事件名称。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row896623314429"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p17966153316425"><a name="zh-cn_topic_0000001150092213_p17966153316425"></a><a name="zh-cn_topic_0000001150092213_p17966153316425"></a>eventType</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p496613364212"><a name="zh-cn_topic_0000001150092213_p496613364212"></a><a name="zh-cn_topic_0000001150092213_p496613364212"></a>EventType</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p10966233134216"><a name="zh-cn_topic_0000001150092213_p10966233134216"></a><a name="zh-cn_topic_0000001150092213_p10966233134216"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p1796643344218"><a name="zh-cn_topic_0000001150092213_p1796643344218"></a><a name="zh-cn_topic_0000001150092213_p1796643344218"></a>应用事件类型。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row1696653315423"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p109660332428"><a name="zh-cn_topic_0000001150092213_p109660332428"></a><a name="zh-cn_topic_0000001150092213_p109660332428"></a>params</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p1396663313428"><a name="zh-cn_topic_0000001150092213_p1396663313428"></a><a name="zh-cn_topic_0000001150092213_p1396663313428"></a>any...</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p1196673354215"><a name="zh-cn_topic_0000001150092213_p1196673354215"></a><a name="zh-cn_topic_0000001150092213_p1196673354215"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p199671338422"><a name="zh-cn_topic_0000001150092213_p199671338422"></a><a name="zh-cn_topic_0000001150092213_p199671338422"></a>应用事件的参数，按顺序输入事件的参数名与参数值。参数名的类型只能为string类型，参数值的类型只能为string、number、boolean、Array（数组数据类型只能为string、number、boolean）。</p>
</td>
</tr>
</tbody>
</table>

**返回值：**

<a name="zh-cn_topic_0000001150092213_table106721328171713"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row9672122817176"><th class="cellrowborder" valign="top" width="26.06%" id="mcps1.1.3.1.1"><p id="zh-cn_topic_0000001150092213_p106728288171"><a name="zh-cn_topic_0000001150092213_p106728288171"></a><a name="zh-cn_topic_0000001150092213_p106728288171"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="73.94%" id="mcps1.1.3.1.2"><p id="zh-cn_topic_0000001150092213_p5672112817178"><a name="zh-cn_topic_0000001150092213_p5672112817178"></a><a name="zh-cn_topic_0000001150092213_p5672112817178"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row06721528191711"><td class="cellrowborder" valign="top" width="26.06%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001150092213_p107821612171919"><a name="zh-cn_topic_0000001150092213_p107821612171919"></a><a name="zh-cn_topic_0000001150092213_p107821612171919"></a>Promise&lt;void&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="73.94%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001150092213_p4672828141718"><a name="zh-cn_topic_0000001150092213_p4672828141718"></a><a name="zh-cn_topic_0000001150092213_p4672828141718"></a>Promise函数</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
hiappevent.write("testEvent", hiappevent.EventType.FAULT, "intData", 100, "strData", "strValue")
    .then((value) => {
        // 事件写入正常
        console.log(`success to write event: ${value}`);
    }).catch((err) => {
        // 事件写入异常：事件存在异常参数或者事件校验失败不执行写入
        console.error(`failed to write event because ${err}`);
    });
```

## writeJson\(string, EventType, object, AsyncCallback<number\>\)<a name="zh-cn_topic_0000001150092213_section570630172512"></a>

应用事件打点，将事件信息写入到当天的事件文件中，可接收类型为JSON对象的事件参数，使用callback方式作为异步方法。

**参数：**

<a name="zh-cn_topic_0000001150092213_table1054125415456"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row354155454518"><th class="cellrowborder" valign="top" width="13.969999999999999%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001150092213_p17541135415455"><a name="zh-cn_topic_0000001150092213_p17541135415455"></a><a name="zh-cn_topic_0000001150092213_p17541135415455"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="13.389999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001150092213_p454195484516"><a name="zh-cn_topic_0000001150092213_p454195484516"></a><a name="zh-cn_topic_0000001150092213_p454195484516"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="8.23%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001150092213_p115414549454"><a name="zh-cn_topic_0000001150092213_p115414549454"></a><a name="zh-cn_topic_0000001150092213_p115414549454"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="64.41%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001150092213_p155411354104516"><a name="zh-cn_topic_0000001150092213_p155411354104516"></a><a name="zh-cn_topic_0000001150092213_p155411354104516"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row6541155413451"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p125411454184516"><a name="zh-cn_topic_0000001150092213_p125411454184516"></a><a name="zh-cn_topic_0000001150092213_p125411454184516"></a>eventName</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p5541195416452"><a name="zh-cn_topic_0000001150092213_p5541195416452"></a><a name="zh-cn_topic_0000001150092213_p5541195416452"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p754115424514"><a name="zh-cn_topic_0000001150092213_p754115424514"></a><a name="zh-cn_topic_0000001150092213_p754115424514"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p185421054144516"><a name="zh-cn_topic_0000001150092213_p185421054144516"></a><a name="zh-cn_topic_0000001150092213_p185421054144516"></a>应用事件名称。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row2542145416459"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p19542185415455"><a name="zh-cn_topic_0000001150092213_p19542185415455"></a><a name="zh-cn_topic_0000001150092213_p19542185415455"></a>eventType</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p20542205474519"><a name="zh-cn_topic_0000001150092213_p20542205474519"></a><a name="zh-cn_topic_0000001150092213_p20542205474519"></a>EventType</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p1354295494510"><a name="zh-cn_topic_0000001150092213_p1354295494510"></a><a name="zh-cn_topic_0000001150092213_p1354295494510"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p754216544454"><a name="zh-cn_topic_0000001150092213_p754216544454"></a><a name="zh-cn_topic_0000001150092213_p754216544454"></a>应用事件类型。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row354265418456"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p1354215547452"><a name="zh-cn_topic_0000001150092213_p1354215547452"></a><a name="zh-cn_topic_0000001150092213_p1354215547452"></a>jsonParam</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p754225416456"><a name="zh-cn_topic_0000001150092213_p754225416456"></a><a name="zh-cn_topic_0000001150092213_p754225416456"></a>object</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p55421654124517"><a name="zh-cn_topic_0000001150092213_p55421654124517"></a><a name="zh-cn_topic_0000001150092213_p55421654124517"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p55431154164513"><a name="zh-cn_topic_0000001150092213_p55431154164513"></a><a name="zh-cn_topic_0000001150092213_p55431154164513"></a>应用事件的参数，key类型只能为string，value类型只能为string、number、boolean、Array（数组数据类型只能为string、number、boolean）。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row87751758579"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p777595810712"><a name="zh-cn_topic_0000001150092213_p777595810712"></a><a name="zh-cn_topic_0000001150092213_p777595810712"></a>callback</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p1577513581719"><a name="zh-cn_topic_0000001150092213_p1577513581719"></a><a name="zh-cn_topic_0000001150092213_p1577513581719"></a>AsyncCallback&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p157753585718"><a name="zh-cn_topic_0000001150092213_p157753585718"></a><a name="zh-cn_topic_0000001150092213_p157753585718"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p1065434111303"><a name="zh-cn_topic_0000001150092213_p1065434111303"></a><a name="zh-cn_topic_0000001150092213_p1065434111303"></a>回调函数，可以在回调函数中处理接口返回值。</p>
<a name="zh-cn_topic_0000001150092213_ul182248492307"></a><a name="zh-cn_topic_0000001150092213_ul182248492307"></a><ul id="zh-cn_topic_0000001150092213_ul182248492307"><li>返回值为0表示事件参数校验成功，事件正常异步写入事件文件；</li><li>大于0表示事件存在异常参数，事件在忽略异常参数后再异步写入事件文件；</li><li>小于0表示事件校验失败，不执行事件异步打点操作。</li></ul>
</td>
</tr>
</tbody>
</table>

**示例：**

```
hiappevent.writeJson("testEvent", hiappevent.EventType.FAULT, {"intData":100, "strData":"strValue"}, (err, value) => {
    if (err) {
        // 事件写入异常：事件存在异常参数或者事件校验失败不执行写入
        console.error(`failed to write event because ${err}`);
        return;
    }

    // 事件写入正常
    console.log(`success to write event: ${value}`);
});
```

## writeJson\(string, EventType, object\)<a name="zh-cn_topic_0000001150092213_section0857164934517"></a>

应用事件打点，将事件信息写入到当天的事件文件中，可接收类型为JSON对象的事件参数，使用promise方式作为异步方法。

**参数：**

<a name="zh-cn_topic_0000001150092213_table11857249104514"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row198584493457"><th class="cellrowborder" valign="top" width="13.969999999999999%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001150092213_p128580494453"><a name="zh-cn_topic_0000001150092213_p128580494453"></a><a name="zh-cn_topic_0000001150092213_p128580494453"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="13.389999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001150092213_p2085813494456"><a name="zh-cn_topic_0000001150092213_p2085813494456"></a><a name="zh-cn_topic_0000001150092213_p2085813494456"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="8.23%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001150092213_p1285894934516"><a name="zh-cn_topic_0000001150092213_p1285894934516"></a><a name="zh-cn_topic_0000001150092213_p1285894934516"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="64.41%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001150092213_p48581849104511"><a name="zh-cn_topic_0000001150092213_p48581849104511"></a><a name="zh-cn_topic_0000001150092213_p48581849104511"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row98581498450"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p1185884919459"><a name="zh-cn_topic_0000001150092213_p1185884919459"></a><a name="zh-cn_topic_0000001150092213_p1185884919459"></a>eventName</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p28586495454"><a name="zh-cn_topic_0000001150092213_p28586495454"></a><a name="zh-cn_topic_0000001150092213_p28586495454"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p2858144912459"><a name="zh-cn_topic_0000001150092213_p2858144912459"></a><a name="zh-cn_topic_0000001150092213_p2858144912459"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p8858164984518"><a name="zh-cn_topic_0000001150092213_p8858164984518"></a><a name="zh-cn_topic_0000001150092213_p8858164984518"></a>应用事件名称。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row198584495457"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p128583494450"><a name="zh-cn_topic_0000001150092213_p128583494450"></a><a name="zh-cn_topic_0000001150092213_p128583494450"></a>eventType</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p13858449194517"><a name="zh-cn_topic_0000001150092213_p13858449194517"></a><a name="zh-cn_topic_0000001150092213_p13858449194517"></a>EventType</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p1785894934513"><a name="zh-cn_topic_0000001150092213_p1785894934513"></a><a name="zh-cn_topic_0000001150092213_p1785894934513"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p198581349194515"><a name="zh-cn_topic_0000001150092213_p198581349194515"></a><a name="zh-cn_topic_0000001150092213_p198581349194515"></a>应用事件类型。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row78580497453"><td class="cellrowborder" valign="top" width="13.969999999999999%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001150092213_p2085819494459"><a name="zh-cn_topic_0000001150092213_p2085819494459"></a><a name="zh-cn_topic_0000001150092213_p2085819494459"></a>jsonParam</p>
</td>
<td class="cellrowborder" valign="top" width="13.389999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001150092213_p8859749154519"><a name="zh-cn_topic_0000001150092213_p8859749154519"></a><a name="zh-cn_topic_0000001150092213_p8859749154519"></a>object</p>
</td>
<td class="cellrowborder" valign="top" width="8.23%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001150092213_p1385984964515"><a name="zh-cn_topic_0000001150092213_p1385984964515"></a><a name="zh-cn_topic_0000001150092213_p1385984964515"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="64.41%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001150092213_p1859114984515"><a name="zh-cn_topic_0000001150092213_p1859114984515"></a><a name="zh-cn_topic_0000001150092213_p1859114984515"></a>应用事件的参数，key类型只能为string，value类型只能为string、number、boolean、Array（数组数据类型只能为string、number、boolean）。</p>
</td>
</tr>
</tbody>
</table>

**返回值：**

<a name="zh-cn_topic_0000001150092213_table10811610134713"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row7811410124716"><th class="cellrowborder" valign="top" width="26.06%" id="mcps1.1.3.1.1"><p id="zh-cn_topic_0000001150092213_p118116107479"><a name="zh-cn_topic_0000001150092213_p118116107479"></a><a name="zh-cn_topic_0000001150092213_p118116107479"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="73.94%" id="mcps1.1.3.1.2"><p id="zh-cn_topic_0000001150092213_p8811910124715"><a name="zh-cn_topic_0000001150092213_p8811910124715"></a><a name="zh-cn_topic_0000001150092213_p8811910124715"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row1181161019479"><td class="cellrowborder" valign="top" width="26.06%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001150092213_p15811181004712"><a name="zh-cn_topic_0000001150092213_p15811181004712"></a><a name="zh-cn_topic_0000001150092213_p15811181004712"></a>Promise&lt;void&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="73.94%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001150092213_p14811710164718"><a name="zh-cn_topic_0000001150092213_p14811710164718"></a><a name="zh-cn_topic_0000001150092213_p14811710164718"></a>Promise函数</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
hiappevent.writeJson("testEvent", hiappevent.EventType.FAULT, {"intData":100, "strData":"strValue"})
    .then((value) => {
        // 事件写入正常
        console.log(`success to write event: ${value}`);
    }).catch((err) => {
        // 事件写入异常：事件存在异常参数或者事件校验失败不执行写入
        console.error(`failed to write event because ${err}`);
    });
```

## 枚举<a name="zh-cn_topic_0000001150092213_section1978842154715"></a>

## EventType<a name="zh-cn_topic_0000001150092213_section099619567453"></a>

用于表示事件类型。

<a name="zh-cn_topic_0000001150092213_table20633101642315"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001150092213_row663331618238"><th class="cellrowborder" valign="top" width="27.900000000000002%" id="mcps1.1.4.1.1"><p id="zh-cn_topic_0000001150092213_a3d0fc780cc904c1cbab7991251622f65"><a name="zh-cn_topic_0000001150092213_a3d0fc780cc904c1cbab7991251622f65"></a><a name="zh-cn_topic_0000001150092213_a3d0fc780cc904c1cbab7991251622f65"></a>名称</p>
</th>
<th class="cellrowborder" valign="top" width="12.43%" id="mcps1.1.4.1.2"><p id="zh-cn_topic_0000001150092213_aace9cae4ba0d4939bfa048460f61c3c7"><a name="zh-cn_topic_0000001150092213_aace9cae4ba0d4939bfa048460f61c3c7"></a><a name="zh-cn_topic_0000001150092213_aace9cae4ba0d4939bfa048460f61c3c7"></a>默认值</p>
</th>
<th class="cellrowborder" valign="top" width="59.67%" id="mcps1.1.4.1.3"><p id="zh-cn_topic_0000001150092213_afec895de33f94e3c87ee7acc20190a17"><a name="zh-cn_topic_0000001150092213_afec895de33f94e3c87ee7acc20190a17"></a><a name="zh-cn_topic_0000001150092213_afec895de33f94e3c87ee7acc20190a17"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001150092213_row188481425182510"><td class="cellrowborder" valign="top" width="27.900000000000002%" headers="mcps1.1.4.1.1 "><p id="zh-cn_topic_0000001150092213_p13876443113318"><a name="zh-cn_topic_0000001150092213_p13876443113318"></a><a name="zh-cn_topic_0000001150092213_p13876443113318"></a>FAULT</p>
</td>
<td class="cellrowborder" valign="top" width="12.43%" headers="mcps1.1.4.1.2 "><p id="zh-cn_topic_0000001150092213_p2282152962115"><a name="zh-cn_topic_0000001150092213_p2282152962115"></a><a name="zh-cn_topic_0000001150092213_p2282152962115"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="59.67%" headers="mcps1.1.4.1.3 "><p id="zh-cn_topic_0000001150092213_p28751543103312"><a name="zh-cn_topic_0000001150092213_p28751543103312"></a><a name="zh-cn_topic_0000001150092213_p28751543103312"></a>故障类型事件。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row0461622112513"><td class="cellrowborder" valign="top" width="27.900000000000002%" headers="mcps1.1.4.1.1 "><p id="zh-cn_topic_0000001150092213_p68697436338"><a name="zh-cn_topic_0000001150092213_p68697436338"></a><a name="zh-cn_topic_0000001150092213_p68697436338"></a>STATISTIC</p>
</td>
<td class="cellrowborder" valign="top" width="12.43%" headers="mcps1.1.4.1.2 "><p id="zh-cn_topic_0000001150092213_p1310553911218"><a name="zh-cn_topic_0000001150092213_p1310553911218"></a><a name="zh-cn_topic_0000001150092213_p1310553911218"></a>2</p>
</td>
<td class="cellrowborder" valign="top" width="59.67%" headers="mcps1.1.4.1.3 "><p id="zh-cn_topic_0000001150092213_p14868114312331"><a name="zh-cn_topic_0000001150092213_p14868114312331"></a><a name="zh-cn_topic_0000001150092213_p14868114312331"></a>统计类型事件。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row91702048195619"><td class="cellrowborder" valign="top" width="27.900000000000002%" headers="mcps1.1.4.1.1 "><p id="zh-cn_topic_0000001150092213_p123991673342"><a name="zh-cn_topic_0000001150092213_p123991673342"></a><a name="zh-cn_topic_0000001150092213_p123991673342"></a>SECURITY</p>
</td>
<td class="cellrowborder" valign="top" width="12.43%" headers="mcps1.1.4.1.2 "><p id="zh-cn_topic_0000001150092213_p14170114811561"><a name="zh-cn_topic_0000001150092213_p14170114811561"></a><a name="zh-cn_topic_0000001150092213_p14170114811561"></a>3</p>
</td>
<td class="cellrowborder" valign="top" width="59.67%" headers="mcps1.1.4.1.3 "><p id="zh-cn_topic_0000001150092213_p1539912793411"><a name="zh-cn_topic_0000001150092213_p1539912793411"></a><a name="zh-cn_topic_0000001150092213_p1539912793411"></a>安全类型事件。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001150092213_row717094895612"><td class="cellrowborder" valign="top" width="27.900000000000002%" headers="mcps1.1.4.1.1 "><p id="zh-cn_topic_0000001150092213_p10231410193416"><a name="zh-cn_topic_0000001150092213_p10231410193416"></a><a name="zh-cn_topic_0000001150092213_p10231410193416"></a>BEHAVIOR</p>
</td>
<td class="cellrowborder" valign="top" width="12.43%" headers="mcps1.1.4.1.2 "><p id="zh-cn_topic_0000001150092213_p1817134815569"><a name="zh-cn_topic_0000001150092213_p1817134815569"></a><a name="zh-cn_topic_0000001150092213_p1817134815569"></a>4</p>
</td>
<td class="cellrowborder" valign="top" width="59.67%" headers="mcps1.1.4.1.3 "><p id="zh-cn_topic_0000001150092213_p523171020343"><a name="zh-cn_topic_0000001150092213_p523171020343"></a><a name="zh-cn_topic_0000001150092213_p523171020343"></a>系统行为事件。</p>
</td>
</tr>
</tbody>
</table>

