# 国际化<a name="ZH-CN_TOPIC_0000001115814852"></a>

-   [导入模块](#zh-cn_topic_0000001103315838_s56d19203690d4782bfc74069abb6bd71)
-   [权限](#zh-cn_topic_0000001103315838_section11257113618419)
-   [类](#zh-cn_topic_0000001103315838_section1956131218111)
-   [Locale](#zh-cn_topic_0000001103315838_section189341937163212)
    -   [属性](#zh-cn_topic_0000001103315838_section23751576140)
    -   [Locale](#zh-cn_topic_0000001103315838_section1410593619146)

-   [DateTimeFormat](#zh-cn_topic_0000001103315838_section88061769522)
    -   [DateTimeFormat](#zh-cn_topic_0000001103315838_section28081362523)
    -   [format](#zh-cn_topic_0000001103315838_section917151185514)


## 导入模块<a name="zh-cn_topic_0000001103315838_s56d19203690d4782bfc74069abb6bd71"></a>

```
import Intl from '@ohos.intl';
```

## 权限<a name="zh-cn_topic_0000001103315838_section11257113618419"></a>

无

## 类<a name="zh-cn_topic_0000001103315838_section1956131218111"></a>

## Locale<a name="zh-cn_topic_0000001103315838_section189341937163212"></a>

提供用于获取区域信息的接口。

### 属性<a name="zh-cn_topic_0000001103315838_section23751576140"></a>

<a name="zh-cn_topic_0000001103315838_table728861911417"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103315838_row62887198149"><th class="cellrowborder" valign="top" width="15.870000000000001%" id="mcps1.1.6.1.1"><p id="zh-cn_topic_0000001103315838_p928811911410"><a name="zh-cn_topic_0000001103315838_p928811911410"></a><a name="zh-cn_topic_0000001103315838_p928811911410"></a>名称</p>
</th>
<th class="cellrowborder" valign="top" width="10.86%" id="mcps1.1.6.1.2"><p id="zh-cn_topic_0000001103315838_p8288191916149"><a name="zh-cn_topic_0000001103315838_p8288191916149"></a><a name="zh-cn_topic_0000001103315838_p8288191916149"></a>参数类型</p>
</th>
<th class="cellrowborder" valign="top" width="9.34%" id="mcps1.1.6.1.3"><p id="zh-cn_topic_0000001103315838_p14288131911418"><a name="zh-cn_topic_0000001103315838_p14288131911418"></a><a name="zh-cn_topic_0000001103315838_p14288131911418"></a>可读</p>
</th>
<th class="cellrowborder" valign="top" width="11.51%" id="mcps1.1.6.1.4"><p id="zh-cn_topic_0000001103315838_p1928861921411"><a name="zh-cn_topic_0000001103315838_p1928861921411"></a><a name="zh-cn_topic_0000001103315838_p1928861921411"></a>可写</p>
</th>
<th class="cellrowborder" valign="top" width="52.42%" id="mcps1.1.6.1.5"><p id="zh-cn_topic_0000001103315838_p728815191149"><a name="zh-cn_topic_0000001103315838_p728815191149"></a><a name="zh-cn_topic_0000001103315838_p728815191149"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103315838_row528891919142"><td class="cellrowborder" valign="top" width="15.870000000000001%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103315838_p3288191991414"><a name="zh-cn_topic_0000001103315838_p3288191991414"></a><a name="zh-cn_topic_0000001103315838_p3288191991414"></a>language</p>
</td>
<td class="cellrowborder" valign="top" width="10.86%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103315838_p3288121901418"><a name="zh-cn_topic_0000001103315838_p3288121901418"></a><a name="zh-cn_topic_0000001103315838_p3288121901418"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.34%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103315838_p182881319191414"><a name="zh-cn_topic_0000001103315838_p182881319191414"></a><a name="zh-cn_topic_0000001103315838_p182881319191414"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="11.51%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103315838_p1928801914148"><a name="zh-cn_topic_0000001103315838_p1928801914148"></a><a name="zh-cn_topic_0000001103315838_p1928801914148"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="52.42%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103315838_p1428811192144"><a name="zh-cn_topic_0000001103315838_p1428811192144"></a><a name="zh-cn_topic_0000001103315838_p1428811192144"></a>区域关联的语言。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103315838_row11288719111417"><td class="cellrowborder" valign="top" width="15.870000000000001%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103315838_p10288419131415"><a name="zh-cn_topic_0000001103315838_p10288419131415"></a><a name="zh-cn_topic_0000001103315838_p10288419131415"></a>script</p>
</td>
<td class="cellrowborder" valign="top" width="10.86%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103315838_p91710563611"><a name="zh-cn_topic_0000001103315838_p91710563611"></a><a name="zh-cn_topic_0000001103315838_p91710563611"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.34%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103315838_p14171165163611"><a name="zh-cn_topic_0000001103315838_p14171165163611"></a><a name="zh-cn_topic_0000001103315838_p14171165163611"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="11.51%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103315838_p1017115543612"><a name="zh-cn_topic_0000001103315838_p1017115543612"></a><a name="zh-cn_topic_0000001103315838_p1017115543612"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="52.42%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103315838_p3171125183610"><a name="zh-cn_topic_0000001103315838_p3171125183610"></a><a name="zh-cn_topic_0000001103315838_p3171125183610"></a>区域关联的文字。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103315838_row19687050183612"><td class="cellrowborder" valign="top" width="15.870000000000001%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103315838_p32281883406"><a name="zh-cn_topic_0000001103315838_p32281883406"></a><a name="zh-cn_topic_0000001103315838_p32281883406"></a>region</p>
</td>
<td class="cellrowborder" valign="top" width="10.86%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103315838_p1522810854016"><a name="zh-cn_topic_0000001103315838_p1522810854016"></a><a name="zh-cn_topic_0000001103315838_p1522810854016"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.34%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103315838_p1422858124014"><a name="zh-cn_topic_0000001103315838_p1422858124014"></a><a name="zh-cn_topic_0000001103315838_p1422858124014"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="11.51%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103315838_p1922817874013"><a name="zh-cn_topic_0000001103315838_p1922817874013"></a><a name="zh-cn_topic_0000001103315838_p1922817874013"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="52.42%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103315838_p1722818834016"><a name="zh-cn_topic_0000001103315838_p1722818834016"></a><a name="zh-cn_topic_0000001103315838_p1722818834016"></a>区域关联的地区</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103315838_row115871535369"><td class="cellrowborder" valign="top" width="15.870000000000001%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103315838_p15801188114019"><a name="zh-cn_topic_0000001103315838_p15801188114019"></a><a name="zh-cn_topic_0000001103315838_p15801188114019"></a>baseName</p>
</td>
<td class="cellrowborder" valign="top" width="10.86%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103315838_p108011082401"><a name="zh-cn_topic_0000001103315838_p108011082401"></a><a name="zh-cn_topic_0000001103315838_p108011082401"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.34%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103315838_p138011980407"><a name="zh-cn_topic_0000001103315838_p138011980407"></a><a name="zh-cn_topic_0000001103315838_p138011980407"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="11.51%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103315838_p1980128134011"><a name="zh-cn_topic_0000001103315838_p1980128134011"></a><a name="zh-cn_topic_0000001103315838_p1980128134011"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="52.42%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103315838_p1801208144012"><a name="zh-cn_topic_0000001103315838_p1801208144012"></a><a name="zh-cn_topic_0000001103315838_p1801208144012"></a>以完整区域字符串的子字符串形式返回有关区域的基本核心信息。</p>
</td>
</tr>
</tbody>
</table>

### Locale<a name="zh-cn_topic_0000001103315838_section1410593619146"></a>

构造方法，用于构造Locale对象

**参数：**

<a name="zh-cn_topic_0000001103315838_table114831131512"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103315838_row914851141517"><th class="cellrowborder" valign="top" width="14.82%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001103315838_p214819113159"><a name="zh-cn_topic_0000001103315838_p214819113159"></a><a name="zh-cn_topic_0000001103315838_p214819113159"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="14.729999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001103315838_p1214921121519"><a name="zh-cn_topic_0000001103315838_p1214921121519"></a><a name="zh-cn_topic_0000001103315838_p1214921121519"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="9.16%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001103315838_p11491711141512"><a name="zh-cn_topic_0000001103315838_p11491711141512"></a><a name="zh-cn_topic_0000001103315838_p11491711141512"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="61.29%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001103315838_p171491011171512"><a name="zh-cn_topic_0000001103315838_p171491011171512"></a><a name="zh-cn_topic_0000001103315838_p171491011171512"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103315838_row91491211131519"><td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001103315838_p45271354164919"><a name="zh-cn_topic_0000001103315838_p45271354164919"></a><a name="zh-cn_topic_0000001103315838_p45271354164919"></a>locale</p>
</td>
<td class="cellrowborder" valign="top" width="14.729999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001103315838_p1252795444917"><a name="zh-cn_topic_0000001103315838_p1252795444917"></a><a name="zh-cn_topic_0000001103315838_p1252795444917"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.16%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001103315838_p314916118154"><a name="zh-cn_topic_0000001103315838_p314916118154"></a><a name="zh-cn_topic_0000001103315838_p314916118154"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="61.29%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001103315838_p814951171516"><a name="zh-cn_topic_0000001103315838_p814951171516"></a><a name="zh-cn_topic_0000001103315838_p814951171516"></a>表示区域信息的字符串，必须包含语言，可选择性包含文字与地区<span>。</span></p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
var enLatnGB = new Intl.Locale("en-Latn-GB");
var enGB = new Intl.Locale("en-GB");
var en = new Intl.Locale("en");
```

## DateTimeFormat<a name="zh-cn_topic_0000001103315838_section88061769522"></a>

提供用于格式化日期字符串的接口。

### DateTimeFormat<a name="zh-cn_topic_0000001103315838_section28081362523"></a>

构造方法，用于构造DateTimeFormat对象

**参数：**

<a name="zh-cn_topic_0000001103315838_table1680806175216"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103315838_row10808868524"><th class="cellrowborder" valign="top" width="14.82%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001103315838_p108080625215"><a name="zh-cn_topic_0000001103315838_p108080625215"></a><a name="zh-cn_topic_0000001103315838_p108080625215"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="14.729999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001103315838_p78089645215"><a name="zh-cn_topic_0000001103315838_p78089645215"></a><a name="zh-cn_topic_0000001103315838_p78089645215"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="9.16%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001103315838_p17808126175217"><a name="zh-cn_topic_0000001103315838_p17808126175217"></a><a name="zh-cn_topic_0000001103315838_p17808126175217"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="61.29%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001103315838_p15808106185212"><a name="zh-cn_topic_0000001103315838_p15808106185212"></a><a name="zh-cn_topic_0000001103315838_p15808106185212"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103315838_row19808116205213"><td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001103315838_p880815616525"><a name="zh-cn_topic_0000001103315838_p880815616525"></a><a name="zh-cn_topic_0000001103315838_p880815616525"></a>locale</p>
</td>
<td class="cellrowborder" valign="top" width="14.729999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001103315838_p18091655211"><a name="zh-cn_topic_0000001103315838_p18091655211"></a><a name="zh-cn_topic_0000001103315838_p18091655211"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="9.16%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001103315838_p19809196105217"><a name="zh-cn_topic_0000001103315838_p19809196105217"></a><a name="zh-cn_topic_0000001103315838_p19809196105217"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="61.29%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001103315838_p28095613525"><a name="zh-cn_topic_0000001103315838_p28095613525"></a><a name="zh-cn_topic_0000001103315838_p28095613525"></a>用于创建DateTimeFormat对象的表示区域信息的字符串，必须包含语言，可选择性包含文字与地区。</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
var dateFmt = new Intl.DateTimeFormat("en-Latn-GB");
```

### format<a name="zh-cn_topic_0000001103315838_section917151185514"></a>

获取格式化的日期字符串。

**参数：**

<a name="zh-cn_topic_0000001103315838_table61711165519"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103315838_row1176115554"><th class="cellrowborder" valign="top" width="14.82%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001103315838_p017312552"><a name="zh-cn_topic_0000001103315838_p017312552"></a><a name="zh-cn_topic_0000001103315838_p017312552"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="14.729999999999999%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001103315838_p217112554"><a name="zh-cn_topic_0000001103315838_p217112554"></a><a name="zh-cn_topic_0000001103315838_p217112554"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="9.16%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001103315838_p61771165517"><a name="zh-cn_topic_0000001103315838_p61771165517"></a><a name="zh-cn_topic_0000001103315838_p61771165517"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="61.29%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001103315838_p418515559"><a name="zh-cn_topic_0000001103315838_p418515559"></a><a name="zh-cn_topic_0000001103315838_p418515559"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103315838_row121811118556"><td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001103315838_p13181419559"><a name="zh-cn_topic_0000001103315838_p13181419559"></a><a name="zh-cn_topic_0000001103315838_p13181419559"></a>date</p>
</td>
<td class="cellrowborder" valign="top" width="14.729999999999999%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001103315838_p918171185515"><a name="zh-cn_topic_0000001103315838_p918171185515"></a><a name="zh-cn_topic_0000001103315838_p918171185515"></a>Date</p>
</td>
<td class="cellrowborder" valign="top" width="9.16%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001103315838_p161819114551"><a name="zh-cn_topic_0000001103315838_p161819114551"></a><a name="zh-cn_topic_0000001103315838_p161819114551"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="61.29%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001103315838_p718316555"><a name="zh-cn_topic_0000001103315838_p718316555"></a><a name="zh-cn_topic_0000001103315838_p718316555"></a>要格式化的日期对象。</p>
</td>
</tr>
</tbody>
</table>

**返回值：**

<a name="zh-cn_topic_0000001103315838_table2187195518"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103315838_row618171115511"><th class="cellrowborder" valign="top" width="17.01%" id="mcps1.1.3.1.1"><p id="zh-cn_topic_0000001103315838_p12186185510"><a name="zh-cn_topic_0000001103315838_p12186185510"></a><a name="zh-cn_topic_0000001103315838_p12186185510"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="82.99%" id="mcps1.1.3.1.2"><p id="zh-cn_topic_0000001103315838_p218171115514"><a name="zh-cn_topic_0000001103315838_p218171115514"></a><a name="zh-cn_topic_0000001103315838_p218171115514"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103315838_row13181115555"><td class="cellrowborder" valign="top" width="17.01%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001103315838_p3195145512"><a name="zh-cn_topic_0000001103315838_p3195145512"></a><a name="zh-cn_topic_0000001103315838_p3195145512"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="82.99%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001103315838_p3196119551"><a name="zh-cn_topic_0000001103315838_p3196119551"></a><a name="zh-cn_topic_0000001103315838_p3196119551"></a>返回根据区域格式化的日期字符串。</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
var date = new Date(1995, 11, 25, 3, 14, 0);
var datefmt = new Intl.DateTimeFormat("en-Latn-GB");
var result = datefmt.format(date); // 返回“Dec 25, 1995”
```

