# Summary

## zh-cn
<!-- 中文版本 -->
- [介绍](zh-cn/readme.md)
- [了解OpenHarmony](zh-cn/OpenHarmony-Overview_zh.md)
- 设备开发
  - [获取源码](zh-cn/device-dev/get-code/Readme-CN.md)
    - [获取源码](zh-cn/device-dev/get-code/源码获取.md)
    - [获取工具](zh-cn/device-dev/get-code/获取工具.md)
  - [快速入门](zh-cn/device-dev/quick-start/Readme-CN.md)
    - [导读](zh-cn/device-dev/quick-start/导读.md)
    - [轻量和小型系统入门](zh-cn/device-dev/quick-start/轻量和小型系统入门.md)
      - [概述](zh-cn/device-dev/quick-start/概述.md)
      - [了解开发板](zh-cn/device-dev/quick-start/了解开发板.md)
        - [Hi3861开发板介绍](zh-cn/device-dev/quick-start/Hi3861开发板介绍.md)
        - [Hi3516开发板介绍](zh-cn/device-dev/quick-start/Hi3516开发板介绍.md)
        - [Hi3518开发板介绍](zh-cn/device-dev/quick-start/Hi3518开发板介绍.md)
      - [搭建系统环境](zh-cn/device-dev/quick-start/搭建系统环境.md)
        - [Windows开发环境准备](zh-cn/device-dev/quick-start/Windows开发环境准备.md)
        - [Ubuntu编译环境准备](zh-cn/device-dev/quick-start/Ubuntu编译环境准备.md)
        - [常见问题](zh-cn/device-dev/quick-start/常见问题.md)
      - [开发步骤](zh-cn/device-dev/quick-start/开发步骤.md)
        - [Hi3861开发板](zh-cn/device-dev/quick-start/Hi3861开发板.md)
          - [安装开发板环境](zh-cn/device-dev/quick-start/安装开发板环境.md)
          - [WLAN联网](zh-cn/device-dev/quick-start/WLAN联网.md)
          - [运行Hello World](zh-cn/device-dev/quick-start/运行Hello-World.md)
          - [常见问题](zh-cn/device-dev/quick-start/常见问题-0.md)
        - [Hi3516开发板](zh-cn/device-dev/quick-start/Hi3516开发板.md)
          - [安装开发板环境](zh-cn/device-dev/quick-start/安装开发板环境-1.md)
          - [运行Hello OHOS](zh-cn/device-dev/quick-start/运行Hello-OHOS.md)
          - [驱动开发示例](zh-cn/device-dev/quick-start/驱动开发示例.md)
          - [常见问题](zh-cn/device-dev/quick-start/常见问题-2.md)
        - [Hi3518开发板](zh-cn/device-dev/quick-start/Hi3518开发板.md)
          - [安装开发板环境](zh-cn/device-dev/quick-start/安装开发板环境-3.md)
          - [运行Hello OHOS](zh-cn/device-dev/quick-start/运行Hello-OHOS-4.md)
          - [常见问题](zh-cn/device-dev/quick-start/常见问题-5.md)
    - [标准系统入门](zh-cn/device-dev/quick-start/标准系统入门.md)
      - [概述](zh-cn/device-dev/quick-start/概述-6.md)
      - [环境搭建](zh-cn/device-dev/quick-start/环境搭建.md)
        - [概述](zh-cn/device-dev/quick-start/概述-7.md)
        - [Windows开发环境准备](zh-cn/device-dev/quick-start/Windows开发环境准备-8.md)
        - [Ubuntu编译环境准备](zh-cn/device-dev/quick-start/Ubuntu编译环境准备-9.md)
        - [常见问题](zh-cn/device-dev/quick-start/常见问题-10.md)
      - [开发步骤](zh-cn/device-dev/quick-start/开发步骤-11.md)
  - 使用指南
    - [内核](zh-cn/device-dev/kernel/Readme-CN.md)
      - [轻内核](zh-cn/device-dev/kernel/轻内核.md)
        - [基础功能](zh-cn/device-dev/kernel/OpenHarmony轻内核基础功能.md)
          - [进程](zh-cn/device-dev/kernel/进程.md)
          - [线程](zh-cn/device-dev/kernel/线程.md)
          - [内存](zh-cn/device-dev/kernel/内存.md)
          - [网络](zh-cn/device-dev/kernel/网络.md)
        - [文件系统](zh-cn/device-dev/kernel/OpenHarmony轻内核文件系统.md)
          - [VFS](zh-cn/device-dev/kernel/VFS.md)
          - [NFS](zh-cn/device-dev/kernel/NFS.md)
          - [RAMFS](zh-cn/device-dev/kernel/RAMFS.md)
          - [FAT](zh-cn/device-dev/kernel/FAT.md)
          - [JFFS2](zh-cn/device-dev/kernel/JFFS2.md)
        - [标准库](zh-cn/device-dev/kernel/标准库.md)
          - [标准库](zh-cn/device-dev/kernel/标准库-0.md)
          - [与Linux标准库的差异](zh-cn/device-dev/kernel/与Linux标准库的差异.md)
        - [调测](zh-cn/device-dev/kernel/调测.md)
          - [Shell介绍](zh-cn/device-dev/kernel/Shell介绍.md)
          - [Shell命令开发指导](zh-cn/device-dev/kernel/Shell命令开发指导.md)
          - [Shell命令编程实例](zh-cn/device-dev/kernel/Shell命令编程实例.md)
          - [Shell命令使用详解](zh-cn/device-dev/kernel/Shell命令使用详解.md)
            - [系统命令](zh-cn/device-dev/kernel/系统命令.md)
              - [cpup](zh-cn/device-dev/kernel/cpup.md)
              - [date](zh-cn/device-dev/kernel/date.md)
              - [dmesg](zh-cn/device-dev/kernel/dmesg.md)
              - [exec](zh-cn/device-dev/kernel/exec.md)
              - [free](zh-cn/device-dev/kernel/free.md)
              - [help](zh-cn/device-dev/kernel/help.md)
              - [hwi](zh-cn/device-dev/kernel/hwi.md)
              - [kill](zh-cn/device-dev/kernel/kill.md)
              - [log](zh-cn/device-dev/kernel/log.md)
              - [memcheck](zh-cn/device-dev/kernel/memcheck.md)
              - [oom](zh-cn/device-dev/kernel/oom.md)
              - [pmm](zh-cn/device-dev/kernel/pmm.md)
              - [reset](zh-cn/device-dev/kernel/reset.md)
              - [sem](zh-cn/device-dev/kernel/sem.md)
              - [stack](zh-cn/device-dev/kernel/stack.md)
              - [su](zh-cn/device-dev/kernel/su.md)
              - [swtmr](zh-cn/device-dev/kernel/swtmr.md)
              - [systeminfo](zh-cn/device-dev/kernel/systeminfo.md)
              - [task](zh-cn/device-dev/kernel/task.md)
              - [uname](zh-cn/device-dev/kernel/uname.md)
              - [vmm](zh-cn/device-dev/kernel/vmm.md)
              - [watch](zh-cn/device-dev/kernel/watch.md)
            - [文件命令](zh-cn/device-dev/kernel/文件命令.md)
              - [cat](zh-cn/device-dev/kernel/cat.md)
              - [cd](zh-cn/device-dev/kernel/cd.md)
              - [chgrp](zh-cn/device-dev/kernel/chgrp.md)
              - [chmod](zh-cn/device-dev/kernel/chmod.md)
              - [chown](zh-cn/device-dev/kernel/chown.md)
              - [cp](zh-cn/device-dev/kernel/cp.md)
              - [format](zh-cn/device-dev/kernel/format.md)
              - [ls](zh-cn/device-dev/kernel/ls.md)
              - [lsfd](zh-cn/device-dev/kernel/lsfd.md)
              - [mkdir](zh-cn/device-dev/kernel/mkdir.md)
              - [mount](zh-cn/device-dev/kernel/mount.md)
              - [partinfo](zh-cn/device-dev/kernel/partinfo.md)
              - [partition](zh-cn/device-dev/kernel/partition.md)
              - [pwd](zh-cn/device-dev/kernel/pwd.md)
              - [rm](zh-cn/device-dev/kernel/rm.md)
              - [rmdir](zh-cn/device-dev/kernel/rmdir.md)
              - [statfs](zh-cn/device-dev/kernel/statfs.md)
              - [sync](zh-cn/device-dev/kernel/sync.md)
              - [touch](zh-cn/device-dev/kernel/touch.md)
              - [writeproc](zh-cn/device-dev/kernel/writeproc.md)
              - [umount](zh-cn/device-dev/kernel/umount.md)
            - [网络命令](zh-cn/device-dev/kernel/网络命令.md)
              - [arp](zh-cn/device-dev/kernel/arp.md)
              - [dhclient](zh-cn/device-dev/kernel/dhclient.md)
              - [dns](zh-cn/device-dev/kernel/dns.md)
              - [ifconfig](zh-cn/device-dev/kernel/ifconfig.md)
              - [ipdebug](zh-cn/device-dev/kernel/ipdebug.md)
              - [netstat](zh-cn/device-dev/kernel/netstat.md)
              - [ntpdate](zh-cn/device-dev/kernel/ntpdate.md)
              - [ping](zh-cn/device-dev/kernel/ping.md)
              - [ping6](zh-cn/device-dev/kernel/ping6.md)
              - [telnet](zh-cn/device-dev/kernel/telnet.md)
              - [tftp](zh-cn/device-dev/kernel/tftp.md)
          - [魔法键使用方法](zh-cn/device-dev/kernel/魔法键使用方法.md)
          - [用户态异常信息说明](zh-cn/device-dev/kernel/用户态异常信息说明.md)
      - [Linux内核](zh-cn/device-dev/kernel/Linux内核.md)
        - [Linux内核概述](zh-cn/device-dev/kernel/Linux内核概述.md)
        - [OpenHarmony开发板Patch使用指导](zh-cn/device-dev/kernel/OpenHarmony开发板Patch使用指导.md)
        - [Linux内核编译与构建指导](zh-cn/device-dev/kernel/Linux内核编译与构建指导.md)
    - [驱动](zh-cn/device-dev/driver/Readme-CN.md)
      - [HDF驱动框架](zh-cn/device-dev/driver/HDF驱动框架.md)
        - [HDF开发概述](zh-cn/device-dev/driver/HDF开发概述.md)
        - [驱动开发](zh-cn/device-dev/driver/驱动开发.md)
        - [驱动服务管理](zh-cn/device-dev/driver/驱动服务管理.md)
        - [驱动消息机制管理](zh-cn/device-dev/driver/驱动消息机制管理.md)
        - [配置管理](zh-cn/device-dev/driver/配置管理.md)
        - [HDF开发实例](zh-cn/device-dev/driver/HDF开发实例.md)
      - [驱动平台](zh-cn/device-dev/driver/驱动平台.md)
        - [GPIO](zh-cn/device-dev/driver/GPIO.md)
          - [GPIO概述](zh-cn/device-dev/driver/GPIO概述.md)
          - [GPIO使用指导](zh-cn/device-dev/driver/GPIO使用指导.md)
          - [GPIO使用实例](zh-cn/device-dev/driver/GPIO使用实例.md)
        - [I2C](zh-cn/device-dev/driver/I2C.md)
          - [I2C概述](zh-cn/device-dev/driver/I2C概述.md)
          - [I2C使用指导](zh-cn/device-dev/driver/I2C使用指导.md)
          - [I2C使用实例](zh-cn/device-dev/driver/I2C使用实例.md)
        - [RTC](zh-cn/device-dev/driver/RTC.md)
          - [RTC概述](zh-cn/device-dev/driver/RTC概述.md)
          - [RTC使用指导](zh-cn/device-dev/driver/RTC使用指导.md)
          - [RTC使用实例](zh-cn/device-dev/driver/RTC使用实例.md)
        - [SDIO](zh-cn/device-dev/driver/SDIO.md)
          - [SDIO概述](zh-cn/device-dev/driver/SDIO概述.md)
          - [SDIO使用指导](zh-cn/device-dev/driver/SDIO使用指导.md)
          - [SDIO使用实例](zh-cn/device-dev/driver/SDIO使用实例.md)
        - [SPI](zh-cn/device-dev/driver/SPI.md)
          - [SPI概述](zh-cn/device-dev/driver/SPI概述.md)
          - [SPI使用指导](zh-cn/device-dev/driver/SPI使用指导.md)
          - [SPI使用实例](zh-cn/device-dev/driver/SPI使用实例.md)
        - [UART](zh-cn/device-dev/driver/UART.md)
          - [UART概述](zh-cn/device-dev/driver/UART概述.md)
          - [UART使用指导](zh-cn/device-dev/driver/UART使用指导.md)
          - [UART使用实例](zh-cn/device-dev/driver/UART使用实例.md)
        - [WATCHDOG](zh-cn/device-dev/driver/WATCHDOG.md)
          - [看门狗概述](zh-cn/device-dev/driver/看门狗概述.md)
          - [看门狗使用指导](zh-cn/device-dev/driver/看门狗使用指导.md)
          - [看门狗使用实例](zh-cn/device-dev/driver/看门狗使用实例.md)
        - [MIPI DSI](zh-cn/device-dev/driver/MIPI-DSI.md)
          - [MIPI DSI概述](zh-cn/device-dev/driver/MIPI-DSI概述.md)
          - [MIPI DSI使用指导](zh-cn/device-dev/driver/MIPI-DSI使用指导.md)
          - [MIPI DSI使用实例](zh-cn/device-dev/driver/MIPI-DSI使用实例.md)
      - [外设](zh-cn/device-dev/driver/外设.md)
        - [LCD](zh-cn/device-dev/driver/LCD.md)
          - [LCD开发概述](zh-cn/device-dev/driver/LCD开发概述.md)
          - [LCD开发指导](zh-cn/device-dev/driver/LCD开发指导.md)
          - [LCD开发实例](zh-cn/device-dev/driver/LCD开发实例.md)
        - [TOUCHSCREEN](zh-cn/device-dev/driver/TOUCHSCREEN.md)
          - [Touchscreen开发概述](zh-cn/device-dev/driver/Touchscreen开发概述.md)
          - [Touchscreen开发指导](zh-cn/device-dev/driver/Touchscreen开发指导.md)
          - [Touchscreen开发实例](zh-cn/device-dev/driver/Touchscreen开发实例.md)
        - [SENSOR](zh-cn/device-dev/driver/SENSOR.md)
          - [传感器驱动开发概述](zh-cn/device-dev/driver/传感器驱动开发概述.md)
          - [传感器驱动开发指导](zh-cn/device-dev/driver/传感器驱动开发指导.md)
          - [传感器驱动开发实例](zh-cn/device-dev/driver/传感器驱动开发实例.md)
          - [传感器驱动测试指导](zh-cn/device-dev/driver/传感器驱动测试指导.md)
        - [WLAN](zh-cn/device-dev/driver/WLAN.md)
          - [WLAN开发概述](zh-cn/device-dev/driver/WLAN开发概述.md)
          - [WLAN开发指导](zh-cn/device-dev/driver/WLAN开发指导.md)
          - [WLAN开发实例](zh-cn/device-dev/driver/WLAN开发实例.md)
    - [子系统](zh-cn/device-dev/subsystems/Readme-CN.md)
      - [编译构建](zh-cn/device-dev/subsystems/编译构建.md)
        - [轻量和小型系统编译构建指导](zh-cn/device-dev/subsystems/轻量和小型系统编译构建指导.md)
          - [编译构建概述](zh-cn/device-dev/subsystems/编译构建概述.md)
          - [编译构建使用指导](zh-cn/device-dev/subsystems/编译构建使用指导.md)
          - [编译构建常见问题](zh-cn/device-dev/subsystems/编译构建常见问题.md)
        - [标准系统编译构建指导](zh-cn/device-dev/subsystems/标准系统编译构建指导.md)
          - [编译构建概述](zh-cn/device-dev/subsystems/编译构建概述-0.md)
          - [编译构建使用指导](zh-cn/device-dev/subsystems/编译构建使用指导-1.md)
      - [分布式远程启动](zh-cn/device-dev/subsystems/分布式远程启动.md)
      - [图形图像](zh-cn/device-dev/subsystems/图形图像.md)
        - [图形图像概述](zh-cn/device-dev/subsystems/图形图像概述.md)
        - [容器类组件开发指导](zh-cn/device-dev/subsystems/容器类组件开发指导.md)
        - [布局容器类组件开发指导](zh-cn/device-dev/subsystems/布局容器类组件开发指导.md)
        - [普通组件开发指导](zh-cn/device-dev/subsystems/普通组件开发指导.md)
        - [动画开发指导](zh-cn/device-dev/subsystems/动画开发指导.md)
      - [媒体](zh-cn/device-dev/subsystems/媒体.md)
        - [相机](zh-cn/device-dev/subsystems/相机.md)
          - [相机开发概述](zh-cn/device-dev/subsystems/相机开发概述.md)
          - [拍照开发指导](zh-cn/device-dev/subsystems/拍照开发指导.md)
          - [录像开发指导](zh-cn/device-dev/subsystems/录像开发指导.md)
          - [预览开发指导](zh-cn/device-dev/subsystems/预览开发指导.md)
        - [音视频](zh-cn/device-dev/subsystems/音视频.md)
          - [音视频开发概述](zh-cn/device-dev/subsystems/音视频开发概述.md)
          - [音视频播放开发指导](zh-cn/device-dev/subsystems/音视频播放开发指导.md)
          - [音视频录制开发指导](zh-cn/device-dev/subsystems/音视频录制开发指导.md)
      - [公共基础](zh-cn/device-dev/subsystems/公共基础.md)
        - [公共基础库概述](zh-cn/device-dev/subsystems/公共基础库概述.md)
        - [公共基础库开发指导](zh-cn/device-dev/subsystems/公共基础库开发指导.md)
        - [公共基础库常见问题](zh-cn/device-dev/subsystems/公共基础库常见问题.md)
      - [AI框架](zh-cn/device-dev/subsystems/AI框架.md)
        - [AI引擎框架开发指南](zh-cn/device-dev/subsystems/AI引擎框架开发指南.md)
        - [搭建环境](zh-cn/device-dev/subsystems/搭建环境.md)
        - [技术规范](zh-cn/device-dev/subsystems/技术规范.md)
          - [代码管理规范](zh-cn/device-dev/subsystems/代码管理规范.md)
          - [命名规范](zh-cn/device-dev/subsystems/命名规范.md)
          - [接口开发规范](zh-cn/device-dev/subsystems/接口开发规范.md)
        - [开发指导](zh-cn/device-dev/subsystems/开发指导.md)
          - [SDK开发过程](zh-cn/device-dev/subsystems/SDK开发过程.md)
          - [插件的开发过程](zh-cn/device-dev/subsystems/插件的开发过程.md)
          - [配置文件的开发过程](zh-cn/device-dev/subsystems/配置文件的开发过程.md)
        - [开发示例](zh-cn/device-dev/subsystems/开发示例.md)
          - [唤醒词识别SDK的开发示例](zh-cn/device-dev/subsystems/唤醒词识别SDK的开发示例.md)
          - [唤醒词识别插件的开发示例](zh-cn/device-dev/subsystems/唤醒词识别插件的开发示例.md)
          - [唤醒词识别配置文件的开发示例](zh-cn/device-dev/subsystems/唤醒词识别配置文件的开发示例.md)
      - [Sensor服务](zh-cn/device-dev/subsystems/Sensor服务.md)
        - [Sensor服务子系概述](zh-cn/device-dev/subsystems/Sensor服务子系概述.md)
        - [Sensor服务子系使用指导](zh-cn/device-dev/subsystems/Sensor服务子系使用指导.md)
        - [Sensor服务子系使用实例](zh-cn/device-dev/subsystems/Sensor服务子系使用实例.md)
      - [用户程序框架](zh-cn/device-dev/subsystems/用户程序框架.md)
        - [概述](zh-cn/device-dev/subsystems/概述.md)
        - [搭建环境](zh-cn/device-dev/subsystems/搭建环境-2.md)
        - [开发指导](zh-cn/device-dev/subsystems/开发指导-3.md)
        - [开发实例](zh-cn/device-dev/subsystems/开发实例.md)
      - [OTA升级](zh-cn/device-dev/subsystems/OTA升级.md)
      - [安全](zh-cn/device-dev/subsystems/安全.md)
        - [概述](zh-cn/device-dev/subsystems/概述-7.md)
        - [应用验签开发指导](zh-cn/device-dev/subsystems/应用验签开发指导.md)
        - [应用权限管理开发指导](zh-cn/device-dev/subsystems/应用权限管理开发指导.md)
        - [IPC通信鉴权开发指导](zh-cn/device-dev/subsystems/IPC通信鉴权开发指导.md)
        - [可信设备群组管理开发指导](zh-cn/device-dev/subsystems/可信设备群组管理开发指导.md)
      - [启动恢复](zh-cn/device-dev/subsystems/启动恢复.md)
        - [启动恢复子系统概述](zh-cn/device-dev/subsystems/启动恢复子系统概述.md)
        - [init启动引导组件](zh-cn/device-dev/subsystems/init启动引导组件.md)
        - [appspawn应用孵化组件](zh-cn/device-dev/subsystems/appspawn应用孵化组件.md)
        - [bootstrap服务启动组件](zh-cn/device-dev/subsystems/bootstrap服务启动组件.md)
        - [syspara系统属性组件](zh-cn/device-dev/subsystems/syspara系统属性组件.md)
        - [常见问题](zh-cn/device-dev/subsystems/常见问题.md)
        - [参考](zh-cn/device-dev/subsystems/参考.md)
      - [测试](zh-cn/device-dev/subsystems/测试.md)
      - [DFX](zh-cn/device-dev/subsystems/DFX.md)
        - [DFX概述](zh-cn/device-dev/subsystems/DFX概述.md)
        - [HiLog开发指导](zh-cn/device-dev/subsystems/HiLog开发指导.md)
        - [HiLog\_Lite开发指导](zh-cn/device-dev/subsystems/HiLog_Lite开发指导.md)
        - [HiSysEvent开发指导](zh-cn/device-dev/subsystems/HiSysEvent开发指导.md)
      - [研发工具链](zh-cn/device-dev/subsystems/研发工具链.md)
        - [bytrace使用指导](zh-cn/device-dev/subsystems/bytrace使用指导.md)
        - [hdc\_std 使用指导](zh-cn/device-dev/subsystems/hdc_std-使用指导.md)
      - [XTS](zh-cn/device-dev/subsystems/XTS认证子系统开发指南.md)
    - [隐私与安全](zh-cn/device-dev/security/Readme-CN.md)
      - [隐私保护](zh-cn/device-dev/security/隐私保护.md)
      - [安全指南](zh-cn/device-dev/security/安全指南.md)
  - [开发示例](zh-cn/device-dev/guide/Readme-CN.md)
    - [WLAN连接类产品](zh-cn/device-dev/guide/WLAN连接类产品.md)
      - [LED外设控制](zh-cn/device-dev/guide/LED外设控制.md)
        - [概述](zh-cn/device-dev/guide/概述.md)
        - [开发](zh-cn/device-dev/guide/开发.md)
        - [验证](zh-cn/device-dev/guide/验证.md)
      - [集成三方SDK](zh-cn/device-dev/guide/集成三方SDK.md)
    - [无屏摄像头类产品](zh-cn/device-dev/guide/无屏摄像头类产品.md)
      - [摄像头控制](zh-cn/device-dev/guide/摄像头控制.md)
        - [概述](zh-cn/device-dev/guide/概述-0.md)
        - [示例开发](zh-cn/device-dev/guide/示例开发.md)
          - [拍照开发指导](zh-cn/device-dev/guide/拍照开发指导.md)
          - [录像开发指导](zh-cn/device-dev/guide/录像开发指导.md)
        - [应用实例](zh-cn/device-dev/guide/应用实例.md)
    - [带屏摄像头类产品](zh-cn/device-dev/guide/带屏摄像头类产品.md)
      - [屏幕和摄像头控制](zh-cn/device-dev/guide/屏幕和摄像头控制.md)
        - [概述](zh-cn/device-dev/guide/概述-1.md)
        - [示例开发](zh-cn/device-dev/guide/示例开发-2.md)
          - [拍照开发指导](zh-cn/device-dev/guide/拍照开发指导-3.md)
          - [录像开发指导](zh-cn/device-dev/guide/录像开发指导-4.md)
          - [预览开发指导](zh-cn/device-dev/guide/预览开发指导.md)
        - [应用实例](zh-cn/device-dev/guide/应用实例-5.md)
      - [视觉应用开发](zh-cn/device-dev/guide/视觉应用开发.md)
        - [概述](zh-cn/device-dev/guide/概述-6.md)
        - [开发准备](zh-cn/device-dev/guide/开发准备.md)
        - [添加页面](zh-cn/device-dev/guide/添加页面.md)
        - [开发首页](zh-cn/device-dev/guide/开发首页.md)
        - [开发详情页](zh-cn/device-dev/guide/开发详情页.md)
        - [调试打包](zh-cn/device-dev/guide/调试打包.md)
        - [真机运行](zh-cn/device-dev/guide/真机运行.md)
        - [常见问题](zh-cn/device-dev/guide/常见问题.md)
    - [时钟应用开发示例](zh-cn/device-dev/guide/时钟应用开发示例.md)
      - [概述](zh-cn/device-dev/guide/概述-7.md)
      - [开发准备](zh-cn/device-dev/guide/开发准备-8.md)
      - [开发步骤](zh-cn/device-dev/guide/开发步骤.md)
      - [签名打包](zh-cn/device-dev/guide/签名打包.md)
      - [真机运行](zh-cn/device-dev/guide/真机运行-9.md)

    - [平台驱动开发示例](zh-cn/device-dev/guide/平台驱动开发示例.md)
      - [概述](zh-cn/device-dev/guide/概述-10.md)
      - [环境准备](zh-cn/device-dev/guide/环境准备.md)
      - [开发](zh-cn/device-dev/guide/开发-11.md)
      - [编译及烧录](zh-cn/device-dev/guide/编译及烧录.md)

    - [外设驱动开发示例](zh-cn/device-dev/guide/外设驱动开发示例.md)
      - [概述](zh-cn/device-dev/guide/概述-12.md)
        - [硬件资源介绍](zh-cn/device-dev/guide/硬件资源介绍.md)
        - [Input模型简介](zh-cn/device-dev/guide/Input模型简介.md)

      - [环境搭建](zh-cn/device-dev/guide/环境搭建.md)
      - [TouchScreen器件驱动开发](zh-cn/device-dev/guide/TouchScreen器件驱动开发.md)
        - [配置设备描述信息](zh-cn/device-dev/guide/配置设备描述信息.md)
        - [配置Touchscreen器件信息](zh-cn/device-dev/guide/配置Touchscreen器件信息.md)
        - [适配器件私有驱动](zh-cn/device-dev/guide/适配器件私有驱动.md)

      - [编译及烧录](zh-cn/device-dev/guide/编译及烧录-13.md)
      - [调试验证](zh-cn/device-dev/guide/调试验证.md)
        - [开机日志分析](zh-cn/device-dev/guide/开机日志分析.md)

      - [Input模型工作流程解析](zh-cn/device-dev/guide/Input模型工作流程解析.md)
        - [私有配置信息解析](zh-cn/device-dev/guide/私有配置信息解析.md)
        - [管理驱动层初始化及注册驱动至HDF框架](zh-cn/device-dev/guide/管理驱动层初始化及注册驱动至HDF框架.md)
        - [公共驱动层初始化及注册驱动至HDF框架](zh-cn/device-dev/guide/公共驱动层初始化及注册驱动至HDF框架.md)
        - [器件驱动层初始化及注册驱动至HDF框架](zh-cn/device-dev/guide/器件驱动层初始化及注册驱动至HDF框架.md)
        - [具体调用逻辑串联函数](zh-cn/device-dev/guide/具体调用逻辑串联函数.md)
        -   
  - [移植适配](zh-cn/device-dev/porting/Readme-CN.md)
    - [三方库移植指导](zh-cn/device-dev/porting/三方库移植指导.md)
      - [概述](zh-cn/device-dev/porting/概述.md)
      - [CMake方式组织编译的库移植](zh-cn/device-dev/porting/CMake方式组织编译的库移植.md)
      - [Makefile方式组织编译的库移植](zh-cn/device-dev/porting/Makefile方式组织编译的库移植.md)
    - [三方芯片移植指导](zh-cn/device-dev/porting/三方芯片移植指导.md)
      - [移植准备](zh-cn/device-dev/porting/移植准备.md)
        - [移植须知](zh-cn/device-dev/porting/移植须知.md)
        - [编译构建适配流程](zh-cn/device-dev/porting/编译构建适配流程.md)
      - [内核移植](zh-cn/device-dev/porting/内核移植.md)
        - [移植概述](zh-cn/device-dev/porting/移植概述.md)
        - [内核基础适配](zh-cn/device-dev/porting/内核基础适配.md)
        - [内核移植验证](zh-cn/device-dev/porting/内核移植验证.md)
      - [板级系统移植](zh-cn/device-dev/porting/板级系统移植.md)
        - [移植概述](zh-cn/device-dev/porting/移植概述-0.md)
        - [板级驱动适配](zh-cn/device-dev/porting/板级驱动适配.md)
        - [HAL层实现](zh-cn/device-dev/porting/HAL层实现.md)
        - [系统组件调用](zh-cn/device-dev/porting/系统组件调用.md)
        - [XTS认证](zh-cn/device-dev/porting/XTS认证.md)
      - [常见问题](zh-cn/device-dev/porting/常见问题.md)
  - [组件开发](zh-cn/device-dev/bundles/Readme-CN.md)
    - [组件开发规范](zh-cn/device-dev/bundles/组件开发规范.md)
      - [概述](zh-cn/device-dev/bundles/概述.md)
      - [组件构成](zh-cn/device-dev/bundles/组件构成.md)
      - [组件管理](zh-cn/device-dev/bundles/组件管理.md)
      - [组件版本](zh-cn/device-dev/bundles/组件版本.md)
      - [发行版](zh-cn/device-dev/bundles/发行版.md)
      - [环境变量说明](zh-cn/device-dev/bundles/环境变量说明.md)
    - [组件开发指南](zh-cn/device-dev/bundles/组件开发指南.md)
      - [概述](zh-cn/device-dev/bundles/概述-0.md)
      - [准备工作](zh-cn/device-dev/bundles/准备工作.md)
      - [组件开发](zh-cn/device-dev/bundles/组件开发.md)
    - [组件开发示例](zh-cn/device-dev/bundles/组件开发示例.md)
      - [HPM介绍](zh-cn/device-dev/bundles/HPM介绍.md)
      - [环境准备](zh-cn/device-dev/bundles/环境准备.md)
      - [操作实例](zh-cn/device-dev/bundles/操作实例.md)
  - [术语](zh-cn/device-dev/glossary/术语.md)
- 应用开发
  - [入门](zh-cn/application-dev/quick-start/Readme-CN.md)
    - [DevEco Studio（OpenHarmony）使用指南](zh-cn/application-dev/quick-start/DevEco-Studio（OpenHarmony）使用指南.md)
      -   [概述](zh-cn/application-dev/quick-start/概述.md)
      -   [配置OpenHarmony SDK](zh-cn/application-dev/quick-start/配置OpenHarmony-SDK.md)
      -   [导入OpenHarmony工程](zh-cn/application-dev/quick-start/导入OpenHarmony工程.md)
      -   [配置OpenHarmony应用签名信息](zh-cn/application-dev/quick-start/配置OpenHarmony应用签名信息.md)
      -   [安装运行OpenHarmony应用](zh-cn/application-dev/quick-start/安装运行OpenHarmony应用.md)
    - [快速入门](zh-cn/application-dev/quick-start/快速入门.md)
      - [开发准备](zh-cn/application-dev/quick-start/开发准备.md)
      - [使用JS语言开发](zh-cn/application-dev/quick-start/使用JS语言开发.md)
    
  - [UI](zh-cn/application-dev/ui/Readme-CN.md)
    - [JS UI框架](zh-cn/application-dev/ui/JS-UI框架.md)
      - [JS UI框架概述](zh-cn/application-dev/ui/JS-UI框架概述.md)
      - [构建用户界面](zh-cn/application-dev/ui/构建用户界面.md)
        - [组件介绍](zh-cn/application-dev/ui/组件介绍.md)
        - [构建布局](zh-cn/application-dev/ui/构建布局.md)
          - [布局说明](zh-cn/application-dev/ui/布局说明.md)
          - [添加标题行和文本区域](zh-cn/application-dev/ui/添加标题行和文本区域.md)
          - [添加图片区域](zh-cn/application-dev/ui/添加图片区域.md)
          - [添加留言区域](zh-cn/application-dev/ui/添加留言区域.md)
          - [添加容器](zh-cn/application-dev/ui/添加容器.md)
        - [添加交互](zh-cn/application-dev/ui/添加交互.md)
        - [动画](zh-cn/application-dev/ui/动画.md)
        - [事件](zh-cn/application-dev/ui/事件.md)
        - [页面路由](zh-cn/application-dev/ui/页面路由.md)
        - [自定义组件](zh-cn/application-dev/ui/自定义组件.md)
  
  - [媒体](zh-cn/application-dev/media/Readme-CN.md)
    - [音频](zh-cn/application-dev/media/音频.md)
      - [音频开发概述](zh-cn/application-dev/media/音频开发概述.md)
      
    - [音频播放开发指导](zh-cn/application-dev/media/音频播放开发指导.md)
      - [音频管理开发指导](zh-cn/application-dev/media/音频管理开发指导.md)
  
  
  - [网络与连接](zh-cn/application-dev/connectivity/Readme-CN.md)
  
    - [IPC与RPC通信](zh-cn/application-dev/connectivity/IPC与RPC通信.md)
      - [IPC与RPC通信概述](zh-cn/application-dev/connectivity/IPC与RPC通信概述.md)
      - [IPC与RPC通信开发指导](zh-cn/application-dev/connectivity/IPC与RPC通信开发指导.md)
      - [远端状态订阅开发实例](zh-cn/application-dev/connectivity/远端状态订阅开发实例.md)
  
  - [JS参考规范](zh-cn/application-dev/js-reference/Readme-CN.md)
    - [框架说明](zh-cn/application-dev/js-reference/框架说明.md) 
      - [文件组织](zh-cn/application-dev/js-reference/文件组织.md)
      - [js标签配置](zh-cn/application-dev/js-reference/js标签配置.md)
      - [app.js](zh-cn/application-dev/js-reference/app-js.md)
      - [语法](zh-cn/application-dev/js-reference/语法.md)
        - [HML语法参考](zh-cn/application-dev/js-reference/HML语法参考.md)
        - [CSS语法参考](zh-cn/application-dev/js-reference/CSS语法参考.md)
        - [JS语法参考](zh-cn/application-dev/js-reference/JS语法参考.md)
    - [组件](zh-cn/application-dev/js-reference/组件.md)
        - [通用](zh-cn/application-dev/js-reference/通用.md)
          - [组件方法](zh-cn/application-dev/js-reference/组件方法.md)
          - [动画样式](zh-cn/application-dev/js-reference/动画样式.md)
          - [渐变样式](zh-cn/application-dev/js-reference/渐变样式.md)
          - [转场样式](zh-cn/application-dev/js-reference/转场样式.md)
          - [自定义字体样式](zh-cn/application-dev/js-reference/自定义字体样式.md)
          - [原子布局](zh-cn/application-dev/js-reference/原子布局.md)
        - [容器组件](zh-cn/application-dev/js-reference/容器组件.md)
          - [badge](zh-cn/application-dev/js-reference/badge.md)
          - [dialog](zh-cn/application-dev/js-reference/dialog.md)
          - [div](zh-cn/application-dev/js-reference/div.md)
          - [list](zh-cn/application-dev/js-reference/list.md)
          - [list-item](zh-cn/application-dev/js-reference/list-item.md)
          - [list-item-group](zh-cn/application-dev/js-reference/list-item-group.md)
          - [panel](zh-cn/application-dev/js-reference/panel.md)
          - [popup](zh-cn/application-dev/js-reference/popup.md)
          - [refresh](zh-cn/application-dev/js-reference/refresh.md)
          - [stack](zh-cn/application-dev/js-reference/stack.md)
          - [stepper](zh-cn/application-dev/js-reference/stepper.md)
          - [stepper-item](zh-cn/application-dev/js-reference/stepper-item.md)
          - [swiper](zh-cn/application-dev/js-reference/swiper.md)
          - [tabs](zh-cn/application-dev/js-reference/tabs.md)
          - [tab-bar](zh-cn/application-dev/js-reference/tab-bar.md)
          - [tab-content](zh-cn/application-dev/js-reference/tab-content.md)
        - [基础组件](zh-cn/application-dev/js-reference/基础组件.md)
          - [button](zh-cn/application-dev/js-reference/button.md)
          - [chart](zh-cn/application-dev/js-reference/chart.md)
          - [divider](zh-cn/application-dev/js-reference/divider.md)
          - [image](zh-cn/application-dev/js-reference/image.md)
          - [image-animator](zh-cn/application-dev/js-reference/image-animator.md)
          - [input](zh-cn/application-dev/js-reference/input.md)
          - [label](zh-cn/application-dev/js-reference/label.md)
          - [marquee](zh-cn/application-dev/js-reference/marquee.md)
          - [menu](zh-cn/application-dev/js-reference/menu.md)
          - [option](zh-cn/application-dev/js-reference/option.md)
          - [picker](zh-cn/application-dev/js-reference/picker.md)
          - [picker-view](zh-cn/application-dev/js-reference/picker-view.md)
          - [piece](zh-cn/application-dev/js-reference/piece.md)
          - [progress](zh-cn/application-dev/js-reference/progress.md)
          - [qrcode](zh-cn/application-dev/js-reference/qrcode.md)
          - [rating](zh-cn/application-dev/js-reference/rating.md)
          - [select](zh-cn/application-dev/js-reference/select.md)
          - [slider](zh-cn/application-dev/js-reference/slider.md)
          - [span](zh-cn/application-dev/js-reference/span.md)
          - [switch](zh-cn/application-dev/js-reference/switch.md)
          - [text](zh-cn/application-dev/js-reference/text.md)
          - [toolbar](zh-cn/application-dev/js-reference/toolbar.md)
          - [toolbar-item](zh-cn/application-dev/js-reference/toolbar-item.md)
          - [toggle](zh-cn/application-dev/js-reference/toggle.md)
        - [画布组件](zh-cn/application-dev/js-reference/画布组件.md)
          - [canvas组件](zh-cn/application-dev/js-reference/canvas组件.md)
          - [CanvasRenderingContext2D对象](zh-cn/application-dev/js-reference/CanvasRenderingContext2D对象.md)
          - [Image对象](zh-cn/application-dev/js-reference/Image对象.md)
          - [CanvasGradient对象](zh-cn/application-dev/js-reference/CanvasGradient对象.md)
          - [ImageData对象](zh-cn/application-dev/js-reference/ImageData对象.md)
        - [栅格组件\(Rich\)](zh-cn/application-dev/js-reference/栅格组件(Rich).md)
          - [基本概念](zh-cn/application-dev/js-reference/基本概念.md)
          - [grid-container](zh-cn/application-dev/js-reference/grid-container.md)
          - [grid-row](zh-cn/application-dev/js-reference/grid-row.md)
          - [grid-col](zh-cn/application-dev/js-reference/grid-col.md)
    - [自定义组件](zh-cn/application-dev/js-reference/自定义组件.md)
        - [基本用法](zh-cn/application-dev/js-reference/基本用法.md)
        - [自定义事件](zh-cn/application-dev/js-reference/自定义事件.md)
        - [Props](zh-cn/application-dev/js-reference/Props.md)
        - [事件参数](zh-cn/application-dev/js-reference/事件参数.md)
    - [组件通用说明](zh-cn/application-dev/js-reference/组件通用说明.md)
        - [通用事件](zh-cn/application-dev/js-reference/通用事件.md)
        - [通用属性](zh-cn/application-dev/js-reference/通用属性.md)
        - [通用样式](zh-cn/application-dev/js-reference/通用样式.md)
    - [接口](zh-cn/application-dev/js-reference/接口.md)
        - [日志打印](zh-cn/application-dev/js-reference/日志打印.md)
        - [应用打点](zh-cn/application-dev/js-reference/应用打点.md)
        - [页面路由](zh-cn/application-dev/js-reference/页面路由.md)
        - [弹窗](zh-cn/application-dev/js-reference/弹窗.md)
        - [定时器](zh-cn/application-dev/js-reference/定时器.md)
        - [时间设置](zh-cn/application-dev/js-reference/时间设置.md)
        - [音频管理](zh-cn/application-dev/js-reference/音频管理.md)
        - [音频播放](zh-cn/application-dev/js-reference/音频播放.md)
        - [设备信息](zh-cn/application-dev/js-reference/设备信息.md)
        - [系统属性](zh-cn/application-dev/js-reference/系统属性.md)
        - [电池和充电属性](zh-cn/application-dev/js-reference/电池和充电属性.md)
        - [设置系统屏幕亮度](zh-cn/application-dev/js-reference/设置系统屏幕亮度.md)
        - [国际化](zh-cn/application-dev/js-reference/国际化.md)
        - [资源管理](zh-cn/application-dev/js-reference/资源管理.md)
        - [升级](zh-cn/application-dev/js-reference/升级.md)
## en

<!-- English Version -->
* [Introduction](en/readme.md)
- [OpenHarmony Overview](en/OpenHarmony-Overview.md)
- Devices Development
  - [Source Code Acquisition](en/device-dev/get-code/Readme-EN.md)
    - [Source Code Acquisition](en/device-dev/get-code/source-code-acquisition.md)
    - [Acquiring Tools](en/device-dev/get-code/tool-acquisition.md)
  - [Getting Started](en/device-dev/quick-start/Readme-EN.md)
    - [Overview](en/device-dev/quick-start/overview.md)
    - [Mini and Small Systems](en/device-dev/quick-start/mini-and-small-systems.md)
      - [Overview](en/device-dev/quick-start/overview-0.md)
      - [Introduction to the Development Boards](en/device-dev/quick-start/introduction-to-the-development-boards.md)
        - [Hi3861 Development Board](en/device-dev/quick-start/hi3861-development-board.md)
        - [Hi3516 Development Board](en/device-dev/quick-start/hi3516-development-board.md)
        - [Hi3518 Development Board](en/device-dev/quick-start/hi3518-development-board.md)
      - [Environment Setup](en/device-dev/quick-start/environment-setup.md)
        - [Windows Development Environment](en/device-dev/quick-start/windows-development-environment.md)
        - [Ubuntu Build Environment](en/device-dev/quick-start/ubuntu-build-environment.md)
        - [FAQ](en/device-dev/quick-start/faq.md)
      - [How to Develop](en/device-dev/quick-start/how-to-develop.md)
        - [Hi3861](en/device-dev/quick-start/hi3861.md)
          - [Setting Up the Environment](en/device-dev/quick-start/setting-up-the-environment.md)
          - [WLAN Connection](en/device-dev/quick-start/wlan-connection.md)
          - [Running a Hello World Program](en/device-dev/quick-start/running-a-hello-world-program.md)
          - [FAQs](en/device-dev/quick-start/faqs.md)
        - [Hi3516](en/device-dev/quick-start/hi3516.md)
          - [Setting Up the Environment](en/device-dev/quick-start/setting-up-the-environment-1.md)
          - [Running a Hello OHOS Program](en/device-dev/quick-start/running-a-hello-ohos-program.md)
          - [Developing a Driver](en/device-dev/quick-start/developing-a-driver.md)
          - [FAQs](en/device-dev/quick-start/faqs-2.md)
        - [Hi3518](en/device-dev/quick-start/hi3518.md)
          - [Setting Up the Environment](en/device-dev/quick-start/setting-up-the-environment-3.md)
          - [Running a Hello OHOS Program](en/device-dev/quick-start/running-a-hello-ohos-program-4.md)
          - [FAQs](en/device-dev/quick-start/faqs-5.md)
    - [Standard System](en/device-dev/quick-start/standard-system.md)
      - [Overview](en/device-dev/quick-start/overview-6.md)
      - [Environment Setup](en/device-dev/quick-start/environment-setup-7.md)
        - [Overview](en/device-dev/quick-start/overview-8.md)
        - [Windows Development Environment](en/device-dev/quick-start/windows-development-environment-9.md)
        - [Ubuntu Build Environment](en/device-dev/quick-start/ubuntu-build-environment-10.md)
        - [FAQs](en/device-dev/quick-start/faqs-11.md)
      - [How to Develop](en/device-dev/quick-start/how-to-develop-12.md)
- Usage Guidelines
 - [Kernel](en/device-dev/kernel/Readme-EN.md)
    - [Lite Kernel](en/device-dev/kernel/lite-kernel.md)
        - [OpenHarmony Lite Kernel Basic Functions](en/device-dev/kernel/openharmony-lite-kernel-basic-functions.md)
          - [Process](en/device-dev/kernel/process.md)
          - [Thread](en/device-dev/kernel/thread.md)
          - [Memory](en/device-dev/kernel/memory.md)
          - [Network](en/device-dev/kernel/network.md)
        - [OpenHarmony Lite Kernel File System](en/device-dev/kernel/openharmony-lite-kernel-file-system.md)
          - [VFS](en/device-dev/kernel/vfs.md)
          - [NFS](en/device-dev/kernel/nfs.md)
          - [RAMFS](en/device-dev/kernel/ramfs.md)
          - [FAT](en/device-dev/kernel/fat.md)
          - [JFFS2](en/device-dev/kernel/jffs2.md)
        - [Standard Library](en/device-dev/kernel/standard-library.md)
          - [Standard Library](en/device-dev/kernel/standard-library-0.md)
          - [Differences from the Linux Standard Library](en/device-dev/kernel/differences-from-the-linux-standard-library.md)
        - [Commissioning](en/device-dev/kernel/commissioning.md)
          - [Introduction to the Shell](en/device-dev/kernel/introduction-to-the-shell.md)
          - [Shell Command Development Guidelines](en/device-dev/kernel/shell-command-development-guidelines.md)
          - [Shell Command Programming Example](en/device-dev/kernel/shell-command-programming-example.md)
          - [Shell Command Reference](en/device-dev/kernel/shell-command-reference.md)
            - [System Commands](en/device-dev/kernel/system-commands.md)
              - [cpup](en/device-dev/kernel/cpup.md)
              - [date](en/device-dev/kernel/date.md)
              - [dmesg](en/device-dev/kernel/dmesg.md)
              - [exec](en/device-dev/kernel/exec.md)
              - [free](en/device-dev/kernel/free.md)
              - [help](en/device-dev/kernel/help.md)
              - [hwi](en/device-dev/kernel/hwi.md)
              - [kill](en/device-dev/kernel/kill.md)
              - [log](en/device-dev/kernel/log.md)
              - [memcheck](en/device-dev/kernel/memcheck.md)
              - [oom](en/device-dev/kernel/oom.md)
              - [pmm](en/device-dev/kernel/pmm.md)
              - [reset](en/device-dev/kernel/reset.md)
              - [sem](en/device-dev/kernel/sem.md)
              - [stack](en/device-dev/kernel/stack.md)
              - [su](en/device-dev/kernel/su.md)
              - [swtmr](en/device-dev/kernel/swtmr.md)
              - [systeminfo](en/device-dev/kernel/systeminfo.md)
              - [task](en/device-dev/kernel/task.md)
              - [uname](en/device-dev/kernel/uname.md)
              - [vmm](en/device-dev/kernel/vmm.md)
              - [watch](en/device-dev/kernel/watch.md)
            - [File Commands](en/device-dev/kernel/file-commands.md)
              - [cat](en/device-dev/kernel/cat.md)
              - [cd](en/device-dev/kernel/cd.md)
              - [chgrp](en/device-dev/kernel/chgrp.md)
              - [chmod](en/device-dev/kernel/chmod.md)
              - [chown](en/device-dev/kernel/chown.md)
              - [cp](en/device-dev/kernel/cp.md)
              - [format](en/device-dev/kernel/format.md)
              - [ls](en/device-dev/kernel/ls.md)
              - [lsfd](en/device-dev/kernel/lsfd.md)
              - [mkdir](en/device-dev/kernel/mkdir.md)
              - [mount](en/device-dev/kernel/mount.md)
              - [partinfo](en/device-dev/kernel/partinfo.md)
              - [partition](en/device-dev/kernel/partition.md)
              - [pwd](en/device-dev/kernel/pwd.md)
              - [rm](en/device-dev/kernel/rm.md)
              - [rmdir](en/device-dev/kernel/rmdir.md)
              - [statfs](en/device-dev/kernel/statfs.md)
              - [sync](en/device-dev/kernel/sync.md)
              - [touch](en/device-dev/kernel/touch.md)
              - [writeproc](en/device-dev/kernel/writeproc.md)
              - [umount](en/device-dev/kernel/umount.md)
            - [Network Commands](en/device-dev/kernel/network-commands.md)
              - [arp](en/device-dev/kernel/arp.md)
              - [dhclient](en/device-dev/kernel/dhclient.md)
              - [dns](en/device-dev/kernel/dns.md)
              - [ifconfig](en/device-dev/kernel/ifconfig.md)
              - [ipdebug](en/device-dev/kernel/ipdebug.md)
              - [netstat](en/device-dev/kernel/netstat.md)
              - [ntpdate](en/device-dev/kernel/ntpdate.md)
              - [ping](en/device-dev/kernel/ping.md)
              - [ping6](en/device-dev/kernel/ping6.md)
              - [telnet](en/device-dev/kernel/telnet.md)
              - [tftp](en/device-dev/kernel/tftp.md)
          - [Magic Key Usage](en/device-dev/kernel/magic-key-usage.md)
          - [User-Space Exception Information](en/device-dev/kernel/user-space-exception-information.md)
    - [Linux Kernel](en/device-dev/kernel/linux-kernel.md)
        - [Linux Kernel Overview](en/device-dev/kernel/linux-kernel-overview.md)
        - [Guidelines for Using Patches on OpenHarmony Development Boards](en/device-dev/kernel/guidelines-for-using-patches-on-openharmony-development-boards.md)
        - [Guidelines for Compiling and Building the Linux Kernel](en/device-dev/kernel/guidelines-for-compiling-and-building-the-linux-kernel.md)
    
- [Drivers](en/device-dev/driver/Readme-EN.md)
    - [HDF](en/device-dev/driver/hdf.md)
    - [HDF Overview](en/device-dev/driver/hdfoverview.md)
        - [Driver Development](en/device-dev/driver/driver-development.md)
        - [Driver Service Management](en/device-dev/driver/driver-service-management.md)
        - [Driver Message Mechanism Management](en/device-dev/driver/driver-message-mechanism-management.md)
        - [Driver Configuration Management](en/device-dev/driver/driver-configuration-management.md)
        - [HDF Development Example](en/device-dev/driver/hdfdevelopment-example.md)
      - [Driver Platform](en/device-dev/driver/driver-platform.md)
        - [GPIO](en/device-dev/driver/gpio.md)
          - [GPIO Overview](en/device-dev/driver/gpiooverview.md)
          - [GPIO Usage Guidelines](en/device-dev/driver/gpiousage-guidelines.md)
          - [GPIO Usage Example](en/device-dev/driver/gpiousage-example.md)
        - [I2C](en/device-dev/driver/i2c.md)
          - [I2C Overview](en/device-dev/driver/i2c-overview.md)
          - [I2C Usage Guidelines](en/device-dev/driver/i2c-usage-guidelines.md)
          - [I2C Usage Example](en/device-dev/driver/i2c-usage-example.md)
        - [RTC](en/device-dev/driver/rtc.md)
          - [RTC Overview](en/device-dev/driver/rtc-overview.md)
          - [RTC Usage Guidelines](en/device-dev/driver/rtc-usage-guidelines.md)
          - [RTC Usage Example](en/device-dev/driver/rtc-usage-example.md)
        - [SDIO](en/device-dev/driver/sdio.md)
          - [SDIO Overview](en/device-dev/driver/sdiooverview.md)
          - [SDIO Usage Guidelines](en/device-dev/driver/sdiousage-guidelines.md)
          - [SDIO Usage Example](en/device-dev/driver/sdiousage-example.md)
        - [SPI](en/device-dev/driver/spi.md)
          - [SPI Overview](en/device-dev/driver/spioverview.md)
          - [SPI Usage Guidelines](en/device-dev/driver/spiusage-guidelines.md)
          - [SPI Usage Example](en/device-dev/driver/spiusage-example.md)
        - [UART](en/device-dev/driver/uart.md)
          - [UART Overview](en/device-dev/driver/uartoverview.md)
          - [UART Usage Guidelines](en/device-dev/driver/uartusage-guidelines.md)
          - [UART Usage Example](en/device-dev/driver/uartusage-example.md)
        - [WATCHDOG](en/device-dev/driver/watchdog.md)
          - [Watchdog Overview](en/device-dev/driver/watchdogoverview.md)
          - [Watchdog Usage Guidelines](en/device-dev/driver/watchdogusage-guidelines.md)
          - [Watchdog Usage Example](en/device-dev/driver/watchdogusage-example.md)
        - [MIPI DSI](en/device-dev/driver/mipi-dsi.md)
          - [MIPI DSI Overview](en/device-dev/driver/mipi-dsi-overview.md)
          - [Usage Guidelines](en/device-dev/driver/usage-guidelines.md)
          - [Usage Example](en/device-dev/driver/usage-example.md)
      - [Peripherals](en/device-dev/driver/Readme-EN.md)
        - [LCD](en/device-dev/driver/lcd.md)
          - [LCD Overview](en/device-dev/driver/lcdoverview.md)
          - [LCD Development Guidelines](en/device-dev/driver/lcddevelopment-guidelines.md)
          - [LCD Development Example](en/device-dev/driver/lcddevelopment-example.md)
        - [TOUCHSCREEN](en/device-dev/driver/touchscreen.md)
          - [Touchscreen Overview](en/device-dev/driver/touchscreenoverview.md)
          - [Touchscreen Development Guidelines](en/device-dev/driver/touchscreendevelopment-guidelines.md)
          - [Touchscreen Development Example](en/device-dev/driver/touchscreendevelopment-example.md)
        - [SENSOR](en/device-dev/driver/sensor.md)
          - [Sensor Driver Overview](en/device-dev/driver/sensor-driver-overview.md)
          - [Sensor Driver Development Guidelines](en/device-dev/driver/sensor-driver-development-guidelines.md)
          - [Sensor Driver Development Example](en/device-dev/driver/sensor-driver-development-example.md)
          - [Sensor Driver Test Guidelines](en/device-dev/driver/sensor-driver-test-guidelines.md)
        - [WLAN](en/device-dev/driver/wlan.md)
          - [WLAN Overview](en/device-dev/driver/wlanoverview.md)
          - [WLAN Development Guidelines](en/device-dev/driver/wlandevelopment-guidelines.md)
          - [WLAN Development Example](en/device-dev/driver/wlandevelopment-example.md)
    
 - [Subsystems](en/device-dev/subsystems/Readme-EN.md)
      - [Compilation and Building](en/device-dev/subsystems/compilation-and-building.md) 
          - [Building Guidelines for Mini and Small Systems](en/device-dev/subsystems/building-guidelines-for-mini-and-small-systems.md)
            - [Compilation and Building Overview](en/device-dev/subsystems/compilation-and-building-overview.md)
            - [Compilation and Building Guidelines](en/device-dev/subsystems/compilation-and-building-guidelines.md)
            - [Compilation and Building FAQ](en/device-dev/subsystems/compilation-and-building-faq.md)
              - [Building Guidelines for the Standard System](en/device-dev/subsystems/building-guidelines-for-the-standard-system.md)
            - [Compilation and Building Overview](en/device-dev/subsystems/compilation-and-building-overview-0.md)
            - [Compilation and Building Guidelines](en/device-dev/subsystems/compilation-and-building-guidelines-1.md)
      
      - [Distributed Remote Startup](en/device-dev/subsystems/distributed-remote-startup.md)
      - [Graphics](en/device-dev/subsystems/graphics.md)
          - [Graphics](en/device-dev/subsystems/graphics-2.md)
          - [Development Guidelines on Container Components](en/device-dev/subsystems/development-guidelines-on-container-components.md)
          - [Development Guidelines on Layout Container Components](en/device-dev/subsystems/development-guidelines-on-layout-container-components.md)
          - [Development Guidelines on Common Components](en/device-dev/subsystems/development-guidelines-on-common-components.md)
          - [Development Guidelines on Animators](en/device-dev/subsystems/development-guidelines-on-animators.md)
      - [Multimedia](en/device-dev/subsystems/multimedia.md)
          - [Camera](en/device-dev/subsystems/camera.md)
            - [Overview](en/device-dev/subsystems/overview.md)
            - [Development Guidelines on Photographing](en/device-dev/subsystems/development-guidelines-on-photographing.md)
            - [Development Guidelines on Video Recording](en/device-dev/subsystems/development-guidelines-on-video-recording.md)
            - [Development Guidelines on Previewing](en/device-dev/subsystems/development-guidelines-on-previewing.md)
          - [Audio/Video](en/device-dev/subsystems/audio-video.md)
            - [Overview](en/device-dev/subsystems/overview-3.md)
            - [Development Guidelines on Media Playback](en/device-dev/subsystems/development-guidelines-on-media-playback.md)
            - [Development Guidelines on Media Recording](en/device-dev/subsystems/development-guidelines-on-media-recording.md)
      - [Utils](en/device-dev/subsystems/utils.md)
          - [Utils Overview](en/device-dev/subsystems/utils-overview.md)
          - [Utils Development Guidelines](en/device-dev/subsystems/utils-development-guidelines.md)
          - [Utils FAQ](en/device-dev/subsystems/utils-faq.md)
      - [AI Framework](en/device-dev/subsystems/ai-framework.md)
          - [AI Engine Framework](en/device-dev/subsystems/ai-engine-framework.md)
          - [Development Environment](en/device-dev/subsystems/development-environment.md)
          - [Technical Specifications](en/device-dev/subsystems/technical-specifications.md)
            - [Code Management](en/device-dev/subsystems/code-management.md)
            - [Naming](en/device-dev/subsystems/naming.md)
            - [API Development](en/device-dev/subsystems/api-development.md)
          - [Development Guidelines](en/device-dev/subsystems/development-guidelines.md)
            - [SDK](en/device-dev/subsystems/sdk.md)
            - [Plug-in](en/device-dev/subsystems/plug-in.md)
            - [Configuration File](en/device-dev/subsystems/configuration-file.md)
          - [Development Examples](en/device-dev/subsystems/development-examples.md)
            - [KWS SDK](en/device-dev/subsystems/kws-sdk.md)
            - [KWS Plug-in](en/device-dev/subsystems/kws-plug-in.md)
            - [KWS Configuration File](en/device-dev/subsystems/kws-configuration-file.md)
      - [Sensors](en/device-dev/subsystems/sensors.md)
          - [Sensors Overview](en/device-dev/subsystems/sensors-overview.md)
          - [Sensors Usage Guidelines](en/device-dev/subsystems/sensors-usage-guidelines.md)
          - [Sensors Usage Example](en/device-dev/subsystems/sensors-usage-example.md)
      - [Application Framework](en/device-dev/subsystems/application-framework.md)
          - [Overview](en/device-dev/subsystems/overview-4.md)
          - [Setting Up a Development Environment](en/device-dev/subsystems/setting-up-a-development-environment.md)
          - [Development Guidelines](en/device-dev/subsystems/development-guidelines-5.md)
          - [Development Example](en/device-dev/subsystems/development-example.md)
      - [OTA Upgrade](en/device-dev/subsystems/ota-upgrade.md)
      - [Security](en/device-dev/subsystems/security.md)
          - [Overview](en/device-dev/subsystems/overview-9.md)
          - [Development Guidelines on Application Signature Verification](en/device-dev/subsystems/development-guidelines-on-application-signature-verification.md)
          - [Development Guidelines on Application Permission Management](en/device-dev/subsystems/development-guidelines-on-application-permission-management.md)
          - [Development Guidelines on IPC Authentication](en/device-dev/subsystems/development-guidelines-on-ipc-authentication.md)
          - [Development Guidelines on Trusted Device Group Management](en/device-dev/subsystems/development-guidelines-on-trusted-device-group-management.md)
          - [Reference](en/device-dev/subsystems/reference.md)
      - [Startup](en/device-dev/subsystems/startup.md)
          - [Startup](en/device-dev/subsystems/startup-10.md)
          - [init Module](en/device-dev/subsystems/init-module.md)
          - [appspawn Module](en/device-dev/subsystems/appspawn-module.md)
          - [bootstrap Module](en/device-dev/subsystems/bootstrap-module.md)
          - [syspara Module](en/device-dev/subsystems/syspara-module.md)
          - [FAQs](en/device-dev/subsystems/faqs.md)
          - [Reference](en/device-dev/subsystems/reference.md)
      - [Testing](en/device-dev/subsystems/testing.md)
      - [DFX](en/device-dev/subsystems/dfx.md)
          - [DFX](en/device-dev/subsystems/dfx-11.md)
          - [Development Guidelines on HiLog ](en/device-dev/subsystems/development-guidelines-on-hilog.md)
          - [Development Guidelines on HiLog\_Lite](en/device-dev/subsystems/development-guidelines-on-hilog_lite.md)
          - [Development Guidelines on HiSysEvent](en/device-dev/subsystems/development-guidelines-on-hisysevent.md)
      - [R&D Tools](en/device-dev/subsystems/r-d-tools.md)
          - [bytrace Usage Guidelines](en/device-dev/subsystems/bytrace-usage-guidelines.md)
          - [hdc std Usage Guidelines](en/device-dev/subsystems/hdc_std-usage-guidelines.md)
      - [XTS](en/device-dev/subsystems/xts.md)
      - [Privacy and Security](en/device-dev/security/Readme-EN.md)   
          - [Privacy Protection](en/device-dev/security/privacy-protection.md)
          - [Security Guidelines](en/device-dev/security/security-guidelines.md)
 - [Development Examples](en/device-dev/guide/Readme-EN.md)
      - [WLAN-connected Products](en/device-dev/guide/wlan-connected-products.md)
          - [LED Peripheral Control](en/device-dev/guide/led-peripheral-control.md)
          - [Overview](en/device-dev/guide/overview.md)
            - [Development](en/device-dev/guide/development.md)
            - [Verification](en/device-dev/guide/verification.md)
          - [Third-Party SDK Integration](en/device-dev/guide/third-party-sdk-integration.md)
      - [Camera Control](en/device-dev/guide/camera-control.md)
          - [Overview](en/device-dev/guide/overview-0.md)
          - [Development Guidelines](en/device-dev/guide/development-guidelines.md)
            - [Photographing](en/device-dev/guide/photographing.md)
            - [Video Recording](en/device-dev/guide/video-recording.md)
          - [Use Case](en/device-dev/guide/use-case.md)
      - [Cameras with a Screen](en/device-dev/guide/cameras-with-a-screen.md)
          - [Screen and Camera Control](en/device-dev/guide/screen-and-camera-control.md)
            - [Overview](en/device-dev/guide/overview-1.md)
            - [Development Guidelines](en/device-dev/guide/development-guidelines-2.md)
              - [Photographing](en/device-dev/guide/photographing-3.md)
              - [Video Recording](en/device-dev/guide/video-recording-4.md)
              - [Previewing](en/device-dev/guide/previewing.md)
            - [Use Case](en/device-dev/guide/use-case-5.md)
      - [Visual Application Development](en/device-dev/guide/visual-application-development.md)
          - [Overview](en/device-dev/guide/overview-6.md)
          - [Preparations](en/device-dev/guide/preparations.md)
          - [Adding Pages](en/device-dev/guide/adding-pages.md)
          - [Building the Home Page](en/device-dev/guide/building-the-home-page.md)
          - [Building the Details Page](en/device-dev/guide/building-the-details-page.md)
          - [Debugging and Packaging](en/device-dev/guide/debugging-and-packaging.md)
          - [Running on the Device](en/device-dev/guide/running-on-the-device.md)
          - [FAQs](en/device-dev/guide/faqs.md)
      - [Development Example for Clock Apps](en/device-dev/guide/development-example-for-clock-apps.md)
           - [Overview](en/device-dev/guide/overview-7.md)
           - [Preparations](en/device-dev/guide/preparations-8.md)
           - [How to Develop](en/device-dev/guide/how-to-develop.md)
           - [Signing and Packaging](en/device-dev/guide/signing-and-packaging.md)
           - [Running on the Device](en/device-dev/guide/running-on-the-device-9.md)
      - [Development Example for Platform Drivers](en/device-dev/guide/development-example-for-platform-drivers.md)
           - [Overview](en/device-dev/guide/overview-10.md)
           - [Preparations](en/device-dev/guide/preparations-11.md)
           - [Development](en/device-dev/guide/development-12.md)
           - [Building and Burning](en/device-dev/guide/building-and-burning.md)
      - [Development Example for Peripheral Drivers](en/device-dev/guide/development-example-for-peripheral-drivers.md)
           - [Overview](en/device-dev/guide/overview-13.md)
              - [Hardware Resources](en/device-dev/guide/hardware-resources.md)
              - [Input Driver Model](en/device-dev/guide/input-driver-model.md)
              - [Setting Up the Environment](en/device-dev/guide/setting-up-the-environment.md)
           - [Developing a Touchscreen Driver](en/device-dev/guide/developing-a-touchscreen-driver.md)
              - [Configuring Device Driver Descriptions](en/device-dev/guide/configuring-device-driver-descriptions.md)
              - [Configuring the Touchscreen](en/device-dev/guide/configuring-the-touchscreen.md)
              - [Adapting to the Private Drivers of the Touchscreen](en/device-dev/guide/adapting-to-the-private-drivers-of-the-touchscreen.md)               
              - [Building and Burning](en/device-dev/guide/building-and-burning-14.md)
              - [Debugging and Verification](en/device-dev/guide/debugging-and-verification.md)
                -   [Startup Log Analysis](en/device-dev/guide/startup-log-analysis.md)               
              - [Input Driver Model Workflow Analysis](en/device-dev/guide/input-driver-model-workflow-analysis.md)
                -   [Parsing Private Configuration Data](en/device-dev/guide/parsing-private-configuration-data.md)
                -   [Initializing the Input Device Manager and Registering the Driver with the HDF](en/device-dev/guide/initializing-the-input-device-manager-and-registering-the-driver-with-the-hdf.md)
                -   [Initializing the Input Common Driver and Registering the Driver with the HDF](en/device-dev/guide/initializing-the-input-common-driver-and-registering-the-driver-with-the-hdf.md)
                -   [Initializing the Input Chip Driver and Registering the Driver with the HDF](en/device-dev/guide/initializing-the-input-chip-driver-and-registering-the-driver-with-the-hdf.md)
                -   [Function Invocation Logic](en/device-dev/guide/function-invocation-logic.md)
  - [Porting Guide](en/device-dev/porting/Readme-EN.md)
    - [Third-Party Library Porting Guide](en/device-dev/porting/third-party-library-porting-guide.md)
      - [Overview](en/device-dev/porting/overview.md)
      - [Porting a Library Built Using CMake](en/device-dev/porting/porting-a-library-built-using-cmake.md)
      - [Porting a Library Built Using Makefile](en/device-dev/porting/porting-a-library-built-using-makefile.md)
    - [Third-Party SoC Porting Guide](en/device-dev/porting/third-party-soc-porting-guide.md)
      - [Porting Preparations](en/device-dev/porting/porting-preparations.md)
        - [Before You Start](en/device-dev/porting/before-you-start.md)
        - [Building Adaptation Process](en/device-dev/porting/building-adaptation-process.md)
      - [Kernel Porting](en/device-dev/porting/kernel-porting.md)
        - [Overview](en/device-dev/porting/overview-0.md)
        - [Basic Kernel Adaptation](en/device-dev/porting/basic-kernel-adaptation.md)
        - [Kernel Porting Verification](en/device-dev/porting/kernel-porting-verification.md)
    - [Board-Level OS Porting](en/device-dev/porting/board-level-os-porting.md)
        - [Overview](en/device-dev/porting/overview-1.md)
        - [Board-Level Driver Adaptation](en/device-dev/porting/board-level-driver-adaptation.md)
        - [Implementation of APIs at the HAL](en/device-dev/porting/implementation-of-apis-at-the-hal.md)
        - [System Modules](en/device-dev/porting/system-modules.md)
        - [XTS](en/device-dev/porting/xts.md)
      - [FAQ](en/device-dev/porting/faq.md)
  - [Bundle Development](en/device-dev/bundles/Readme-EN.md)
    - [Development Specifications](en/device-dev/bundles/development-specifications.md)
      - [Overview](en/device-dev/bundles/overview.md)
      - [Bundle Composition](en/device-dev/bundles/bundle-composition.md)
      - [Bundle Management](en/device-dev/bundles/bundle-management.md)
      - [Bundle Version](en/device-dev/bundles/bundle-version.md)
      - [Distribution](en/device-dev/bundles/distribution.md)
      - [Environment Variables](en/device-dev/bundles/environment-variables.md)
    - [Development Guidelines](en/device-dev/bundles/development-guidelines.md)
      - [Overview](en/device-dev/bundles/overview-0.md)
      - [Preparations](en/device-dev/bundles/preparations.md)
      - [Bundle Development](en/device-dev/bundles/bundle-development.md)
    - [HPM User Guide](en/device-dev/bundles/hpm-user-guide.md)
      - [Introduction](en/device-dev/bundles/introduction.md)
      - [Preparations](en/device-dev/bundles/preparations-1.md)
      - [Development Example](en/device-dev/bundles/development-example.md)
  - [Glossary](en/device-dev/glossary/glossary.md)
  
- Application Development
  - [DevEco Studio \(OpenHarmony\) User Guide](en/application-dev/quick-start/deveco-studio-(openharmony)-user-guide.md)
    -   [Overview](en/application-dev/quick-start/overview.md)
    -   [Configuring the OpenHarmony SDK](en/application-dev/quick-start/configuring-the-openharmony-sdk.md)
    -   [Configuring the OpenHarmony App Signature](en/application-dev/quick-start/configuring-the-openharmony-app-signature.md)
-   [Installing and Running Your OpenHarmony App](en/application-dev/quick-start/installing-and-running-your-openharmony-app.md)
  - [Basics ](en/application-dev/quick-start/Readme-EN.md)
    - [Getting Started](en/application-dev/quick-start/getting-started.md)
      - [Preparations](en/application-dev/quick-start/preparations.md)
      - [Getting Started with JavaScript](en/application-dev/quick-start/getting-started-with-javascript.md)
  - [UI](en/application-dev/ui/Readme-EN.md)
    - [JS UI Framework](en/application-dev/ui/js-ui-framework.md)
      - [JS UI Framework Overview](en/application-dev/ui/js-ui-framework-overview.md)
      - [Building the UI](en/application-dev/ui/building-the-ui.md)
        - [Component Overview](en/application-dev/ui/component-overview.md)
        - [Building the Layout](en/application-dev/ui/building-the-layout.md)
          - [Layout Description](en/application-dev/ui/layout-description.md)
          - [Adding Title and Paragraph Text](en/application-dev/ui/adding-title-and-paragraph-text.md)
          - [Adding an Image](en/application-dev/ui/adding-an-image.md)
          - [Adding a Comment](en/application-dev/ui/adding-a-comment.md)
          - [Adding a Container](en/application-dev/ui/adding-a-container.md)
        - [Adding Interactions](en/application-dev/ui/adding-interactions.md)
        - [Animation](en/application-dev/ui/animation.md)
        - [Event](en/application-dev/ui/event.md)
        - [Defining Page Routes](en/application-dev/ui/defining-page-routes.md)
      - [Custom Components](en/application-dev/ui/custom-components.md)
  - [Media](en/application-dev/media/Readme-EN.md)
    - [Audio](en/application-dev/media/audio.md)
      - [Audio Overview](en/application-dev/media/audio-overview.md)
      - [Development Guidelines on Audio Playback](en/application-dev/media/development-guidelines-on-audio-playback.md)
      - [Development Guidelines on Audio Management](en/application-dev/media/development-guidelines-on-audio-management.md)
  - [Connectivity](en/application-dev/connectivity/Readme-EN.md)
    - [IPC & RPC](en/application-dev/connectivity/ipc-rpc.md)
      - [IPC & RPC Overview](en/application-dev/connectivity/ipc-rpc-overview.md)
      - [IPC & RPC Development Guidelines](en/application-dev/connectivity/ipc-rpc-development-guidelines.md)
      - [Subscribing to State Changes of a Remote Object](en/application-dev/connectivity/subscribing-to-state-changes-of-a-remote-object.md)
  - [JS Reference](en/application-dev/js-reference/Readme-EN.md)
  
    - [Framework](en/application-dev/js-reference/framework.md)
      - [File Organization](en/application-dev/js-reference/file-organization.md)
      - ["js" Tag](en/application-dev/js-reference/js-tag.md)
      - [app.js](en/application-dev/js-reference/app-js.md)
      - [Syntax](en/application-dev/js-reference/syntax.md)
        - [HML](en/application-dev/js-reference/hml.md)
        - [CSS](en/application-dev/js-reference/css.md)
        - [JavaScript](en/application-dev/js-reference/javascript.md)
      - [Loading Images Based on DPI](en/application-dev/js-reference/loading-images-based-on-dpi.md)
    - [Components](en/application-dev/js-reference/components.md)
      - [Common](en/application-dev/js-reference/common.md)
        - [Component Methods](en/application-dev/js-reference/component-methods.md)
        - [Animation Styles](en/application-dev/js-reference/animation-styles.md)
        - [Gradient Styles](en/application-dev/js-reference/gradient-styles.md)
        - [Transition Styles](en/application-dev/js-reference/transition-styles.md)
        - [Custom Font Styles](en/application-dev/js-reference/custom-font-styles.md)
        - [Atomic Layout](en/application-dev/js-reference/atomic-layout.md)
      - [Container Components](en/application-dev/js-reference/container-components.md)
        - [badge](en/application-dev/js-reference/badge.md)
        - [dialog](en/application-dev/js-reference/dialog.md)
        - [div](en/application-dev/js-reference/div.md)
        - [list](en/application-dev/js-reference/list.md)
        - [list-item](en/application-dev/js-reference/list-item.md)
        - [list-item-group](en/application-dev/js-reference/list-item-group.md)
        - [panel](en/application-dev/js-reference/panel.md)
        - [popup](en/application-dev/js-reference/popup.md)
        - [refresh](en/application-dev/js-reference/refresh.md)
        - [stack](en/application-dev/js-reference/stack.md)
        - [stepper](en/application-dev/js-reference/stepper.md)
        - [stepper-item](en/application-dev/js-reference/stepper-item.md)
        - [swiper](en/application-dev/js-reference/swiper.md)
        - [tabs](en/application-dev/js-reference/tabs.md)
        - [tab-bar](en/application-dev/js-reference/tab-bar.md)
        - [tab-content](en/application-dev/js-reference/tab-content.md)
      - [Basic Components](en/application-dev/js-reference/basic-components.md)
        - [button](en/application-dev/js-reference/button.md)
        - [chart](en/application-dev/js-reference/chart.md)
        - [divider](en/application-dev/js-reference/divider.md)
        - [image](en/application-dev/js-reference/image.md)
        - [image-animator](en/application-dev/js-reference/image-animator.md)
        - [input](en/application-dev/js-reference/input.md)
        - [label](en/application-dev/js-reference/label.md)
        - [marquee](en/application-dev/js-reference/marquee.md)
        - [menu](en/application-dev/js-reference/menu.md)
        - [option](en/application-dev/js-reference/option.md)
        - [picker](en/application-dev/js-reference/picker.md)
        - [picker-view](en/application-dev/js-reference/picker-view.md)
        - [piece](en/application-dev/js-reference/piece.md)
        - [progress](en/application-dev/js-reference/progress.md)
        - [qrcode](en/application-dev/js-reference/qrcode.md)
        - [rating](en/application-dev/js-reference/rating.md)
        - [search](en/application-dev/js-reference/search.md)
        - [select](en/application-dev/js-reference/select.md)
        - [slider](en/application-dev/js-reference/slider.md)
        - [span](en/application-dev/js-reference/span.md)
        - [switch](en/application-dev/js-reference/switch.md)
        - [text](en/application-dev/js-reference/text.md)
        - [textarea](en/application-dev/js-reference/textarea.md)
        - [toolbar](en/application-dev/js-reference/toolbar.md)
        - [toolbar-item](en/application-dev/js-reference/toolbar-item.md)
        - [toggle](en/application-dev/js-reference/toggle.md)
      - [Canvas Components](en/application-dev/js-reference/canvas-components.md)
        - [canvas](en/application-dev/js-reference/canvas.md)
        - [CanvasRenderingContext2D](en/application-dev/js-reference/canvasrenderingcontext2d.md)
        - [Image](en/application-dev/js-reference/image-0.md)
        - [CanvasGradient](en/application-dev/js-reference/canvasgradient.md)
        - [ImageData](en/application-dev/js-reference/imagedata.md)
      - [Grid Components](en/application-dev/js-reference/grid-components.md)
        - [Basic Concepts](en/application-dev/js-reference/basic-concepts.md)
        - [grid-container](en/application-dev/js-reference/grid-container.md)
        - [grid-row](en/application-dev/js-reference/grid-row.md)
        - [grid-col](en/application-dev/js-reference/grid-col.md)
    - [Custom Components](en/application-dev/js-reference/custom-components.md)
      - [Basic Usage](en/application-dev/js-reference/basic-usage.md)
      - [Custom Events](en/application-dev/js-reference/custom-events.md)
      - [Props](en/application-dev/js-reference/props.md)
      - [Event Parameter](en/application-dev/js-reference/event-parameter.md)
    - [Universal Description](en/application-dev/js-reference/universal-description.md)
      - [Universal Events](en/application-dev/js-reference/universal-events.md)
      - [Universal Attributes](en/application-dev/js-reference/universal-attributes.md)
      - [Common Styles](en/application-dev/js-reference/common-styles.md)
    - [APIs](en/application-dev/js-reference/apis.md)
      - [Console Logs](en/application-dev/js-reference/console-logs.md)
      - [HiAppEvent](en/application-dev/js-reference/hiappevent.md)
      - [Page Routing](en/application-dev/js-reference/page-routing.md)
      - [Pop-up Window](en/application-dev/js-reference/pop-up-window.md)
      - [Timer](en/application-dev/js-reference/timer.md)
      - [Audio Management](en/application-dev/js-reference/audio-management.md)
      - [Audio Playback](en/application-dev/js-reference/audio-playback.md)
      - [Device Information](en/application-dev/js-reference/device-information.md)
      - [System Attribute](en/application-dev/js-reference/system-attribute.md)
      - [Battery and Charging](en/application-dev/js-reference/battery-and-charging.md)
      - [Screen Brightness](en/application-dev/js-reference/screen-brightness.md)
      - [Globalization](en/application-dev/js-reference/globalization.md)
      - [Resource Management](en/application-dev/js-reference/resource-management.md)
      - [Updater](en/application-dev/js-reference/updater.md)
