# WELCOME TO OPENHARMONY

This project stores OpenHarmony documentation, including the quick start guide, development guides, and API reference. We appreciate your contribution to the OpenHarmony documentation.

## Contents

- [OpenHarmony Overview](OpenHarmony-Overview.md)
- Mini and Small System Development Guidelines \(Reference Memory < 128 MB\)
    -   Device development
        -   **overview**:  [device development overview](device-dev/overview.md)
        -   **quick-start**:  [quick start guide](device-dev/quick-start/Readme-EN.md)  \(covering environment setup, source code acquisition, build, and burning\)
        -   Basic development capabilities
            -   **Kernel**:  [lite kernel](device-dev/kernel/kernel-lite.md)
            -   **Drivers**:  [drivers](device-dev/driver/Readme-EN.md)
            -   **Subsystems**:  [subsystems](device-dev/subsystems/Readme-EN.md)  \(such as compilation and building, graphics, DFX, and XTS\)
            -   **Security**:  [privacy and security](device-dev/security/Readme-EN.md)

        -   **guide**:  
            -   [WLAN-connected products](device-dev/guide/device-wifi.md)  \(LED peripheral control and third-party SDK integration\)
            -   [Screenless cameras](device-dev/guide/device-iotcamera.md)  \(camera control\)
            -   [Cameras with a screen](device-dev/guide/device-camera.md)  \(screen and camera control, visual application development\)

        -   **porting**: 
            -   [Mini System SoC Porting Guide](device-dev/porting/transplant-minichip.md)
            -   [Small System SoC Porting Guide](device-dev/porting/transplant-smallchip.md)
            -   [Third-Party Library Porting Guide](device-dev/porting/transplant-thirdparty.md)

        -   **bundles**: 
            -   [Development Specifications](device-dev/bundles/bundles-standard-rules.md)
            -   [Development Guidelines](device-dev/bundles/bundles-guide.md)
            -   [HPM User Guide](device-dev/bundles/bundles-demo.md)

- Standard System Development Guidelines \(Reference Memory ≥ 128 MB\)
    - Device development
        - **overview**:  [device development overview](device-dev/overview.md)
        - **quick-start**:  [quick start guide](device-dev/quick-start/quickstart-standard.md)  \(covering environment setup, source code acquisition, build, and burning\)
        - Basic development capabilities
            -   **Kernel**:  [Linux kernel](device-dev/kernel/kernel-standard.md)
            -   **Drivers**:  [drivers](device-dev/driver/Readme-EN.md)
            -   **Subsystems**:  [subsystems](device-dev/subsystems/Readme-EN.md)  \(such as compilation and building, graphics, DFX, and XTS\)
            -   **Security**:  [privacy and security](device-dev/security/Readme-EN.md)

        - **guide**:
            -   [Clock apps](device-dev/guide/oem_device_clockapp_des.md)
            -   [Platform drivers](device-dev/guide/device-driver-demo.md)
            -   [Peripheral drivers](device-dev/guide/device-outerdriver-demo.md)

        - **porting**:  

            [Third-Party Library Porting Guide](device-dev/porting/transplant-thirdparty.md)

        - **bundles**: 
            -   [Development Specifications](device-dev/bundles/bundles-standard-rules.md)
            -   [Development Guidelines](device-dev/bundles/bundles-guide.md)
            -   [HPM User Guide](device-dev/bundles/bundles-demo.md)


-   App development
    -   **Overview**:  [app development overview](application-dev/application-dev-guide.md)
    -   **quick-start**:  [quick start guide](application-dev/quick-start/Readme-EN.md)
    -   **ui**:  [UI](application-dev/ui/Readme-EN.md)
    -   **media**:  [media](application-dev/media/Readme-EN.md)
    -   **connectivity**:  [networks and connectivity](application-dev/connectivity/Readme-EN.md)
    -   **js-reference**:  [JS reference](application-dev/js-reference/Readme-EN.md)
-   **glossary**:  [glossary](device-dev/glossary/glossary.md)

## Version Change History

For details, see  [Release Notes](release-notes/OpenHarmony-Release-Notes.md).

## Third-Party Open-Source Software and License Notice

None.

## How to Contribute

A great open-source project wouldn't be possible without the hard work of many contributors. We'd like to invite anyone from around the world to  [participate](contribute/contribution.md)  in this exciting journey, and we're grateful for your time, passion, and efforts!

You can evaluate available documents, make simple modifications, provide feedback on document quality, and contribute your original content. For details, see  [Documentation Contribution](contribute/documentation-contribution.md).

Excellent contributors will be awarded and the contributions will be publicized in the developer community.

