# appspawn Module<a name="EN-US_TOPIC_0000001063680582"></a>

After appspawn is started by init, its service name \(appspawn\) is registered with the IPC framework. Upon receiving inter-process messages, appspawn starts the application service based on the message parsing result, and grants the corresponding permission to the application service.

You can obtain the macro definition  **APPSPAWN\_SERVICE\_NAME**  corresponding to  **appspawn**  by including the header file  **base\\startup\\appspawn\_lite\\services\\include\\appspawn\_service.h**. Due to some constraints on the security subsystem, only Ability Manager Service \(AMS\) has the permission to send inter-process messages to appspawn.

The messages are in JSON format, as shown in the following:

"\{\\"bundleName\\":\\"testvalid1\\",\\"identityID\\":\\"1234\\",\\"uID\\":1000,\\"gID\\":1000,\\"capability\\":\[0\]\}"

**Table  1**  Keys in messages

<a name="table164915296372"></a>
<table><thead align="left"><tr id="row6650142913713"><th class="cellrowborder" valign="top" width="39.489999999999995%" id="mcps1.2.3.1.1"><p id="p17650112914379"><a name="p17650112914379"></a><a name="p17650112914379"></a>Key</p>
</th>
<th class="cellrowborder" valign="top" width="60.51%" id="mcps1.2.3.1.2"><p id="p865032916376"><a name="p865032916376"></a><a name="p865032916376"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row36506298373"><td class="cellrowborder" valign="top" width="39.489999999999995%" headers="mcps1.2.3.1.1 "><p id="p76501029113715"><a name="p76501029113715"></a><a name="p76501029113715"></a>bundleName</p>
</td>
<td class="cellrowborder" valign="top" width="60.51%" headers="mcps1.2.3.1.2 "><p id="p2650329183715"><a name="p2650329183715"></a><a name="p2650329183715"></a>Name of the application service process to be started. The length ranges from 7 bytes to 127 bytes.</p>
</td>
</tr>
<tr id="row86501129183712"><td class="cellrowborder" valign="top" width="39.489999999999995%" headers="mcps1.2.3.1.1 "><p id="p2065010298379"><a name="p2065010298379"></a><a name="p2065010298379"></a>identityID</p>
</td>
<td class="cellrowborder" valign="top" width="60.51%" headers="mcps1.2.3.1.2 "><p id="p13650192963715"><a name="p13650192963715"></a><a name="p13650192963715"></a>Identifier generated by the AMS for the new process. The length ranges from 1 byte to 24 bytes. The appspawn process passes the value to the new process.</p>
</td>
</tr>
<tr id="row13650329103719"><td class="cellrowborder" valign="top" width="39.489999999999995%" headers="mcps1.2.3.1.1 "><p id="p16501292377"><a name="p16501292377"></a><a name="p16501292377"></a>uID</p>
</td>
<td class="cellrowborder" valign="top" width="60.51%" headers="mcps1.2.3.1.2 "><p id="p186503291371"><a name="p186503291371"></a><a name="p186503291371"></a>UID of the application service process to be started. The value must be a positive number.</p>
</td>
</tr>
<tr id="row187625816314"><td class="cellrowborder" valign="top" width="39.489999999999995%" headers="mcps1.2.3.1.1 "><p id="p188771758833"><a name="p188771758833"></a><a name="p188771758833"></a>gID</p>
</td>
<td class="cellrowborder" valign="top" width="60.51%" headers="mcps1.2.3.1.2 "><p id="p187716587310"><a name="p187716587310"></a><a name="p187716587310"></a>GID of the application service process to be started. The value must be a positive number.</p>
</td>
</tr>
<tr id="row106508294373"><td class="cellrowborder" valign="top" width="39.489999999999995%" headers="mcps1.2.3.1.1 "><p id="p16501829183715"><a name="p16501829183715"></a><a name="p16501829183715"></a>capability</p>
</td>
<td class="cellrowborder" valign="top" width="60.51%" headers="mcps1.2.3.1.2 "><p id="p11650182953717"><a name="p11650182953717"></a><a name="p11650182953717"></a>Capability permissions required by the application service process to be started. A maximum of 10 capability permissions are allowed.</p>
</td>
</tr>
</tbody>
</table>

