# Porting Guide

- [Third-Party Library Porting Guide](transplant-thirdparty.md)
  - [Overview](transplant-thirdparty-overview.md)
  - [Porting a Library Built Using CMake](transplant-thirdparty-cmake.md)
  - [Porting a Library Built Using Makefile](transplant-thirdparty-makefile.md)
- [Mini System SoC Porting Guide](transplant-minichip.md)
  - [Porting Preparations](transplant-chip-prepare.md)
    - [Before You Start](transplant-chip-prepare-knows.md)
    - [Building Adaptation Process](transplant-chip-prepare-process.md)
  - [Kernel Porting](transplant-chip-kernel.md)
    - [Overview](transplant-chip-kernel-overview.md)
    - [Basic Kernel Adaptation](transplant-chip-kernel-adjustment.md)
    - [Kernel Porting Verification](transplant-chip-kernel-verify.md)
  - [Board-Level OS Porting](transplant-chip-board.md)
    - [Overview](transplant-chip-board-overview.md)
    - [Board-Level Driver Adaptation](transplant-chip-board-drive.md)
    - [Implementation of APIs at the HAL](transplant-chip-board-hal.md)
    - [System Modules](transplant-chip-board-component.md)
    - [Third-party Module Adaptation](transplant-chip-board-bundle.md)
    - [XTS](transplant-chip-board-xts.md)
  - [FAQ](transplant-chip-faqs.md)
- [Small System SoC Porting Guide](transplant-smallchip.md)
  - [Porting Preparations](transplant-smallchip-prepare.md)
    - [Before You Start](transplant-smallchip-prepare-needs.md)
    - [Compilation and Building](transplant-smallchip-prepare-building.md)
  - [Kernel Porting](transplant-smallchip-kernel.md)
    - [LiteOS Cortex-A](transplant-smallchip-kernel-a.md)
    - [Linux Kernel](transplant-smallchip-kernel-linux.md)
  - [Driver Porting](transplant-smallchip-drive.md)
    - [Overview](transplant-smallchip-drive-des.md)
    - [Platform Driver Porting](transplant-smallchip-drive-plat.md)
    - [Device Driver Porting](transplant-smallchip-drive-oom.md)