#  Kernel

- [Kernel for Mini and Small Systems](kernel-lite.md)
  - [Kernel for Small Systems](kernel-lite-small.md)
    - [Basic Kernel](kernel-lite-small-basic.md)
      - [Process](kernel-lite-small-process.md)
      - [Thread](kernel-lite-small-thread.md)
      - [Memory](kernel-lite-small-memory.md)
      - [Network](kernel-lite-small-net.md)
    - [File System](kernel-lite-small-file.md)
      - [VFS](kernel-lite-small-file-vfs.md)
      - [NFS](kernel-lite-small-file-nfs.md)
      - [RAMFS](kernel-lite-small-file-ramfs.md)
      - [FAT](kernel-lite-small-file-fat.md)
      - [JFFS2](kernel-lite-small-file-jffs.md)
    - [Standard Library](kernel-lite-small-lib.md)
      - [Standard Library](kernel-lite-small-lib-standard.md)
      - [Differences from the Linux Standard Library](kernel-lite-small-lib-differ.md)
    - [Commissioning](kernel-lite-small-shell.md)
      - [Introduction to the Shell](kernel-lite-small-shell-des.md)
      - [Shell Command Development Guidelines](kernel-lite-small-shell-guide.md)
      - [Shell Command Programming Example](kernel-lite-small-shell-sample.md)
      - [Shell Command Reference](kernel-lite-small-shell-cmd.md)
        - [System Commands](kernel-lite-small-shell-cmd-sys.md)
          - [cpup](kernel-lite-small-shell-cmd-sys-cpup.md)
          - [date](kernel-lite-small-shell-cmd-sys-date.md)
          - [dmesg](kernel-lite-small-shell-cmd-sys-demsg.md)
          - [exec](kernel-lite-small-shell-cmd-sys-exec.md)
          - [free](kernel-lite-small-shell-cmd-sys-free.md)
          - [help](kernel-lite-small-shell-cmd-sys-help.md)
          - [hwi](kernel-lite-small-shell-cmd-sys-hwi.md)
          - [kill](kernel-lite-small-shell-cmd-sys-kill.md)
          - [log](kernel-lite-small-shell-cmd-sys-log.md)
          - [memcheck](kernel-lite-small-shell-cmd-sys-mem.md)
          - [oom](kernel-lite-small-shell-cmd-sys-oom.md)
          - [pmm](kernel-lite-small-shell-cmd-sys-pmm.md)
          - [reset](kernel-lite-small-shell-cmd-sys-reset.md)
          - [sem](kernel-lite-small-shell-cmd-sys-sem.md)
          - [stack](kernel-lite-small-shell-cmd-sys-stack.md)
          - [su](kernel-lite-small-shell-cmd-sys-su.md)
          - [swtmr](kernel-lite-small-shell-cmd-sys-swymr.md)
          - [systeminfo](kernel-lite-small-shell-cmd-sys-sys.md)
          - [task](kernel-lite-small-shell-cmd-sys-task.md)
          - [uname](kernel-lite-small-shell-cmd-sys-uname.md)
          - [vmm](kernel-lite-small-shell-cmd-sys-vmm.md)
          - [watch](kernel-lite-small-shell-cmd-sys-watch.md)
        - [File Commands](kernel-lite-small-shell-cmd-file.md)
          - [cat](kernel-lite-small-shell-cmd-file-cat.md)
          - [cd](kernel-lite-small-shell-cmd-file-cd.md)
          - [chgrp](kernel-lite-small-shell-cmd-file-chgrp.md)
          - [chmod](kernel-lite-small-shell-cmd-file-chmod.md)
          - [chown](kernel-lite-small-shell-cmd-file-chown.md)
          - [cp](kernel-lite-small-shell-cmd-file-cp.md)
          - [format](kernel-lite-small-shell-cmd-file-format.md)
          - [ls](kernel-lite-small-shell-cmd-file-is.md)
          - [lsfd](kernel-lite-small-shell-cmd-file-isfd.md)
          - [mkdir](kernel-lite-small-shell-cmd-file-mkdir.md)
          - [mount](kernel-lite-small-shell-cmd-file-mount.md)
          - [partinfo](kernel-lite-small-shell-cmd-file-part.md)
          - [partition](kernel-lite-small-shell-cmd-file-partion.md)
          - [pwd](kernel-lite-small-shell-cmd-file-pwd.md)
          - [rm](kernel-lite-small-shell-cmd-file-rm.md)
          - [rmdir](kernel-lite-small-shell-cmd-file-rmdir.md)
          - [statfs](kernel-lite-small-shell-cmd-file-sta.md)
          - [sync](kernel-lite-small-shell-cmd-file-sync.md)
          - [touch](kernel-lite-small-shell-cmd-file-touch.md)
          - [writeproc](kernel-lite-small-shell-cmd-file-write.md)
          - [umount](kernel-lite-small-shell-cmd-file-umount.md)
        - [Network Commands](kernel-lite-small-shell-cmd-net.md)
          - [arp](kernel-lite-small-shell-cmd-net-arp.md)
          - [dhclient](kernel-lite-small-shell-cmd-net-dh.md)
          - [dns](kernel-lite-small-shell-cmd-net-dns.md)
          - [ifconfig](kernel-lite-small-shell-cmd-net-ipc.md)
          - [ipdebug](kernel-lite-small-shell-cmd-net-ipd.md)
          - [netstat](kernel-lite-small-shell-cmd-net-net.md)
          - [ntpdate](kernel-lite-small-shell-cmd-net-ntp.md)
          - [ping](kernel-lite-small-shell-cmd-net-ping.md)
          - [ping6](kernel-lite-small-shell-cmd-net-ping6.md)
          - [telnet](kernel-lite-small-shell-cmd-net-tel.md)
          - [tftp](kernel-lite-small-shell-cmd-net-tftp.md)
      - [Magic Key Usage](kernel-lite-small-shell-cmd-mag.md)
      - [User-Space Exception Information](kernel-lite-small-shell-cmd-abn.md)
- [Kernel for Standard Systems](kernel-standard.md)
  - [Linux Kernel Overview](kernel-standard-des.md)
  - [Guidelines for Using Patches on OpenHarmony Development Boards](kernel-standard-patch.md)
  - [Guidelines for Compiling and Building the Linux Kernel](kernel-standard-build.md)