# Animation Styles<a name="EN-US_TOPIC_0000001162414609"></a>

This section describes the dynamic rotation, translation, and scaling effects supported by components. These effects can be set in the  **style**  attribute or  **css**  files.

<a name="en-us_topic_0000001058830799_table1863253974"></a>
<table><thead align="left"><tr id="en-us_topic_0000001058830799_row786315538710"><th class="cellrowborder" valign="top" width="30%" id="mcps1.1.5.1.1"><p id="en-us_topic_0000001058830799_p108631953175"><a name="en-us_topic_0000001058830799_p108631953175"></a><a name="en-us_topic_0000001058830799_p108631953175"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="17%" id="mcps1.1.5.1.2"><p id="en-us_topic_0000001058830799_p1486365316710"><a name="en-us_topic_0000001058830799_p1486365316710"></a><a name="en-us_topic_0000001058830799_p1486365316710"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="16%" id="mcps1.1.5.1.3"><p id="en-us_topic_0000001058830799_p138637531275"><a name="en-us_topic_0000001058830799_p138637531275"></a><a name="en-us_topic_0000001058830799_p138637531275"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="37%" id="mcps1.1.5.1.4"><p id="en-us_topic_0000001058830799_p17863053878"><a name="en-us_topic_0000001058830799_p17863053878"></a><a name="en-us_topic_0000001058830799_p17863053878"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="en-us_topic_0000001058830799_row178631153474"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p4863105311717"><a name="en-us_topic_0000001058830799_p4863105311717"></a><a name="en-us_topic_0000001058830799_p4863105311717"></a>transform-origin</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p19520834194416"><a name="en-us_topic_0000001058830799_p19520834194416"></a><a name="en-us_topic_0000001058830799_p19520834194416"></a>&lt;percentage&gt; | &lt;length&gt; &lt;percentage&gt; | &lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p1986319537716"><a name="en-us_topic_0000001058830799_p1986319537716"></a><a name="en-us_topic_0000001058830799_p1986319537716"></a>Control center</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p6867140201912"><a name="en-us_topic_0000001058830799_p6867140201912"></a><a name="en-us_topic_0000001058830799_p6867140201912"></a>Origin coordinates of the transforming object. The values can be numbers (px) or percentages (relative to the target of the animation). If only one value is set, the other value is 50% by default.</p>
<p id="en-us_topic_0000001058830799_p11863165316720"><a name="en-us_topic_0000001058830799_p11863165316720"></a><a name="en-us_topic_0000001058830799_p11863165316720"></a>Example:</p>
<p id="en-us_topic_0000001058830799_p146961332184513"><a name="en-us_topic_0000001058830799_p146961332184513"></a><a name="en-us_topic_0000001058830799_p146961332184513"></a>transform-origin: 200px 30%</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row486314531779"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p28641953175"><a name="en-us_topic_0000001058830799_p28641953175"></a><a name="en-us_topic_0000001058830799_p28641953175"></a>transform</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p1286475313710"><a name="en-us_topic_0000001058830799_p1286475313710"></a><a name="en-us_topic_0000001058830799_p1286475313710"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p8864155311715"><a name="en-us_topic_0000001058830799_p8864155311715"></a><a name="en-us_topic_0000001058830799_p8864155311715"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p52158111929"><a name="en-us_topic_0000001058830799_p52158111929"></a><a name="en-us_topic_0000001058830799_p52158111929"></a>Translation, rotation, and scaling attributes.</p>
<p id="en-us_topic_0000001058830799_p1286415319715"><a name="en-us_topic_0000001058830799_p1286415319715"></a><a name="en-us_topic_0000001058830799_p1286415319715"></a>For details, see <a href="#en-us_topic_0000001058830799_table28802443315">Table 1</a>.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row14864453877"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p88641753677"><a name="en-us_topic_0000001058830799_p88641753677"></a><a name="en-us_topic_0000001058830799_p88641753677"></a>animation-name</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p20864853870"><a name="en-us_topic_0000001058830799_p20864853870"></a><a name="en-us_topic_0000001058830799_p20864853870"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p158644534715"><a name="en-us_topic_0000001058830799_p158644534715"></a><a name="en-us_topic_0000001058830799_p158644534715"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p58645531719"><a name="en-us_topic_0000001058830799_p58645531719"></a><a name="en-us_topic_0000001058830799_p58645531719"></a>@keyframes rule. For details, see <a href="#en-us_topic_0000001058830799_t48a722bba37a44c883ed4e046a4cf82e">Table 2</a>.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row8864125319718"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p128646539711"><a name="en-us_topic_0000001058830799_p128646539711"></a><a name="en-us_topic_0000001058830799_p128646539711"></a>animation-delay</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p1486418539720"><a name="en-us_topic_0000001058830799_p1486418539720"></a><a name="en-us_topic_0000001058830799_p1486418539720"></a>&lt;time&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p086445317716"><a name="en-us_topic_0000001058830799_p086445317716"></a><a name="en-us_topic_0000001058830799_p086445317716"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p1864135310710"><a name="en-us_topic_0000001058830799_p1864135310710"></a><a name="en-us_topic_0000001058830799_p1864135310710"></a>Delay for playing the animation, in ms or s, for example, <strong id="en-us_topic_0000001058830799_b293531415419"><a name="en-us_topic_0000001058830799_b293531415419"></a><a name="en-us_topic_0000001058830799_b293531415419"></a>1000 ms</strong> or <strong id="en-us_topic_0000001058830799_b583541616540"><a name="en-us_topic_0000001058830799_b583541616540"></a><a name="en-us_topic_0000001058830799_b583541616540"></a>1s</strong>. The default unit is ms.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row11864135314712"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p1586435311713"><a name="en-us_topic_0000001058830799_p1586435311713"></a><a name="en-us_topic_0000001058830799_p1586435311713"></a>animation-duration</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p16864135316714"><a name="en-us_topic_0000001058830799_p16864135316714"></a><a name="en-us_topic_0000001058830799_p16864135316714"></a>&lt;time&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p148641753971"><a name="en-us_topic_0000001058830799_p148641753971"></a><a name="en-us_topic_0000001058830799_p148641753971"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p342192073412"><a name="en-us_topic_0000001058830799_p342192073412"></a><a name="en-us_topic_0000001058830799_p342192073412"></a>Animation duration, in ms or s, for example, <strong id="en-us_topic_0000001058830799_b12381105114557"><a name="en-us_topic_0000001058830799_b12381105114557"></a><a name="en-us_topic_0000001058830799_b12381105114557"></a>1000 ms</strong> or <strong id="en-us_topic_0000001058830799_b19208554135519"><a name="en-us_topic_0000001058830799_b19208554135519"></a><a name="en-us_topic_0000001058830799_b19208554135519"></a>1s</strong>. The default unit is ms.</p>
<div class="note" id="en-us_topic_0000001058830799_note11257121119511"><a name="en-us_topic_0000001058830799_note11257121119511"></a><a name="en-us_topic_0000001058830799_note11257121119511"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="en-us_topic_0000001058830799_p126422011184410"><a name="en-us_topic_0000001058830799_p126422011184410"></a><a name="en-us_topic_0000001058830799_p126422011184410"></a><strong id="en-us_topic_0000001058830799_b926872271012"><a name="en-us_topic_0000001058830799_b926872271012"></a><a name="en-us_topic_0000001058830799_b926872271012"></a>animation-duration</strong> must be specified. Otherwise, the duration is <strong id="en-us_topic_0000001058830799_b0902710165718"><a name="en-us_topic_0000001058830799_b0902710165718"></a><a name="en-us_topic_0000001058830799_b0902710165718"></a>0</strong>, which means the animation will not be played.</p>
</div></div>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row12864253377"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p138641353779"><a name="en-us_topic_0000001058830799_p138641353779"></a><a name="en-us_topic_0000001058830799_p138641353779"></a>animation-iteration-count</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p68642532717"><a name="en-us_topic_0000001058830799_p68642532717"></a><a name="en-us_topic_0000001058830799_p68642532717"></a>number | infinite</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p9864195312710"><a name="en-us_topic_0000001058830799_p9864195312710"></a><a name="en-us_topic_0000001058830799_p9864195312710"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p138641653475"><a name="en-us_topic_0000001058830799_p138641653475"></a><a name="en-us_topic_0000001058830799_p138641653475"></a>Number of times that an animation is played. The animation is played once by default. You can set the value to <strong id="en-us_topic_0000001058830799_b1292791613197"><a name="en-us_topic_0000001058830799_b1292791613197"></a><a name="en-us_topic_0000001058830799_b1292791613197"></a>infinite</strong> to play the animation infinitely.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row17864453976"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p158650537712"><a name="en-us_topic_0000001058830799_p158650537712"></a><a name="en-us_topic_0000001058830799_p158650537712"></a>animation-timing-function</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p19865185313717"><a name="en-us_topic_0000001058830799_p19865185313717"></a><a name="en-us_topic_0000001058830799_p19865185313717"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p686514531178"><a name="en-us_topic_0000001058830799_p686514531178"></a><a name="en-us_topic_0000001058830799_p686514531178"></a>ease</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p38652531974"><a name="en-us_topic_0000001058830799_p38652531974"></a><a name="en-us_topic_0000001058830799_p38652531974"></a>Speed curve of an animation, which makes the animation more fluent.</p>
<p id="en-us_topic_0000001058830799_p586513531377"><a name="en-us_topic_0000001058830799_p586513531377"></a><a name="en-us_topic_0000001058830799_p586513531377"></a>Available values are as follows:</p>
<a name="en-us_topic_0000001058830799_ul104958313219"></a><a name="en-us_topic_0000001058830799_ul104958313219"></a><ul id="en-us_topic_0000001058830799_ul104958313219"><li><strong id="en-us_topic_0000001058830799_b18699201511716"><a name="en-us_topic_0000001058830799_b18699201511716"></a><a name="en-us_topic_0000001058830799_b18699201511716"></a>linear</strong>: The animation speed keeps unchanged.</li><li><strong id="en-us_topic_0000001058830799_b144551743373"><a name="en-us_topic_0000001058830799_b144551743373"></a><a name="en-us_topic_0000001058830799_b144551743373"></a>ease</strong>: The animation starts at a low speed and then accelerates. It slows down before the animation ends. <strong id="en-us_topic_0000001058830799_b55701863912"><a name="en-us_topic_0000001058830799_b55701863912"></a><a name="en-us_topic_0000001058830799_b55701863912"></a>cubic-bezier(0.25, 0.1, 0.25, 1.0)</strong> </li><li><strong id="en-us_topic_0000001058830799_b115717510818"><a name="en-us_topic_0000001058830799_b115717510818"></a><a name="en-us_topic_0000001058830799_b115717510818"></a>ease-in</strong>: The animation starts at a low speed. <strong id="en-us_topic_0000001058830799_b161691025131118"><a name="en-us_topic_0000001058830799_b161691025131118"></a><a name="en-us_topic_0000001058830799_b161691025131118"></a>cubic-bezier(0.42, 0.0, 1.0, 1.0)</strong></li><li><strong id="en-us_topic_0000001058830799_b1069413125146"><a name="en-us_topic_0000001058830799_b1069413125146"></a><a name="en-us_topic_0000001058830799_b1069413125146"></a>ease-out</strong>: The animation ends at a low speed. <strong id="en-us_topic_0000001058830799_b18657220191111"><a name="en-us_topic_0000001058830799_b18657220191111"></a><a name="en-us_topic_0000001058830799_b18657220191111"></a>cubic-bezier(0.0, 0.0, 0.58, 1.0)</strong></li><li><strong id="en-us_topic_0000001058830799_b1540172812147"><a name="en-us_topic_0000001058830799_b1540172812147"></a><a name="en-us_topic_0000001058830799_b1540172812147"></a>ease-in-out</strong>: The animation starts and ends at a low speed. <strong id="en-us_topic_0000001058830799_b13968449121017"><a name="en-us_topic_0000001058830799_b13968449121017"></a><a name="en-us_topic_0000001058830799_b13968449121017"></a>cubic-bezier(0.42, 0.0, 0.58, 1.0)</strong></li><li><strong id="en-us_topic_0000001058830799_b752771711716"><a name="en-us_topic_0000001058830799_b752771711716"></a><a name="en-us_topic_0000001058830799_b752771711716"></a>friction</strong>: Damping curve, <strong id="en-us_topic_0000001058830799_b1142194217138"><a name="en-us_topic_0000001058830799_b1142194217138"></a><a name="en-us_topic_0000001058830799_b1142194217138"></a>cubic-bezier(0.2, 0.0, 0.2, 1.0)</strong> </li><li><strong id="en-us_topic_0000001058830799_b19750154161716"><a name="en-us_topic_0000001058830799_b19750154161716"></a><a name="en-us_topic_0000001058830799_b19750154161716"></a>extreme-deceleration</strong>: Extreme deceleration curve, <strong id="en-us_topic_0000001058830799_b5678937171412"><a name="en-us_topic_0000001058830799_b5678937171412"></a><a name="en-us_topic_0000001058830799_b5678937171412"></a>cubic-bezier(0.0, 0.0, 0.0, 1.0) curve</strong> </li><li><strong id="en-us_topic_0000001058830799_b1555123841813"><a name="en-us_topic_0000001058830799_b1555123841813"></a><a name="en-us_topic_0000001058830799_b1555123841813"></a>sharp</strong>: Sharp curve, <strong id="en-us_topic_0000001058830799_b667512256157"><a name="en-us_topic_0000001058830799_b667512256157"></a><a name="en-us_topic_0000001058830799_b667512256157"></a>cubic-bezier(0.33, 0.0, 0.67, 1.0)</strong> </li><li><strong id="en-us_topic_0000001058830799_b655994931814"><a name="en-us_topic_0000001058830799_b655994931814"></a><a name="en-us_topic_0000001058830799_b655994931814"></a>rhythm</strong>: Rhythm curve, <strong id="en-us_topic_0000001058830799_b4933030141514"><a name="en-us_topic_0000001058830799_b4933030141514"></a><a name="en-us_topic_0000001058830799_b4933030141514"></a>cubic-bezier(0.7, 0.0, 0.2, 1.0)</strong> </li><li><strong id="en-us_topic_0000001058830799_b13383205711181"><a name="en-us_topic_0000001058830799_b13383205711181"></a><a name="en-us_topic_0000001058830799_b13383205711181"></a>smooth</strong>: Smooth curve, <strong id="en-us_topic_0000001058830799_b223183816152"><a name="en-us_topic_0000001058830799_b223183816152"></a><a name="en-us_topic_0000001058830799_b223183816152"></a>cubic-bezier(0.4, 0.0, 0.4, 1.0)</strong> </li><li><strong id="en-us_topic_0000001058830799_b787022161914"><a name="en-us_topic_0000001058830799_b787022161914"></a><a name="en-us_topic_0000001058830799_b787022161914"></a>cubic-bezier</strong>: You can customize an animation speed curve in the <strong id="en-us_topic_0000001058830799_b2993184561819"><a name="en-us_topic_0000001058830799_b2993184561819"></a><a name="en-us_topic_0000001058830799_b2993184561819"></a>cubic-bezier()</strong> function. The x and y values of each input parameter must be between 0 and 1. </li></ul>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row1686675319718"><td class="cellrowborder" valign="top" width="30%" headers="mcps1.1.5.1.1 "><p id="en-us_topic_0000001058830799_p886655314713"><a name="en-us_topic_0000001058830799_p886655314713"></a><a name="en-us_topic_0000001058830799_p886655314713"></a>animation-fill-mode</p>
</td>
<td class="cellrowborder" valign="top" width="17%" headers="mcps1.1.5.1.2 "><p id="en-us_topic_0000001058830799_p386625318718"><a name="en-us_topic_0000001058830799_p386625318718"></a><a name="en-us_topic_0000001058830799_p386625318718"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.3 "><p id="en-us_topic_0000001058830799_p158661153171"><a name="en-us_topic_0000001058830799_p158661153171"></a><a name="en-us_topic_0000001058830799_p158661153171"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="37%" headers="mcps1.1.5.1.4 "><p id="en-us_topic_0000001058830799_p48661353174"><a name="en-us_topic_0000001058830799_p48661353174"></a><a name="en-us_topic_0000001058830799_p48661353174"></a>Start and end styles of the animation</p>
<a name="en-us_topic_0000001058830799_ul6388194816"></a><a name="en-us_topic_0000001058830799_ul6388194816"></a><ul id="en-us_topic_0000001058830799_ul6388194816"><li><strong id="en-us_topic_0000001058830799_b14268971763"><a name="en-us_topic_0000001058830799_b14268971763"></a><a name="en-us_topic_0000001058830799_b14268971763"></a>none</strong>: No style is applied to the target before or after the animation is executed.</li><li><strong id="en-us_topic_0000001058830799_b103612812616"><a name="en-us_topic_0000001058830799_b103612812616"></a><a name="en-us_topic_0000001058830799_b103612812616"></a>forwards</strong>: The target keeps the state at the end of the animation (defined in the last key frame) after the animation is executed.</li></ul>
</td>
</tr>
</tbody>
</table>

**Table  1**  Methods of the  **transform**  attribute

<a name="en-us_topic_0000001058830799_table28802443315"></a>
<table><thead align="left"><tr id="en-us_topic_0000001058830799_row88808448314"><th class="cellrowborder" valign="top" width="18.04%" id="mcps1.2.4.1.1"><p id="en-us_topic_0000001058830799_p88808441132"><a name="en-us_topic_0000001058830799_p88808441132"></a><a name="en-us_topic_0000001058830799_p88808441132"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="27.71%" id="mcps1.2.4.1.2"><p id="en-us_topic_0000001058830799_p16880244334"><a name="en-us_topic_0000001058830799_p16880244334"></a><a name="en-us_topic_0000001058830799_p16880244334"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="54.25%" id="mcps1.2.4.1.3"><p id="en-us_topic_0000001058830799_p198802443316"><a name="en-us_topic_0000001058830799_p198802443316"></a><a name="en-us_topic_0000001058830799_p198802443316"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="en-us_topic_0000001058830799_row1588011441433"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p1188018441039"><a name="en-us_topic_0000001058830799_p1188018441039"></a><a name="en-us_topic_0000001058830799_p1188018441039"></a>translate</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p288015447310"><a name="en-us_topic_0000001058830799_p288015447310"></a><a name="en-us_topic_0000001058830799_p288015447310"></a>&lt;length&gt;<span id="en-us_topic_0000001058830799_ph168318101405"><a name="en-us_topic_0000001058830799_ph168318101405"></a><a name="en-us_topic_0000001058830799_ph168318101405"></a>| &lt;percent&gt;</span></p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p98811441934"><a name="en-us_topic_0000001058830799_p98811441934"></a><a name="en-us_topic_0000001058830799_p98811441934"></a>Moves an element along the x-axis and y-axis.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row088154420311"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p1688124420315"><a name="en-us_topic_0000001058830799_p1688124420315"></a><a name="en-us_topic_0000001058830799_p1688124420315"></a>translateX</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p208813441237"><a name="en-us_topic_0000001058830799_p208813441237"></a><a name="en-us_topic_0000001058830799_p208813441237"></a>&lt;length&gt;<span id="en-us_topic_0000001058830799_ph108741224400"><a name="en-us_topic_0000001058830799_ph108741224400"></a><a name="en-us_topic_0000001058830799_ph108741224400"></a>| &lt;percent&gt;</span></p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p688112441132"><a name="en-us_topic_0000001058830799_p688112441132"></a><a name="en-us_topic_0000001058830799_p688112441132"></a>Moves an element along the x-axis.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row08816441839"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p1588110447311"><a name="en-us_topic_0000001058830799_p1588110447311"></a><a name="en-us_topic_0000001058830799_p1588110447311"></a>translateY</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p288118441533"><a name="en-us_topic_0000001058830799_p288118441533"></a><a name="en-us_topic_0000001058830799_p288118441533"></a>&lt;length&gt;<span id="en-us_topic_0000001058830799_ph2207350401"><a name="en-us_topic_0000001058830799_ph2207350401"></a><a name="en-us_topic_0000001058830799_ph2207350401"></a>| &lt;percent&gt;</span></p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p38818447314"><a name="en-us_topic_0000001058830799_p38818447314"></a><a name="en-us_topic_0000001058830799_p38818447314"></a>Moves an element along the y-axis.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row288111441037"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p988164419317"><a name="en-us_topic_0000001058830799_p988164419317"></a><a name="en-us_topic_0000001058830799_p988164419317"></a>scale</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p0881744132"><a name="en-us_topic_0000001058830799_p0881744132"></a><a name="en-us_topic_0000001058830799_p0881744132"></a>&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p5881114412312"><a name="en-us_topic_0000001058830799_p5881114412312"></a><a name="en-us_topic_0000001058830799_p5881114412312"></a>Changes the size of an element. You need to set the target width and height on the x-axis and y-axis.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row088117445315"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p7881164417311"><a name="en-us_topic_0000001058830799_p7881164417311"></a><a name="en-us_topic_0000001058830799_p7881164417311"></a>scaleX</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p128816446311"><a name="en-us_topic_0000001058830799_p128816446311"></a><a name="en-us_topic_0000001058830799_p128816446311"></a>&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p388112446310"><a name="en-us_topic_0000001058830799_p388112446310"></a><a name="en-us_topic_0000001058830799_p388112446310"></a>Changes the element width.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row78813444315"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p1988144419319"><a name="en-us_topic_0000001058830799_p1988144419319"></a><a name="en-us_topic_0000001058830799_p1988144419319"></a>scaleY</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p2881124416314"><a name="en-us_topic_0000001058830799_p2881124416314"></a><a name="en-us_topic_0000001058830799_p2881124416314"></a>&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p128815441936"><a name="en-us_topic_0000001058830799_p128815441936"></a><a name="en-us_topic_0000001058830799_p128815441936"></a>Changes the element height.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row1488114441539"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p1888104411314"><a name="en-us_topic_0000001058830799_p1888104411314"></a><a name="en-us_topic_0000001058830799_p1888104411314"></a>rotate</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p168825447318"><a name="en-us_topic_0000001058830799_p168825447318"></a><a name="en-us_topic_0000001058830799_p168825447318"></a>&lt;deg&gt; | &lt;rad&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p8882194415317"><a name="en-us_topic_0000001058830799_p8882194415317"></a><a name="en-us_topic_0000001058830799_p8882194415317"></a>Rotates an element. <span id="en-us_topic_0000001058830799_ph146515256413"><a name="en-us_topic_0000001058830799_ph146515256413"></a><a name="en-us_topic_0000001058830799_ph146515256413"></a>You can set the element to rotate around its x-axis or y-axis.</span></p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row188821744736"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p7882744632"><a name="en-us_topic_0000001058830799_p7882744632"></a><a name="en-us_topic_0000001058830799_p7882744632"></a>rotateX</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p78821744632"><a name="en-us_topic_0000001058830799_p78821744632"></a><a name="en-us_topic_0000001058830799_p78821744632"></a>&lt;deg&gt; | &lt;rad&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p588217441134"><a name="en-us_topic_0000001058830799_p588217441134"></a><a name="en-us_topic_0000001058830799_p588217441134"></a>Rotates an element around the x-axis.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row1488294410320"><td class="cellrowborder" valign="top" width="18.04%" headers="mcps1.2.4.1.1 "><p id="en-us_topic_0000001058830799_p108826442034"><a name="en-us_topic_0000001058830799_p108826442034"></a><a name="en-us_topic_0000001058830799_p108826442034"></a>rotateY</p>
</td>
<td class="cellrowborder" valign="top" width="27.71%" headers="mcps1.2.4.1.2 "><p id="en-us_topic_0000001058830799_p388213445311"><a name="en-us_topic_0000001058830799_p388213445311"></a><a name="en-us_topic_0000001058830799_p388213445311"></a>&lt;deg&gt; | &lt;rad&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="54.25%" headers="mcps1.2.4.1.3 "><p id="en-us_topic_0000001058830799_p8882544638"><a name="en-us_topic_0000001058830799_p8882544638"></a><a name="en-us_topic_0000001058830799_p8882544638"></a>Rotates an element around the y-axis.</p>
</td>
</tr>
</tbody>
</table>

**Table  2**  Attributes available for the @keyframes rule

<a name="en-us_topic_0000001058830799_t48a722bba37a44c883ed4e046a4cf82e"></a>
<table><thead align="left"><tr id="en-us_topic_0000001058830799_r856a9393ccf4423ba47ec1b9ed96bb8e"><th class="cellrowborder" valign="top" width="24.242424242424242%" id="mcps1.2.5.1.1"><p id="en-us_topic_0000001058830799_ae7a02418e61f4e1db82e64f0e2f1c09e"><a name="en-us_topic_0000001058830799_ae7a02418e61f4e1db82e64f0e2f1c09e"></a><a name="en-us_topic_0000001058830799_ae7a02418e61f4e1db82e64f0e2f1c09e"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="16.16161616161616%" id="mcps1.2.5.1.2"><p id="en-us_topic_0000001058830799_a4cee3e18cb724963be38ac53355b7b4d"><a name="en-us_topic_0000001058830799_a4cee3e18cb724963be38ac53355b7b4d"></a><a name="en-us_topic_0000001058830799_a4cee3e18cb724963be38ac53355b7b4d"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="13.13131313131313%" id="mcps1.2.5.1.3"><p id="en-us_topic_0000001058830799_a3e0026aad554469d964bbc102a8eaadb"><a name="en-us_topic_0000001058830799_a3e0026aad554469d964bbc102a8eaadb"></a><a name="en-us_topic_0000001058830799_a3e0026aad554469d964bbc102a8eaadb"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="46.464646464646464%" id="mcps1.2.5.1.4"><p id="en-us_topic_0000001058830799_a2b58cc16430e4420b7e9ab323cab292d"><a name="en-us_topic_0000001058830799_a2b58cc16430e4420b7e9ab323cab292d"></a><a name="en-us_topic_0000001058830799_a2b58cc16430e4420b7e9ab323cab292d"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="en-us_topic_0000001058830799_r452ea683f0af4624a69c836abfcdc440"><td class="cellrowborder" valign="top" width="24.242424242424242%" headers="mcps1.2.5.1.1 "><p id="en-us_topic_0000001058830799_a5eb36c26384742ba9e99adc2493de600"><a name="en-us_topic_0000001058830799_a5eb36c26384742ba9e99adc2493de600"></a><a name="en-us_topic_0000001058830799_a5eb36c26384742ba9e99adc2493de600"></a>background-color</p>
</td>
<td class="cellrowborder" valign="top" width="16.16161616161616%" headers="mcps1.2.5.1.2 "><p id="en-us_topic_0000001058830799_abc67b94bfbcb4d64a00cfe2e1e372b6d"><a name="en-us_topic_0000001058830799_abc67b94bfbcb4d64a00cfe2e1e372b6d"></a><a name="en-us_topic_0000001058830799_abc67b94bfbcb4d64a00cfe2e1e372b6d"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="13.13131313131313%" headers="mcps1.2.5.1.3 "><p id="en-us_topic_0000001058830799_ab027f70b389742bbb69fa1665a1aaaf6"><a name="en-us_topic_0000001058830799_ab027f70b389742bbb69fa1665a1aaaf6"></a><a name="en-us_topic_0000001058830799_ab027f70b389742bbb69fa1665a1aaaf6"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="46.464646464646464%" headers="mcps1.2.5.1.4 "><p id="en-us_topic_0000001058830799_a2a9535e7a520474eaa5ca78ca61ca148"><a name="en-us_topic_0000001058830799_a2a9535e7a520474eaa5ca78ca61ca148"></a><a name="en-us_topic_0000001058830799_a2a9535e7a520474eaa5ca78ca61ca148"></a>Background color applied to the component after the animation is played.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_rb2e92403cacf4ce283fd5e3c625635c5"><td class="cellrowborder" valign="top" width="24.242424242424242%" headers="mcps1.2.5.1.1 "><p id="en-us_topic_0000001058830799_afd219ea8c1384a3c84d4e7ca09be073c"><a name="en-us_topic_0000001058830799_afd219ea8c1384a3c84d4e7ca09be073c"></a><a name="en-us_topic_0000001058830799_afd219ea8c1384a3c84d4e7ca09be073c"></a>opacity</p>
</td>
<td class="cellrowborder" valign="top" width="16.16161616161616%" headers="mcps1.2.5.1.2 "><p id="en-us_topic_0000001058830799_a89cf6dcf06954b37a77fb21ff2140188"><a name="en-us_topic_0000001058830799_a89cf6dcf06954b37a77fb21ff2140188"></a><a name="en-us_topic_0000001058830799_a89cf6dcf06954b37a77fb21ff2140188"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="13.13131313131313%" headers="mcps1.2.5.1.3 "><p id="en-us_topic_0000001058830799_a2718c52ec5574f49a263ccd45d448656"><a name="en-us_topic_0000001058830799_a2718c52ec5574f49a263ccd45d448656"></a><a name="en-us_topic_0000001058830799_a2718c52ec5574f49a263ccd45d448656"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="46.464646464646464%" headers="mcps1.2.5.1.4 "><p id="en-us_topic_0000001058830799_a6bcdedbaaa87470cae3e3beea1b67aad"><a name="en-us_topic_0000001058830799_a6bcdedbaaa87470cae3e3beea1b67aad"></a><a name="en-us_topic_0000001058830799_a6bcdedbaaa87470cae3e3beea1b67aad"></a>Opacity value applied to the component after the animation is played. The value ranges from <strong id="en-us_topic_0000001058830799_b1144151018012"><a name="en-us_topic_0000001058830799_b1144151018012"></a><a name="en-us_topic_0000001058830799_b1144151018012"></a>0</strong> to <strong id="en-us_topic_0000001058830799_b291916111108"><a name="en-us_topic_0000001058830799_b291916111108"></a><a name="en-us_topic_0000001058830799_b291916111108"></a>1</strong>. The default value is <strong id="en-us_topic_0000001058830799_b52858406505"><a name="en-us_topic_0000001058830799_b52858406505"></a><a name="en-us_topic_0000001058830799_b52858406505"></a>1</strong>.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_row13625142317305"><td class="cellrowborder" valign="top" width="24.242424242424242%" headers="mcps1.2.5.1.1 "><p id="en-us_topic_0000001058830799_p116261023163017"><a name="en-us_topic_0000001058830799_p116261023163017"></a><a name="en-us_topic_0000001058830799_p116261023163017"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="16.16161616161616%" headers="mcps1.2.5.1.2 "><p id="en-us_topic_0000001058830799_p5647133543013"><a name="en-us_topic_0000001058830799_p5647133543013"></a><a name="en-us_topic_0000001058830799_p5647133543013"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="13.13131313131313%" headers="mcps1.2.5.1.3 "><p id="en-us_topic_0000001058830799_p13626202319305"><a name="en-us_topic_0000001058830799_p13626202319305"></a><a name="en-us_topic_0000001058830799_p13626202319305"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="46.464646464646464%" headers="mcps1.2.5.1.4 "><p id="en-us_topic_0000001058830799_p562617236301"><a name="en-us_topic_0000001058830799_p562617236301"></a><a name="en-us_topic_0000001058830799_p562617236301"></a>Width value applied to the component after the animation is played.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_rf77cedb94a3c4c9a8556a2a2a3876997"><td class="cellrowborder" valign="top" width="24.242424242424242%" headers="mcps1.2.5.1.1 "><p id="en-us_topic_0000001058830799_a2f05af1c56e34ed4aa900b467dcf3bb7"><a name="en-us_topic_0000001058830799_a2f05af1c56e34ed4aa900b467dcf3bb7"></a><a name="en-us_topic_0000001058830799_a2f05af1c56e34ed4aa900b467dcf3bb7"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="16.16161616161616%" headers="mcps1.2.5.1.2 "><p id="en-us_topic_0000001058830799_af3cdb37ab1cc46ac823bee3784909613"><a name="en-us_topic_0000001058830799_af3cdb37ab1cc46ac823bee3784909613"></a><a name="en-us_topic_0000001058830799_af3cdb37ab1cc46ac823bee3784909613"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="13.13131313131313%" headers="mcps1.2.5.1.3 "><p id="en-us_topic_0000001058830799_a35aa8df3690b4b169f67360826114e7f"><a name="en-us_topic_0000001058830799_a35aa8df3690b4b169f67360826114e7f"></a><a name="en-us_topic_0000001058830799_a35aa8df3690b4b169f67360826114e7f"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="46.464646464646464%" headers="mcps1.2.5.1.4 "><p id="en-us_topic_0000001058830799_a0ecbff2f02ac42ffb797b9bcae919003"><a name="en-us_topic_0000001058830799_a0ecbff2f02ac42ffb797b9bcae919003"></a><a name="en-us_topic_0000001058830799_a0ecbff2f02ac42ffb797b9bcae919003"></a>Height value applied to the component after the animation is played.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058830799_r43ece702a1c945f08cd7eb195b5faac3"><td class="cellrowborder" valign="top" width="24.242424242424242%" headers="mcps1.2.5.1.1 "><p id="en-us_topic_0000001058830799_aa51ca83ead4c4c00b078f3d2c1e7e66b"><a name="en-us_topic_0000001058830799_aa51ca83ead4c4c00b078f3d2c1e7e66b"></a><a name="en-us_topic_0000001058830799_aa51ca83ead4c4c00b078f3d2c1e7e66b"></a>transform</p>
</td>
<td class="cellrowborder" valign="top" width="16.16161616161616%" headers="mcps1.2.5.1.2 "><p id="en-us_topic_0000001058830799_a44aec140ddba46b19c96be3ef58468c6"><a name="en-us_topic_0000001058830799_a44aec140ddba46b19c96be3ef58468c6"></a><a name="en-us_topic_0000001058830799_a44aec140ddba46b19c96be3ef58468c6"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="13.13131313131313%" headers="mcps1.2.5.1.3 "><p id="en-us_topic_0000001058830799_af2ea25b4333d490d9723dec6c6d1709f"><a name="en-us_topic_0000001058830799_af2ea25b4333d490d9723dec6c6d1709f"></a><a name="en-us_topic_0000001058830799_af2ea25b4333d490d9723dec6c6d1709f"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="46.464646464646464%" headers="mcps1.2.5.1.4 "><p id="en-us_topic_0000001058830799_adff3debf36764e5c868ca9823663cd5b"><a name="en-us_topic_0000001058830799_adff3debf36764e5c868ca9823663cd5b"></a><a name="en-us_topic_0000001058830799_adff3debf36764e5c868ca9823663cd5b"></a>Transformation type applied to a component. For details, see <a href="#en-us_topic_0000001058830799_table28802443315">Table 1</a>.</p>
</td>
</tr>
</tbody>
</table>

If there is no default value for when an animation will start or end, use  **from**  and  **to**  to specify the start and end of the display. The following is an example:

```
@keyframes Go
{
  from {
    background-color: #f76160;
    transform:translate(100px) rotate(0deg) scale(1.0);
  }

  to {
    background-color: #09ba07;
    transform:translate(100px) rotate(180deg) scale(2.0);
  }
}
```

![](figures/动画样式demo2.gif)

>![](public_sys-resources/icon-note.gif) **NOTE:** 
>The @keyframes rule with  **from**  and  **to**  defined cannot be dynamically bound to an element.

