# Application Development

- [Application Development Overview](application-dev-guide.md)
- Quick Start
  - Getting Started

    - [Preparations](quick-start/start-overview.md)

    - [Getting Started with eTS in the Traditional Coding Approach](quick-start/start-with-ets.md)

    - [Getting Started with eTS in the Low-Code Approach](quick-start/start-with-ets-low-code.md)

    - [Getting Started with JavaScript in the Traditional Coding Approach](quick-start/start-with-js.md)

    - [Getting Started with JavaScript in the Low-Code Approach](quick-start/start-with-js-low-code.md)

  - Development Fundamentals

    - [Application Package Structure Configuration File (FA Model)](quick-start/package-structure.md)

    - [Application Package Structure Configuration File (Stage Model)](quick-start/stage-structure.md)

    - [Resource File Categories](quick-start/basic-resource-file-categories.md)

    - [SysCap](quick-start/syscap.md)

- Development
  - Ability Development
    - [Ability Framework Overview](ability/ability-brief.md)

    - [Context Usage](ability/context-userguide.md)

    - FA Model

      - [FA Model Overview](ability/fa-brief.md)

      - [Page Ability Development](ability/fa-pageability.md)

      - [Service Ability Development](ability/fa-serviceability.md)

      - [Data Ability Development](ability/fa-dataability.md)

      - [FA Widget Development](ability/fa-formability.md)

    - Stage Model

      - [Stage Model Overview](ability/stage-brief.md)

      - [Ability Development](ability/stage-ability.md)

      - [Service Extension Ability Development](ability/stage-serviceextension.md)

      - [Ability Continuation Development](ability/stage-ability-continuation.md)

      - [Ability Call Development](ability/stage-call.md)

      - [Stage Widget Development](ability/stage-formextension.md)

    - Other

      - [WantAgent Development](ability/wantagent.md)

      - [Ability Assistant Usage](ability/ability-assistant-guidelines.md)

      - [Test Framework Usage](ability/ability-delegator.md)

  - UI
    - [ArkUI Overview](ui/arkui-overview.md)

    - JavaScript-based Web-like Development Paradigm

      - [Overview](ui/ui-js-overview.md)

      - Framework

        - [File Organization](ui/js-framework-file.md)

        - ["js" Tag](ui/js-framework-js-tag.md)

        - [app.js](ui/js-framework-js-file.md)

        - Syntax

          - [HML](ui/js-framework-syntax-hml.md)

          - [CSS](ui/js-framework-syntax-css.md)

          - [JavaScript](ui/js-framework-syntax-js.md)

        - [Lifecycle](ui/js-framework-lifecycle.md)

        - [Resource Limitations and Access](ui/js-framework-resource-restriction.md)

        - [Multi-Language Capability](ui/js-framework-multiple-languages.md)

      - Building the UI

        - [Component Overview](ui/ui-js-building-ui-component.md)

        - Building the Layout

          - [Layout Description](ui/ui-js-building-ui-layout-intro.md)

          - [Adding Title and Paragraph Text](ui/ui-js-building-ui-layout-text.md)

          - [Adding an Image](ui/ui-js-building-ui-layout-image.md)

          - [Adding a Comment](ui/ui-js-building-ui-layout-comment.md)

          - [Adding a Container](ui/ui-js-building-ui-layout-external-container.md)

        - [Adding Interactions](ui/ui-js-building-ui-interactions.md)

        - [Developing Animations](ui/ui-js-building-ui-animation.md)

        - [Defining Gesture Events](ui/ui-js-building-ui-event.md)

        - [Defining Page Routes](ui/ui-js-building-ui-routes.md)

      - Common Component Development Guidelines

        - Container Components

          - [List Development](ui/ui-js-components-list.md)

          - [Dialog Development](ui/ui-js-components-dialog.md)

          - [Form Development](ui/ui-js-components-form.md)

          - [Stepper Development](ui/ui-js-components-stepper.md)

          - [Tabs Development](ui/ui-js-component-tabs.md)

          - [Swiper Development](ui/ui-js-components-swiper.md)

        - Basic Components

          - [Text Development](ui/ui-js-components-text.md)

          - [Input Development](ui/ui-js-components-input.md)

          - [Button Development](ui/ui-js-components-button.md)

          - [Picker Development](ui/ui-js-components-picker.md)

          - [Image Development](ui/ui-js-components-images.md)

          - [Image-animator Development](ui/ui-js-components-image-animator.md)

          - [Rating Development](ui/ui-js-components-rating.md)

          - [Slider Development](ui/ui-js-components-slider.md)

          - [Chart Development](ui/ui-js-components-chart.md)

          - [Switch Development](ui/ui-js-components-switch.md)

          - [Toolbar Development](ui/ui-js-components-toolbar.md)

          - [Menu Development](ui/ui-js-components-menu.md)

          - [Marquee Development](ui/ui-js-components-marquee.md)

          - [Qrcode Development](ui/ui-js-components-qrcode.md)

          - [Search Development](ui/ui-js-components-search.md)

        - Canvas Development

          - [Canvas](ui/ui-js-components-canvas.md)

          - [CanvasRenderingContext2D](ui/ui-js-components-canvasrenderingcontext2d.md)

          - [Path2D](ui/ui-js-components-path2d.md)

          - [OffscreenCanvas](ui/ui-js-components-offscreencanvas.md)

        - [Grid-container Development](ui/ui-js-components-grid.md)

        - Svg

          - [Basics](ui/ui-js-components-svg-overview.md)

          - [Graph Drawing](ui/ui-js-components-svg-graphics.md)

          - [Path Drawing](ui/ui-js-components-svg-path.md)

          - [Text Drawing](ui/ui-js-components-svg-text.md)

      - Animation Development Guidelines

        - CSS Animation

          - [Defining Attribute Style Animations](ui/ui-js-animate-attribute-style.md)

          - [Defining Animations with the transform Attribute](ui/ui-js-animate-transform.md)

          - [Defining Animations with the background-position Attribute](ui/ui-js-animate-background-position-style.md)

          - [Defining Animations for SVG Components](ui/ui-js-animate-svg.md)

        - JS Animation

          - [Component Animation](ui/ui-js-animate-component.md)

          - Interpolator Animation

            - [Animation Effect](ui/ui-js-animate-dynamic-effects.md)

            - [Animation Frame](ui/ui-js-animate-frame.md)

      - [Custom Components](ui/ui-js-custom-components.md)

    - TypeScript-based Declarative Development Paradigm

      - [Overview](ui/ui-ts-overview.md)

      - Framework Overview

        - File Organization

          - [Directory Structure](ui/ts-framework-directory.md)

          - [Rules for Accessing Application Code Files](ui/ts-framework-file-access-rules.md)

        - ["js" Tag](ui/ts-framework-js-tag.md)

        - Resource Access

          - [Accessing Application Resources](ui/ts-application-resource-access.md)

          - [Accessing System Resources](ui/ts-system-resource-access.md)

          - [Media Resource Types](ui/ts-media-resource-type.md)

        - [Pixel Units](ui/ts-pixel-units.md)

        - [Types](ui/ts-types.md)

      - Declarative Syntax

        - [Overview](ui/ts-syntax-intro.md)

        - General UI Description Specifications

          - [Basic Concepts](ui/ts-general-ui-concepts.md)

          - Declarative UI Description Specifications

            - [Configuration Without Parameters](ui/ts-parameterless-configuration.md)

            - [Configuration with Mandatory Parameters](ui/ts-configuration-with-mandatory-parameters.md)

            - [Attribute Configuration](ui/ts-attribution-configuration.md)

            - [Event Configuration](ui/ts-event-configuration.md)

            - [Child Component Configuration](ui/ts-child-component-configuration.md)

          - Componentization

            - [@Component](ui/ts-component-based-component.md)

            - [@Entry](ui/ts-component-based-entry.md)

            - [@Preview](ui/ts-component-based-preview.md)

            - [@Builder](ui/ts-component-based-builder.md)

            - [@Extend](ui/ts-component-based-extend.md)

            - [@CustomDialog](ui/ts-component-based-customdialog.md)

            - [@Styles](ui/ts-component-based-styles.md)

        - About UI State Management

          - [Basic Concepts](ui/ts-ui-state-mgmt-concepts.md)

          - Managing Component States

            - [@State](ui/ts-component-states-state.md)

            - [@Prop](ui/ts-component-states-prop.md)

            - [@Link](ui/ts-component-states-link.md)

          - Managing Application States

            - [AppStorage](ui/ts-application-states-appstorage.md)

            - [PersistentStorage](ui/ts-application-states-apis-persistentstorage.md)

            - [Environment](ui/ts-application-states-apis-environment.md)

          - Managing Other States

            - [@Observed and @ObjectLink](ui/ts-other-states-observed-objectlink.md)

            - [@Consume and @Provide](ui/ts-other-states-consume-provide.md)

            - [@Watch](ui/ts-other-states-watch.md)

          - About Rendering Control Syntax

            - [if/else](ui/ts-rending-control-syntax-if-else.md)

            - [ForEach](ui/ts-rending-control-syntax-foreach.md)

            - [LazyForEach](ui/ts-rending-control-syntax-lazyforeach.md)

        - About @Component

          - [build Function](ui/ts-function-build.md)

          - [Initialization of Custom Components' Member Variables](ui/ts-custom-component-initialization.md)

          - [Custom Component Lifecycle Callbacks](ui/ts-custom-component-lifecycle-callbacks.md)

          - [Component Creation and Re-initialization](ui/ts-component-creation-re-initialization.md)

        - [About Syntactic Sugar](ui/ts-syntactic-sugar.md)

      - Common Component Development Guidelines

        - [Button](ui/ui-ts-basic-components-button.md)

        - [Web](ui/ui-ts-components-web.md)

      - Common Layout Development Guidelines

        - [Flex Layout](ui/ui-ts-layout-flex.md)

        - [Grid Layout](ui/ui-ts-layout-grid-container.md)

        - [Media Query](ui/ui-ts-layout-mediaquery.md)

      - Experiencing the Declarative UI

        - [Creating a Declarative UI Project](ui/ui-ts-creating-project.md)

        - [Getting to Know Components](ui/ui-ts-components.md)

        - [Creating a Simple Page](ui/ui-ts-creating-simple-page.md)

      - Defining Page Layout and Connection

        - [Building a Food Data Model](ui/ui-ts-building-data-model.md)

        - [Building a Food Category List Layout](ui/ui-ts-building-category-list-layout.md)

        - [Building a Food Category Grid Layout](ui/ui-ts-building-category-grid-layout.md)

        - [Implementing Page Redirection and Data Transmission](ui/ui-ts-page-redirection-data-transmission.md)

  - Basic Functions
    - Window Manager
      * Window

        *  [Window Overview](windowmanager/window-overview.md)

        *  [Window Development](windowmanager/window-guidelines.md)

      * Display

        * [Display Overview](windowmanager/display-overview.md)

        * [Display Development](windowmanager/display-guidelines.md)

      * Screenshot

        * [Screenshot Overview](windowmanager/screenshot-overview.md)

        * [Screenshot Development](windowmanager/screenshot-guidelines.md)

    - WebGL
      - [WebGL Overview](webgl/webgl-overview.md)

      - [WebGL Development](webgl/webgl-guidelines.md)

    - Media
      -   Audio

          -   [Audio Overview](media/audio-overview.md)

          -   [Audio Playback Development](media/audio-playback.md) 

          -   [Audio Recording Development](media/audio-recorder.md) 

          -   [Audio Rendering Development](media/audio-renderer.md)

          -   [Audio Capture Development](media/audio-capturer.md)

          -   [OpenSL ES Audio Playback Development](media/opensles-playback.md)

      -   Video

          - [Video Playback Development](media/video-playback.md)

          - [Video Recording Development](media/video-recorder.md)

      -   Image

          - [Image Development](media/image.md)

    - Security
      - Access Control  

        - [Access Control Overview](security/accesstoken-overview.md)

        - [Access Control Development](security/accesstoken-guidelines.md)

      - User Authentication

        - [User Authentication Overview](security/userauth-overview.md)

        - [User Authentication Development](security/userauth-guidelines.md)

      - Key Management

        - [HUKS Overview](security/huks-overview.md)

        - [HUKS Development](security/huks-guidelines.md)

      - hapsigner  

        - [hapsigner Guide](security/hapsigntool-guidelines.md)

    - Connectivity
      - Network Management

        - [Network Management Overview](connectivity/net-mgmt-overview.md)

        - [HTTP Data Request](connectivity/http-request.md)

        - [WebSocket Connection](connectivity/websocket-connection.md)

        - [Socket Connection](connectivity/socket-connection.md)

      - IPC & RPC

        - [IPC & RPC Overview](connectivity/ipc-rpc-overview.md)

        - [IPC & RPC Development](connectivity/ipc-rpc-development-guideline.md)

        - [Subscribing to State Changes of a Remote Object](connectivity/subscribe-remote-state.md)

    - Data Management
      - Distributed Data Service

        - [Distributed Data Service Overview](database/database-mdds-overview.md)

        - [Distributed Data Service Development](database/database-mdds-guidelines.md)

      - Relational Database

        - [RDB Overview](database/database-relational-overview.md)

        - [RDB Development](database/database-relational-guidelines.md)

      - Preferences

        - [Preferences Overview](database/database-preference-overview.md)

        - [Preferences Development](database/database-preference-guidelines.md)

      - Distributed Data Object

        - [Distributed Data Object Overview](database/database-distributedobject-overview.md)

        - [Distributed Data Object Development](database/database-distributedobject-guidelines.md)

    - Agent-Powered Scheduled Reminders
      - [Agent-Powered Scheduled Reminder Overview](background-agent-scheduled-reminder/background-agent-scheduled-reminder-overview.md)

      - [Agent-Powered Scheduled Reminder Development](background-agent-scheduled-reminder/background-agent-scheduled-reminder-guide.md)

    - Background Task Management
      - [Background Task Management Overview](background-task-management/background-task-overview.md)

      - [Background Task Management Development](background-task-management/background-task-dev-guide.md)
    - Device
      - USB Service

        - [USB Service Overview](device/usb-overview.md)

        - [USB Service Development](device/usb-guidelines.md)

      - Location

        - [Location Overview](device/device-location-overview.md)

        - [Obtaining Device Location Information](device/device-location-info.md)

        - [Geocoding and Reverse Geocoding Capabilities](device/device-location-geocoding.md)

      - Sensor

        - [Sensor Overview](device/sensor-overview.md)

        - [Sensor Development](device/sensor-guidelines.md)

      - Vibrator

        - [Vibrator Overview](device/vibrator-overview.md)

        - [Vibrator Development](device/vibrator-guidelines.md)

      - Update Servcie

        - [Sample Server Overview](device/sample-server-overview.md)

        - [Sample Server Development](device/sample-server-guidelines.md)

    - Device Usage Statistics
      - [Device Usage Statistics Overview](device-usage-statistics/device-usage-statistics-overview.md)

      - [Device Usage Statistics Development](device-usage-statistics/device-usage-statistics-dev-guide.md)

    - DFX
      - Application Event Logging

        - [Overview of Application Event Logging](dfx/hiappevent-overview.md)

        - [Development of Application Event Logging](dfx/hiappevent-guidelines.md)

      - Performance Tracing

        - [Overview of Performance Tracing](dfx/hitracemeter-overview.md)

        - [Development of Performance Tracing](dfx/hitracemeter-guidelines.md)

      - Distributed Call Chain Tracing

        - [Overview of Distributed Call Chain Tracing](dfx/hitracechain-overview.md)

        - [Development of Distributed Call Chain Tracing](dfx/hitracechain-guidelines.md)

    - Internationalization
      - [Internationalization Overview](internationalization/international-overview.md)

      - [Internationalization Development (intl)](internationalization/intl-guidelines.md)

      - [Internationalization Development (i18n)](internationalization/i18n-guidelines.md)
 - [OpenHarmony IDL Specifications and User Guide](IDL/idl-guidelines.md)

- Tools
  - [DevEco Studio (OpenHarmony) User Guide](quick-start/deveco-studio-user-guide-for-openharmony.md)
- Hands-On Tutorials
  - [Samples](https://gitee.com/openharmony/app_samples/blob/master/README.md)
- API References
  - Compent Reference (JavaScript-based Web-like Development Paradigm)
    -   Components

        -   Common

            -   [Universal Attributes](reference/arkui-js/js-components-common-attributes.md)

            -   [Universal Styles](reference/arkui-js/js-components-common-styles.md)

            -   [Universal Events](reference/arkui-js/js-components-common-events.md)

            -   [Universal Methods](reference/arkui-js/js-components-common-methods.md)

            -   [Animation Styles](reference/arkui-js/js-components-common-animation.md)

            -   [Gradient Styles](reference/arkui-js/js-components-common-gradient.md)

            -   [Transition Styles](reference/arkui-js/js-components-common-transition.md)

            -   [Media Query](reference/arkui-js/js-components-common-mediaquery.md)

            -   [Custom Font Styles](reference/arkui-js/js-components-common-customizing-font.md)

            -   [Atomic Layout](reference/arkui-js/js-components-common-atomic-layout.md)

        -   Container Component

            -   [badge](reference/arkui-js/js-components-container-badge.md)

            -   [dialog](reference/arkui-js/js-components-container-dialog.md)

            -   [div](reference/arkui-js/js-components-container-div.md)

            -   [form](reference/arkui-js/js-components-container-form.md)

            -   [list](reference/arkui-js/js-components-container-list.md)

            -   [list-item](reference/arkui-js/js-components-container-list-item.md)

            -   [list-item-group](reference/arkui-js/js-components-container-list-item-group.md)

            -   [panel](reference/arkui-js/js-components-container-panel.md)

            -   [popup](reference/arkui-js/js-components-container-popup.md)

            -   [refresh](reference/arkui-js/js-components-container-refresh.md)

            -   [stack](reference/arkui-js/js-components-container-stack.md)

            -   [stepper](reference/arkui-js/js-components-container-stepper.md)

            -   [stepper-item](reference/arkui-js/js-components-container-stepper-item.md)

            -   [swiper](reference/arkui-js/js-components-container-swiper.md)

            -   [tabs](reference/arkui-js/js-components-container-tabs.md)

            -   [tab-bar](reference/arkui-js/js-components-container-tab-bar.md)

            -   [tab-content](reference/arkui-js/js-components-container-tab-content.md)

        -   Basic Components

            -   [button](reference/arkui-js/js-components-basic-button.md)

            -   [chart](reference/arkui-js/js-components-basic-chart.md)

            -   [divider](reference/arkui-js/js-components-basic-divider.md)

            -   [image](reference/arkui-js/js-components-basic-image.md)

            -   [image-animator](reference/arkui-js/js-components-basic-image-animator.md)

            -   [input](reference/arkui-js/js-components-basic-input.md)

            -   [label](reference/arkui-js/js-components-basic-label.md)

            -   [marquee](reference/arkui-js/js-components-basic-marquee.md)

            -   [menu](reference/arkui-js/js-components-basic-menu.md)

            -   [option](reference/arkui-js/js-components-basic-option.md)

            -   [picker](reference/arkui-js/js-components-basic-picker.md)

            -   [picker-view](reference/arkui-js/js-components-basic-picker-view.md)

            -   [piece](reference/arkui-js/js-components-basic-piece.md)

            -   [progress](reference/arkui-js/js-components-basic-progress.md)

            -   [qrcode](reference/arkui-js/js-components-basic-qrcode.md)

            -   [rating](reference/arkui-js/js-components-basic-rating.md)

            -   [richtext](reference/arkui-js/js-components-basic-richtext.md)

            -   [search](reference/arkui-js/js-components-basic-search.md)

            -   [select](reference/arkui-js/js-components-basic-select.md)

            -   [slider](reference/arkui-js/js-components-basic-slider.md)

            -   [span](reference/arkui-js/js-components-basic-span.md)

            -   [switch](reference/arkui-js/js-components-basic-switch.md)

            -   [text](reference/arkui-js/js-components-basic-text.md)

            -   [textarea](reference/arkui-js/js-components-basic-textarea.md)

            -   [toolbar](reference/arkui-js/js-components-basic-toolbar.md)

            -   [toolbar-item](reference/arkui-js/js-components-basic-toolbar-item.md)

            -   [toggle](reference/arkui-js/js-components-basic-toggle.md)

            -   [web](reference/arkui-js/js-components-basic-web.md)

        -   Media Components

            -   [video](reference/arkui-js/js-components-media-video.md)

        -   Canvas Components

            -   [canvas](reference/arkui-js/js-components-canvas-canvas.md)

            -   [CanvasRenderingContext2D](reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)

            -   [Image](reference/arkui-js/js-components-canvas-image.md)

            -   [CanvasGradient](reference/arkui-js/js-components-canvas-canvasgradient.md)

            -   [ImageData](reference/arkui-js/js-components-canvas-imagedata.md)

            -   [Path2D](reference/arkui-js/js-components-canvas-path2d.md)

            -   [ImageBitmap](reference/arkui-js/js-components-canvas-imagebitmap.md)

            -   [OffscreenCanvas](reference/arkui-js/js-components-canvas-offscreencanvas.md)

            -   [OffscreenCanvasRenderingContext2D](reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)

        -   Grid

            -   [Basic Concepts](reference/arkui-js/js-components-grid-basic-concepts.md)

            -   [grid-container](reference/arkui-js/js-components-grid-container.md)

            -   [grid-row](reference/arkui-js/js-components-grid-row.md)

            -   [grid-col](reference/arkui-js/js-components-grid-col.md)

        -   SVG Components

            -   [Universal Attributes](reference/arkui-js/js-components-svg-common-attributes.md)

            -   [svg](reference/arkui-js/js-components-svg.md)

            -   [rect](reference/arkui-js/js-components-svg-rect.md)

            -   [circle](reference/arkui-js/js-components-svg-circle.md)

            -   [ellipse](reference/arkui-js/js-components-svg-ellipse.md)

            -   [path](reference/arkui-js/js-components-svg-path.md)

            -   [line](reference/arkui-js/js-components-svg-line.md)

            -   [polyline](reference/arkui-js/js-components-svg-polyline.md)

            -   [polygon](reference/arkui-js/js-components-svg-polygon.md)

            -   [text](reference/arkui-js/js-components-svg-text.md)

            -   [tspan](reference/arkui-js/js-components-svg-tspan.md)

            -   [textPath](reference/arkui-js/js-components-svg-textpath.md)

            -   [animate](reference/arkui-js/js-components-svg-animate.md)

            -   [animateMotion](reference/arkui-js/js-components-svg-animatemotion.md)

            -   [animateTransform](reference/arkui-js/js-components-svg-animatetransform.md)

    -   Custom Components

        -   [Basic Usage](reference/arkui-js/js-components-custom-basic-usage.md)

        -   [Custom Events](reference/arkui-js/js-components-custom-events.md)

        -   [props](reference/arkui-js/js-components-custom-props.md)

        -   [Event Parameter](reference/arkui-js/js-components-custom-event-parameter.md)

        -   [slot](reference/arkui-js/js-components-custom-slot.md)

        -   [Lifecycle Definition](reference/arkui-js/js-components-custom-lifecycle.md)

    -   Appendix

        - [Type Attributes](reference/arkui-js/js-appendix-types.md)

  - Compent Reference (TypeScript-based Declarative Development Paradigm)
    - Components

      - Universal Components

        - Universal Events

          - [Click Event](reference/arkui-ts/ts-universal-events-click.md)

          - [Touch Event](reference/arkui-ts/ts-universal-events-touch.md)

          - [Show/Hide Event](reference/arkui-ts/ts-universal-events-show-hide.md)

          - [Drag/Drop Event](reference/arkui-ts/ts-universal-events-drag-drop.md)

          - [Key Event](reference/arkui-ts/ts-universal-events-key.md)

          - [Focus Event](reference/arkui-ts/ts-universal-focus-event.md)

          - [Mouse Event](reference/arkui-ts/ts-universal-mouse-key.md)

          - [Component Area Change Event](reference/arkui-ts/ts-universal-component-area-change-event.md)

        - Universal Attributes

          - [Size](reference/arkui-ts/ts-universal-attributes-size.md)

          - [Location](reference/arkui-ts/ts-universal-attributes-location.md)

          - [Layout Constraints](reference/arkui-ts/ts-universal-attributes-layout-constraints.md)

          - [Flex Layout](reference/arkui-ts/ts-universal-attributes-flex-layout.md)

          - [Border](reference/arkui-ts/ts-universal-attributes-border.md)

          - [Background](reference/arkui-ts/ts-universal-attributes-background.md)

          - [Opacity](reference/arkui-ts/ts-universal-attributes-opacity.md)

          - [Visibility](reference/arkui-ts/ts-universal-attributes-visibility.md)

          - [Enable/Disable](reference/arkui-ts/ts-universal-attributes-enable.md)

          - [Overlay](reference/arkui-ts/ts-universal-attributes-overlay.md)

          - [Z-order Control](reference/arkui-ts/ts-universal-attributes-z-order.md)

          - [Transformation](reference/arkui-ts/ts-universal-attributes-transformation.md)

          - [Image Effect Configuration](reference/arkui-ts/ts-universal-attributes-image-effect.md)

          - [Shape Clipping](reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)

          - [Text Style](reference/arkui-ts/ts-universal-attributes-text-style.md)

          - [Grid](reference/arkui-ts/ts-universal-attributes-grid.md)

          - [Gradient Color](reference/arkui-ts/ts-universal-attributes-gradient-color.md)

          - [Popup Control](reference/arkui-ts/ts-universal-attributes-popup.md)

          - [Menu Control](reference/arkui-ts/ts-universal-attributes-menu.md)

          - [Click Control](reference/arkui-ts/ts-universal-attributes-click.md)

          - [Focus Control](reference/arkui-ts/ts-universal-attributes-focus.md)

          - [Hover Effect](reference/arkui-ts/ts-universal-attributes-hover-effect.md)

          - [Component ID](reference/arkui-ts/ts-universal-attributes-component-id.md)

          - [Touch Target](reference/arkui-ts/ts-universal-attributes-touch-target.md)

          - [Polymorphic Style](reference/arkui-ts/ts-universal-attributes-polymorphic-style.md)

        - Gesture Processing

          - [Gesture Binding Methods](reference/arkui-ts/ts-gesture-settings.md)

          - Basic Gestures

            - [TapGesture](reference/arkui-ts/ts-basic-gestures-tapgesture.md)

            - [LongPressGesture](reference/arkui-ts/ts-basic-gestures-longpressgesture.md)

            - [PanGesture](reference/arkui-ts/ts-basic-gestures-pangesture.md)

            - [PinchGesture](reference/arkui-ts/ts-basic-gestures-pinchgesture.md)

            - [RotationGesture](reference/arkui-ts/ts-basic-gestures-rotationgesture.md)

            - [SwipeGesture](reference/arkui-ts/ts-basic-gestures-swipegesture.md)

          - [Combined Gestures](reference/arkui-ts/ts-combined-gestures.md)

      - Basic Components

        - [Blank](reference/arkui-ts/ts-basic-components-blank.md)

        - [Button](reference/arkui-ts/ts-basic-components-button.md)

        - [Checkbox](reference/arkui-ts/ts-basic-components-checkbox.md)

        - [CheckboxGroup](reference/arkui-ts/ts-basic-components-checkboxgroup.md)

        - [DataPanel](reference/arkui-ts/ts-basic-components-datapanel.md)

        - [DatePicker](reference/arkui-ts/ts-basic-components-datepicker.md)

        - [Divider](reference/arkui-ts/ts-basic-components-divider.md)

        - [Gauge](reference/arkui-ts/ts-basic-components-gauge.md)

        - [Image](reference/arkui-ts/ts-basic-components-image.md)

        - [ImageAnimator](reference/arkui-ts/ts-basic-components-imageanimator.md)

        - [LoadingProgress](reference/arkui-ts/ts-basic-components-loadingprogress.md)

        - [Marquee](reference/arkui-ts/ts-basic-components-marquee.md)

        - [Navigation](reference/arkui-ts/ts-basic-components-navigation.md)

        - [PatternLock](reference/arkui-ts/ts-basic-components-patternlock.md)

        - [PluginComponent](reference/arkui-ts/ts-basic-components-plugincomponent.md)

        - [Progress](reference/arkui-ts/ts-basic-components-progress.md)

        - [QRCode](reference/arkui-ts/ts-basic-components-qrcode.md)

        - [Radio](reference/arkui-ts/ts-basic-components-radio.md)

        - [Rating](reference/arkui-ts/ts-basic-components-rating.md)

        - [RichText](reference/arkui-ts/ts-basic-components-richtext.md)

        - [ScrollBar](reference/arkui-ts/ts-basic-components-scrollbar.md)

        - [Search](reference/arkui-ts/ts-basic-components-search.md)

        - [Select](reference/arkui-ts/ts-basic-components-select.md)

        - [Slider](reference/arkui-ts/ts-basic-components-slider.md)

        - [Span](reference/arkui-ts/ts-basic-components-span.md)

        - [Stepper](reference/arkui-ts/ts-basic-components-stepper.md)

        - [StepperItem](reference/arkui-ts/ts-basic-components-stepperitem.md)

        - [Text](reference/arkui-ts/ts-basic-components-text.md)

        - [TextArea](reference/arkui-ts/ts-basic-components-textarea.md)

        - [TextClock](reference/arkui-ts/ts-basic-components-textclock.md)

        - [TextInput](reference/arkui-ts/ts-basic-components-textinput.md)

        - [TextPicker](reference/arkui-ts/ts-basic-components-textpicker.md)

        - [TextTimer](reference/arkui-ts/ts-basic-components-texttimer.md)

        - [TimePicker](reference/arkui-ts/ts-basic-components-timepicker.md)

        - [Toggle](reference/arkui-ts/ts-basic-components-toggle.md)

        - [Web](reference/arkui-ts/ts-basic-components-web.md)

        - [Xcomponent](reference/arkui-ts/ts-basic-components-xcomponent.md)

      - Container Components

        - [AlphabetIndexer](reference/arkui-ts/ts-container-alphabet-indexer.md)

        - [Badge](reference/arkui-ts/ts-container-badge.md)

        - [Column](reference/arkui-ts/ts-container-column.md)

        - [ColumnSplit](reference/arkui-ts/ts-container-columnsplit.md)

        - [Counter](reference/arkui-ts/ts-container-counter.md)

        - [Flex](reference/arkui-ts/ts-container-flex.md)

        - [GridContainer](reference/arkui-ts/ts-container-gridcontainer.md)

        - [Grid](reference/arkui-ts/ts-container-grid.md)

        - [GridItem](reference/arkui-ts/ts-container-griditem.md)

        - [List](reference/arkui-ts/ts-container-list.md)

        - [ListItem](reference/arkui-ts/ts-container-listitem.md)

        - [Navigator](reference/arkui-ts/ts-container-navigator.md)        

        - [Panel](reference/arkui-ts/ts-container-panel.md)

        - [Refresh](reference/arkui-ts/ts-container-refresh.md)

        - [Row](reference/arkui-ts/ts-container-row.md)

        - [RowSplit](reference/arkui-ts/ts-container-rowsplit.md)

        - [Scroll](reference/arkui-ts/ts-container-scroll.md)        

        - [SideBarContainer](reference/arkui-ts/ts-container-sidebarcontainer.md)

        - [Stack](reference/arkui-ts/ts-container-stack.md)

        - [Swiper](reference/arkui-ts/ts-container-swiper.md)

        - [Tabs](reference/arkui-ts/ts-container-tabs.md)

        - [TabContent](reference/arkui-ts/ts-container-tabcontent.md)

      - Media Components

        - [Video](reference/arkui-ts/ts-media-components-video.md)

      - Drawing Components

        - [Circle](reference/arkui-ts/ts-drawing-components-circle.md)

        - [Ellipse](reference/arkui-ts/ts-drawing-components-ellipse.md)

        - [Line](reference/arkui-ts/ts-drawing-components-line.md)

        - [Polyline](reference/arkui-ts/ts-drawing-components-polyline.md)

        - [Polygon](reference/arkui-ts/ts-drawing-components-polygon.md)

        - [Path](reference/arkui-ts/ts-drawing-components-path.md)

        - [Rect](reference/arkui-ts/ts-drawing-components-rect.md)

        - [Shape](reference/arkui-ts/ts-drawing-components-shape.md)

      - Canvas Components

        - [Canvas](reference/arkui-ts/ts-components-canvas-canvas.md)

        - [CanvasRenderingContext2D](reference/arkui-ts/ts-canvasrenderingcontext2d.md)

        - [OffscreenCanvasRenderingConxt2D](reference/arkui-ts/ts-offscreencanvasrenderingcontext2d.md)

        - [Lottie](reference/arkui-ts/ts-components-canvas-lottie.md)

        - [Path2D](reference/arkui-ts/ts-components-canvas-path2d.md)

        - [CanvasGradient](reference/arkui-ts/ts-components-canvas-canvasgradient.md)

        - [ImageBitmap](reference/arkui-ts/ts-components-canvas-imagebitmap.md)

        - [ImageData](reference/arkui-ts/ts-components-canvas-imagedata.md)

    - Animation

      - [AnimatorProperty](reference/arkui-ts/ts-animatorproperty.md)

      - [Explicit Animation](reference/arkui-ts/ts-explicit-animation.md)

      - Transition Animation

        - [Page Transition](reference/arkui-ts/ts-page-transition-animation.md)

        - [Component Transition](reference/arkui-ts/ts-transition-animation-component.md)

        - [Transition of Shared Elements](reference/arkui-ts/ts-transition-animation-shared-elements.md)

      - [Motion Path Animation](reference/arkui-ts/ts-motion-path-animation.md)

      - [Matrix Transformation](reference/arkui-ts/ts-matrix-transformation.md)

      - [Interpolation Calculation](reference/arkui-ts/ts-interpolation-calculation.md)

    - Global UI Methods

      - Pop-up Window

        - [Alert Dialog Box](reference/arkui-ts/ts-methods-alert-dialog-box.md)

        - [Action Sheet](reference/arkui-ts/ts-methods-action-sheet.md)

        - [Custom Dialog Box](reference/arkui-ts/ts-methods-custom-dialog-box.md)

        - [Date Picker Dialog Box](reference/arkui-ts/ts-methods-datepicker-dialog.md)

        - [Time Picker Dialog Box](reference/arkui-ts/ts-methods-timepicker-dialog.md)

        - [Text Picker Dialog Box](reference/arkui-ts/ts-methods-textpicker-dialog.md)

      - [Menu](reference/arkui-ts/ts-methods-menu.md)

    - [Built-in Enums](reference/arkui-ts/ts-appendix-enums.md)

  - APIs
    - Ability Framework
      - [@ohos.ability.dataUriUtils](reference/apis/js-apis-DataUriUtils.md)
      - [@ohos.ability.errorCode](reference/apis/js-apis-ability-errorCode.md)
      - [@ohos.ability.wantConstant](reference/apis/js-apis-ability-wantConstant.md)
      - [@ohos.application.Ability](reference/apis/js-apis-application-ability.md)
      - [@ohos.application.AbilityConstant](reference/apis/js-apis-application-abilityConstant.md)
      - [@ohos.application.abilityDelegatorRegistry](reference/apis/js-apis-abilityDelegatorRegistry.md)
      - [@ohos.application.AbilityStage ](reference/apis/js-apis-application-abilitystage.md)
      - [@ohos.application.appManager](reference/apis/js-apis-appmanager.md)
      - [@ohos.application.Configuration](reference/apis/js-apis-configuration.md)
      - [@ohos.application.ConfigurationConstant](reference/apis/js-apis-configurationconstant.md)
      - [@ohos.ability.featureAbility](reference/apis/js-apis-featureAbility.md)
      - [@ohos.application.formBindingData](reference/apis/js-apis-formbindingdata.md)
      - [@ohos.application.FormExtension](reference/apis/js-apis-formextension.md)
      - [@ohos.application.formError](reference/apis/js-apis-formerror.md)
      - [@ohos.application.formHost](reference/apis/js-apis-formhost.md)
      - [@ohos.application.formInfo](reference/apis/js-apis-formInfo.md)
      - [@ohos.application.missionManager](reference/apis/js-apis-missionManager.md)
      - [@ohos.application.formProvider](reference/apis/js-apis-formprovider.md)
      - [@ohos.ability.particleAbility](reference/apis/js-apis-particleAbility.md)
      - [@ohos.application.ServiceExtensionAbility](reference/apis/js-apis-service-extension-ability.md)
      - [@ohos.application.StartOptions](reference/apis/js-apis-application-StartOptions.md)
      - [@ohos.application.StaticSubscriberExtensionAbility](reference/apis/js-apis-application-staticSubscriberExtensionAbility.md)
      - [@ohos.application.uriPermissionManager](reference/apis/js-apis-uripermissionmanager.md)
      - [@ohos.application.Want](reference/apis/js-apis-application-Want.md)
      - [@ohos.wantAgent](reference/apis/js-apis-wantAgent.md)
      - ability/[dataAbilityHelper](reference/apis/js-apis-dataAbilityHelper.md)
      - app/[context](reference/apis/js-apis-Context.md)
      - application/[AbilityContext](reference/apis/js-apis-ability-context.md)
      - application/[abilityDelegator](reference/apis/js-apis-application-abilityDelegator.md)
      - application/[abilityDelegatorArgs](reference/apis/js-apis-application-abilityDelegatorArgs.md)
      - application/[abilityMonitor](reference/apis/js-apis-application-abilityMonitor.md)
      - application/[AbilityRunningInfo](reference/apis/js-apis-abilityrunninginfo.md)
      - application/[AbilityStageContext](reference/apis/js-apis-abilitystagecontext.md)
      - application/[Context](reference/apis/js-apis-application-context.md)
      - application/[ExtensionContext](reference/apis/js-apis-extension-context.md)
      - application/[ExtensionRunningInfo](reference/apis/js-apis-extensionrunninginfo.md)
      - application/[FormExtensionContext](reference/apis/js-apis-formextensioncontext.md)
      - application/[MissionSnapshot](reference/apis/js-apis-application-MissionSnapshot.md)
      - application/[PermissionRequestResult](reference/apis/js-apis-permissionrequestresult.md)
      - application/[ProcessRunningInfo](reference/apis/js-apis-processrunninginfo.md)
      - application/[ServiceExtensionContext](reference/apis/js-apis-service-extension-context.md)
      - application/[shellCmdResult](reference/apis/js-apis-application-shellCmdResult.md)
    - Common Event and Notification
      - [@ohos.commonEvent](reference/apis/js-apis-commonEvent.md)
      - [@ohos.events.emitter](reference/apis/js-apis-emitter.md)
      - [@ohos.notification](reference/apis/js-apis-notification.md)
      - [@ohos.reminderAgent](reference/apis/js-apis-reminderAgent.md)
      - application/[EventHub](reference/apis/js-apis-eventhub.md)
    - Bundle Management
      - [@ohos.bundle](reference/apis/js-apis-Bundle.md)
      - [@ohos.bundleState](reference/apis/js-apis-deviceUsageStatistics.md)
      - [@ohos.zlib](reference/apis/js-apis-zlib.md)
    - UI Page
      - [@ohos.animator](reference/apis/js-apis-animator.md)
      - [@ohos.mediaquery](reference/apis/js-apis-mediaquery.md)
      - [@ohos.prompt](reference/apis/js-apis-prompt.md)
      - [@ohos.router](reference/apis/js-apis-router.md)
    - Graphics
      - [@ohos.display ](reference/apis/js-apis-display.md)
      - [@ohos.screenshot](reference/apis/js-apis-screenshot.md)
      - [@ohos.window](reference/apis/js-apis-window.md)
      - [webgl](reference/apis/js-apis-webgl.md)
      - [webgl2](reference/apis/js-apis-webgl2.md)
    - Media
      - [@ohos.multimedia.audio](reference/apis/js-apis-audio.md)
      - [@ohos.multimedia.camera](reference/apis/js-apis-camera.md)
      - [@ohos.multimedia.image](reference/apis/js-apis-image.md)
      - [@ohos.multimedia.media](reference/apis/js-apis-media.md)
      - [@ohos.multimedia.medialibrary](reference/apis/js-apis-medialibrary.md)
    - Resource Management
      - [@ohos.i18n](reference/apis/js-apis-i18n.md)
      - [@ohos.intl](reference/apis/js-apis-intl.md)
      - [@ohos.resourceManager](reference/apis/js-apis-resource-manager.md)
    - Resource Scheduling
      - [@ohos.backgroundTaskManager](reference/apis/js-apis-backgroundTaskManager.md)
      - [@ohos.workScheduler ](reference/apis/js-apis-workScheduler.md)
      - [@ohos.WorkSchedulerExtensionAbility](reference/apis/js-apis-WorkSchedulerExtensionAbility.md)
    - Custom Management
      - [@ohos.configPolicy](reference/apis/js-apis-config-policy.md)
      - [@ohos.enterpriseDeviceManager](reference/apis/js-apis-enterprise-device-manager.md)
    - Security
      - [@ohos.abilityAccessCtrl](reference/apis/js-apis-abilityAccessCtrl.md)
      - [@ohos.security.huks ](reference/apis/js-apis-huks.md)
      - [@ohos.userIAM.userAuth ](reference/apis/js-apis-useriam-userauth.md)
      - [@system.cipher](reference/apis/js-apis-system-cipher.md)
    - Data Management
      - [@ohos.data.dataAbility ](reference/apis/js-apis-data-ability.md)
      - [@ohos.data.distributedData](reference/apis/js-apis-distributed-data.md)
      - [@ohos.data.distributedDataObject](reference/apis/js-apis-data-distributedobject.md)
      - [@ohos.data.preferences](reference/apis/js-apis-data-preferences.md)
      - [@ohos.data.rdb](reference/apis/js-apis-data-rdb.md)
      - [@ohos.settings](reference/apis/js-apis-settings.md)
      - data/rdb/[resultSet](reference/apis/js-apis-data-resultset.md)
    - File Management
      - [@ohos.document](reference/apis/js-apis-document.md)
      - [@ohos.environment](reference/apis/js-apis-environment.md)
      - [@ohos.fileio](reference/apis/js-apis-fileio.md)
      - [@ohos.fileManager](reference/apis/js-apis-filemanager.md)
      - [@ohos.statfs](reference/apis/js-apis-statfs.md)
      - [@ohos.storageStatistics](reference/apis/js-apis-storage-statistics.md)
      - [@ohos.volumeManager](reference/apis/js-apis-volumemanager.md)
    - Telephony Service
      - [@ohos.contact](reference/apis/js-apis-contact.md)
      - [@ohos.telephony.call](reference/apis/js-apis-call.md)
      - [@ohos.telephony.observer](reference/apis/js-apis-observer.md)
      - [@ohos.telephony.radio](reference/apis/js-apis-radio.md)
      - [@ohos.telephony.sim](reference/apis/js-apis-sim.md)
      - [@ohos.telephony.sms](reference/apis/js-apis-sms.md)
      - [@ohos.telephony.data](reference/apis/js-apis-telephony-data.md)
    - Network Management
      - [@ohos.net.connection](reference/apis/js-apis-net-connection.md)
      - [@ohos.net.http](reference/apis/js-apis-http.md)
      - [@ohos.request](reference/apis/js-apis-request.md)
      - [@ohos.net.socket](reference/apis/js-apis-socket.md)
      - [@ohos.net.webSocket](reference/apis/js-apis-webSocket.md)
    - Connectivity
      - [@ohos.bluetooth](reference/apis/js-apis-bluetooth.md)
      - [@ohos.connectedTag](reference/apis/js-apis-connectedTag.md)
      - [@ohos.rpc](reference/apis/js-apis-rpc.md)
      - [@ohos.wifi](reference/apis/js-apis-wifi.md)
      - [@ohos.wifiext](reference/apis/js-apis-wifiext.md)
    - Basic Features
      - [@ohos.accessibility](reference/apis/js-apis-accessibility.md)
      - [@ohos.faultLogger](reference/apis/js-apis-faultLogger.md)
      - [@ohos.hiAppEvent](reference/apis/js-apis-hiappevent.md)
      - [@ohos.hichecker](reference/apis/js-apis-hichecker.md)
      - [@ohos.hidebug](reference/apis/js-apis-hidebug.md)
      - [@ohos.hilog](reference/apis/js-apis-hilog.md)
      - [@ohos.hiTraceChain](reference/apis/js-apis-hitracechain.md)
      - [@ohos.hiTraceMeter](reference/apis/js-apis-hitracemeter.md)
      - [@ohos.inputMethod](reference/apis/js-apis-inputmethod.md)
      - [@ohos.inputMethodEngine](reference/apis/js-apis-inputmethodengine.md)
      - [@ohos.pasteboard](reference/apis/js-apis-pasteboard.md)
      - [@ohos.screenLock](reference/apis/js-apis-screen-lock.md)
      - [@ohos.systemTime](reference/apis/js-apis-system-time.md)
      - [@ohos.wallpaper](reference/apis/js-apis-wallpaper.md)
      - [Timer](reference/apis/js-apis-timer.md)
    - Device Management
      - [@ohos.batteryInfo ](reference/apis/js-apis-battery-info.md)
      - [@ohos.brightness](reference/apis/js-apis-brightness.md)
      - [@ohos.deviceInfo](reference/apis/js-apis-device-info.md)
      - [@ohos.distributedHardware.deviceManager](reference/apis/js-apis-device-manager.md)
      - [@ohos.geolocation](reference/apis/js-apis-geolocation.md)
      - [@ohos.multimodalInput.inputConsumer](reference/apis/js-apis-inputconsumer.md)
      - [@ohos.multimodalInput.inputDevice](reference/apis/js-apis-inputdevice.md)
      - [@ohos.multimodalInput.inputEventClient](reference/apis/js-apis-inputeventclient.md)
      - [@ohos.multimodalInput.inputMonitor](reference/apis/js-apis-inputmonitor.md)
      - [@ohos.power](reference/apis/js-apis-power.md)
      - [@ohos.runningLock](reference/apis/js-apis-runninglock.md)
      - [@ohos.sensor](reference/apis/js-apis-sensor.md)
      - [@ohos.systemParameter](reference/apis/js-apis-system-parameter.md)
      - [@ohos.thermal](reference/apis/js-apis-thermal.md)
      - [@ohos.update](reference/apis/js-apis-update.md)
      - [@ohos.usb](reference/apis/js-apis-usb.md)
      - [@ohos.vibrator](reference/apis/js-apis-vibrator.md)
    - Account Management
      - [@ohos.account.appAccount](reference/apis/js-apis-appAccount.md)
      - [@ohos.account.distributedAccount](reference/apis/js-apis-distributed-account.md)
      - [@ohos.account.osAccount](reference/apis/js-apis-osAccount.md)
    - Language Base Class Library
      - [@ohos.convertxml](reference/apis/js-apis-convertxml.md)
      - [@ohos.process](reference/apis/js-apis-process.md)
      - [@ohos.uri](reference/apis/js-apis-uri.md)
      - [@ohos.url](reference/apis/js-apis-url.md)
      - [@ohos.util](reference/apis/js-apis-util.md)
      - [@ohos.util.ArrayList](reference/apis/js-apis-arraylist.md)
      - [@ohos.util.Deque](reference/apis/js-apis-deque.md)
      - [@ohos.util.HashMap](reference/apis/js-apis-hashmap.md)
      - [@ohos.util.HashSet](reference/apis/js-apis-hashset.md)
      - [@ohos.util.LightWeightMap](reference/apis/js-apis-lightweightmap.md)
      - [@ohos.util.LightWeightSet](reference/apis/js-apis-lightweightset.md)
      - [@ohos.util.LinkedList](reference/apis/js-apis-linkedlist.md)
      - [@ohos.util.List](reference/apis/js-apis-list.md)
      - [@ohos.util.PlainArray](reference/apis/js-apis-plainarray.md)
      - [@ohos.util.Queue](reference/apis/js-apis-queue.md)
      - [@ohos.util.Stack](reference/apis/js-apis-stack.md)
      - [@ohos.util.TreeMap](reference/apis/js-apis-treemap.md)
      - [@ohos.util.TreeSet](reference/apis/js-apis-treeset.md)
      - [@ohos.util.Vector](reference/apis/js-apis-vector.md)
      - [@ohos.worker](reference/apis/js-apis-worker.md)
      - [@ohos.xml](reference/apis/js-apis-xml.md)
    - Test
      - [@ohos.application.testRunner](reference/apis/js-apis-testRunner.md)
      - [@ohos.uitest](reference/apis/js-apis-uitest.md)
    - APIs No Longer Maintained
      - [@ohos.bytrace](reference/apis/js-apis-bytrace.md)
      - [@ohos.data.storage](reference/apis/js-apis-data-storage.md)
      - [@system.app](reference/apis/js-apis-system-app.md)
      - [@system.battery](reference/apis/js-apis-system-battery.md)
      - [@system.bluetooth](reference/apis/js-apis-system-bluetooth.md)
      - [@system.brightness](reference/apis/js-apis-system-brightness.md)
      - [@system.configuration](reference/apis/js-apis-system-configuration.md)
      - [@system.device](reference/apis/js-apis-system-device.md)
      - [@system.fetch](reference/apis/js-apis-system-fetch.md)
      - [@system.file](reference/apis/js-apis-system-file.md)
      - [@system.geolocation](reference/apis/js-apis-system-location.md)
      - [@system.mediaquery](reference/apis/js-apis-system-mediaquery.md)
      - [@system.network](reference/apis/js-apis-system-network.md)
      - [@system.notification](reference/apis/js-apis-system-notification.md)
      - [@system.package](reference/apis/js-apis-system-package.md)
      - [@system.prompt](reference/apis/js-apis-system-prompt.md)
      - [@system.request](reference/apis/js-apis-system-request.md)
      - [@system.router](reference/apis/js-apis-system-router.md)
      - [@system.sensor](reference/apis/js-apis-system-sensor.md)
      - [@system.storage](reference/apis/js-apis-system-storage.md)
      - [@system.vibrator](reference/apis/js-apis-system-vibrate.md)
      - [console](reference/apis/js-apis-logs.md)