# 导读<a name="ZH-CN_TOPIC_0000001152533331"></a>

-   [系统类型](#section767218232110)
-   [文档导读](#section19810171681218)

为了方便开发者正确获取内容，本导读基于OpenHarmony学习路径同时结合开发者具体业务对相关资料资源进行了分类。

## 系统类型<a name="section767218232110"></a>

在正式学习OpenHarmony开发前，开发者需要先了解系统类型，方便后续根据自身业务匹配对应的系统及对应文档资源。

OpenHarmony是一款面向全场景的开源分布式操作系统，采用组件化设计，支持在128KiB到xGB RAM资源的设备上运行系统组件，设备开发者可基于目标硬件能力自由选择系统组件进行集成。

为了保证在不同硬件上集成的易用性，OpenHarmony当前定义了三种基础系统类型，设备开发者通过选择基础系统类型完成必选组件集配置后，便可实现其最小系统的开发。这三种基础系统类型的参考定义如下：

-   轻量系统（mini system）

    面向MCU类处理器例如Arm Cortex-M、RISC-V 32位的设备，硬件资源极其有限，支持的设备最小内存为128KiB，可以提供多种轻量级网络协议，轻量级的图形框架，以及丰富的IOT总线读写部件等。可支撑的产品如智能家居领域的连接类模组、传感器设备、穿戴类设备等。

-   小型系统（small system）

    面向应用处理器例如Arm Cortex-A的设备，支持的设备最小内存为1MiB，可以提供更高的安全能力、标准的图形框架、视频编解码的多媒体能力。可支撑的产品如智能家居领域的IP Camera、电子猫眼、路由器以及智慧出行域的行车记录仪等。

-   标准系统（standard system）

    面向应用处理器例如Arm Cortex-A的设备，支持的设备最小内存为128MiB，可以提供增强的交互能力、3D GPU以及硬件合成能力、更多控件以及动效更丰富的图形能力、完整的应用框架。可支撑的产品如高端的冰箱显示屏。


OpenHarmony也提供了一系列可选的系统组件，方便设备开发者按需配置，以支撑其特色功能的扩展或定制开发。系统将这些可选的系统组件组合为一系列描述为特性或功能的系统能力，以方便设备开发者理解和选择。

## 文档导读<a name="section19810171681218"></a>

**表 1**  文档资源导读

<a name="table12124241175"></a>
<table><thead align="left"><tr id="row1021316249176"><th class="cellrowborder" valign="top" width="27.872787278727873%" id="mcps1.2.4.1.1"><p id="p162131124191710"><a name="p162131124191710"></a><a name="p162131124191710"></a>学习路径</p>
</th>
<th class="cellrowborder" valign="top" width="38.54385438543855%" id="mcps1.2.4.1.2"><p id="p721310243170"><a name="p721310243170"></a><a name="p721310243170"></a>开发者业务</p>
</th>
<th class="cellrowborder" valign="top" width="33.58335833583358%" id="mcps1.2.4.1.3"><p id="p15213192431712"><a name="p15213192431712"></a><a name="p15213192431712"></a>相关文档</p>
</th>
</tr>
</thead>
<tbody><tr id="row82139245176"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p021372418175"><a name="p021372418175"></a><a name="p021372418175"></a>了解<span id="text64714522207"><a name="text64714522207"></a><a name="text64714522207"></a>OpenHarmony</span></p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p6213142414179"><a name="p6213142414179"></a><a name="p6213142414179"></a>整体认知<span id="text9808161615252"><a name="text9808161615252"></a><a name="text9808161615252"></a>OpenHarmony</span></p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul1979224313222"></a><a name="ul1979224313222"></a><ul id="ul1979224313222"><li><a href="https://gitee.com/openharmony" target="_blank" rel="noopener noreferrer">OpenHarmony概述</a></li><li><a href="../glossary/术语.md">术语</a></li></ul>
</td>
</tr>
<tr id="row124015595011"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p132401950505"><a name="p132401950505"></a><a name="p132401950505"></a>获取开发资源</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p724015515504"><a name="p724015515504"></a><a name="p724015515504"></a>准备开发前相关资源</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul13903204717506"></a><a name="ul13903204717506"></a><ul id="ul13903204717506"><li><a href="../get-code/源码获取.md">获取源码</a></li><li><a href="../get-code/获取工具.md">获取工具</a></li></ul>
</td>
</tr>
<tr id="row11213142451711"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p18213172414174"><a name="p18213172414174"></a><a name="p18213172414174"></a>快速入门</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p3213132491711"><a name="p3213132491711"></a><a name="p3213132491711"></a>快速熟悉<span id="text203751321355"><a name="text203751321355"></a><a name="text203751321355"></a>OpenHarmony</span>环境搭建、编译、烧录、调测、运行。</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul1222811151378"></a><a name="ul1222811151378"></a><ul id="ul1222811151378"><li><a href="概述.md">轻量和小型系统快速入门</a></li><li><a href="概述-6.md">标准系统快速入门</a></li></ul>
</td>
</tr>
<tr id="row421315248178"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p0213724191718"><a name="p0213724191718"></a><a name="p0213724191718"></a>基础能力使用</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p6214112417173"><a name="p6214112417173"></a><a name="p6214112417173"></a>使用<span id="text8928941123820"><a name="text8928941123820"></a><a name="text8928941123820"></a>OpenHarmony</span>提供的基础能力</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul1293915133917"></a><a name="ul1293915133917"></a><ul id="ul1293915133917"><li><a href="../kernel/Readme-CN.md">内核开发指南</a></li><li><a href="../driver/Readme-CN.md">驱动开发指南</a></li><li><a href="../subsystems/Readme-CN.md">子系统开发指南</a></li><li><a href="../security/安全指南.md">安全指南</a></li><li><a href="../security/隐私保护.md">隐私保护</a></li></ul>
</td>
</tr>
<tr id="row14214122410178"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p162142242175"><a name="p162142242175"></a><a name="p162142242175"></a>进阶开发</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p12214624171719"><a name="p12214624171719"></a><a name="p12214624171719"></a>结合系统能力开发智能设备</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul151291418444"></a><a name="ul151291418444"></a><ul id="ul151291418444"><li><a href="../guide/LED外设控制.md">LED控制</a></li><li><a href="../guide/屏幕和摄像头控制.md">音视摄像头控制</a></li><li><a href="../guide/视觉应用开发.md">空气质量检测app开发</a></li><li><a href="../guide/时钟应用开发示例.md">时钟应用开发示例</a></li><li><a href="../guide/平台驱动开发示例.md">平台驱动开发示例</a></li><li><a href="../guide/外设驱动开发示例.md">外设驱动开发示例</a></li></ul>
</td>
</tr>
<tr id="row2021462441719"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p521402416177"><a name="p521402416177"></a><a name="p521402416177"></a>移植适配</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><a name="ul151441577479"></a><a name="ul151441577479"></a><ul id="ul151441577479"><li>针对特定芯片做移植适配</li><li>对三方库进行移植适配</li></ul>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul49839175470"></a><a name="ul49839175470"></a><ul id="ul49839175470"><li><a href="../porting/三方芯片移植指导.md" target="_blank" rel="noopener noreferrer">轻量系统芯片移植指导</a></li><li><a href="../porting/三方库移植指导.md">三方库移植指导</a></li></ul>
</td>
</tr>
<tr id="row321442419177"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p102149240175"><a name="p102149240175"></a><a name="p102149240175"></a>贡献组件</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p12142024151711"><a name="p12142024151711"></a><a name="p12142024151711"></a>为<span id="text207913212498"><a name="text207913212498"></a><a name="text207913212498"></a>OpenHarmony</span>贡献功能组件</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul1675715272499"></a><a name="ul1675715272499"></a><ul id="ul1675715272499"><li><a href="../bundles/组件开发规范.md">组件开发规范</a></li><li><a href="../bundles/组件开发指南.md">组件开发指南</a></li><li><a href="../bundles/组件开发示例.md">组件开发示例</a></li></ul>
</td>
</tr>
<tr id="row1621492419178"><td class="cellrowborder" valign="top" width="27.872787278727873%" headers="mcps1.2.4.1.1 "><p id="p10214172414173"><a name="p10214172414173"></a><a name="p10214172414173"></a>参考</p>
</td>
<td class="cellrowborder" valign="top" width="38.54385438543855%" headers="mcps1.2.4.1.2 "><p id="p122140244172"><a name="p122140244172"></a><a name="p122140244172"></a>开发参考</p>
</td>
<td class="cellrowborder" valign="top" width="33.58335833583358%" headers="mcps1.2.4.1.3 "><a name="ul14961914175515"></a><a name="ul14961914175515"></a><ul id="ul14961914175515"><li><a href="https://device.harmonyos.com/cn/docs/develop/apiref/js-framework-file-0000000000611396" target="_blank" rel="noopener noreferrer">API参考</a></li></ul>
</td>
</tr>
</tbody>
</table>

