# 网络<a name="ZH-CN_TOPIC_0000001051770946"></a>

-   [基本概念](#section9840143083510)
-   [使用场景](#section1575885183516)
-   [功能](#section16351198193614)

## 基本概念<a name="section9840143083510"></a>

网络模块实现了TCP/IP协议栈基本功能，提供标准的POSIX socket接口。

>![](public_sys-resources/icon-note.gif) **说明：** 
>当前系统使用**lwIP**提供网络能力。

## 使用场景<a name="section1575885183516"></a>

针对用户态开发，OpenHarmony内核提供了一套网络功能系统调用接口，支持socket的创建关闭、数据收发、网络属性的设置等，通过C库提供标准的POSIX socket函数供开发者使用。

## 功能<a name="section16351198193614"></a>

**表 1**  标准C库相关接口

<a name="table89488035718"></a>
<table><thead align="left"><tr id="row1494810045717"><th class="cellrowborder" valign="top" width="15.17%" id="mcps1.2.4.1.1"><p id="p294915015578"><a name="p294915015578"></a><a name="p294915015578"></a>头文件</p>
</th>
<th class="cellrowborder" valign="top" width="50.9%" id="mcps1.2.4.1.2"><p id="p17949190205711"><a name="p17949190205711"></a><a name="p17949190205711"></a>接口</p>
</th>
<th class="cellrowborder" valign="top" width="33.93%" id="mcps1.2.4.1.3"><p id="p894950175712"><a name="p894950175712"></a><a name="p894950175712"></a>功能</p>
</th>
</tr>
</thead>
<tbody><tr id="row19501105571"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p109504011576"><a name="p109504011576"></a><a name="p109504011576"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p99508013571"><a name="p99508013571"></a><a name="p99508013571"></a>int accept(int socket, struct sockaddr *address, socklen_t *address_len)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p2095015035719"><a name="p2095015035719"></a><a name="p2095015035719"></a>接受连接。</p>
</td>
</tr>
<tr id="row209508065717"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p136322417199"><a name="p136322417199"></a><a name="p136322417199"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p89509014573"><a name="p89509014573"></a><a name="p89509014573"></a>int bind(int s, const struct sockaddr *name, socklen_t namelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p6950903575"><a name="p6950903575"></a><a name="p6950903575"></a>socket与IP地址绑定。</p>
</td>
</tr>
<tr id="row99511100571"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p23757247194"><a name="p23757247194"></a><a name="p23757247194"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p59529055717"><a name="p59529055717"></a><a name="p59529055717"></a>int shutdown(int socket, int how)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p129527012573"><a name="p129527012573"></a><a name="p129527012573"></a>关闭连接。</p>
</td>
</tr>
<tr id="row49527011574"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p0392172441910"><a name="p0392172441910"></a><a name="p0392172441910"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p29531909577"><a name="p29531909577"></a><a name="p29531909577"></a>int getpeername(int s, struct sockaddr *name, socklen_t *namelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p119534011576"><a name="p119534011576"></a><a name="p119534011576"></a>获取对端地址。</p>
</td>
</tr>
<tr id="row139532014576"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p34091724181911"><a name="p34091724181911"></a><a name="p34091724181911"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p616711716015"><a name="p616711716015"></a><a name="p616711716015"></a>int getsockname(int s, struct sockaddr *name, socklen_t *namelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p181651471103"><a name="p181651471103"></a><a name="p181651471103"></a>获取本地地址。</p>
</td>
</tr>
<tr id="row695520019572"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p1842812441920"><a name="p1842812441920"></a><a name="p1842812441920"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p2016357007"><a name="p2016357007"></a><a name="p2016357007"></a>int getsockopt(int s, struct sockaddr *name, socklen_t *namelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p1716037404"><a name="p1716037404"></a><a name="p1716037404"></a>获取socket属性信息。</p>
</td>
</tr>
<tr id="row79551708579"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p2442224121911"><a name="p2442224121911"></a><a name="p2442224121911"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p6158671601"><a name="p6158671601"></a><a name="p6158671601"></a>int setsockopt(int sockfd, int level, int optname, void *optval, socklen_t *optlen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p415510716015"><a name="p415510716015"></a><a name="p415510716015"></a>配置socket属性。</p>
</td>
</tr>
<tr id="row595550165713"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p1345422415197"><a name="p1345422415197"></a><a name="p1345422415197"></a>unistd.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p19153371020"><a name="p19153371020"></a><a name="p19153371020"></a>int close(int s)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p815119715017"><a name="p815119715017"></a><a name="p815119715017"></a>关闭socket。</p>
</td>
</tr>
<tr id="row139566085714"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p114692024121917"><a name="p114692024121917"></a><a name="p114692024121917"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p181481371010"><a name="p181481371010"></a><a name="p181481371010"></a>int connect(int s, const struct sockaddr *name, socklen_t namelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p41455713010"><a name="p41455713010"></a><a name="p41455713010"></a>连接到指定的目的IP。</p>
</td>
</tr>
<tr id="row89575035714"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p184811924191919"><a name="p184811924191919"></a><a name="p184811924191919"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p21421376013"><a name="p21421376013"></a><a name="p21421376013"></a>int listen(int sockfd, int backlog)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p9139271308"><a name="p9139271308"></a><a name="p9139271308"></a>聆听连接本socket的请求。</p>
</td>
</tr>
<tr id="row69581108574"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p349182412196"><a name="p349182412196"></a><a name="p349182412196"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p1813627005"><a name="p1813627005"></a><a name="p1813627005"></a>ssize_t recv(int socket, void *buffer, size_t length, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p1113318713018"><a name="p1113318713018"></a><a name="p1113318713018"></a>接收socket上收到的数据。</p>
</td>
</tr>
<tr id="row89591609574"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p55011249191"><a name="p55011249191"></a><a name="p55011249191"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p10131976020"><a name="p10131976020"></a><a name="p10131976020"></a>ssize_t recvmsg(int s, struct msghdr *message, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p2010837004"><a name="p2010837004"></a><a name="p2010837004"></a>接收socket上收到的数据，可使用更丰富的参数。</p>
</td>
</tr>
<tr id="row8960903574"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p1351310242192"><a name="p1351310242192"></a><a name="p1351310242192"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p310519717015"><a name="p310519717015"></a><a name="p310519717015"></a>ssize_t recvfrom(int socket, void *buffer, size_t length, int flags, struct sockaddr *address, socklen_t *address_len)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p11102471608"><a name="p11102471608"></a><a name="p11102471608"></a>接收socket上收到的数据，可同时获得数据来源IP地址。</p>
</td>
</tr>
<tr id="row16961120195719"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p3525112420198"><a name="p3525112420198"></a><a name="p3525112420198"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p101001872009"><a name="p101001872009"></a><a name="p101001872009"></a>ssize_t send(int s, const void *dataptr, size_t size, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p197171402"><a name="p197171402"></a><a name="p197171402"></a>通过socket发送数据。</p>
</td>
</tr>
<tr id="row59620075717"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p165381324121910"><a name="p165381324121910"></a><a name="p165381324121910"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p6941671602"><a name="p6941671602"></a><a name="p6941671602"></a>ssize_t sendmsg(int s, const struct msghdr *message, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p13912710013"><a name="p13912710013"></a><a name="p13912710013"></a>通过socket发送数据，可使用更丰富的参数。</p>
</td>
</tr>
<tr id="row296213055716"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p1055242414196"><a name="p1055242414196"></a><a name="p1055242414196"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p588573013"><a name="p588573013"></a><a name="p588573013"></a>ssize_t sendto(int s, const void *dataptr, size_t size, int flags, const struct sockaddr *to, socklen_t tolen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p108612713014"><a name="p108612713014"></a><a name="p108612713014"></a>通过socket发送数据，可指定发送的目的IP地址。</p>
</td>
</tr>
<tr id="row1896320155718"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p165642024191919"><a name="p165642024191919"></a><a name="p165642024191919"></a>sys/socket.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p168413711019"><a name="p168413711019"></a><a name="p168413711019"></a>int socket(int domain, int type, int protocol)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p1278772017"><a name="p1278772017"></a><a name="p1278772017"></a>创建socket。</p>
</td>
</tr>
<tr id="row49644012571"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p3574152491918"><a name="p3574152491918"></a><a name="p3574152491918"></a>sys/select.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p575471204"><a name="p575471204"></a><a name="p575471204"></a>int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p6721171012"><a name="p6721171012"></a><a name="p6721171012"></a>多路复用。</p>
</td>
</tr>
<tr id="row1965904571"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p1958512413195"><a name="p1958512413195"></a><a name="p1958512413195"></a>sys/ioctl.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p27013715013"><a name="p27013715013"></a><a name="p27013715013"></a>int ioctl(int s, int request, ...)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p867471405"><a name="p867471405"></a><a name="p867471405"></a>socket属性获取、设置。</p>
</td>
</tr>
<tr id="row179471552191312"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p4595192471910"><a name="p4595192471910"></a><a name="p4595192471910"></a>arpa/inet.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p189481522130"><a name="p189481522130"></a><a name="p189481522130"></a>const char *inet_ntop(int af, const void *src, char *dst, socklen_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p494814527138"><a name="p494814527138"></a><a name="p494814527138"></a>网络地址格式转换：将二进制格式IP地址转换为字符串格式。</p>
</td>
</tr>
<tr id="row189663017574"><td class="cellrowborder" valign="top" width="15.17%" headers="mcps1.2.4.1.1 "><p id="p335556182016"><a name="p335556182016"></a><a name="p335556182016"></a>arpa/inet.h</p>
</td>
<td class="cellrowborder" valign="top" width="50.9%" headers="mcps1.2.4.1.2 "><p id="p46417716014"><a name="p46417716014"></a><a name="p46417716014"></a>int inet_pton(int af, const char *src, void *dst)</p>
</td>
<td class="cellrowborder" valign="top" width="33.93%" headers="mcps1.2.4.1.3 "><p id="p176112713010"><a name="p176112713010"></a><a name="p176112713010"></a>网络地址格式转换：将字符串格式IP地址转换为二进制格式。</p>
</td>
</tr>
</tbody>
</table>

与标准接口差异详细说明：

-   **sendmsg**

    **函数原型：**

    ssize\_t sendmsg\(int s, const struct msghdr \*message, int flags\)

    **函数功能：**发送消息。

    **参数说明：**

    <a name="table193101953145116"></a>
    <table><thead align="left"><tr id="row13311125313516"><th class="cellrowborder" valign="top" width="19.43%" id="mcps1.1.3.1.1"><p id="p19311195312510"><a name="p19311195312510"></a><a name="p19311195312510"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="80.57%" id="mcps1.1.3.1.2"><p id="p19311205313512"><a name="p19311205313512"></a><a name="p19311205313512"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row1731175316511"><td class="cellrowborder" valign="top" width="19.43%" headers="mcps1.1.3.1.1 "><p id="p153111753125118"><a name="p153111753125118"></a><a name="p153111753125118"></a>s</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.57%" headers="mcps1.1.3.1.2 "><p id="p031165311519"><a name="p031165311519"></a><a name="p031165311519"></a>套接字描述符。</p>
    </td>
    </tr>
    <tr id="row15311185317518"><td class="cellrowborder" valign="top" width="19.43%" headers="mcps1.1.3.1.1 "><p id="p7311115319516"><a name="p7311115319516"></a><a name="p7311115319516"></a>message</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.57%" headers="mcps1.1.3.1.2 "><p id="p331125385118"><a name="p331125385118"></a><a name="p331125385118"></a>待发送的消息，不支持发送ancillary消息。</p>
    </td>
    </tr>
    <tr id="row63111753195116"><td class="cellrowborder" valign="top" width="19.43%" headers="mcps1.1.3.1.1 "><p id="p131175318519"><a name="p131175318519"></a><a name="p131175318519"></a>flags</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.57%" headers="mcps1.1.3.1.2 "><p id="p11799112211525"><a name="p11799112211525"></a><a name="p11799112211525"></a>用于指定发送消息时行为特性，有如下行为特性：</p>
    <a name="ul1179912222521"></a><a name="ul1179912222521"></a><ul id="ul1179912222521"><li>MSG_MORE：允许将多次发送的消息进行拼包发送。</li><li>MSG_DONTWAIT：非阻塞操作。</li></ul>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回：已发送的消息长度（字节数）。
    -   失败返回：-1，并设置errno。


-   **recvmsg**

    **函数原型：**

    ssize\_t recvmsg\(int s, struct msghdr \*message, int flags\)

    **函数功能：**接收消息。

    **参数说明：**

    <a name="table1847716407526"></a>
    <table><thead align="left"><tr id="row15477840185218"><th class="cellrowborder" valign="top" width="21.42%" id="mcps1.1.3.1.1"><p id="p8477104015217"><a name="p8477104015217"></a><a name="p8477104015217"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="78.58000000000001%" id="mcps1.1.3.1.2"><p id="p1447717402527"><a name="p1447717402527"></a><a name="p1447717402527"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row3477340125210"><td class="cellrowborder" valign="top" width="21.42%" headers="mcps1.1.3.1.1 "><p id="p154771740155218"><a name="p154771740155218"></a><a name="p154771740155218"></a>s</p>
    </td>
    <td class="cellrowborder" valign="top" width="78.58000000000001%" headers="mcps1.1.3.1.2 "><p id="p1347718402522"><a name="p1347718402522"></a><a name="p1347718402522"></a>套接字描述符。</p>
    </td>
    </tr>
    <tr id="row174771405527"><td class="cellrowborder" valign="top" width="21.42%" headers="mcps1.1.3.1.1 "><p id="p54771440185218"><a name="p54771440185218"></a><a name="p54771440185218"></a>message</p>
    </td>
    <td class="cellrowborder" valign="top" width="78.58000000000001%" headers="mcps1.1.3.1.2 "><p id="p5477164075215"><a name="p5477164075215"></a><a name="p5477164075215"></a>存放接收的消息，不支持接收ancillary消息。</p>
    </td>
    </tr>
    <tr id="row9477174020529"><td class="cellrowborder" valign="top" width="21.42%" headers="mcps1.1.3.1.1 "><p id="p747715404521"><a name="p747715404521"></a><a name="p747715404521"></a>flags</p>
    </td>
    <td class="cellrowborder" valign="top" width="78.58000000000001%" headers="mcps1.1.3.1.2 "><p id="p99911829531"><a name="p99911829531"></a><a name="p99911829531"></a>用于指定接收消息时行为特性，有如下行为特性：</p>
    <a name="ul1099113216538"></a><a name="ul1099113216538"></a><ul id="ul1099113216538"><li>MSG_PEEK：允许预读消息而不取走。</li><li>MSG_DONTWAIT：非阻塞操作。</li></ul>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回：已接收的消息长度（字节数）。
    -   失败返回：-1，并设置errno。


-   **ioctl**

    **函数原型：**

    int ioctl\(int s, int request, ...\)

    **函数功能：**获取或设置socket属性。

    **参数说明：**

    <a name="table1011381714533"></a>
    <table><thead align="left"><tr id="row16113161795318"><th class="cellrowborder" valign="top" width="15.25%" id="mcps1.1.3.1.1"><p id="p1811381712530"><a name="p1811381712530"></a><a name="p1811381712530"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="84.75%" id="mcps1.1.3.1.2"><p id="p20113161712534"><a name="p20113161712534"></a><a name="p20113161712534"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row18113191735318"><td class="cellrowborder" valign="top" width="15.25%" headers="mcps1.1.3.1.1 "><p id="p9113617165312"><a name="p9113617165312"></a><a name="p9113617165312"></a>s</p>
    </td>
    <td class="cellrowborder" valign="top" width="84.75%" headers="mcps1.1.3.1.2 "><p id="p16114317145314"><a name="p16114317145314"></a><a name="p16114317145314"></a>套接字描述符。</p>
    </td>
    </tr>
    <tr id="row5114121719536"><td class="cellrowborder" valign="top" width="15.25%" headers="mcps1.1.3.1.1 "><p id="p17114117185312"><a name="p17114117185312"></a><a name="p17114117185312"></a>request</p>
    </td>
    <td class="cellrowborder" valign="top" width="84.75%" headers="mcps1.1.3.1.2 "><p id="p137162040165319"><a name="p137162040165319"></a><a name="p137162040165319"></a>对socket属性要进行的操作，当前支持如下操作：</p>
    <a name="ul1671694075316"></a><a name="ul1671694075316"></a><ul id="ul1671694075316"><li>FIONREAD：获取socket当前可读取的数据大小（字节数）。</li><li>FIONBIO：设置socket是否非阻塞。</li></ul>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回：0。
    -   失败返回：-1，并设置errno。


