# 配置设备描述信息<a name="ZH-CN_TOPIC_0000001158241515"></a>

配置文件路径：./drivers/adapter/khdf/linux/hcs/device\_info/device\_info.hcs

device\_info.hcs中的信息主要提供给HDF框架使用，包含了Input模型各层驱动注册到HDF框架所必需的信息，开发者无特殊场景需求无需改动。各驱动层私有配置信息通过“deviceMatchAttr”字段与input\_config.hcs中的“match\_attr”相关内容进行匹配。

配置文件中与input模块相关的内容如下所示，相关字段的详细含义可以参考《[驱动配置](../driver/驱动开发.md)》：

```
input :: host {
            hostName = "input_host";
            priority = 100;
            device_input_manager :: device {              // Input管理层设备描述信息
                device0 :: deviceNode {
                    policy = 2;                           // 向内核用户态均发布服务
                    priority = 100;                       // input管理层驱动优先级默认为100
                    preload = 0;                          // 加载该驱动
                    permission = 0660;                    // 驱动创建设备节点权限
                    moduleName = "HDF_INPUT_MANAGER";     // 与驱动入口的moduleName匹配
                    serviceName = "hdf_input_host";       // HDF框架生成的节点名
                    deviceMatchAttr = "";                 // manager目前不需要私有配置，因此为空
                }
            }

            device_hdf_touch :: device {                  // Input公共驱动层设备描述信息
                device0 :: deviceNode {
                    policy = 2;                           // 向内核用户态均发布服务
                    priority = 120;                       // input公共驱动优先级默认为120
                    preload = 0;                          // 加载该驱动
                    permission = 0660;                    // 驱动创建设备节点权限
                    moduleName = "HDF_TOUCH";             // 与驱动入口的moduleName匹配
                    serviceName = "hdf_input_event1";     // HDF框架生成的节点名
                    deviceMatchAttr = "touch_device1";    // 与私有配置信息中的“match_attr”字段保持一致
                }
            }

            device_touch_chip :: device {                 // Input器件驱动层信息
                device0 :: deviceNode {
                    policy = 0;                           // 向内核用户态均不发布服务
                    priority = 130;                       // input器件驱动优先级默认为130
                    preload = 0;                          // 加载该驱动
                    permission = 0660;                    // 驱动创建设备节点权限
                    moduleName = "HDF_TOUCH_GT911";       // 与驱动入口的moduleName匹配
                    serviceName = "hdf_touch_gt911_service";// HDF框架生成的节点名
                    deviceMatchAttr = "zsj_gt911_5p5";    //与私有配置信息中的“match_attr”字段保持一致
                }
            }
  }
```

该配置文件中需要重点关注的字段有：

“priority”决定驱动加载顺序；

“preload”决定驱动是否加载；

“moduleName ”需要与驱动注册入口处的“moduleName ”字段保持一致；

“serviceName ”HDF框架依据该字段创建节点名；

“deviceMatchAttr ”需要与私有配置信息中的“match\_attr”字段保持一致。

通过配置设备描述信息，使得HDF框架通过moduleName与注册至驱动入口的代码相匹配，保证了驱动的正常加载，通过priority字段保证了各驱动的加载顺序。

