# 具体调用逻辑串联函数<a name="ZH-CN_TOPIC_0000001158241891"></a>

Input模型管理层驱动init函数初始化了设备管理链表，公共驱动层初始化函数完成了相关结构体的内存申请。器件驱动相关信息通过RegisterChipDevice函数对公共驱动层相关结构体进行信息填充，同时完成了相关硬件信息的初始化（如中断注册等），绑定设备与驱动组成inputDev通过RegisterInputDevice函数向驱动管理层进行注册，在RegisterInputDevice函数中主要实现了将inputDev向设备管理链表的添加等功能。如下所示为两个函数的实现部分：

```
//函数具体实现代码位置 ：./drivers/framework/model/input/driver/hdf_touch.c
int32_t RegisterChipDevice(ChipDevice *chipDev)
{
    ...
    /* 绑定设备与驱动，从而通过InputDeviceInstance函数创建inputDev */
    DeviceBindDriver(chipDev);
    ...
    /* 主要包含器件中断注册及中断处理函数,中断处理函数中有数据上报用户态的数据通道 */
    ChipDriverInit(chipDev);
    ...
    /* 申请内存实例化InputDev */
    inputDev = InputDeviceInstance(chipDev);
    ...
    /* 将InputDev设备注册至input驱动管理层 */
    RegisterInputDevice(inputDev);
    ...
}

//函数具体实现代码位置 ：./drivers/framework/model/input/driver/hdf_input_device_manager.c
int32_t RegisterInputDevice(InputDevice *inputDev)
{
    ...
    /* 申请ID，该ID对于不同input设备唯一 */
    ret = AllocDeviceID(inputDev);
    ...
    /* 该函数包含了对hid类设备的特殊处理，对于触摸屏驱动，该函数无实质操作； */
    CreateDeviceNode(inputDev);
    /* 内核态数据传送至用户态需使用IOService能力，需要申请buffer */
    AllocPackageBuffer(inputDev);
    /* 将input设备添加进设备全局管理链表 */
    AddInputDevice(inputDev);
    ...
}
```

