# 第三方开源软件引入指导

## 目的
OpenHarmony遵从 [Open Source Definition](https://opensource.org/docs/osd) ，满足这一定义的软件，被OpenHarmony社区认同为开源软件。
提供易用、高质量的开源软件是OpenHarmony的重要目标，因第三方开源软件数量多，而社区开发人员同样数量多、分布广，为确保OpenHarmony项目的整体质量，特别拟定本指南，供社区贡献者参考。

## 范围
本指导适用于所有引入到OpenHarmony项目中的第三方开源软件。

## 本文的改进和修订说明
1. 本文档由OpenHarmony PMC主导起草和维护。本文档的最新版本总可以在 [这里](https://gitee.com/openharmony/docs/blob/36955109ed21d73afe09fcb5a5bc7067ad6ce18b/zh-cn/contribute/%E7%AC%AC%E4%B8%89%E6%96%B9%E5%BC%80%E6%BA%90%E8%BD%AF%E4%BB%B6%E5%BC%95%E5%85%A5%E6%8C%87%E5%AF%BC.md) 找到。
2. 任何对于本文中涉及的规则的增加，修改，删除都必须被追踪，请进入该追踪系统 。
3. 最终规则经过社区充分的讨论后，由PMC定稿。

## 软件引入与引入原则
### 什么是软件引入
一个软件的引入指的是为满足OpenHarmony中指定SIG的业务需求，申请将其引入到OpenHarmony项目中，具体的流程请参考的[SIG管理章程](https://gitee.com/openharmony/community/tree/master/sig) 进行具体的开源软件引入，并确保整个引入的过程都必须可被追踪。

### 软件引入的基本要求
为便于第三方开源软件的维护与演进，在引入第三方开源软件时请参考如下原则：

1. 软件必须有明确的来源，引入到OpenHarmony的软件必须有清晰定义的上游社区。
2. 必须有明确的引入理由，若需要引入的软件在OpenHarmony项目中已存在，请重用该版本，避免多版本共存增加维护的复杂性。
3. 软件应该以源码方式引入，原则上二进制不应该被引入，应从源码构建。如果需要引入二进制，经由PMC评审后决定。
4. 软件应该在OpenHarmony上可以被正确构建，若该软件有尚未被引入的依赖软件，或者软件的运行或者构建依赖一个不能引入OpenHarmony的组件，需由PMC评审后决定。
5. 引入软件到OpenHarmony项目中必须将其放置到单独的代码仓或独立的目录，命名统一为third_party_软件名称，其中软件名称和其官网保持一致。
6. 应当完整保留引入软件的官方代码仓目录结构、许可证及Copyright信息，不要修改第三方开源软件的原始许可证与Copyright信息。
7. 不建议引入未发布正式版本（如只发布Beta版本）的开源软件。
8. 若需针对引入的开源软件进行修改，请将修改的代码放在该开源软件仓中，并确保满足该开源软件的许可证要求，修改的文件应当保持其原始许可证条款，新增的文件也建议采用相同的许可证条款。
9. 新引入的开源软件必须在其根目录提供README.OpenSource文件，在该文件中准确描述其软件名、许可证、许可文件位置、版本、对应版本的上游社区地址、软件的维护Owner、功能描述以及引入的原因。
10. 引入新软件到OpenHarmony时必须有对应的SIG负责管理，原则上如果没有相应SIG的确认，PMC不批准相应软件的引入。当要批量引入多个软件时，可以求助PMC主持发起SIG间的临时评审会议，提升协调效率。
如因特殊原因不能满足上述要求但又需要引入，请请联系邮箱：law@openatom.org。

### 软件引入流程
#### 软件引入前检查

| 检查点 | 说明 |
| :----- | :----- |
| 归一化 | 1、检查该软件在OpenHarmony中是否已存在，原则上一款软件只在OpenHarmony中引入一次。 |
| 来源可靠 | 1、应该从开源软件官网获取或官网指定的代码托管地址获取。 |
| 社区活跃 | 1、软件来自知名社区或组织，社区或组织通过发布公告、修改软件仓库状态、将仓库放到特定目录下等方式告知停止维护的，不建议引入。<br>2、软件来自个人、小型社区或组织，两年内未发布版本（含正式版本与测试版本），无明确版本计划，社区提交了有效的Bug或PR，但是半年以上未响应的，不建议引入。<br>3、社区运营状态不明确，通过Issue 或者邮件等方式询问社区是否继续维护，半年以上未响应或者答复停止维护的，不建议引入。|
| 规范化软件名称 | 1、 仓库命名统一为third_party_软件名称，其中软件名称和其官网保持一致。<br>2、 不允许以软件的子模块作为软件名。<br>3、 当软件是某个语言的开发库时，可以追加python-、perl-等前缀予以规范化管理。 |
| 官网信息 | 1、在申请引入请求中准确描述该软件官方网址，如无正式官网则提供主流代码托管商上面对应的项目网址，不能使用maven、mvnrepository、springsource等托管库地址。<br>2、必须同时提供要引入版本的官方源代码包下载地址，以达到可溯源，如需要二进制包，请提供官方的二进制包下载地址。 |
| License检查 | 1、待引入软件是否有license。 <br>2、入库的License是否和官网对应版本的License保持一致。<br>3、高风险license的开源软件谨慎引入，在引入前请充分评估并在申请时附上分析结论。 |

#### 提交申请

如需要引入新的软件，请参考的[SIG管理章程](https://gitee.com/openharmony/community/tree/master/sig) 进行具体的开源软件引入，并在申请材料中包含如下内容：
1、引入该软件的具体价值，被哪些仓使用解决什么问题
2、引入软件的相关信息：
1）引入的软件名称及版本
2）官网链接地址
3）软件的许可证以及引入后以什么方式使用，如静态、动态链接到哪个模块，或跨被哪个进程跨进程调用等
4）是否OpenHarmony项目已存在，如果存在要引入新版本的原因
5）该软件的社区活跃情况
3、引入该软件的具体方案：
1）引入SIG名称及责任人
2）引入后开源仓名称
3）针对该软件进行OAT扫描的结果及OAT.xml内容，对于GPL、LGPL等非开放型许可证要描述具体的使用方式
4）该仓的README.OpenSource内容

### 第三方开源软件许可证要求
1. 第三方开源软件许可证类型必须是[OSI](https://opensource.org/osd-annotated) 明确定义的。
2. 第三方开源软件许可证必须与使用该开源软件的代码仓许可证兼容。
3. 如下类型许可证可以引入到OpenHarmony项目中：
* Apache License 2.0
* Mulan Permissive Software License, Version 2
* BSD 2-clause
* BSD 3-clause
* DOM4J License
* PostgreSQL License
* Eclipse Distribution License 1.0
* MIT
* ISC
* ICU
* University of Illinois/NCSA
* W3C Software License
* zlib/libpng
* Academic Free License 3.0
* Python Software Foundation License
* Python Imaging Library Software License
* Boost Software License Version 1.0
* WTF Public License
* UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
* Zope Public License 2.0

4. 如下类型许可证不建议引入到OpenHarmony项目中:
* GNU GPL 1, 2, 3
* GNU Affero GPL 3
* GNU LGPL 2, 2.1, 3
* QPL
* Sleepycat License
* Server Side Public License (SSPL) version 1
* Code Project Open License (CPOL)
* BSD-4-Clause/BSD-4-Clause (University of California-Specific)
* Facebook BSD+Patents license
* NPL 1.0/NPL 1.1
* The Solipsistic Eclipse Public License
* The "Don't Be A Dick" Public License
* JSON License
* Binary Code License (BCL)
* Intel Simplified Software License
* JSR-275 License
* Microsoft Limited Public License
* Amazon Software License (ASL)
* Java SDK for Satori RTM license
* Redis Source Available License (RSAL)
* Booz Allen Public License
* Creative Commons Non-Commercial
* Sun Community Source License 3.0
* Common Development and Distribution Licenses: CDDL 1.0 and CDDL 1.1
* Common Public License: CPL 1.0
* Eclipse Public License: EPL 1.0
* IBM Public License: IPL 1.0
* Mozilla Public Licenses: MPL 1.0, MPL 1.1, and MPL 2.0
* Sun Public License: SPL 1.0
* Open Software License 3.0
* Erlang Public License
* UnRAR License 
* SIL Open Font License
* Ubuntu Font License Version 1.0
* IPA Font License Agreement v1.0
* Ruby License
* Eclipse Public License 2.0: EPL 2.0

如要引入其它类型License或上述（4）所列License，请联系邮箱：law@openatom.org。

## 软件退出与退出原则
### 什么是软件退出
1. 一个软件的退出指的是一个软件(项目)申请从OpenHarmony项目中删除，依照本文件描述的规则讨论，最终在OpenHarmony中移除的过程。
2. 该软件相关的SIG负责申报议题到PMC评审，管理软件退出。

### 软件退出原则
当满足以下两个条件时，OpenHarmony中软件的退出申请可以被立即执行，对应文件将从项目中直接删除。

1. 软件的License变化，或者其他法律法规影响了目前正在使用的版本，导致OpenHarmony因为法务风险，不能继续集成该软件。
2. 存在恶意代码或严重安全隐患且OpenHarmony社区无能力修复的，要求软件被立即移除。

除以上描述两种场景外，其它场景OpenHarmony对软件的退出实行过程化管理：

1. 随着技术演进与发展，软件因技术陈旧或架构落后，不能满足现有的应用场景被其他更优秀的软件所取代。
2. OpenHarmony已经集成的版本过于老旧，且软件新版本License或其他法律法规限制导致OpenHarmony不能升级新版本。
3. 软件来自知名社区或组织，社区或组织通过发布公告、修改软件仓库状态、将仓库放到特定目录下等方式告知停止维护的。
4. 软件来自个人、小型社区或组织，两年内未发布版本（含正式版本与测试版本），无明确版本计划，社区提交了有效的Bug或PR，社区半年以上未响应的。
5. 社区运营状态不明确，通过Issue或者邮件等方式询问社区是否继续维护，社区半年以上未响应或者答复停止维护的。

如果软件符合以上任何一条退出条件，PMC与相应SIG首先分析该软件在当前OpenHarmony社区中被依赖、被使用的情况。
1. 如果OpenHarmony中存在依赖关系，且短时间内不能解除，我们建议SIG新建分支代码仓，并主动进行社区维护动作。
2. 如果OpenHarmony中不存在依赖关系，或者短时间内可以解除，则责任SIG将软件从OpenHarmony正式发行中移出，并在相应的Release Notes中说明移除的原因及影响。