# 音频播放<a name="ZH-CN_TOPIC_0000001115974764"></a>

-   [导入模块](#zh-cn_topic_0000001103383404_s56d19203690d4782bfc74069abb6bd71)
-   [权限](#zh-cn_topic_0000001103383404_section11257113618419)
-   [方法](#zh-cn_topic_0000001103383404_section125675489541)
-   [createAudioPlayer\(\)](#zh-cn_topic_0000001103383404_section582314017253)
-   [附录](#zh-cn_topic_0000001103383404_section1933416317165)
-   [AudioPlayer](#zh-cn_topic_0000001103383404_section5174142818365)
    -   [属性](#zh-cn_topic_0000001103383404_section4947115405)
    -   [play\(\)](#zh-cn_topic_0000001103383404_section964512672913)
    -   [pause\(\)](#zh-cn_topic_0000001103383404_section78173258296)
    -   [stop\(\)](#zh-cn_topic_0000001103383404_section122114334296)
    -   [seek\(number\)](#zh-cn_topic_0000001103383404_section1387113816298)
    -   [setVolume\(number\)](#zh-cn_topic_0000001103383404_section164235176552)
    -   [release\(\)](#zh-cn_topic_0000001103383404_section9224621145512)
    -   [事件](#zh-cn_topic_0000001103383404_section5453721192911)
    -   [play](#zh-cn_topic_0000001103383404_section87307411494)
    -   [pause](#zh-cn_topic_0000001103383404_section198217471590)
    -   [stop](#zh-cn_topic_0000001103383404_section437616531910)
    -   [dataLoad](#zh-cn_topic_0000001103383404_section982114219106)
    -   [timeUpdate](#zh-cn_topic_0000001103383404_section13687114181014)
    -   [volumeChange](#zh-cn_topic_0000001103383404_section139227715717)
    -   [finish](#zh-cn_topic_0000001103383404_section15181321181018)
    -   [error](#zh-cn_topic_0000001103383404_section5593132921016)
-   [AudioState](#zh-cn_topic_0000001103383404_section5181155710523)

>![](public_sys-resources/icon-note.gif) **说明：** 
>由于权限问题，此部分功能在标准系统暂不可用，待更新。

## 导入模块<a name="zh-cn_topic_0000001103383404_s56d19203690d4782bfc74069abb6bd71"></a>

```
import audio from '@ohos.multimedia.media';
```

## 权限<a name="zh-cn_topic_0000001103383404_section11257113618419"></a>

无

## 方法<a name="zh-cn_topic_0000001103383404_section125675489541"></a>

## createAudioPlayer\(\)<a name="zh-cn_topic_0000001103383404_section582314017253"></a>

创建音频播放的实例来控制音频的播放。

**返回值：**

<a name="zh-cn_topic_0000001103383404_table482411406254"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row138241940172518"><th class="cellrowborder" valign="top" width="16.05%" id="mcps1.1.3.1.1"><p id="zh-cn_topic_0000001103383404_p28256407257"><a name="zh-cn_topic_0000001103383404_p28256407257"></a><a name="zh-cn_topic_0000001103383404_p28256407257"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="83.95%" id="mcps1.1.3.1.2"><p id="zh-cn_topic_0000001103383404_p1582544017256"><a name="zh-cn_topic_0000001103383404_p1582544017256"></a><a name="zh-cn_topic_0000001103383404_p1582544017256"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row0825540192520"><td class="cellrowborder" valign="top" width="16.05%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001103383404_p482574042511"><a name="zh-cn_topic_0000001103383404_p482574042511"></a><a name="zh-cn_topic_0000001103383404_p482574042511"></a><a href="#zh-cn_topic_0000001103383404_section5174142818365">AudioPlayer</a></p>
</td>
<td class="cellrowborder" valign="top" width="83.95%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001103383404_p14825194014258"><a name="zh-cn_topic_0000001103383404_p14825194014258"></a><a name="zh-cn_topic_0000001103383404_p14825194014258"></a>返回AudioPlayer类实例，失败时返回null。</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
var audioplayer = audio.createAudioPlayer(); 
```

## 附录<a name="zh-cn_topic_0000001103383404_section1933416317165"></a>

## AudioPlayer<a name="zh-cn_topic_0000001103383404_section5174142818365"></a>

音频播放器。

### 属性<a name="zh-cn_topic_0000001103383404_section4947115405"></a>

<a name="zh-cn_topic_0000001103383404_table92548495595"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row132541749175917"><th class="cellrowborder" valign="top" width="15.8015801580158%" id="mcps1.1.6.1.1"><p id="zh-cn_topic_0000001103383404_p925404965919"><a name="zh-cn_topic_0000001103383404_p925404965919"></a><a name="zh-cn_topic_0000001103383404_p925404965919"></a>名称</p>
</th>
<th class="cellrowborder" valign="top" width="19.591959195919593%" id="mcps1.1.6.1.2"><p id="zh-cn_topic_0000001103383404_p325464914599"><a name="zh-cn_topic_0000001103383404_p325464914599"></a><a name="zh-cn_topic_0000001103383404_p325464914599"></a>参数类型</p>
</th>
<th class="cellrowborder" valign="top" width="7.660766076607661%" id="mcps1.1.6.1.3"><p id="zh-cn_topic_0000001103383404_p025484918596"><a name="zh-cn_topic_0000001103383404_p025484918596"></a><a name="zh-cn_topic_0000001103383404_p025484918596"></a>可读</p>
</th>
<th class="cellrowborder" valign="top" width="8.29082908290829%" id="mcps1.1.6.1.4"><p id="zh-cn_topic_0000001103383404_p025414499590"><a name="zh-cn_topic_0000001103383404_p025414499590"></a><a name="zh-cn_topic_0000001103383404_p025414499590"></a>可写</p>
</th>
<th class="cellrowborder" valign="top" width="48.65486548654865%" id="mcps1.1.6.1.5"><p id="zh-cn_topic_0000001103383404_p20254134925912"><a name="zh-cn_topic_0000001103383404_p20254134925912"></a><a name="zh-cn_topic_0000001103383404_p20254134925912"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row18254849155915"><td class="cellrowborder" valign="top" width="15.8015801580158%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103383404_p20254204935915"><a name="zh-cn_topic_0000001103383404_p20254204935915"></a><a name="zh-cn_topic_0000001103383404_p20254204935915"></a>src</p>
</td>
<td class="cellrowborder" valign="top" width="19.591959195919593%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103383404_p1525413497591"><a name="zh-cn_topic_0000001103383404_p1525413497591"></a><a name="zh-cn_topic_0000001103383404_p1525413497591"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="7.660766076607661%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103383404_p8254749195914"><a name="zh-cn_topic_0000001103383404_p8254749195914"></a><a name="zh-cn_topic_0000001103383404_p8254749195914"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="8.29082908290829%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103383404_p5255549115910"><a name="zh-cn_topic_0000001103383404_p5255549115910"></a><a name="zh-cn_topic_0000001103383404_p5255549115910"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="48.65486548654865%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103383404_p72551449145914"><a name="zh-cn_topic_0000001103383404_p72551449145914"></a><a name="zh-cn_topic_0000001103383404_p72551449145914"></a>音频媒体URI。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row10255134945917"><td class="cellrowborder" valign="top" width="15.8015801580158%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103383404_p82551349125910"><a name="zh-cn_topic_0000001103383404_p82551349125910"></a><a name="zh-cn_topic_0000001103383404_p82551349125910"></a>loop</p>
</td>
<td class="cellrowborder" valign="top" width="19.591959195919593%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103383404_p18255154913598"><a name="zh-cn_topic_0000001103383404_p18255154913598"></a><a name="zh-cn_topic_0000001103383404_p18255154913598"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="7.660766076607661%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103383404_p525516497595"><a name="zh-cn_topic_0000001103383404_p525516497595"></a><a name="zh-cn_topic_0000001103383404_p525516497595"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="8.29082908290829%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103383404_p2025504917593"><a name="zh-cn_topic_0000001103383404_p2025504917593"></a><a name="zh-cn_topic_0000001103383404_p2025504917593"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="48.65486548654865%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103383404_p7255194925919"><a name="zh-cn_topic_0000001103383404_p7255194925919"></a><a name="zh-cn_topic_0000001103383404_p7255194925919"></a>音频循环播放属性。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row18256049165911"><td class="cellrowborder" valign="top" width="15.8015801580158%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103383404_p2256154919590"><a name="zh-cn_topic_0000001103383404_p2256154919590"></a><a name="zh-cn_topic_0000001103383404_p2256154919590"></a>currentTime</p>
</td>
<td class="cellrowborder" valign="top" width="19.591959195919593%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103383404_p10256849165915"><a name="zh-cn_topic_0000001103383404_p10256849165915"></a><a name="zh-cn_topic_0000001103383404_p10256849165915"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="7.660766076607661%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103383404_p19256149155915"><a name="zh-cn_topic_0000001103383404_p19256149155915"></a><a name="zh-cn_topic_0000001103383404_p19256149155915"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="8.29082908290829%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103383404_p3256174935919"><a name="zh-cn_topic_0000001103383404_p3256174935919"></a><a name="zh-cn_topic_0000001103383404_p3256174935919"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="48.65486548654865%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103383404_p12256144995913"><a name="zh-cn_topic_0000001103383404_p12256144995913"></a><a name="zh-cn_topic_0000001103383404_p12256144995913"></a>音频的当前播放阶段。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row11256144911598"><td class="cellrowborder" valign="top" width="15.8015801580158%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103383404_p92561949125910"><a name="zh-cn_topic_0000001103383404_p92561949125910"></a><a name="zh-cn_topic_0000001103383404_p92561949125910"></a>duration</p>
</td>
<td class="cellrowborder" valign="top" width="19.591959195919593%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103383404_p9256124914597"><a name="zh-cn_topic_0000001103383404_p9256124914597"></a><a name="zh-cn_topic_0000001103383404_p9256124914597"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="7.660766076607661%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103383404_p1725654915911"><a name="zh-cn_topic_0000001103383404_p1725654915911"></a><a name="zh-cn_topic_0000001103383404_p1725654915911"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="8.29082908290829%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103383404_p192562049125910"><a name="zh-cn_topic_0000001103383404_p192562049125910"></a><a name="zh-cn_topic_0000001103383404_p192562049125910"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="48.65486548654865%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103383404_p125684995913"><a name="zh-cn_topic_0000001103383404_p125684995913"></a><a name="zh-cn_topic_0000001103383404_p125684995913"></a>音频播放的时长。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row6256149115920"><td class="cellrowborder" valign="top" width="15.8015801580158%" headers="mcps1.1.6.1.1 "><p id="zh-cn_topic_0000001103383404_p2256144918596"><a name="zh-cn_topic_0000001103383404_p2256144918596"></a><a name="zh-cn_topic_0000001103383404_p2256144918596"></a>state</p>
</td>
<td class="cellrowborder" valign="top" width="19.591959195919593%" headers="mcps1.1.6.1.2 "><p id="zh-cn_topic_0000001103383404_p9256144918593"><a name="zh-cn_topic_0000001103383404_p9256144918593"></a><a name="zh-cn_topic_0000001103383404_p9256144918593"></a><a href="#zh-cn_topic_0000001103383404_section5181155710523">AudioState</a></p>
</td>
<td class="cellrowborder" valign="top" width="7.660766076607661%" headers="mcps1.1.6.1.3 "><p id="zh-cn_topic_0000001103383404_p102563495592"><a name="zh-cn_topic_0000001103383404_p102563495592"></a><a name="zh-cn_topic_0000001103383404_p102563495592"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="8.29082908290829%" headers="mcps1.1.6.1.4 "><p id="zh-cn_topic_0000001103383404_p625620497594"><a name="zh-cn_topic_0000001103383404_p625620497594"></a><a name="zh-cn_topic_0000001103383404_p625620497594"></a>否</p>
</td>
<td class="cellrowborder" valign="top" width="48.65486548654865%" headers="mcps1.1.6.1.5 "><p id="zh-cn_topic_0000001103383404_p162571549195920"><a name="zh-cn_topic_0000001103383404_p162571549195920"></a><a name="zh-cn_topic_0000001103383404_p162571549195920"></a>音频播放的状态。</p>
</td>
</tr>
</tbody>
</table>

### play\(\)<a name="zh-cn_topic_0000001103383404_section964512672913"></a>

开始播放音频资源。

**示例：**

```
audioplayer.src = 'common/mydream.mp3';
audioplayer.on('play', (err, action) => {
  if (err) {
     console.log(`err returned in play() callback`);
     return;
  }
  console.log('start to play');
  audioplayer.pause();
};
audioplayer.play();
```

### pause\(\)<a name="zh-cn_topic_0000001103383404_section78173258296"></a>

暂停播放音频资源。

**示例：**

```
audioplayer.src = 'common/mydream.mp3';
audioplayer.on('pause', (err, action) => {
  if (err) {
     console.log(`err returned in pause() callback`);
     return;
  }
  console.log('playback pause');
};
audioplayer.pause();
```

### stop\(\)<a name="zh-cn_topic_0000001103383404_section122114334296"></a>

停止播放音频资源。

**示例：**

```
audioplayer.src = 'common/mydream.mp3';
audioplayer.on('stop',(err, action) => {
  if (err) {
     console.log(`err returned in stop() callback`);
     return;
  }
  console.log('playback stop');
};
audioplayer.stop();
```

### seek\(number\)<a name="zh-cn_topic_0000001103383404_section1387113816298"></a>

跳转到指定播放位置。

**参数：**

<a name="zh-cn_topic_0000001103383404_table1442723852917"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row84261138172911"><th class="cellrowborder" valign="top" width="17.57%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001103383404_p204261938182919"><a name="zh-cn_topic_0000001103383404_p204261938182919"></a><a name="zh-cn_topic_0000001103383404_p204261938182919"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="12.02%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001103383404_p1342683842920"><a name="zh-cn_topic_0000001103383404_p1342683842920"></a><a name="zh-cn_topic_0000001103383404_p1342683842920"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001103383404_p134260383297"><a name="zh-cn_topic_0000001103383404_p134260383297"></a><a name="zh-cn_topic_0000001103383404_p134260383297"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="62.89%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001103383404_p442663832912"><a name="zh-cn_topic_0000001103383404_p442663832912"></a><a name="zh-cn_topic_0000001103383404_p442663832912"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row18427738202910"><td class="cellrowborder" valign="top" width="17.57%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001103383404_p184261338192913"><a name="zh-cn_topic_0000001103383404_p184261338192913"></a><a name="zh-cn_topic_0000001103383404_p184261338192913"></a>timeMs</p>
</td>
<td class="cellrowborder" valign="top" width="12.02%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001103383404_p1242643819295"><a name="zh-cn_topic_0000001103383404_p1242643819295"></a><a name="zh-cn_topic_0000001103383404_p1242643819295"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001103383404_p44261838112918"><a name="zh-cn_topic_0000001103383404_p44261838112918"></a><a name="zh-cn_topic_0000001103383404_p44261838112918"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="62.89%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001103383404_p16427163812913"><a name="zh-cn_topic_0000001103383404_p16427163812913"></a><a name="zh-cn_topic_0000001103383404_p16427163812913"></a>想要跳转到的时间点。</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
audioplayer.src = 'common/mydream.mp3';
audioplayer.on('timeupdate', (err, action) => {
  if (err) {
     console.log(`err returned in seek() callback`);
     return;
  }
  var newTime = audioplayer.currenTime;
  if(newTime = 30000) {
    console.info('Seek success, new time : ' + newTime);
  } else {
    console.info('Seek Failed');
  }
};
audioplayer.seek(30000);
```

### setVolume\(number\)<a name="zh-cn_topic_0000001103383404_section164235176552"></a>

设置音量。

**参数：**

<a name="zh-cn_topic_0000001103383404_table1242391713555"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row14424217195517"><th class="cellrowborder" valign="top" width="17.57%" id="mcps1.1.5.1.1"><p id="zh-cn_topic_0000001103383404_p1424917135519"><a name="zh-cn_topic_0000001103383404_p1424917135519"></a><a name="zh-cn_topic_0000001103383404_p1424917135519"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="12.02%" id="mcps1.1.5.1.2"><p id="zh-cn_topic_0000001103383404_p10424121795520"><a name="zh-cn_topic_0000001103383404_p10424121795520"></a><a name="zh-cn_topic_0000001103383404_p10424121795520"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.5.1.3"><p id="zh-cn_topic_0000001103383404_p1042415178559"><a name="zh-cn_topic_0000001103383404_p1042415178559"></a><a name="zh-cn_topic_0000001103383404_p1042415178559"></a>必填</p>
</th>
<th class="cellrowborder" valign="top" width="62.89%" id="mcps1.1.5.1.4"><p id="zh-cn_topic_0000001103383404_p13424717125513"><a name="zh-cn_topic_0000001103383404_p13424717125513"></a><a name="zh-cn_topic_0000001103383404_p13424717125513"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row13424171745513"><td class="cellrowborder" valign="top" width="17.57%" headers="mcps1.1.5.1.1 "><p id="zh-cn_topic_0000001103383404_p204241517125517"><a name="zh-cn_topic_0000001103383404_p204241517125517"></a><a name="zh-cn_topic_0000001103383404_p204241517125517"></a>vol</p>
</td>
<td class="cellrowborder" valign="top" width="12.02%" headers="mcps1.1.5.1.2 "><p id="zh-cn_topic_0000001103383404_p18424121755517"><a name="zh-cn_topic_0000001103383404_p18424121755517"></a><a name="zh-cn_topic_0000001103383404_p18424121755517"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.5.1.3 "><p id="zh-cn_topic_0000001103383404_p2042417176554"><a name="zh-cn_topic_0000001103383404_p2042417176554"></a><a name="zh-cn_topic_0000001103383404_p2042417176554"></a>是</p>
</td>
<td class="cellrowborder" valign="top" width="62.89%" headers="mcps1.1.5.1.4 "><p id="zh-cn_topic_0000001103383404_p9424171717557"><a name="zh-cn_topic_0000001103383404_p9424171717557"></a><a name="zh-cn_topic_0000001103383404_p9424171717557"></a>想要设置的音量值。</p>
</td>
</tr>
</tbody>
</table>

**示例：**

```
audioplayer.src = 'common/mydream.mp3';
audioplayer.on('volumeChange', (err, action) => {
  if (err) {
     console.log(`err returned in setVolume() callback`);
     return;
  }
  console.log('playback volume change');
};
audioplayer.setVolume(30);
```

### release\(\)<a name="zh-cn_topic_0000001103383404_section9224621145512"></a>

释放音频资源。

**示例：**

```
audioplay.release();
```

### 事件<a name="zh-cn_topic_0000001103383404_section5453721192911"></a>

### play<a name="zh-cn_topic_0000001103383404_section87307411494"></a>

在调用play方法后的回调事件。

### pause<a name="zh-cn_topic_0000001103383404_section198217471590"></a>

在调用pause方法后的回调事件。

### stop<a name="zh-cn_topic_0000001103383404_section437616531910"></a>

在调用stop方法后的回调事件。

### dataLoad<a name="zh-cn_topic_0000001103383404_section982114219106"></a>

在音频数据加载后的回调事件。

### timeUpdate<a name="zh-cn_topic_0000001103383404_section13687114181014"></a>

在播放时间改变后的回调事件。

### volumeChange<a name="zh-cn_topic_0000001103383404_section139227715717"></a>

在播放音量改变后的回调事件。

### finish<a name="zh-cn_topic_0000001103383404_section15181321181018"></a>

在播放完成后的回调事件。

### error<a name="zh-cn_topic_0000001103383404_section5593132921016"></a>

在播放错误时的回调事件。

<a name="zh-cn_topic_0000001103383404_table24591722143619"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row1945962219364"><th class="cellrowborder" valign="top" width="24.060000000000002%" id="mcps1.1.4.1.1"><p id="zh-cn_topic_0000001103383404_p84591522103610"><a name="zh-cn_topic_0000001103383404_p84591522103610"></a><a name="zh-cn_topic_0000001103383404_p84591522103610"></a>参数名</p>
</th>
<th class="cellrowborder" valign="top" width="25.25%" id="mcps1.1.4.1.2"><p id="zh-cn_topic_0000001103383404_p11459102243616"><a name="zh-cn_topic_0000001103383404_p11459102243616"></a><a name="zh-cn_topic_0000001103383404_p11459102243616"></a>类型</p>
</th>
<th class="cellrowborder" valign="top" width="50.690000000000005%" id="mcps1.1.4.1.3"><p id="zh-cn_topic_0000001103383404_p14591922113616"><a name="zh-cn_topic_0000001103383404_p14591922113616"></a><a name="zh-cn_topic_0000001103383404_p14591922113616"></a>说明</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row2459622183611"><td class="cellrowborder" valign="top" width="24.060000000000002%" headers="mcps1.1.4.1.1 "><p id="zh-cn_topic_0000001103383404_p17338122234119"><a name="zh-cn_topic_0000001103383404_p17338122234119"></a><a name="zh-cn_topic_0000001103383404_p17338122234119"></a>callback</p>
</td>
<td class="cellrowborder" valign="top" width="25.25%" headers="mcps1.1.4.1.2 "><p id="zh-cn_topic_0000001103383404_p174601822193612"><a name="zh-cn_topic_0000001103383404_p174601822193612"></a><a name="zh-cn_topic_0000001103383404_p174601822193612"></a>ErrorCallback</p>
</td>
<td class="cellrowborder" valign="top" width="50.690000000000005%" headers="mcps1.1.4.1.3 "><p id="zh-cn_topic_0000001103383404_p7460222123612"><a name="zh-cn_topic_0000001103383404_p7460222123612"></a><a name="zh-cn_topic_0000001103383404_p7460222123612"></a>错误事件的回调函数。</p>
</td>
</tr>
</tbody>
</table>

## AudioState<a name="zh-cn_topic_0000001103383404_section5181155710523"></a>

音频播放的状态机。

<a name="zh-cn_topic_0000001103383404_table919114616314"></a>
<table><thead align="left"><tr id="zh-cn_topic_0000001103383404_row31917610318"><th class="cellrowborder" valign="top" width="33.739999999999995%" id="mcps1.1.3.1.1"><p id="zh-cn_topic_0000001103383404_p219196531"><a name="zh-cn_topic_0000001103383404_p219196531"></a><a name="zh-cn_topic_0000001103383404_p219196531"></a>名称</p>
</th>
<th class="cellrowborder" valign="top" width="66.25999999999999%" id="mcps1.1.3.1.2"><p id="zh-cn_topic_0000001103383404_p14191563313"><a name="zh-cn_topic_0000001103383404_p14191563313"></a><a name="zh-cn_topic_0000001103383404_p14191563313"></a>描述</p>
</th>
</tr>
</thead>
<tbody><tr id="zh-cn_topic_0000001103383404_row2019146539"><td class="cellrowborder" valign="top" width="33.739999999999995%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001103383404_p201913617311"><a name="zh-cn_topic_0000001103383404_p201913617311"></a><a name="zh-cn_topic_0000001103383404_p201913617311"></a>playing</p>
</td>
<td class="cellrowborder" valign="top" width="66.25999999999999%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001103383404_p81911362316"><a name="zh-cn_topic_0000001103383404_p81911362316"></a><a name="zh-cn_topic_0000001103383404_p81911362316"></a>音频正在播放。</p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row11912612316"><td class="cellrowborder" valign="top" width="33.739999999999995%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001103383404_p9191136731"><a name="zh-cn_topic_0000001103383404_p9191136731"></a><a name="zh-cn_topic_0000001103383404_p9191136731"></a>paused</p>
</td>
<td class="cellrowborder" valign="top" width="66.25999999999999%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001103383404_p419166738"><a name="zh-cn_topic_0000001103383404_p419166738"></a><a name="zh-cn_topic_0000001103383404_p419166738"></a>音频暂停播放<span>。</span></p>
</td>
</tr>
<tr id="zh-cn_topic_0000001103383404_row111912617314"><td class="cellrowborder" valign="top" width="33.739999999999995%" headers="mcps1.1.3.1.1 "><p id="zh-cn_topic_0000001103383404_p9191156333"><a name="zh-cn_topic_0000001103383404_p9191156333"></a><a name="zh-cn_topic_0000001103383404_p9191156333"></a>stopped</p>
</td>
<td class="cellrowborder" valign="top" width="66.25999999999999%" headers="mcps1.1.3.1.2 "><p id="zh-cn_topic_0000001103383404_p2019215618316"><a name="zh-cn_topic_0000001103383404_p2019215618316"></a><a name="zh-cn_topic_0000001103383404_p2019215618316"></a>音频播放停止。</p>
</td>
</tr>
</tbody>
</table>

