# WELCOME TO OPENHARMONY
This project stores OpenHarmony documentation, including the quick start guide, development guides, and API reference. We appreciate your contribution to the OpenHarmony documentation.

## Motivation
Traditional OSs are limited to a specific type of device, while OpenHarmony provides distributed features that are compatible with a wide range of different devices. The first version supports devices with 128 KB to 128 MB of memory. Join us as we keep updating OpenHarmony versions.
For device developers, OpenHarmony utilizes a component-based design to tailor its features to better suit specific devices, based on each device's capabilities and service characteristics. OpenHarmony can run on devices with limited resources and wearables with hundreds of KB of memory, as well as more powerful devices, such as smart home cameras and dashcams with hundreds of MB of memory.

[中文版本](../zh-cn/readme.md)

## Device Development - Documentation Directory Structure
- [Getting Started](device-dev/quick-start/Readme-EN.md)
- [Source Code Acquisition/Tool Acquisition](device-dev/get-code/Readme-EN.md)
- [Kernel Usage Guidelines](device-dev/kernel/Readme-EN.md)
- [Driver Usage Guidelines](device-dev/driver/Readme-EN.md)
- [Subsystem Development Guidelines](device-dev/subsystems/Readme-EN.md)
  - [Compilation and Building](device-dev/subsystems/compilation-and-building.md)
  - [Distributed Remote Startup](device-dev/subsystems/distributed-remote-startup.md)
  - [Graphics](device-dev/subsystems/graphics.md)
  - [Multimedia](device-dev/subsystems/multimedia.md)
  - [Utils](device-dev/subsystems/utils.md)
  - [AI Framework](device-dev/subsystems/ai-framework.md)
  - [Sensors](device-dev/subsystems/sensors.md)
  - [Application Framework](device-dev/subsystems/application-framework.md)
  - [OTA Upgrade](device-dev/subsystems/ota-upgrade.md)
  - [Security](device-dev/subsystems/security.md)
  - [Startup](device-dev/subsystems/startup.md)
  - [Testing](device-dev/subsystems/testing.md)
  - [DFX](device-dev/subsystems/dfx.md)
  - [R&D Tools](device-dev/subsystems/r-d-tools.md)
  - [X Test Suite](device-dev/subsystems/xts.md)
- [Bundle Development Guidelines](device-dev/bundles/Readme-EN.md)
- [Third-Party Library Porting Guide](device-dev/porting/Readme-EN.md)
- [Device Development Guidelines](device-dev/guide/Readme-EN.md) 
  - [WLAN-connected Products](device-dev/guide/wlan-connected-products.md)
  - [Cameras Without a Screen](device-dev/guide/cameras-without-a-screen.md)
  - [Cameras with a Screen](device-dev/guide/cameras-with-a-screen.md)
  - [Visual Application Development](device-dev/guide/visual-application-development.md)
  - [Development Example for Clock Apps](device-dev/guide/development-example-for-clock-apps.md)
  - [Development Example for Platform Drivers](device-dev/guide/development-example-for-platform-drivers.md)
  - [Development Example for Peripheral Drivers](device-dev/guide/development-example-for-peripheral-drivers.md)
- [Privacy and Security](device-dev/security/Readme-EN.md)
- [Glossary](device-dev/glossary/glossary.md)

# Application Development - Documentation Directory Structure

-   [Getting Started](application-dev/quick-start/getting-started.md)
-   [UI](application-dev/ui/Readme-EN.md)
-   [Media](application-dev/media/Readme-EN.md)
-   [Connectivity](application-dev/connectivity/Readme-EN.md)
-   [JS Reference](application-dev/js-reference/Readme-EN.md)

## Start Contributing

OpenHarmony is an open-source community and encourages everyone in the community to submit patches directly to the project. You can contribute either to the code or documentation.
- [Contributing to the Code](contribute/contributing-code.md)
- [Contributing to the Documentation](contribute/documentation-contribution.md)

For more details on how to contribute, see [Contributing Documents](contribute).
## Get Source Code and Tools
To download the source code and tools required for the project, click the following links:
- [Source Code Acquisition](device-dev/get-code/source-code-acquisition.md)
- [Tool Acquisition](device-dev/get-code/tool-acquisition.md)

## Where to Turn for Help
You can subscribe to the mailing list to get constant updates on new features, released road maps, and community activities. For how to subscribe to the mailing list or get any other support, see [Communication in Community](https://gitee.com/openharmony/docs/tree/master/contribute/communication-in-community.md).

## Code of Conduct
OpenHarmony is committed to providing a welcoming and inspiring community for all. In order to maintain a collaborative environment, we recommend you read and follow the community [Code of Conduct](https://gitee.com/openharmony/docs/blob/master/contribute/code-of-conduct.md). 

## Contributors & Acknowledgements
A great open-source project wouldn't be possible without the hard work of many contributors. We'd like to invite anyone from around the world to participate in this exciting journey, and we're grateful for your time, passion, and efforts!

## Release
In order to provide new features and bug fixes, the community constantly updates code and provides new releases.

See [OpenHarmony Release Notes](release-notes/OpenHarmony-Release-Notes.md).