# 分布式数据管理子系统<a name="ZH-CN_TOPIC_0000001096920663"></a>

-   [简介](#section11660541593)
-   [目录](#section161941989596)
-   [组件说明](#section1312121216216)
    -   [分布式数据对象](#section129654513264)
    -   [数据共享](#section1961602912224)
    -   [分布式数据服务](#section1961602912225)
    -   [首选项](#section1961602912226)
    -   [关系型数据库](#section1961602912227)


-   [相关仓](#section1371113476307)

## 简介<a name="section11660541593"></a>

**子系统介绍**

分布式数据管理子系统支持单设备的各种结构化数据的持久化，以及跨设备之间数据的同步、共享功能。开发者通过分布式数据管理子系统，能够方便地完成应用程序数据在不同终端设备间的无缝衔接，满足用户跨设备使用数据的一致性体验。


**子系统架构**

**图 1**  子系统架构图<a name="fig4460722185514"></a>


![](figures/数据管理子系统架构图.png)

## 目录<a name="section161941989596"></a>

子系统1-2层目录描述

```
distributeddatamgr/         # 子系统目录
├── data_object             # 分布式数据对象目录
└── data_share              # 数据共享目录
└── datamgr_service         # 数据服务目录
└── kv_store                # Key-Value数据库目录
└── preferences             # 首选项目录
└── relational_store        # 关系型数据库目录

third_party/                # 开源软件目录
├── flatbuffers             # flatbuffers代码目录
└── sqlite                  # SQLite代码目录
```

## 组件说明<a name="section1312121216216"></a>

### 分布式数据对象<a name="section129654513264"></a>

分布式数据对象管理框架是一款面向对象的内存数据管理框架，向应用开发者提供内存对象的创建、查询、删除、修改、订阅等基本数据对象的管理能力，同时具备分布式能力，满足超级终端场景下，相同应用多设备间的数据对象协同需求。

分布式数据对象提供JS接口，让开发者能以使用本地对象的方式使用分布式对象。分布式数据对象支持的数据类型包括数字型、字符型、布尔型等基本类型，同时也支持数组、基本类型嵌套等复杂类型。

### 数据共享<a name="section1961602912224"></a>

**数据共享（Data Share）** 提供了向其他应用共享以及管理其数据的方法，支持同个设备上不同应用之间的数据共享。

### 分布式数据服务<a name="section1961602912225"></a>

分布式数据服务（Distributed Data Service，DDS） 提供不同设备间数据库数据分布式的能力。通过结合帐号、应用和数据库三元组，分布式数据服务对数据进行隔离。在通过可信认证的设备间，分布式数据服务支持数据相互同步，为用户提供在多种终端设备上一致的数据访问体验。

### 首选项<a name="section1961602912226"></a>

**首选项（Preferences）** 主要提供轻量级Key-Value操作，支持本地应用存储少量数据，数据存储在本地文件中，同时也加载在内存中，所以访问速度更快，效率更高。首选项提供非关系型数据存储，不宜存储大量数据，经常用于操作键值对形式数据的场景。

1.  本模块提供首选项的操作类，应用通过这些操作类完成首选项操作。
2.  借助getPreferences，可以将指定文件的内容加载到Preferences实例，每个文件最多有一个Preferences实例，系统会通过静态容器将该实例存储在内存中，直到主动从内存中移除该实例或者删除该文件。
3.  获取Preferences实例后，可以借助Preferences类的函数，从Preferences实例中读取数据或者将数据写入Preferences实例，通过flush将Preferences实例持久化。

### 关系型数据库<a name="section1961602912227"></a>

**关系型数据库（Relational Database，RDB）** 是一种基于关系模型来管理数据的数据库。OpenHarmony关系型数据库基于SQLite组件提供了一套完整的对本地数据库进行管理的机制。

OpenHarmony关系型数据库底层使用SQLite作为持久化存储引擎，支持SQLite具有的所有数据库特性，包括但不限于事务、索引、视图、触发器、外键、参数化查询和预编译SQL语句。



## 相关仓<a name="section1371113476307"></a>

分布式数据管理子系统

[distributeddatamgr\_data_object](https://gitee.com/openharmony/distributeddatamgr_data_object)

[distributeddatamgr\_data_share](https://gitee.com/openharmony/distributeddatamgr_data_share)

[distributeddatamgr\_preferences](https://gitee.com/openharmony/distributeddatamgr_preferences)

[distributeddatamgr\_relational_store](https://gitee.com/openharmony/distributeddatamgr_relational_store)

[distributeddatamgr\_kv_store](https://gitee.com/openharmony/distributeddatamgr_kv_store)

[third\_party\_sqlite](https://gitee.com/openharmony/third_party_sqlite)

[third\_party\_flatbuffers](https://gitee.com/openharmony/third_party_flatbuffers)