# 概述


OpenHarmony安全子系统目前提供给开发者的安全能力主要包含应用可信、权限管理、设备可信。涉及以下几个模块：


- 应用验签

  为了确保应用内容的完整性，系统通过应用签名和Profile对应用的来源进行管控，同时对于调试应用，还可通过验签接口验证应用和设备的UDID是否匹配，确保应用安装在了正确的设备上。

- 应用权限管理

  应用权限是管理应用访问系统资源和使用系统能力的一种通用方式，应用在开发阶段需要在profile.json中指明此应用在运行过程中可能会调用哪些权限，其中静态权限表示只需要在安装阶段注册就可以，而动态权限一般表示涉及到敏感信息，所以需要用户进行动态授权。

- IPC通信鉴权

  系统服务通过IPC跨进程方式开放的接口，需要对接口调用者进行鉴权操作。在Samgr中注册的系统服务，可以通过进程间通信的方式暴露接口给其他进程访问，同时需要配置相应的访问策略，当其他进程访问这些接口时，将会触发IPC通信鉴权机制校验访问进程是否拥有权限访问该接口，若无权限，则访问会被拒绝。

- 设备安全等级管理

  OpenHarmony设备安全等级管理（DSLM）模块，负责管理各种不同形态和种类的OpenHarmony设备的设备安全等级。对于OpenHarmony中的各类分布式业务，当其对各类用户数据进行流转或处理的时候，可以调用本模块提供的接口获取相关目标设备的安全等级，并根据获取到的等级进行相应的处理。

- OpenHarmony通用密钥库

  通用密钥库（HUKS）提供系统级的密钥管理能力，实现密钥全生命周期（生成、存储、使用、销毁）的管理和安全使用，满足生态应用和上层业务的诉求。上层应用可以通过调用本模块提供的接口执行密钥操作，同时明文密钥的存储和使用不能出现在非安全环境中，需要保证在安全环境中使用。


## 基本概念

在进行依赖验签组件的应用开发前，开发者应了解以下基本概念：

- Samgr

  Samgr(System Ability Manager)系统能力管理，在OpenHarmony上作为一个管理系统能力的模块，详见系统服务框架子系统。

- BMS

  BMS(Bundle Manager Service)包管理管理，在OpenHarmony上主要负责应用的安装、卸载和数据管理。

- 授权文件

  本文中的授权文件，指HarmonyAppProvision，简称profile。HarmonyAppProvision采用json文件格式进行描述。

- 调试应用

  指开发者从应用市场申请调试证书与调试授权文件，并以此签名的hap包。

- 发布应用

  指开发者从应用市场申请发布证书与发布授权文件，以此签名的hap包，上传至应用市场，并由应用市场正式发布的hap包。

- OpenHarmony签名应用

  OpenHarmony开源了一个根CA的证书和密钥，以此根CA签发的签名证书和授权文件签名的应用。


## 约束与限制

- 仅支持以下三类应用的验签：应用市场调试应用、应用市场发布应用、OpenHarmony签名应用。

- 若对应用市场调试应用验签，则本机UDID需要在授权文件授权调试的UDID列表中。
