# subsystems

- 编译构建
    - [编译构建指导](subsys-build-all.md)
    - [构建系统编码规范与最佳实践](subsys-build-gn-coding-style-and-best-practice.md)
    - [编译构建Kconfig可视化配置指导](subsys-build-gn-kconfig-visual-config-guide.md)
    - 编译构建相关操作
      - [产品配置规则](subsys-build-product.md#产品配置规则)
      - [子系统配置规则](subsys-build-subsystem.md#子系统配置规则)
      - [部件配置规则](subsys-build-component.md#部件配置规则)
      - [模块配置规则](subsys-build-module.md#模块配置规则)
      - [芯片解决方案配置规则](subsys-build-chip_solution.md#芯片解决方案配置规则)
      - [特性配置规则](subsys-build-feature.md#特性配置规则)
      - [系统能力配置规则](subsys-build-syscap.md#如何按需配置部件的系统能力)
      - [关于deps、external_deps的使用](subsys-build-reference.md#关于deps、external_deps的使用)
      - [开源软件Notice收集策略说明](subsys-build-reference.md#开源软件notice收集策略说明)
      - [加快本地编译的一些参数](subsys-build-reference.md#加快本地编译的一些参数)
      - [查看NinjaTrace](subsys-build-reference.md#查看ninjatrace)
      - [HAP编译构建指导](subsys-build-gn-hap-compilation-guide.md)
      - [ 常见问题](subsys-build-FAQ.md)
- [分布式远程启动](subsys-remote-start.md)
- 图形图像
    - [图形图像概述](subsys-graphics-overview.md)
    - [容器类组件开发指导](subsys-graphics-container-guide.md)
    - [布局容器类组件开发指导](subsys-graphics-layout-guide.md)
    - [普通组件开发指导](subsys-graphics-common-guide.md)
    - [动画开发指导](subsys-graphics-animation-guide.md)
- 媒体
    - 相机
        - [相机开发概述](subsys-multimedia-camera-overview.md)
        - [拍照开发指导](subsys-multimedia-camera-photo-guide.md)
        - [录像开发指导](subsys-multimedia-camera-record-guide.md)
        - [预览开发指导](subsys-multimedia-camera-preview-guide.md)
    - 音视频
        - [音视频开发概述](subsys-multimedia-video-overview.md)
        - [音视频播放开发指导](subsys-multimedia-video-play-guide.md)
        - [音视频录制开发指导](subsys-multimedia-video-record-guide.md)
- 公共基础
    - [公共基础库概述](subsys-utils-overview.md)
    - [公共基础库开发指导](subsys-utils-guide.md)
    - [公共基础库常见问题](subsys-utils-faqs.md)
- [AI框架开发指导](subsys-ai-aiframework-devguide.md)
- 数据管理
    - 关系型数据库
      - [关系型数据库概述](subsys-data-relational-database-overview.md)
      - [关系型数据库开发指导](subsys-data-relational-database-guide.md)
    - 轻量级数据存储
      - [轻量级数据存储概述](subsys-data-storage-overview.md)
      - [轻量级数据存储开发指导](subsys-data-storage-guide.md)
- Sensor服务
    - [Sensor服务概述](subsys-sensor-overview.md)
    - [Sensor服务使用指导](subsys-sensor-guide.md)
    - [Sensor服务使用实例](subsys-sensor-demo.md)
- USB服务
    - [USB服务概述](subsys-usbservice-overview.md)
    - [USB服务使用指导](subsys-usbservice-guide.md)
    - [USB服务使用实例](subsys-usbservice-demo.md)
- 用户程序框架
    - [概述](subsys-application-framework-overview.md)
    - [搭建环境](subsys-application-framework-envbuild.md)
    - [开发指导](subsys-application-framework-guide.md)
    - [开发实例](subsys-application-framework-demo.md)
- [OTA升级](subsys-ota-guide.md)
- 电话服务
    - [电话服务概述](subsys-tel-overview.md)
    - [电话服务开发指导](subsys-tel-guide.md)
- 安全
    - [概述](subsys-security-overview.md)
    - [应用验签开发指导](subsys-security-sigverify.md)
    - [应用权限管理开发指导](subsys-security-rightmanagement.md)
    - [IPC通信鉴权开发指导](subsys-security-communicationverify.md)
    - [设备安全等级管理开发指导](subsys-security-devicesecuritylevel.md)
    - [OpenHarmony通用密钥库系统开发指导](subsys-security-huks-guide.md)
    - [应用特权配置指导](subsys-app-privilege-config-guide.md)
    - [预置应用配置指导](subsys-preinstall-app-config-guide.md)
- 启动恢复
    - [启动恢复子系统概述](subsys-boot-overview.md)
    - init启动引导组件
      - [引导启动配置文件](subsys-boot-init-cfg.md)
      - [jobs管理](subsys-boot-init-jobs.md)
      - [服务管理](subsys-boot-init-service.md)
      - [系统参数](subsys-boot-init-sysparam.md)
      - [沙盒管理](subsys-boot-init-sandbox.md)
      - [插件](subsys-boot-init-plugin.md)
    - [appspawn应用孵化组件](subsys-boot-appspawn.md)
    - [bootstrap服务启动组件](subsys-boot-bootstrap.md)
    - [常见问题](subsys-boot-faqs.md)
    - [参考](subsys-boot-ref.md)
- [测试用例开发指导](subsys-testguide-test.md)
- DFX
    - [DFX概述](subsys-dfx-overview.md)
    - [HiLog开发指导](subsys-dfx-hilog-rich.md)
    - [HiLog_Lite开发指导](subsys-dfx-hilog-lite.md)
    - [HiTrace开发指导](subsys-dfx-hitrace.md)
    - [HiCollie开发指导](subsys-dfx-hicollie.md)
    - HiSysEvent开发指导
        - [HiSysEvent概述](subsys-dfx-hisysevent-overview.md)
        - [HiSysEvent打点配置指导](subsys-dfx-hisysevent-logging-config.md)
        - [HiSysEvent打点指导](subsys-dfx-hisysevent-logging.md)
        - [HiSysEvent订阅指导](subsys-dfx-hisysevent-listening.md)
        - [HiSysEvent查询指导](subsys-dfx-hisysevent-query.md)
        - [HiSysEvent工具使用指导](subsys-dfx-hisysevent-tool.md)
    - [HiDumper开发指导](subsys-dfx-hidumper.md)
    - [HiChecker开发指导](subsys-dfx-hichecker.md)
    - [Faultlogger开发指导](subsys-dfx-faultlogger.md)
    - [Hiview开发指导](subsys-dfx-hiview.md)
- 调测工具
    - [bytrace使用指导](subsys-toolchain-bytrace-guide.md)
    - [hdc_std使用指导](subsys-toolchain-hdc-guide.md)
    - [hiperf使用指导](subsys-toolchain-hiperf.md)
- [XTS测试用例开发指导](subsys-xts-guide.md)
