# 写作规范<a name="ZH-CN_TOPIC_0000001053707964"></a>

本文介绍OpenHarmony文档贡献的写作规范。

## 命名规范<a name="section6823246189"></a>

如需提交新的文档，在Gitee上工程代码doc目录下创建新的.md文件，命名需遵循xxx-xxx.md格式，根据文档的内容来声明。

比如介绍写作规范的文档，可以命名为write-standard.md。

## 内容规范<a name="section650663210183"></a>

以简洁、直观地表达所述内容为目的，介绍性文档言简意赅介绍原理、架构、设计思路等，操作类文档写明关键步骤，以便能对其他开发者起到帮助。可以优先使用中文，建议中英文都支持，OpenHarmony也将持续更新，保证中英文的同步。

**标题**

建议标题层级不超过三级。

操作类文档标题尽量用动宾结构，执行的主体要描述清楚。（例如：申请权限）

**正文**

**操作类文档**以移植为例，文档结构可以参考如下：

-   目的（简述操作目的，如移植到哪款型号的单板）

-   软硬件环境准备

-   移植具体步骤

-   结果验证

    步骤写作要求：

    -   步骤里涉及的接口在前面开放能力介绍里有说明。
    -   如果操作可选，要明确可选条件。
    -   每一个开发步骤，如果涉及接口调用，需要清晰给出使用的接口及其使用说明，或给出示例代码。


**介绍性文档**以开发指南某一功能为例，文档结构可以参考如下：

-   概述（概念及原理介绍）

-   功能（支持的接口列表）

-   开发流程（如何使用及相应步骤）

-   编程实例（提供具体代码示例）

-   注意事项


**图片**

图片统一存放到文档同级目录下的pic文件夹中（英文文档对应pic-en），如：

“OpenHarmony\_DOCUMENTS/docs/quick-start/write-standard.md”中使用的图片，统一放置到

“OpenHarmony\_DOCUMENTS/docs/quick-start/pic”目录下，文档中使用相对路径引用图片。

>![](public_sys-resources/icon-caution.gif) **注意**：
>请使用原创图片，避免存在知识产权侵权风险。

-   图形清晰可辨识，图形信息完整，如流程图有“开始”和“结束”。
-   图形逻辑清晰，图文配合使用，切忌图文分离。
-   图片高度建议在640px左右、宽度不超过820px、图片一般为.png格式，大小不超过150K。
-   中文用中文图，英文用英文图形。
-   图片建议根据内容命名，只用数字序列不利于后续图片的继承。

>![](public_sys-resources/icon-note.gif) **说明**：
>引用方式：
>!\[\]\(./pic/pic-standard.png\)

如果是自制图片，配色请参考如下，格式不限png/jpg/gif...均可。

**图 1**  配色示例<a name="fig952595173513"></a>  
![](figures/配色示例.png "配色示例")

如果是截图请参考如下，如需突出图形中的关键信息，可增加红色框线或者文字备注说明。

线条宽度：0.75pt

线条颜色：CE0E2D

中文字体：微软雅黑

英文字体：首选Arial

字体大小：10pt

**图 2**  截图示例<a name="fig1472123913217"></a>  
![](figures/截图示例.png "截图示例")

**表格**

在md中可以按照如下形式插入表格。

Input

```
| Tables      | Type          | Note  |
| ----------- |:-------------:| -----:|
| first       | standard      |  None |
| second      | outstanding   |     5 |
| third       | inside        |  with |
```

Output

**表 1**  参数表

| Tables      | Type          | Note  |
| ----------- |:-------------:| -----:|
| first       | standard      |  None |
| second      | outstanding   |     5 |
| third       | inside        |  with |


**代码**

代码示例说明了如何实现特定功能，开发人员使用代码示例来编写和调试代码。代码要求如下：

-   代码的逻辑和语法正确
-   如果有返回值，也一并描述
-   保证代码中关键段用粗体突出显示，关键步骤要有注释说明

