# 延迟任务调度概述

延迟任务调度给应用提供一个机制，允许应用根据系统安排，在系统空闲时执行实时性不高的任务。当满足设定条件的时候，任务会被放入待调度队列，当系统空闲时调度该任务。

## 使用说明

应用要执行对实时性要求不高的任务的时候，比如设备空闲时候做一次数据学习等场景，可以使用延迟调度任务，该机制在满足应用设定条件的时候，会根据系统当前状态，如内存、功耗、温度等统一决策调度时机。

## 延迟任务调度约束

延迟调度任务的使用需要遵从如下约束和规则：

- **超时**：系统会设置超时机制，延迟任务回调只允许运行一段时间，超时之后，系统会主动停止。默认的超时限制为2分钟，对于系统应用，可以通过[能效资源申请接口](background-task-overview.md#能效资源申请)获取更长的执行时间（充电状态20分钟，非充电状态10分钟）。
- **执行频率**：系统会根据应用的活跃度对延迟任务做分级管控，限制延迟任务调度的执行频率。对于通过能效资源接口申请了WORK_SCHEDULER资源的应用，在资源的有效期内，它的延迟任务执行频率不受限制。

应用分组             |     延迟任务执行频率约束                            
--------------------|-------------------------
活跃 | 最小间隔2小时
每日使用 | 最小间隔4小时 
经常使用 | 最小间隔24小时 
不经常使用 | 最小间隔48小时 
受限分组 | 禁止 
未使用分组 | 禁止 
[能效资源豁免分组](../reference/apis/js-apis-backgroundTaskManager.md#resourcetype9)  | 执行频率不受限制

- **WorkInfo设置参数约束** 

（1） workId、bundleName、abilityName为必填项，bundleName必须填本应用，否则校验失败。

（2）至少要设置一个满足的条件。

（3）重复任务时间间隔至少20分钟，当设置重复任务时间间隔时，必须设置始终重复和重复次数中的一个。

（4）携带参数信息支持number、string、bool三种类型。