# 通用属性

> **说明：**
>
>从API Version 8 开始支持。后续版本如有新增内容，则采用上角标单独标记该内容的起始版本。

## 常规属性

常规属性指的是组件普遍支持的用来设置组件基本标识和外观显示特征的属性。

| 名称 | 类型 | 默认值 | 必填 | 描述 |
| -------- | -------- | -------- | -------- | -------- |
| id | string | - | 否 | 组件的唯一标识。 |
| style | string | - | 否 | 组件的样式声明。 |
| class | string | - | 否 | 组件的样式类，用于引用样式表。 |
| ref | string | - | 否 | 用来指定指向子元素或子组件的引用信息，该引用将注册到父组件的$refs&nbsp;属性对象上。 |
| disabled | boolean | false | 否 | 当前组件是否被禁用，在禁用场景下，组件将无法响应用户交互。 |
| dir | string | auto | 否 | 设置元素布局模式，支持设置rtl、ltr和auto三种属性值：<br/>-&nbsp;"rtl"：使用从右往左布局模式。<br/>-&nbsp;"ltr"：使用从左往右布局模式。<br/>-&nbsp;"auto"：跟随系统语言环境。 |


## 渲染属性

组件普遍支持的用来设置组件是否渲染的属性。

| 名称 | 类型 | 默认值 | 描述 |
| -------- | -------- | -------- | -------- |
| for | Array | - | 根据设置的数据列表，展开当前元素。 |
| if | boolean | - | 根据设置的boolean值，添加或移除当前元素。 |
| show | boolean | - | 根据设置的boolean值，显示或隐藏当前元素。 |

>  **说明：**
> 属性和样式不能混用，不能在属性字段中进行样式设置。
