# 原子布局

在屏幕形态和规格不同等情况下，布局效果需要实现自适应，因此系统提供了面向不同屏幕尺寸的自适应布局能力，称为原子布局。设计师可以考虑使用原子能力，定义元素在不同形态的尺寸界面上体现的自适应规则。开发者可以使用原子布局能力，快速实现让应用在多形态屏幕上有与设计效果相匹配的自适应效果。


>  **说明：**
>
>  从API Version 8 开始支持。后续版本如有新增内容，则采用上角标单独标记该内容的起始版本。


## 隐藏能力

在非折行flex布局基础上，增加了显示优先级标记，可以调整组件内元素水平/垂直方向的显示优先级，根据当前组件容器的可用空间来显示内容。

| 样式            | 类型     | 默认值  | 说明                                       |
| ------------- | ------ | ---- | ---------------------------------------- |
| display-index | number | 0    | 适用于div等支持flex布局的容器组件中的子组件上，当容器组件在flex主轴上尺寸不足以显示全部内容时，按照display-index值从小到大的顺序进行隐藏，具有相同display-index值的组件同时隐藏，默认值为0，表示隐藏。 |


## 占比能力

在非折行的flex布局中，定义了占比能力的组件，保证指定元素始终在容器的某一个比例空间中进行布局。

| 样式          | 类型     | 默认值  | 说明                                       |
| ----------- | ------ | ---- | ---------------------------------------- |
| flex-weight | number | -    | 指明当前元素在flex主轴方向上尺寸权值，当且仅当容器组件中所有节点均设置此属性时生效，当前元素尺寸为：&nbsp;容器主轴尺寸&nbsp;\*&nbsp;当前权值&nbsp;/&nbsp;所有子元素权值和。 |


## 固定比例

定义了组件固定比例调整尺寸的能力。

| 样式           | 类型     | 默认值  | 说明                                       |
| ------------ | ------ | ---- | ---------------------------------------- |
| aspect-ratio | number | -    | &nbsp;接受任意大于0的浮点值，定义为该节点的宽度与高度比，设置该属性后，该元素尺寸宽高比按照此属性值进行调整。<br/>&nbsp;遵守最大值与最小值的限制。<br/>&nbsp;在flex布局中，主轴尺寸先进行调整，后根据该尺寸调整交叉轴。 |
