# 点击事件

点击事件指组件被点击时触发的事件。

>  **说明：**
>
>  从API Version 7开始支持。后续版本如有新增内容，则采用上角标单独标记该内容的起始版本。


## 事件

| 名称                                       | 支持冒泡 | 功能描述                              |
| ---------------------------------------- | ---- | --------------------------------- |
| onClick(event:&nbsp;(event?:&nbsp;ClickEvent)&nbsp;=&gt;&nbsp;void) | 否    | 点击动作触发该方法调用，event参数见ClickEvent介绍。 |

## ClickEvent对象说明
| 属性名称            | 类型                                 | 描述                                                     |
| ------------------- | ------------------------------------ | -------------------------------------------------------- |
| screenX             | number                               | 点击点相对于应用窗口左上角的X坐标。                      |
| screenY             | number                               | 点击点相对于应用窗口左上角的Y坐标。                      |
| x                   | number                               | 点击点相对于被点击元素左上角的X坐标。                    |
| y                   | number                               | 点击点相对于被点击元素左上角的Y坐标。                    |
| target<sup>8+</sup> | [EventTarget](#eventtarget8对象说明) | 被点击元素对象。                                         |
| timestamp           | number                               | 事件时间戳。触发事件时距离系统启动的时间间隔，单位纳秒。 |

## EventTarget<sup>8+</sup>对象说明

| 名称   | 参数类型                      | 描述         |
| ---- | ------------------------- | ---------- |
| area | [Area](ts-types.md#area8) | 目标元素的区域信息。 |



## 示例

```ts
// xxx.ets
@Entry
@Component
struct ClickExample {
  @State text: string = ''

  build() {
    Column() {
      Button('Click').backgroundColor(0x2788D9).width(100).height(40)
        .onClick((event: ClickEvent) => {
          console.info(this.text = 'Click Point:' + '\n  screenX:' + event.screenX + '\n  screenY:' + event.screenY
          + '\n  x:' + event.x + '\n  y:' + event.y + '\ntarget:' + '\n  component globalPos:('
          + event.target.area.globalPosition.x + ',' + event.target.area.globalPosition.y + ')\n  width:'
          + event.target.area.width + '\n  height:' + event.target.area.height)
        })
      Text(this.text).padding(15)
    }.height(350).width('100%').padding(10)
  }
}
```


![zh-cn_image_0000001210353788](figures/zh-cn_image_0000001210353788.gif)
