# 线性容器Vector

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 本模块首批接口从API version 8开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。

Vector是一种线性数据结构，底层基于数组实现。当Vector的内存用尽时，会自动分配更大的连续内存区，将原先的元素复制到新的内存区，并释放旧的内存区。使用Vector能够高效快速地访问元素。

Vector和[ArrayList](js-apis-arraylist.md)相似，都是基于数组实现，但Vector提供了更多操作数组的接口。它们都可以动态调整容量，但Vector每次扩容增加1倍，ArrayList只扩容0.5倍。

**推荐使用场景：** 当数据量大时，一般使用Vector来存取数据。

文档中存在泛型的使用,涉及以下泛型标记符:<br>
- T: Type, 类

## 导入模块

```ts
import Vector from '@ohos.util.Vector';  
```


## Vector

### 属性

**系统能力：** SystemCapability.Utils.Lang

| 名称 | 参数类型 | 可读 | 可写 | 说明 |
| -------- | -------- | -------- | -------- | -------- |
| length | number | 是 | 否 | Vector的元素个数。 |


### constructor

constructor()

Vector的构造函数。

**系统能力：** SystemCapability.Utils.Lang

**示例：**

```ts
let vector = new Vector();
```


### add

add(element: T): boolean

在Vector中尾部插入元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 添加进去的元素。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| boolean | 插入成功返回true,失败返回false。 |

**示例：**

```ts
let vector = new Vector();
let result = vector.add("a");
let result1 = vector.add(1);
let b = [1, 2, 3];
vector.add(b);
let c = {name : "Dylon", age : "13"};
let result3 = vector.add(c);
```

### insert

insert(element: T, index: number): void

在长度范围内任意插入指定元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 被插入的元素。 |
| index | number | 是 | 被插入的位置索引。 |

**示例：**

```ts
let vector = new Vector();
vector.insert("A", 0);
vector.insert(0, 1);
vector.insert(true, 2);
```

### has

has(element: T): boolean

判断此Vector中是否含有该指定元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 指定的元素。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| boolean | 是否包含指定元素。 |

**示例：**

```ts
let vector = new Vector();
let result = vector.has("squirrel");
vector.add("squirrel");
let result1 = vector.has("squirrel");
```

### getIndexOf

getIndexOf(element: T): number

返回指定元素第一次出现时的下标值，查找失败返回-1。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 指定的元素。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| number | 返回指定元素第一次出现时的下标值，查找失败返回-1。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(2);
vector.add(1);
vector.add(2);
vector.add(4);
let result = vector.getIndexOf(2);
```

### getLastIndexOf

getLastIndexOf(element: T): number

返回指定元素最后一次出现时的下标值，查找失败返回-1。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 指定元素。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| number | 返回指定元素最后一次出现时的下标值，查找失败返回-1。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(2);
vector.add(1);
vector.add(2);
vector.add(4);
let result = vector.getLastIndexOf(2);
```

### removeByIndex

removeByIndex(index: number): T

根据元素的下标值查找元素，返回元素后将其删除。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| index | number | 是 | 指定元素的下标值。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| T | 返回删除的元素。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(2);
vector.add(4);
let result = vector.removeByIndex(2);
```

### remove

remove(element: T): boolean

删除查找到的第一个指定的元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 指定元素。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| boolean | 删除成功返回true，否则返回false。 |

**返回值：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.remove(2);
```

### removeByRange

removeByRange(fromIndex: number, toIndex: number): void

从一段范围内删除元素，包括起始值但不包括终止值。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| fromIndex | number | 是 | 起始下标。 |
| toIndex | number | 是 | 终止下标。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.removeByRange(2,4);
vector.removeByRange(4,3);
vector.removeByRange(2,6);
```

### replaceAllElements

replaceAllElements(callbackfn: (value: T, index?: number, vector?: Vector&lt;T&gt;) => T,
thisArg?: Object): void

用户操作Vector中的元素，用操作后的元素替换原元素并返回操作后的元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| callbackfn | function | 是 | 回调函数。 |
| thisArg | Object | 否 | callbackfn被调用时用作this值。 |

callbackfn的参数说明：

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| value | T | 是 | 当前遍历到的元素。 |
| index | number | 否 | 当前遍历到的下标值。 |
| vector | Vector&lt;T&gt; | 否 | 当前调用replaceAllElements方法的实例对象。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.replaceAllElements((value: number, index: number) => {
  return value = 2 * value;
});
vector.replaceAllElements((value: number, index: number) => {
  return value = value - 2;
});
```

### forEach

forEach(callbackfn: (value: T, index?: number, vector?: Vector&lt;T&gt;) => void,
thisArg?: Object): void

通过回调函数来遍历Vector实例对象上的元素以及元素对应的下标。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| callbackfn | function | 是 | 回调函数。 |
| thisArg | Object | 否 | callbackfn被调用时用作this值。 |

callbackfn的参数说明：

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| value | T | 是 | 当前遍历到的元素。 |
| index | number | 否 | 当前遍历到的下标值。 |
| vector | Vector&lt;T&gt; | 否 | 当前调用forEach方法的实例对象。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.forEach((value, index) => {
  console.log("value:" + value, index)
});

```

### sort

sort(comparator?: (firstValue: T, secondValue: T) => number): void

对Vector中的元素进行一个排序操作。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| comparator | function | 否 | 回调函数。 |

comparator的参数说明：

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| firstValue | T | 是 | 前一项元素。 |
| secondValue | T | 是 | 后一项元素。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.sort((a: number, b: number) => a - b);
vector.sort((a: number, b: number) => b - a);
vector.sort();
```

### subVector

subVector(fromIndex: number, toIndex: number): Vector&lt;T&gt;

根据下标截取Vector中的一段元素，并返回这一段vector实例，包括起始值但不包括终止值。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| fromIndex | number | 是 | 起始下标。 |
| toIndex | number | 是 | 终止下标。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| Vector&lt;T&gt; | 返回Vector对象实例。 |

**返回值：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.subVector(2,4);
let result1 = vector.subVector(4,3);
let result2 = vector.subVector(2,6);

```

### clear

clear(): void

清除Vector中的所有元素，并把length置为0。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.clear();
```

### clone

clone(): Vector&lt;T&gt;

克隆一个与Vector相同的实例，并返回克隆后的实例。修改克隆后的实例并不会影响原实例。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| Vector&lt;T&gt; | 返回Vector对象实例。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.clone();
```

### getCapacity

getCapacity(): number

获取当前实例的容量大小。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| number | 返回Vector的容量大小。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.getCapacity();
```

### convertToArray

convertToArray(): Array&lt;T&gt;

把当前Vector实例转换成数组，并返回转换后的数组。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| Array&lt;T&gt; | 返回数组类型。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.convertToArray();
```

### isEmpty

isEmpty(): boolean

判断该Vector是否为空。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| boolean | 为空返回true，否则返回false。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.isEmpty();
```

### increaseCapacityTo

increaseCapacityTo(newCapacity: number): void

如果传入的新容量大于或等于Vector中的元素个数，将容量变更为新容量。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| newCapacity | number | 是 | 新容量。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.increaseCapacityTo(2);
vector.increaseCapacityTo(8);
```

### trimToCurrentLength

trimToCurrentLength(): void

把容量限制为当前的length大小。

**系统能力：** SystemCapability.Utils.Lang

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.trimToCurrentLength();
```

### toString

toString(): string

用","将Vector实例中的元素按顺序拼接成字符串。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| string | 返回对应的字符串。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.toString();
```

### copyToArray

copyToArray(array: Array&lt;T&gt;): void

将Vector实例中的元素按照下标复制到指定数组。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| array | Array&lt;T&gt; | 是 | 指定数组。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let array = ["a", "b", "c", "d", "e", "f"];
let result = vector.copyToArray(array);
```

### getFirstElement

getFirstElement(): T

获取实例中的第一个元素。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| T | 返回第一个元素。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.getFirstElement();
```

### getLastElement

getLastElement(): T

获取Vector实例中的最后一个元素。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| T | 返回最后一个元素。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
let result = vector.getLastElement();
```

### getLastIndexFrom

getLastIndexFrom(element: T, index: number): number

从指定索引向后搜索，返回该元素的下标索引。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 要查找的元素。 |
| index | number | 是 | 从指定索引开始搜索。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| number | 返回该元素的下标，如果查找失败，则返回-1。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.add("a");
let result = vector.getLastIndexFrom(4,3);
```

### getIndexFrom

getIndexFrom(element: T, index: number): number

从指定索引向前搜索，返回该元素的下标索引。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| element | T | 是 | 要查找的元素。 |
| index | number | 是 | 从指定索引开始搜索。 |

**返回值：**

| 类型 | 说明 |
| -------- | -------- |
| number | 返回该元素的下标，如果查找失败，则返回 -1。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.add("a");
let result = vector.getIndexFrom(4, 3);
```

### setLength

setLength(newSize: number): void

设置Vector实例的元素个数。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| newSize | number | 是 | 设置的新长度。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);
vector.setLength(8);
vector.setLength(2);
```

### get

get(index: number): T 

根据下标值获取Vector实例中的元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

  | 参数名 | 类型 | 必填 | 说明 |
  | -------- | -------- | -------- | -------- |
  | index | number | 是 | 查找的下标值。 |

**返回值：**

  | 类型 | 说明 |
  | -------- | -------- |
  | T | 返回获取到的元素。 |

**示例：**

  ```ts
  let vector = new Vector();
  vector.add(2);
  vector.add(4);
  vector.add(5);
  vector.add(4);
  let result = vector.get(2);
  ```
### set

set(index: number, element: T): T

将此Vector中指定位置的元素替换为指定元素。

**系统能力：** SystemCapability.Utils.Lang

**参数：**

| 参数名 | 类型 | 必填 | 说明 |
| -------- | -------- | -------- | -------- |
| index | number | 是 | 查找的下标值。 |
| element | T | 是 | 用来替换的元素。 |

**返回值：**

  | 类型 | 说明 |
  | -------- | -------- |
  | T | 返回替换后的元素。 |

**示例：**

  ```ts
  let vector = new Vector();
  vector.add(2);
  vector.add(4);
  vector.add(5);
  vector.add(4);
  let result = vector.set(2, "A");
  ```

### [Symbol.iterator]

[Symbol.iterator]\(): IterableIterator&lt;T&gt;

返回一个迭代器，迭代器的每一项都是一个 JavaScript 对象,并返回该对象。

**系统能力：** SystemCapability.Utils.Lang

**返回值：**
| 类型 | 说明 |
| -------- | -------- |
| IterableIterator&lt;T&gt; | 返回一个迭代器。 |

**示例：**

```ts
let vector = new Vector();
vector.add(2);
vector.add(4);
vector.add(5);
vector.add(4);

// 使用方法一：
for (let item of vector) { 
  console.log("value:" + item); 
} 

// 使用方法二：
let iter = vector[Symbol.iterator]();
let temp = iter.next().value;
while(temp != undefined) {
  console.log("value:" + temp);
  temp = iter.next().value;
}
```