# AccessibilityExtensionContext

AccessibilityExtensionContext是AccessibilityExtensionAbility上下文环境，继承自ExtensionContext。

AccessibilityExtensionContext模块提供扩展的上下文的能力，包括允许配置辅助应用关注信息类型、查询节点信息、手势注入等。

> **说明：**
>
> 本模块首批接口从API version 9开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。
> 本模块接口仅可在Stage模型下使用。

## 使用说明

在使用AccessibilityExtensionContext的功能前，需要通过AccessibilityExtensionAbility子类实例获取。

```js
import AccessibilityExtensionAbility from '@ohos.application.AccessibilityExtensionAbility'
class MainAbility extends AccessibilityExtensionAbility {
    onConnect(): void {
        console.log("AxExtensionAbility onConnect");
        let axContext = this.context;
    }
}
```

## FocusDirection

表示查询下一焦点元素的方向。

**系统能力**：以下各项对应的系统能力均为 SystemCapability.BarrierFree.Accessibility.Core

| 名称       | 描述      |
| -------- | ------- |
| up       | 表示向上查询。 |
| down     | 表示向上查询。 |
| left     | 表示向左查询。 |
| right    | 表示向右查询。 |
| forward  | 表示向前查询。 |
| backward | 表示向后查询。 |

## FocusType

表示查询焦点元素的类型。

**系统能力**：以下各项对应的系统能力均为 SystemCapability.BarrierFree.Accessibility.Core

| 名称            | 描述          |
| ------------- | ----------- |
| accessibility | 表示无障碍的焦点类型。 |
| normal        | 表示普通的焦点类型。  |

## Rect

表示矩形区域。

**系统能力**：以下各项对应的系统能力均为 SystemCapability.BarrierFree.Accessibility.Core

| 名称     | 参数类型   | 可读   | 可写   | 说明        |
| ------ | ------ | ---- | ---- | --------- |
| left   | number | 是    | 否    | 矩形区域的左边界。 |
| top    | number | 是    | 否    | 矩形区域的上边界。 |
| width  | number | 是    | 否    | 矩形区域的宽度。  |
| height | number | 是    | 否    | 矩形区域的高度。  |

## WindowType

表示窗口的类型。

**系统能力**：以下各项对应的系统能力均为 SystemCapability.BarrierFree.Accessibility.Core

| 名称          | 描述        |
| ----------- | --------- |
| application | 表示应用窗口类型。 |
| system      | 表示系统窗口类型。 |

## AccessibilityExtensionContext.setTargetBundleName

setTargetBundleName(targetNames: Array\<string>): Promise\<void>;

设置关注的事件类型。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名         | 参数类型                | 必填   | 说明       |
| ----------- | ------------------- | ---- | -------- |
| targetNames | Array&lt;string&gt; | 是    | 关注的目标包名。 |

**返回值：**

| 类型                     | 说明                    |
| ---------------------- | --------------------- |
| Promise&lt;boolean&gt; | Promise对象。返回当前设置是否成功。 |

**示例：**

```ts
this.context.setTargetBundleName(['com.ohos.mms']);
```

## AccessibilityExtensionContext.getFocusElement

getFocusElement(isAccessibilityFocus?: boolean): Promise\<AccessibilityElement>;

获取焦点元素。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名                  | 参数类型    | 必填   | 说明                  |
| -------------------- | ------- | ---- | ------------------- |
| isAccessibilityFocus | boolean | 否    | 获取的是否是无障碍焦点元素，默认为否。 |

**返回值：**

| 类型                                  | 说明                     |
| ----------------------------------- | ---------------------- |
| Promise&lt;AccessibilityElement&gt; | Promise对象。返回当前对应的焦点元素。 |

**示例：**

```ts
this.context.getFocusElement().then(focusElement => {
    console.log("AxExtensionAbility getFocusElement success");
})
```

## AccessibilityExtensionContext.getWindowRootElement

getWindowRootElement(windowId?: number): Promise\<AccessibilityElement>;

获取窗口的根节点元素。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名      | 参数类型   | 必填   | 说明                          |
| -------- | ------ | ---- | --------------------------- |
| windowId | number | 否    | 指定获取根节点元素的窗口，未指定则从当前活跃窗口获取。 |

**返回值：**

| 类型                                  | 说明                      |
| ----------------------------------- | ----------------------- |
| Promise&lt;AccessibilityElement&gt; | Promise对象。返回当前对应的根节点元素。 |

**示例：**

```ts
this.context.getWindowRootElement().then(rootElement => {
    console.log("AxExtensionAbility getWindowRootElement success");
})
```

## AccessibilityExtensionContext.getWindows

getWindows(displayId?: number): Promise<Array\<AccessibilityElement>>;

获取用户可见的窗口列表。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名       | 参数类型   | 必填   | 说明                        |
| --------- | ------ | ---- | ------------------------- |
| displayId | number | 否    | 指定获取窗口信息的屏幕，未指定则从默认主屏幕获取。 |

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;AccessibilityElement&gt;&gt; | Promise对象。返回当前对应的窗口列表信息。 |

**示例：**

```ts
this.context.getWindows().then(windows => {
    console.log("AxExtensionAbility getWindows success");
})
```

## AccessibilityExtensionContext.injectGesture

injectGesture(gesturePath: GesturePath, callback: AsyncCallback\<void>): void

注入手势。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名         | 参数类型                                     | 必填   | 说明             |
| ----------- | ---------------------------------------- | ---- | -------------- |
| gesturePath | [GesturePath](js-apis-application-AccessibilityExtensionAbility.md#GesturePath) | 是    | 表示手势的路径信息。     |
| callback    | AsyncCallback&lt;void&gt;                  | 是    | 表示注入手势执行结果的回调。 |

**示例：**

```ts
let gesturePath = new GesturePath(100);
for (let i = 0; i < 10; i++) {
    let gesturePoint = new GesturePosition(100, i * 200);
    gesturePath.positions.push(gesturePoint);
}
this.context.gestureInject(gesturePath, (result) => {
    console.info('gestureInject result: ' + result);
})
```
## AccessibilityElement.attributeNames

attributeNames\<T extends keyof ElementAttributeValues>(): Promise\<Array\<T>>;

获取节点元素的所有属性名称。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;T&gt;&gt; | Promise对象。返回获取元素所有属性名称的调用结果。 |

**示例：**

```ts
let accessibilityElement;
try {
    accessibilityElement.attributeNames().then((values) => {
        console.log("get attribute names success");
    }).catch((err) => {
        console.log("get attribute names err: "  + JSON.stringify(err));
    });
} catch (e) {
    console.log("An unexpected error occurred. Error:" + e);
}
```

## AccessibilityElement.attributeValue

attributeValue\<T extends keyof ElementAttributeValues>(attributeName: T): Promise\<ElementAttributeValues[T]>;

根据属性名称获取属性值。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名         | 参数类型                                     | 必填   | 说明             |
| ----------- | ---------------------------------------- | ---- | -------------- |
| attributeName | T | 是    | 表示属性的名称。     |

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;ElementAttributeValues[T]&gt;&gt; | Promise对象。返回根据属性名称获取属性值的调用结果。 |

**示例：**

```ts
let accessibilityElement;
try {
    let attributeName = 'name';
    accessibilityElement.attributeValue(attributeName).then((value) => {
        console.log("get attribute value by name success");
    }).catch((err) => {
        console.log("get attribute value by name err: "  + JSON.stringify(err));
    });
} catch (e) {
    console.log("An unexpected error occurred. Error:" + e);
}
```

## AccessibilityElement.actionNames

actionNames(): Promise\<Array\<string>>;

获取节点元素支持的所有操作名称。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;string&gt;&gt; | Promise对象。返回获取节点元素支持的所有操作名称的调用结果。 |

**示例：**

```ts
let accessibilityElement;
try {
    accessibilityElement.actionNames().then((values) => {
        console.log("get action names success");
    }).catch((err) => {
        console.log("get action names err: "  + JSON.stringify(err));
    });
} catch (e) {
    console.log("An unexpected error occurred. Error:" + e);
}
```

## AccessibilityElement.performAction

performAction(actionName: string, parameters?: object): Promise\<boolean>;

根据操作名称执行某个操作。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名         | 参数类型                                     | 必填   | 说明             |
| ----------- | ---------------------------------------- | ---- | -------------- |
| actionName | string | 是    | 表示属性的名称。     |
| parameters | object | 否    | 表示执行操作时所需要的参数。     |

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;boolean&gt;&gt; | Promise对象。返回获取元素所有属性名的调用结果。 |

**示例：**

```ts
let accessibilityElement;
try {

    accessibilityElement.performAction('action').then((result) => {
        console.info('perform action result: ' + result);
    }).catch((err) => {
        console.log("perform action err: "  + JSON.stringify(err));
    });
} catch (e) {
    console.log("An unexpected error occurred. Error:" + e);
}
```

## AccessibilityElement.findElement

findElement(type: 'content', condition: string): Promise\<Array\<AccessibilityElement>>;

查询节点元素的指定内容。

**系统能力：**  SystemCapability.BarrierFree.Accessibility.Core

**参数：**

| 参数名         | 参数类型                                     | 必填   | 说明             |
| ----------- | ---------------------------------------- | ---- | -------------- |
| type | string | 是    | 固定为'content',表示查找的类型为节点元素内容。     |
| condition | string | 是    | 表示查找的条件。     |

**返回值：**

| 类型                                       | 说明                       |
| ---------------------------------------- | ------------------------ |
| Promise&lt;Array&lt;T&gt;&gt; | Promise对象。返回获取元素所有属性名的调用结果。 |

**示例：**

```ts
let accessibilityElement;
try {
    let condition = 'keyword';
    accessibilityElement.findElement('content', condition).then((values) => {
        console.log("find element success");
    }).catch((err) => {
        console.log("find element err: "  + JSON.stringify(err));
    });
} catch (e) {
    console.log("An unexpected error occurred. Error:" + e);
}
```
