# 前言


本文介绍了“一次开发，多端部署”（后文中简称为“一多”）的定义、目标等，同时从UX设计、工程管理、页面开发、功能开发等角度，端到端的给出了指导，帮助开发者快速开发出适配多种类型设备的应用。在应用开发前，开发者应尽可能全面考虑应用支持多设备的情况，避免在后期加入新的类型设备时对应用架构进行大幅调整。


## 本文面向的读者

本文适合开发OpenHarmony应用的UX设计师及开发人员。当然，也欢迎任何对“一多”感兴趣的读者阅读本文，相信读者们都可以从中获益。

推荐尽量按照章节顺序阅读本文。如果时间有限，按照角色区分，建议至少阅读如下章节：

- UX设计师：第2章、第3章、第4章。

- 开发人员：第2章、第3章、第5章、第6章、第7章。


## 章节概要

应用在需求明确后，开发过程大致分为：应用设计（包含界面UX设计、业务功能设计）-&gt;工程设计和创建-&gt;功能代码实现。本指导也是基于这个流程进行的内容编排。

本文档各章节简介如下：

- 第1章前言说明本文的目的以及本文面向的读者，指引读者更好地阅读。

- 第2章[简介](introduction.md)简短介绍了“一多”的背景、定义、目标、以及用于指导后续开发的一些基础知识。

- 第3章[从一个例子开始](start-with-a-example.md)通过示例介绍“一多”应用的开发过程，让读者对“一多”有个直观认识。

- 第4章[应用UX设计](design-principles.md)介绍了应用UX设计理念。主要阐述了应用设计之初UX设计的原则和要点。该章节主要面向应用的UX设计师。
  UX设计原则应该考虑多设备的“差异性” 、“一致性”、“灵活性”和“兼容性”。

  UX设计要点则从6个方面阐述如何进行多设备应用设计，分别是“自适应应用架构”、“响应式界面布局”、“交互归一”、“视觉参数化”、“多态控件”和“针对性优化”。

  最后，给出设计自检表，用于检查应用UX设计是否合理 。

- 第5章[工程管理](ide-using.md)介绍了从工程角度如何开始开发应用，让读者可以直接上手创建多设备应用的工程，是后面学习“一多”能力的上手基础。

- 第6章[页面开发的一多能力介绍](page-development-intro.md)和第7章[功能开发的一多能力介绍](development-intro.md)介绍了OpenHarmony提供的“一多”能力，其中每个能力都提供了代码示例和UX效果，让读者可以快速学习“一多”能力。

- 第8章[案例应用](case.md)阐述了从应用设计到开发这一过程中如何实践前面章节介绍的设计思路或“一多”能力，让读者可以整体掌握“一多”在应用开发过程中的知识。

- 第9章[常见问题](faq.md)提供了常见的问题（FAQ），方便读者查阅。

本指导在介绍过程中还包括一些“说明”。这些“说明”，表示例外情况或者额外信息的补充。“说明”在文中如下所示：

> **说明：**<br/>此处承载说明内容。

