# 首选项概述

首选项Preferences，适用于对`Key-Value`结构的数据进行存取和持久化操作。

应用获取某个`Preferences`对象后，该存储对象中的数据将会被缓存在内存中，以便应用获得更快的数据存取速度。

应用也可以将缓存的数据再次写回文本文件中进行持久化存储，由于文件读写将产生不可避免的系统资源开销，建议应用降低对持久化文件的读写频率。

关于数据库锁机制，开发者无需关注其具体实现。

## 基本概念

- **Key-Value数据结构**

  一种键值型的数据结构。`Key`是不重复的关键字，`Value`是数据值。

- **非关系型数据库**

  区别于关系数据库，不保证遵循ACID（Atomic、Consistency、Isolation及Durability）特性，不采用关系模型来组织数据，数据之间无关系。比如，以`Key-Value`数据结构组成的数据库。

## 运作机制

1. 应用通过指定首选项持久化文件将其中的数据加载到`Preferences`实例，系统会通过静态容器将该实例存储在内存中，同一应用或进程中每个文件仅存在一个`Preferences`实例，直到应用主动从内存中移除该实例或者删除该首选项持久化文件。
2. 应用获取到首选项持久化文件对应的实例后，可以从`Preferences`实例中读取数据，或者将数据存入`Preferences`实例中。通过调用flush方法可以将`Preferences`实例中的数据回写到文件里。

**图1** 首选项运作机制

![zh-cn_image_0000001199139454](figures/zh-cn_image_0000001199139454.png)

## 约束与限制

- 因`Preferences`实例会加载到内存中，建议存储的数据不超过一万条，并注意及时清理不再使用的实例，以便减少非内存开销。
- 数据中的`Key`为`string`类型，要求非空且字符长度不超过80个字节。
- 当数据中的`Value`为`string`类型时，允许为空，字符长度不超过8192个字节。