# TypeScript-based Declarative Development Paradigm

- Universal Component Information
    - Universal Events
        - [Click Event](ts-universal-events-click.md)
        - [Touch Event](ts-universal-events-touch.md)
        - [Show/Hide Event](ts-universal-events-show-hide.md)
        - [Drag/Drop Event](ts-universal-events-drag-drop.md)
        - [Key Event](ts-universal-events-key.md)
        - [Focus Event](ts-universal-focus-event.md)
        - [Mouse Event](ts-universal-mouse-key.md)
        - [Component Area Change Event](ts-universal-component-area-change-event.md)
        - [Visible Area Change Event](ts-universal-component-visible-area-change-event.md)
    - Universal Attributes
        - [Size](ts-universal-attributes-size.md)
        - [Location](ts-universal-attributes-location.md)
        - [Layout Constraints](ts-universal-attributes-layout-constraints.md)
        - [Flex Layout](ts-universal-attributes-flex-layout.md)
        - [Border](ts-universal-attributes-border.md)
        - [Border Image](ts-universal-attributes-border-image.md)
        - [Background](ts-universal-attributes-background.md)
        - [Opacity](ts-universal-attributes-opacity.md)
        - [Visibility](ts-universal-attributes-visibility.md)
        - [Enable/Disable](ts-universal-attributes-enable.md)
        - [Overlay](ts-universal-attributes-overlay.md)
        - [Z-order Control](ts-universal-attributes-z-order.md)
        - [Transformation](ts-universal-attributes-transformation.md)
        - [Image Effect Configuration](ts-universal-attributes-image-effect.md)
        - [Shape Clipping](ts-universal-attributes-sharp-clipping.md)
        - [Text Style](ts-universal-attributes-text-style.md)
        - [Grid](ts-universal-attributes-grid.md)
        - [Gradient Color](ts-universal-attributes-gradient-color.md)
        - [Popup Control](ts-universal-attributes-popup.md)
        - [Menu Control](ts-universal-attributes-menu.md)
        - [Click Control](ts-universal-attributes-click.md)
        - [Focus Control](ts-universal-attributes-focus.md)
        - [Hover Effect](ts-universal-attributes-hover-effect.md)
        - [Component ID](ts-universal-attributes-component-id.md)
        - [Touch Target](ts-universal-attributes-touch-target.md)
        - [Polymorphic Style](ts-universal-attributes-polymorphic-style.md)
        - [Hit Test Control](ts-universal-attributes-hit-test-behavior.md)
        - [Background Blur](ts-universal-attributes-backgroundBlurStyle.md)
        - [restoreId](ts-universal-attributes-restoreId.md)
    - Gesture Processing
        - [Gesture Binding Methods](ts-gesture-settings.md)
        - Basic Gestures
            - [TapGesture](ts-basic-gestures-tapgesture.md)
            - [LongPressGesture](ts-basic-gestures-longpressgesture.md)
            - [PanGesture](ts-basic-gestures-pangesture.md)
            - [PinchGesture](ts-basic-gestures-pinchgesture.md)
            - [RotationGesture](ts-basic-gestures-rotationgesture.md)
            - [SwipeGesture](ts-basic-gestures-swipegesture.md)
        - [Combined Gestures](ts-combined-gestures.md)
- Basic Components
     - [Blank](ts-basic-components-blank.md)
     - [Button](ts-basic-components-button.md)
     - [Checkbox](ts-basic-components-checkbox.md)
     - [CheckboxGroup](ts-basic-components-checkboxgroup.md)
     - [DataPanel](ts-basic-components-datapanel.md)
     - [DatePicker](ts-basic-components-datepicker.md)
     - [Divider](ts-basic-components-divider.md)
     - [Gauge](ts-basic-components-gauge.md)
     - [Image](ts-basic-components-image.md)
     - [ImageAnimator](ts-basic-components-imageanimator.md)
     - [LoadingProgress](ts-basic-components-loadingprogress.md)
     - [Marquee](ts-basic-components-marquee.md)
     - [Navigation](ts-basic-components-navigation.md)
     - [PatternLock](ts-basic-components-patternlock.md)
     - [PluginComponent](ts-basic-components-plugincomponent.md)
     - [Progress](ts-basic-components-progress.md)
     - [QRCode](ts-basic-components-qrcode.md)
     - [Radio](ts-basic-components-radio.md)
     - [Rating](ts-basic-components-rating.md)
    - [RemoteWindow](ts-basic-components-remotewindow.md)
     - [RichText](ts-basic-components-richtext.md)
     - [ScrollBar](ts-basic-components-scrollbar.md)
     - [Search](ts-basic-components-search.md)
     - [Select](ts-basic-components-select.md)
     - [Slider](ts-basic-components-slider.md)
     - [Span](ts-basic-components-span.md)
     - [Stepper](ts-basic-components-stepper.md)
     - [StepperItem](ts-basic-components-stepperitem.md)
     - [Text](ts-basic-components-text.md)
     - [TextArea](ts-basic-components-textarea.md)
     - [TextClock](ts-basic-components-textclock.md)
     - [TextInput](ts-basic-components-textinput.md)
     - [TextPicker](ts-basic-components-textpicker.md)
     - [TextTimer](ts-basic-components-texttimer.md)
     - [TimePicker](ts-basic-components-timepicker.md)
     - [Toggle](ts-basic-components-toggle.md)
     - [Web](ts-basic-components-web.md)
     - [XComponent](ts-basic-components-xcomponent.md)
- Container Components
    - [AbilityComponent](ts-container-ability-component.md)
    - [AlphabetIndexer](ts-container-alphabet-indexer.md)
    - [Badge](ts-container-badge.md)
    - [Column](ts-container-column.md)
    - [ColumnSplit](ts-container-columnsplit.md)
    - [Counter](ts-container-counter.md)
    - [Flex](ts-container-flex.md)
    - [GridContainer](ts-container-gridcontainer.md)
    - [GridCol](ts-container-gridcol.md)
    - [GridRow](ts-container-gridrow.md)
    - [Grid](ts-container-grid.md)
    - [GridItem](ts-container-griditem.md)
    - [List](ts-container-list.md)
    - [ListItem](ts-container-listitem.md)
    - [ListItemGroup](ts-container-listitemgroup.md)
    - [Navigator](ts-container-navigator.md)        
    - [Panel](ts-container-panel.md)
    - [Refresh](ts-container-refresh.md)
    - [RelativeContainer](ts-container-relativecontainer.md)
    - [Row](ts-container-row.md)
    - [RowSplit](ts-container-rowsplit.md)
    - [Scroll](ts-container-scroll.md)        
    - [SideBarContainer](ts-container-sidebarcontainer.md)
    - [Stack](ts-container-stack.md)
    - [Swiper](ts-container-swiper.md)
    - [Tabs](ts-container-tabs.md)
    - [TabContent](ts-container-tabcontent.md)
- Media Components

    - [Video](ts-media-components-video.md)
- Drawing Components
    - [Circle](ts-drawing-components-circle.md)
    - [Ellipse](ts-drawing-components-ellipse.md)
    - [Line](ts-drawing-components-line.md)
    - [Polyline](ts-drawing-components-polyline.md)
    - [Polygon](ts-drawing-components-polygon.md)
    - [Path](ts-drawing-components-path.md)
    - [Rect](ts-drawing-components-rect.md)
    - [Shape](ts-drawing-components-shape.md)
- Canvas Components
    - [Canvas](ts-components-canvas-canvas.md)
    - [CanvasRenderingContext2D](ts-canvasrenderingcontext2d.md)
    - [OffscreenCanvasRenderingContext2D](ts-offscreencanvasrenderingcontext2d.md)
    - [Lottie](ts-components-canvas-lottie.md)
    - [Path2D](ts-components-canvas-path2d.md)
    - [CanvasGradient](ts-components-canvas-canvasgradient.md)
    - [ImageBitmap](ts-components-canvas-imagebitmap.md)
    - [ImageData](ts-components-canvas-imagedata.md)
- Animation
    - [AnimatorProperty](ts-animatorproperty.md)
    - [Explicit Animation](ts-explicit-animation.md)
    - Transition Animation
        - [Page Transition](ts-page-transition-animation.md)
        - [Component Transition](ts-transition-animation-component.md)
        - [Transition of Shared Elements](ts-transition-animation-shared-elements.md)
    - [Motion Path Animation](ts-motion-path-animation.md)
    - [Matrix Transformation](ts-matrix-transformation.md)
    - [Interpolation Calculation](ts-interpolation-calculation.md)
- Global UI Methods
    - Pop-up Window
        - [Alert Dialog Box](ts-methods-alert-dialog-box.md)
        - [Action Sheet](ts-methods-action-sheet.md)
        - [Custom Dialog Box](ts-methods-custom-dialog-box.md)
        - [Date Picker Dialog Box](ts-methods-datepicker-dialog.md)
        - [Time Picker Dialog Box](ts-methods-timepicker-dialog.md)
        - [Text Picker Dialog Box](ts-methods-textpicker-dialog.md)
    - [Menu](ts-methods-menu.md)
- [Built-in Enums](ts-appendix-enums.md)
