# innerBundleManager

The **innerBundleManager** module manages internal bundles.

> **NOTE**
> 
> The initial APIs of this module are supported since API version 8. Newly added APIs will be marked with a superscript to indicate their earliest API version.

## Modules to Import

```
import innerBundleManager from '@ohos.bundle.innerBundleManager';
```

## System Capability

SystemCapability.BundleManager.BundleFramework

## Required Permissions

| Permission                                      | Permission Level    | Description                        |
| ------------------------------------------ | ------------ | ---------------------------- |
| ohos.permission.GET_BUNDLE_INFO_PRIVILEGED | system_basic | Permission to query information about all applications.          |
| ohos.permission.LISTEN_BUNDLE_CHANGE       | system_grant | Permission to listen for application changes.|

For details, see [Permission Levels](../../security/accesstoken-overview.md#permission-levels).

## innerBundleManager.getLauncherAbilityInfos

getLauncherAbilityInfos(bundleName: string, userId: number, callback: AsyncCallback&lt;Array&lt;LauncherAbilityInfo&gt;&gt;) : void;

Obtains the launcher ability information based on a given bundle name. This API uses an asynchronous callback to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name      | Type                                                        | Mandatory| Description                                                 |
| ---------- | ------------------------------------------------------------ | ---- | ----------------------------------------------------- |
| bundleName | string                                                       | Yes  | Bundle name of an application.                             |
| userId     | number                                                       | Yes  | User ID. The default value is the user ID of the caller. The value must be greater than or equal to 0.|
| callback   | AsyncCallback\<Array<[LauncherAbilityInfo](js-apis-bundle-LauncherAbilityInfo.md)>> | Yes  | Callback used to return an array of the launcher ability information.           |



## innerBundleManager.getLauncherAbilityInfos

getLauncherAbilityInfos(bundleName: string, userId: number) : Promise&lt;Array&lt;LauncherAbilityInfo&gt;&gt;

Obtains the launcher ability information based on a given bundle name. This API uses a promise to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name      | Type  | Mandatory| Description                                                 |
| ---------- | ------ | ---- | ----------------------------------------------------- |
| bundleName | string | Yes  | Bundle name of an application.                             |
| userId     | number | Yes  | User ID. The default value is the user ID of the caller. The value must be greater than or equal to 0.|

**Return value**

| Type                                                        | Description                     |
| ------------------------------------------------------------ | ------------------------- |
| Promise\<Array<[LauncherAbilityInfo](js-apis-bundle-LauncherAbilityInfo.md)>> | Promise used to return an array of the launcher ability information.|

## innerBundleManager.on

on(type:"BundleStatusChange", bundleStatusCallback : BundleStatusCallback, callback: AsyncCallback&lt;string&gt;) : void;

Registers a callback to receive bundle status changes. This API uses an asynchronous callback to return the result.

**Required permissions**

ohos.permission.LISTEN_BUNDLE_CHANGE

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name                | Type                 | Mandatory| Description                                                |
| -------------------- | --------------------- | ---- | ---------------------------------------------------- |
| type                 | "BundleStatusChange"  | Yes  | Event type.                                    |
| bundleStatusCallback | BundleStatusCallback  | Yes  | Callback to register.                                  |
| callback             | AsyncCallback\<string> | Yes  | Callback used to return a successful result or error information.|

## innerBundleManager.on

on(type:"BundleStatusChange", bundleStatusCallback : BundleStatusCallback): Promise&lt;string&gt;

Registers a callback to receive bundle status changes. This API uses a promise to return the result.

**Required permissions**

ohos.permission.LISTEN_BUNDLE_CHANGE

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name                | Type                | Mandatory| Description              |
| -------------------- | -------------------- | ---- | ------------------ |
| type                 | "BundleStatusChange" | Yes  | Event type.  |
| bundleStatusCallback | BundleStatusCallback | Yes  | Callback to register.|

**Return value**

| Type           | Description                               |
| --------------- | ----------------------------------- |
| Promise\<string> | Promise used to return a successful result or error information.|

## innerBundleManager.off

off(type:"BundleStatusChange", callback: AsyncCallback&lt;string&gt;) : void;

Deregisters the callback that receives bundle status changes. This API uses an asynchronous callback to return the result.

**Required permissions**

ohos.permission.LISTEN_BUNDLE_CHANGE

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name    | Type                 | Mandatory| Description                                                |
| -------- | --------------------- | ---- | ---------------------------------------------------- |
| type     | "BundleStatusChange"  | Yes  | Event type.                                    |
| callback | AsyncCallback\<string> | Yes  | Callback used to return a successful result or error information.|

## innerBundleManager.off

off(type:"BundleStatusChange"): Promise&lt;string&gt;

Deregisters the callback that receives bundle status changes. This API uses a promise to return the result.

**Required permissions**

ohos.permission.LISTEN_BUNDLE_CHANGE

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name| Type                | Mandatory| Description            |
| ---- | -------------------- | ---- | ---------------- |
| type | "BundleStatusChange" | Yes  | Event type.|

**Return value**

| Type           | Description                               |
| --------------- | ----------------------------------- |
| Promise\<string> | Promise used to return a successful result or error information.|

## innerBundleManager.getAllLauncherAbilityInfos

getAllLauncherAbilityInfos(userId: number, callback: AsyncCallback&lt;Array&lt;LauncherAbilityInfo&gt;&gt;) : void;

Obtains the information about all launcher abilities. This API uses an asynchronous callback to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name    | Type                                                        | Mandatory| Description                                                 |
| -------- | ------------------------------------------------------------ | ---- | ----------------------------------------------------- |
| userId   | number                                                       | Yes  | User ID. The default value is the user ID of the caller. The value must be greater than or equal to 0.|
| callback | AsyncCallback\<Array<[LauncherAbilityInfo](js-apis-bundle-LauncherAbilityInfo.md)>> | Yes  | Callback used to return an array of the launcher ability information.           |

## innerBundleManager.getAllLauncherAbilityInfos

getAllLauncherAbilityInfos(userId: number) : Promise&lt;Array&lt;LauncherAbilityInfo&gt;&gt;

Obtains the information about all launcher abilities. This API uses a promise to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name  | Type  | Mandatory| Description                                                 |
| ------ | ------ | ---- | ----------------------------------------------------- |
| userId | number | Yes  | User ID. The default value is the user ID of the caller. The value must be greater than or equal to 0.|

**Return value**

| Type                                                        | Description                     |
| ------------------------------------------------------------ | ------------------------- |
| Promise\<Array<[LauncherAbilityInfo](js-apis-bundle-LauncherAbilityInfo.md)>> | Promise used to return an array of the launcher ability information.|

## innerBundleManager.getShortcutInfos

getShortcutInfos(bundleName :string, callback: AsyncCallback&lt;Array&lt;ShortcutInfo&gt;&gt;) : void;

Obtains the shortcut information based on a given bundle name. This API uses an asynchronous callback to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name      | Type                                                        | Mandatory| Description                                          |
| ---------- | ------------------------------------------------------------ | ---- | ---------------------------------------------- |
| bundleName | string                                                       | Yes  | Bundle name of an application.                      |
| callback   | AsyncCallback\<Array<[ShortcutInfo](js-apis-bundle-ShortcutInfo.md)>> | Yes  | Callback used to return an array of the shortcut information.|

## innerBundleManager.getShortcutInfos

getShortcutInfos(bundleName : string) : Promise&lt;Array&lt;ShortcutInfo&gt;&gt;

Obtains the shortcut information based on a given bundle name. This API uses a promise to return the result.

**Required permissions**

ohos.permission.GET_BUNDLE_INFO_PRIVILEGED

**System capability**

SystemCapability.BundleManager.BundleFramework

**System API**

This is a system API and cannot be called by third-party applications.

**Parameters**

| Name      | Type  | Mandatory| Description                    |
| ---------- | ------ | ---- | ------------------------ |
| bundleName | string | Yes  | Bundle name of an application.|

**Return value**

| Type                                                    | Description                         |
| -------------------------------------------------------- | ----------------------------- |
| Promise\<Array<[ShortcutInfo](js-apis-bundle-ShortcutInfo.md)>> | Promise used to return an array of the shortcut information.|
