# 移植子系统概述


OpenHarmony系统功能按照“系统 &gt; 子系统 &gt; 部件”逐级展开，支持根据实际需求裁剪某些非必要的部件（本文只对HarmonyOS Connect服务包所必需的子系统、部件进行介绍）。若想使用OpenHarmony系统的能力，需要对相应子系统进行适配。


OpenHarmony芯片适配常见子系统列表如下（详见表1），需结合具体芯片再做增删减操作。


  **表1** OpenHarmony子系统

| 子系统 | 作用 | 
| -------- | -------- |
| applications | 应用程序demo。可将应用相关源码存放在此目录下。 | 
| kernel | 内核子系统。负责任务调度、内存管理等常见的内核功能。 | 
| hiviewdfx | 可维可测子系统。提供日志相关功能。 | 
| communication | 通信子系统。包含Wi-Fi，蓝牙功能。 | 
| iot_hardware | IOT外设子系统。提供常见的外设接口，例如GPIO，I2C，SPI等。 | 
| startup | 启动子系统。内核启动后运行的第一个子系统，负责在内核启动之后到应用启动之前的系统关键进程和服务的启动过程的功能。 | 
| update | 升级子系统。用来支持OpenHarmony设备的OTA升级。 | 
| utils | 公共基础库子系统。提供了一些常用的C、C++开发增强API。 | 
| distributed_schedule | 分布式调度子系统。负责跨设备部件管理，提供访问和控制远程组件的能力，支持分布式场景下的应用协同。 | 
| security | 安全子系统。包括系统安全、数据安全、应用安全等功能，为OpenHarmony提供有效保护应用和用户数据的能力。当前开源的功能，包括应用完整性保护、应用权限管理、设备认证、密钥管理服务、数据传输管控。 | 
| test | 测试子系统。OpenHarmony为开发者提供了一套全面的自测试框架，开发者可根据测试需求开发相关测试用例，开发阶段提前发现缺陷，大幅提高代码质量。 | 
