# 延迟任务调度概述

延迟任务调度给应用提供一个机制，允许应用根据系统安排，在系统空闲时执行实时性不高的任务。当满足设定条件的时候，任务会被放入待调度队列，当系统空闲时调度该任务。

## 使用说明

应用要执行对实时性要求不高的任务的时候，比如设备空闲时候做一次数据学习等场景，可以使用延迟调度任务，该机制在满足应用设定条件的时候，会根据系统当前状态，如内存、功耗、温度等统一决策调度时机。

## 延迟任务调度约束

延迟调度任务的使用需要遵从如下约束和规则：

- **超时**：系统会设置超时机制，延迟任务回调只允许运行一段时间，超时之后，系统会主动停止。
- **执行频率**：系统会根据应用的活跃度对延迟任务做分级管控，限制延迟任务调度的执行频率。

应用分组             |     延迟任务执行频率约束                            
--------------------|-------------------------
活跃 | 最小间隔2小时
每日使用 | 最小间隔4小时 
经常使用 | 最小间隔24小时 
不经常使用 | 最小间隔48小时 
受限分组 | 禁止 
未使用分组 | 禁止 

- **WorkInfo设置参数约束** 

（1） workId、bundleName、abilityName为必填项，bundleName必须填本应用，否则校验失败。

（2）至少要设置一个满足的条件。

（3）重复任务时间间隔至少20分钟，当设置重复任务时间间隔时，必须设置始终重复和重复次数中的一个。