# SysCap列表

SysCap，全称SystemCapability，即系统能力，指操作系统中每一个相对独立的特性。开发者使用某个接口进行开发前，建议先阅读[SysCap使用指南](../quick-start/syscap.md)，了解Syscap的定义和使用指导。再结合下表判断具体能力集是否支持某个设备，提高开发效率。

| SysCap名称                                                   | SysCap描述                                                   | Default | 运动表 | 智能表 | 平板 | 车机 | 智慧屏 | Smart-Vision | Router |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------- | ------ | ------ | ---- | ---- | ------ | ------------ | ------ |
| SystemCapability.ArkUI.<br/>ArkUI.Full                       | ArKUI标准系统                                                | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ArkUI.<br/>ArkUI.Lite                       | ArkUI小型系统                                                | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 否     |
| SystemCapability.ArkUI.<br/>ArkUI.Napi                       | napi功能                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ArkUI.<br/>ArkUI.Libuv                      | libuv功能                                                    | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ArkUI.<br/>UiAppearance                     | 外观配置功能                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BundleManager.<br/>BundleFramework          | 包管理服务                                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BundleManager.<br/>DistributedBundleFramework | 分布式包管理服务                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BundleManager.<br/>BundleTool               | 包管理命令行工具                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BundleManager.<br/>Zlib                     | Zlib压缩、解压缩工具                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BundleManager.<br/>PackingTool              | 包管理打包、拆包工具                                         | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 否     |
| SystemCapability.Graphic.<br/>Graphic2D.WebGL                | WebGL1.0 标准api                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Graphic.<br/>Graphic2D.WebGL2               | WebGL2.0 标准api                                             | 是      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |
| SystemCapability.WindowManager.<br/>WindowManager.Core       | 窗口管理                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.WindowManager.<br/>WindowManager.MutiScreen | 多屏能力                                                     | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Notification.<br/>CommonEvent               | 公共事件                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Notification.<br/>Notification              | 通知                                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Notification.<br/>ReminderAgent             | 后台代理提醒                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Notification.<br/>Emitter                   | 事件处理服务                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>IPC.Core                 | 进程间通信                                                   | 是      | 否     | 是     | 是   | 是   | 是     | 是           | 否     |
| SystemCapability.Communication.<br/>SoftBus.Core             | 软总线                                                       | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.Communication.<br/>NetManager.Core          | 网络管理基础服务                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>NetManager.Extension     | 网络管理扩展服务                                             | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>NetStack                 | 基础网络协议栈能力                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>WiFi.Core                | WIFI基础能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>WiFi.STA                 | WIFI STA能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>WiFi.AP.Core             | WIFI AP能力                                                  | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>WiFi.AP.Extension        | WIFI AP扩展能力                                              | 否      | 否     | 否     | 否   | 否   | 否     | 否           | 是     |
| SystemCapability.Communication.<br/>WiFi.P2P                 | WIFI P2P能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>Bluetooth.Core           | 蓝牙服务以及协议栈                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>Bluetooth.Lite           | 蓝牙轻量级服务                                               | 是      | 是     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Communication.<br/>NFC.Core                 | NFC服务                                                      | 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |
| SystemCapability.Communication.<br/>ConnectedTag             | 有源NFC标签服务                                              | 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |
| SystemCapability.Location.<br/>Location.Core                 | 位置服务基础能力                                             | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Location.<br/>Location.Geocoder             | 地理编码能力                                                 | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Location.<br/>Location.Geofence             | 地理围栏能力                                                 | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Location.<br/>Location.Gnss                 | GNSS硬件相关能力                                             | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Location.<br/>Location.Lite                 | 位置服务轻设备能力                                           | 是      | 是     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.Core             | 基本输入能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.InputDevice      | 输入设备管理                                                 | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.RemoteInputDevice | 分布式输入设备管理                                           | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.InputMonitor     | 输入事件监听者                                               | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.InputConsumer    | 输入事件消费者                                               | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.InputSimulator   | 输入事件模拟者                                               | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.MultimodalInput.<br/>Input.InputFilter      | 输入事件过滤器                                               | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.PowerManager.<br/>BatteryManager.Extension  | 电池服务扩展能力                                             | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.PowerManager.<br/>BatteryStatistics         | 耗电统计                                                     | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.PowerManager.<br/>DisplayPowerManager       | 显示能效管理                                                 | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.PowerManager.<br/>ThermalManager            | 温控服务                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.PowerManager.<br/>PowerManager.Core         | 系统电源管理服务核心能力                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.PowerManager.<br/>PowerManager.Lite         | 轻设备系统电源管理服务能力                                   | 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |
| SystemCapability.PowerManager.<br/>BatteryManager.Core       | 电池服务核心能力                                             | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.PowerManager.<br/>BatteryManager.Lite       | 轻设备电池服务能力                                           | 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |
| SystemCapability.PowerManager.<br/>PowerManager.Extension    | 系统电源管理服务扩展能力                                     | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.Core                  | 媒体基础能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.AudioPlayer           | 媒体音频播放引擎能力                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.AudioRecorder         | 媒体音频播录制引擎能力                                       | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.VideoPlayer           | 媒体视频播放引擎能力                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.VideoRecorder         | 媒体视频录制引擎能力                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.CodecBase             | 媒体编解码基础能力                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.AudioDecoder          | 媒体音频解码能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.AudioEncoder          | 媒体音频编码能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.VideoDecoder          | 媒体视频解码能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.VideoEncoder          | 媒体视频编码能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.Spliter               | 媒体解封装能力                                               | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Media.Muxer                 | 媒体封装能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>AVSession.Core              | 媒体会话基础能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>AVSession.Manager           | 媒体会话管理能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Core                  | 音频基础能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Renderer              | 音频输出能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Capturer              | 音频输入能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Device                | 音频设备管理能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Volume                | 音频音量管理能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Audio.Communication         | 音频通信能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Camera.Core                 | 相机基础能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Camera.DistributedCore      | 相机分布式能力                                               | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Image.Core                  | 图片基础能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Image.ImageSource           | 图片源解码解析能力                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Image.ImagePacker           | 图片打包能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>Image.ImageReceiver         | 图片接收能力                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>MediaLibrary.Core           | 媒体库基础能力                                               | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>MediaLibrary.SmartAlbum     | 媒体库智慧相册能力                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Multimedia.<br/>MediaLibrary.DistributedCore | 媒体库分布式能力                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Telephony.<br/>CoreService                  | 蜂窝核心服务                                                 | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Telephony.<br/>CallManager                  | 通话管理服务                                                 | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Telephony.<br/>CellularCall                 | 蜂窝通话服务                                                 | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Telephony.<br/>CellularData                 | 蜂窝数据服务                                                 | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Telephony.<br/>SmsMms                       | 短彩信服务                                                   | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Telephony.<br/>StateRegistry                | 蜂窝网络状态注册服务                                         | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Global.I18n                                 | 国际化                                                       | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Global.<br/>ResourceManager                 | 资源管理                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Customization.<br/>ConfigPolicy             | 定制框架                                                     | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.Customization.<br/>EnterpriseDeviceManager  | 企业设备管理                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BarrierFree.<br/>Accessibility.Core         | 提供开发辅助应用的能力                                       | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BarrierFree.<br/>Accessibility.Vision       | 无障碍视觉辅助能力                                           | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BarrierFree.<br/>Accessibility.Hearing      | 无障碍听觉辅助能力                                           | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.BarrierFree.<br/>Accessibility.Interaction  | 无障碍行为辅助能力                                           | 是      | 否     | 否     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.ResourceSchedule.<br/>WorkScheduler         | 延迟任务调度                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ResourceSchedule.<br/>BackgroundTaskManager.<br/>ContinuousTask | 长时任务管理                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ResourceSchedule.<br/>BackgroundTaskManager.<br/>TransientTask | 短时任务管理                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ResourceSchedule.<br/>UsageStatistics.App   | 应用使用信息统计                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.ResourceSchedule.<br/>UsageStatistics.AppGroup | 应用使用活跃分组                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Utils.Lang                                  | TS/JS语言基础库                                              | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiLog                        | 流水日志                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiLogLite                    | 轻量级流水日志                                               | 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |
| SystemCapability.HiviewDFX.<br/>HiTrace                      | 分布式追踪                                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>Hiview.FaultLogger           | 事件打点                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiviewLite                   | 轻量级hiview服务                                             | 否      | 是     | 否     | 否   | 否   | 否     | 是           | 是     |
| SystemCapability.HiviewDFX.<br/>HiChecker                    | 检测模式                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiCollie                     | 卡死检测                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiDumper                     | 系统信息导出                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiAppEvent                   | 应用事件打点                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiSysEvent                   | 系统事件打点                                                 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.HiviewDFX.<br/>HiEventLite                  | 轻量级事件打点                                               | 否      | 是     | 否     | 否   | 否   | 否     | 否           | 是     |
| SystemCapability.HiviewDFX.<br/>HiProfiler.HiDebug           | 调试调优                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Update.<br/>UpdateService                   | 升级服务                                                     | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.<br/>DistributedHardware.<br/>DeviceManager | 分布式设备管理                                               | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>DeviceAuth                    | 设备互信认证                                                 | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>DataTransitManager            | 数据传输管控策略库                                           | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>DeviceSecurityLevel           | 设备安全等级管理                                             | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>Huks                          | 设备密钥管理                                                 | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>AccessToken                   | 访问控制                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Security.<br/>Cipher                        | 加解密                                                       | 否      | 否     | 否     | 否   | 否   | 否     | 是           | 否     |
| SystemCapability.Account.<br/>OsAccount                      | 帐号                                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Account.<br/>AppAccount                     | 应用账号                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.UserIAM.<br/>UserAuth.Core                  | 统一用户认证                                                 | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.UserIAM.<br/>UserAuth.PinAuth               | 口令认证                                                     | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.UserIAM.<br/>UserAuth.FaceAuth              | 人脸认证                                                     | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.MiscServices.<br/>InputMethodFramework      | 输入法框架                                                   | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.MiscServices.<br/>Pasteboard                | 剪贴板服务                                                   | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.MiscServices.<br/>Time                      | 时间时区定时                                                 | 是      | 否     | 是     | 是   | 否   | 是     | 否           | 否     |
| SystemCapability.MiscServices.<br/>Wallpaper                 | 壁纸框架                                                     | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.MiscServices.<br/>ScreenLock                | 锁屏服务                                                     | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.MiscServices.<br/>Upload                    | 上传服务                                                     | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.MiscServices.<br/>Download                  | 下载服务                                                     | 是      | 否     | 否     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.FileManagement.<br/>StorageService.Backup   | 备份恢复                                                     | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>StorageService.SpatialStatistics | 空间统计                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>StorageService.Volume   | 卷管理                                                       | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>StorageService.Encryption | 文件加密能力                                                 | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>File.FileIO             | 基础文件IO接口                                               | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.FileManagement.<br/>File.Environment        | 环境相关接口                                                 | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.FileManagement.<br/>File.DistributedFile    | 分布式文件扩展接口                                           | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>AppFileService          | 应用文件分享                                                 | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.FileManagement.<br/>UserFileService         | 用户文件访问服务                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.USB.USBManager                              | usb服务                                                      | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Sensors.Sensor                              | 传感器服务订阅                                               | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Sensors.MiscDevice                          | 小器件-振感                                                  | 是      | 否     | 是     | 是   | 否   | 否     | 否           | 否     |
| SystemCapability.Startup.SystemInfo                          | 系统基本信息                                                 | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.<br/>DistributedDataManager.<br/>RelationalStore.Core | 关系型数据库核心能力                                         | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>RelationalStore.Synchronize | 关系型数据库分布式能力                                       | 是      | 否     | 否     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>RelationalStore.Lite | 轻量级关系型数据库                                           | 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>KVStore.Core | Key-Value型数据库核心能力                                    | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>KVStore.Lite | 轻量级Key-Value型数据库核心能力                              | 否      | 否     | 否     | 否   | 否   | 否     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>KVStore.DistributedKVStore | 分布式Key-Value型数据库                                      | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>DataObject.DistributedObject | 分布式对象                                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>Preferences.Core | 偏好型数据存储核心能力                                       | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>DataShare.Core | 跨进程数据共享，基础能力                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>DataShare.Consumer | 跨进程数据共享，数据消费者                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.<br/>DistributedDataManager.<br/>DataShare.Provider | 跨进程数据共享，数据生产者                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.AbilityBase                         | 组件运行基础数据定义，主要包括组件通信数据的载体want、系统配置定义等 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability<br/>.AbilityRuntime.Core            | 组件运行核心基础功能模块，包括应用初始化、无界面组件运行等； | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.<br/>AbilityRuntime.FAModel         | FA模型                                                       | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.<br/>AbilityRuntime.AbilityCore     | 通用组件(有界面)                                             | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.<br/>AbilityRuntime.Mission         | 任务管理                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.<br/>AbilityTools.AbilityAssistant  | 命令行工具                                                   | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.Form                                | 卡片管理                                                     | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Ability.<br/>DistributedAbilityManager      | 分布式流转管理（continuationManager)接口定义，支持打开互联面板、更新流转状态 | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Applications.<br/>ContactsData              | 联系人数据库                                                 | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Applications.<br/>Contacts                  | 联系人                                                       | 是      | 否     | 是     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Applictaions.<br/>settings.Core             | 设置API                                                      | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Test.UiTest                                 | UI测试框架能力支持                                           | 是      | 否     | 否     | 是   | 是   | 否     | 否           | 否     |
| SystemCapability.Web.<br/>Webview.Core                       | webview组件                                                  | 是      | 否     | 是     | 是   | 是   | 是     | 否           | 否     |
| SystemCapability.Cloud.AAID                                  | AAID管理服务                                                 | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.Cloud.OAID                                  | OAID管理服务                                                 | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |
| SystemCapability.Cloud.VAID                                  | VAID管理服务                                                 | 是      | 是     | 是     | 是   | 是   | 是     | 是           | 是     |