# HML语法参考


HML（OpenHarmony Markup Language）是一套类HTML的标记语言，通过组件，事件构建出页面的内容。页面具备数据绑定、事件绑定、条件渲染和逻辑控制等高级能力。


## 页面结构


```html
<!-- xxx.hml -->
<div class="item-container">
  <text class="item-title">Image Show</text>
  <div class="item-content">
    <image src="/common/xxx.png" class="image"></image>
  </div>
</div>
```


## 数据绑定


```html
<!-- xxx.hml -->
<div class="item-container">
  <text>{{content}} </text>            <!-- 输出：Hello World！-->
  <text>{{key1}} {{key2}}</text>       <!-- 输出：Hello World6+-->
  <text>key1 {{key1}}</text>           <!-- 输出：key1 Hello 6+-->
  <text>{{flag1 && flag2}}</text>      <!-- 输出：false 6+-->
  <text>{{flag1 || flag2}}</text>      <!-- 输出：true 6+-->
  <text>{{!flag1}}</text>              <!-- 输出：false 6+-->
</div>
```


```json
{
  "data": {
    "content": "Hello World!",
    "key1": "Hello",
    "key2": "World",
    "flag1": true,
    "flag2": false
  }
}
```


>  **说明：**
>  - key值支持对象操作符和数组操作符，如{{key.value}}、{{key[0]}}。
>
>  - 从 API Version 6 开始支持字符串拼接、逻辑运算和三元表达式。
>   - 字符串拼接：
>      - 支持变量跟变量：{{key1}}{{key2}}等
>      - 支持常量跟变量： "my name is {{name}}， i am from {{city}}."    "key1 {{key1}}"
>   - 逻辑运算：
>      - 与：{{flag1 &amp;&amp; flag2}}（仅支持两个boolean变量间的与）
>      - 或：{{flag1 || flag2}} （仅支持两个boolean变量间的或）
>      - 非：{{!flag1}} （仅支持boolean变量的非运行）
>   - 三元表达式
>      - {{flag? key1:key2}}（flag为boolean变量，key1和key2可以是变量，也可以是常量）
>   - 注意事项
>      - 非boolean类型值进行bool运算默认为false
>      - 以上所有变量解析跟运算解析均不支持嵌套

## 事件绑定

卡片仅支持click通用事件，事件的定义只能是直接命令式，事件定义必须包含action字段，用以说明事件类型。卡片支持两种事件类型：跳转事件(router)和消息事件(message)。跳转事件可以跳转到卡片提供方的OpenHarmony应用，消息事件可以将开发者自定义信息传递给卡片提供方。事件参数支持变量，变量以"{{}}"修饰。跳转事件中若定义了params字段，则在被拉起应用的onStart的intent中，可用"params"作为key将跳转事件定义的params字段的值取到。

- 跳转事件格式

  通过定义ability名称和携带的参数字段params直接跳转，可用"params"作为key提取到跳转事件定义的params字段值。

  | 选择器         | 样例     | 默认值      | 样例描述                                     |
  | ----------- | ------ | -------- | ---------------------------------------- |
  | action      | string | "router" | 事件类型。<br/>- "router"：用于应用跳转。<br/>- "message"：自定义点击事件。 |
  | abilityName | string | -        | 跳转ability名。                              |
  | params      | Object | -        | 跳转应用携带的额外参数。                             |


  ```json
  {
    "data": {
      "mainAbility": "xxx.xxx.xxx"
    },
    "actions": {
      "routerEvent": { 
        "action": "router",
        "abilityName": "{{mainAbility}}",
        "params":{}
      } 
    }
  }
  ```

   也可以使用want格式绑定参数跳转到目标应用，want定义了ability名称、包名、携带的参数字段等。

  | 选择器    | 类型     | 默认值      | 样例描述                                     |
  | ------ | ------ | -------- | ---------------------------------------- |
  | action | string | "router" | 事件类型。<br>- "router"：用于应用跳转。<br>- "message"：自定义点击事件。 |
  | want   | Object | -        | 跳转目标应用的信息，参考want格式表。                     |

    **表1** want格式

  | 选择器         | 类型                   | 默认值          | 样例描述                                     |
  | ----------- | -------------------- | ------------ | ---------------------------------------- |
  | bundleName  | string               | -            | 表示包描述。如果在Want中同时指定了BundleName和AbilityName，则Want可以直接匹配到指定的Ability。 |
  | abilityName | string               | -            | 表示待启动的Ability名称。                         |
  | action      | string               | -            | 表示action选项描述。                            |
  | uri         | string               | -            | 表示Uri描述。如果在Want中指定了Uri，则Want将匹配指定的Uri信息，包括scheme, schemeSpecificPart, authority和path信息。 |
  | type        | string               | "text/plain" | 表示MIME type类型描述，比如："text/plain" 、 "image/*"等。 |
  | flags       | number               | -            | 表示处理Want的方式。默认传数字，具体参考[flags说明](../apis/js-apis-featureAbility.md#flags说明)。 |
  | entities    | Array\<string>       | -            | 类别，用于指定Intent的操作类别。                      |
  | parameters  | {[key: string]: any} | -            | 表示WantParams描述。                          |


    ```json
  {
      "data": {
        "mainAbility": "xxx.xxx.xxx"
      },
      "actions": {
        "routerEventName1": { 
          "action": "router",
          "want": {
            "bundleName": "com.example.myapplication",
            "abilityName": "com.example.entry.MainAbility"
          }
        },
        "routerEventName2": { 
          "action": "router",
          "want": {
            "action": "xxx.intent.action.DIAL",
            "uri": "tel:12345678"
          }
        }  
      }
    }
    ```

    在API Version 8，want参数需要在app.js或app.ets文件的onCreate方法中调用[featureAbility.getWant](../apis/js-apis-featureAbility.md)接口接收相关参数。

- 消息事件格式

  | 选择器    | 样例     | 默认值     | 样例描述         |
  | ------ | ------ | ------- | ------------ |
  | action | string | message | 表示事件类型。      |
  | params | Object | -       | 跳转应用携带的额外参数。 |


  ```json
  {
    "actions": {
      "activeEvent": { 
        "action": "message",
        "params": {}           
      } 
    }
  }
  ```

- 绑定路由事件和消息事件

  ```html
  <!-- xxx.hml --> 
  <div> 
    <!-- 正常格式 --> 
    <div onclick="activeEvent"></div> 
    <!-- 缩写 --> 
    <div @click="activeEvent"></div> 
  </div>
  ```


## 列表渲染


```html
<!-- xxx.hml -->
<div class="array-container">
  <!-- div列表渲染 -->
  <!-- 默认$item代表数组中的元素, $idx代表数组中的元素索引 -->
  <div for="{{array}}" tid="id">
    <text>{{$item.name}}</text>
  </div>
  <!-- 自定义元素变量名称 -->
  <div for="{{value in array}}" tid="id">    
    <text>{{value.name}}</text>
  </div>
  <!-- 自定义元素变量、索引名称 -->
  <div for="{{(index, value) in array}}" tid="id">    
    <text>{{value.name}}</text>
  </div>
</div>
```


```json
{
  "data": {
    "array": [
      {"id": 1, "name": "jack", "age": 18},
      {"id": 2, "name": "tony", "age": 18}
    ]
  }
}
```

tid属性主要用来加速for循环的重渲染，旨在列表中的数据有变更时，提高重新渲染的效率。tid属性是用来指定数组中每个元素的唯一标识，如果未指定，数组中每个元素的索引为该元素的唯一id。例如上述tid="id"表示数组中的每个元素的id属性为该元素的唯一标识。for循环支持的写法如下：

- for="array"：其中array为数组对象，array的元素变量默认为$item。

- for="v in array"：其中v为自定义的元素变量，元素索引默认为$idx。

- for="(i, v) in array"：其中元素索引为i，元素变量为v，遍历数组对象array。

>  **说明：**
>  - 数组中的每个元素必须存在tid指定的数据属性，否则运行时可能会导致异常。
>
>  - 数组中被tid指定的属性要保证唯一性，如果不是则会造成性能损耗。比如，示例中只有id和name可以作为tid字段，因为它们属于唯一字段。
>
>  - tid不支持表达式。
>
>  - 不支持for嵌套使用。
>
>  - for对应的变量数组，当前要求数组中的object是相同类型，不支持多种object类型混合写在一个数组中。


## 条件渲染

条件渲染分为2种：if/elif/else和show。

当使用if/elif/else写法时，节点必须是兄弟节点，否则编译无法通过。实例如下：


```html
<!-- xxx.hml -->
<div>
  <text if="{{show}}"> Hello-TV </text>
  <text elif="{{display}}"> Hello-Wearable </text>
  <text else> Hello-World </text>
</div>
```


```json
{
  "data": {
    "show": false,
    "display": true
  }
}
```

当show为真时，节点正常渲染；当show为假时，节点不渲染，效果等同display样式为none。


```html
<!-- xxx.hml -->
<text show="{{visible}}"> Hello World </text>
```


```json
{
  "data": {
    "visible": false
  }
}
```


## 逻辑控制块

&lt;block&gt;控制块使得循环渲染和条件渲染变得更加灵活；block在构建时不会被当作真实的节点编译。block标签只支持if属性。


```html
<!-- xxx.hml --> 
<div> 
  <block if="{{show}}"> 
    <text>Hello</text> 
    <text>World</text> 
  </block>
</div>
```


```json
{ 
  "data": { 
    "show": true
  } 
}
```
