# 设计自检表


设计自检表详细列举出了在全场景设备设计和开发过程中应当注意的设计规则，这将帮助应用减少用户舆情且提升用户体验的一致性。


自检表的要求范围分为“必选”与“推荐”两类。必选类一般为已总结出的较优解决方案或效果，表示相关设计需要按照此原则统一执行；推荐类指可能受应用品牌风格或业务特殊性影响，可适量做出修改。

请参考以下表格范围内提出的要求对应用进行检查。

| **类型** | **条目**           | **说明**                                                     |
| -------- | ------------------ | ------------------------------------------------------------ |
| 应用架构 | 导航结构           | 保证同一应用/服务在各设备上导航结构一致。                    |
|          | 界面框架           | 尽量使用推荐的常用界面架构，以更好达到一多效果。             |
| 布局     | 自适应布局         | 关注布局标注是否逻辑合理，是否具备自适应能力。保证在不同尺寸和分辨率的设备上能够无错位/不截断/不变形地正常显示。 |
|          | 响应式布局         | 关注布局是否更有效利用屏幕控件，是否具备响应式能力。保证在不同尺寸和分辨率的设备上不过多空白（50%以上）/不过于拥挤（间距小于16vp，明显截断）。 |
|          | 页面结构           | 尽量使用推荐的常用页面结构，以更好达到一多效果。             |
|          | 页面结构优化       | 在通用能力不适用业务诉求时，进行页面特殊优化，保证在具体设备上的使用体验。 |
| 人机交互 | 输入方式           | 需保证在各设备上完整支持触摸、鼠标、触控、键盘、遥控器、摇杆等交互方式，并符合标准定义。 |
|          | 交互归一           | 应使用系统提供的控件以达到一致的交互体验。如有定制，需保证在各场景下，不同输入设备上的操作与指南要求一致。需特别注意鼠标行为。 |
| 视觉风格 | 单位               | 用于界面布局的单位应全部使用vp。只针对严格控制元素尺寸的场景使用px。 |
|          | 色彩               | 用于色彩的赋值应使用分层参数。推荐支持深色模式，需保证界面在系统切换色彩模式时没有识别性问题。 |
|          | 字体               | 尽量使用fp为文字大小单位，需要响应系统大字体模式，确保系统调节字体大小后，界面字体能响应变化大小，并且界面布局没有出现布局错乱问题。 |
| 多态控件 | 支持常用的控件状态 | 确保控件不同状态下的视觉效果没有缺失。控件的常用状态有：正常态、不可用态、点击态、获焦态、激活态、悬停态。 |