# label<a name="EN-US_TOPIC_0000001127284880"></a>

The  **<label\>**  component defines labels for the  **<input\>**,  **<button\>**, and  **<textarea\>**  components. When a label is clicked, the click effect of the component associated with the label will be triggered.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Component<a name="s0cb8fdf50d8a4f78a86bb76deec468fc"></a>

Not supported

## Attributes<a name="s6c8b111b1d2e40b3b356f03389dad9cf"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row113619414438"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1740035114313"><a name="p1740035114313"></a><a name="p1740035114313"></a>target</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1640018514431"><a name="p1640018514431"></a><a name="p1640018514431"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p15400354439"><a name="p15400354439"></a><a name="p15400354439"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p2040015534315"><a name="p2040015534315"></a><a name="p2040015534315"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p140018514433"><a name="p140018514433"></a><a name="p140018514433"></a>Attribute ID of the target component.</p>
</td>
</tr>
</tbody>
</table>

## Styles<a name="s5ed16ca4a52b4f8eb4c1a1e04ea9c2c4"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table1066211279710"></a>
<table><thead align="left"><tr id="row46621427876"><th class="cellrowborder" valign="top" width="23.11768823117688%" id="mcps1.1.6.1.1"><p id="p146621527278"><a name="p146621527278"></a><a name="p146621527278"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20.477952204779523%" id="mcps1.1.6.1.2"><p id="p116628273714"><a name="p116628273714"></a><a name="p116628273714"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="8.869113088691131%" id="mcps1.1.6.1.3"><p id="p1966212272710"><a name="p1966212272710"></a><a name="p1966212272710"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.519248075192481%" id="mcps1.1.6.1.4"><p id="p966211271973"><a name="p966211271973"></a><a name="p966211271973"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="40.01599840015999%" id="mcps1.1.6.1.5"><p id="p96621527270"><a name="p96621527270"></a><a name="p96621527270"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1566214278715"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p2066212271673"><a name="p2066212271673"></a><a name="p2066212271673"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p36638271178"><a name="p36638271178"></a><a name="p36638271178"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p36631727171"><a name="p36631727171"></a><a name="p36631727171"></a>#e5000000</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1666313271878"><a name="p1666313271878"></a><a name="p1666313271878"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p4663132717711"><a name="p4663132717711"></a><a name="p4663132717711"></a>Text color.</p>
</td>
</tr>
<tr id="row12663102710714"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1666310276712"><a name="p1666310276712"></a><a name="p1666310276712"></a>font-size</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p156641127174"><a name="p156641127174"></a><a name="p156641127174"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p196646273713"><a name="p196646273713"></a><a name="p196646273713"></a>30px</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p766452710718"><a name="p766452710718"></a><a name="p766452710718"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1766413271577"><a name="p1766413271577"></a><a name="p1766413271577"></a>Font size (px).</p>
</td>
</tr>
<tr id="row0664127878"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p11664112715710"><a name="p11664112715710"></a><a name="p11664112715710"></a>allow-scale</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p86643271179"><a name="p86643271179"></a><a name="p86643271179"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p56642027677"><a name="p56642027677"></a><a name="p56642027677"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p8665127678"><a name="p8665127678"></a><a name="p8665127678"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p566517271977"><a name="p566517271977"></a><a name="p566517271977"></a>Whether the text size changes with the system's font size settings.</p>
<div class="note" id="note166651727377"><a name="note166651727377"></a><a name="note166651727377"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p96651327075"><a name="p96651327075"></a><a name="p96651327075"></a>For details about how to make the configuration take effect dynamically, see the <strong id="b140963492841533"><a name="b140963492841533"></a><a name="b140963492841533"></a>config-changes</strong> attribute in the <strong id="b40058943041533"><a name="b40058943041533"></a><a name="b40058943041533"></a>config.json</strong> file.</p>
</div></div>
</td>
</tr>
<tr id="row96651127874"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p966532714714"><a name="p966532714714"></a><a name="p966532714714"></a>letter-spacing</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p26651427176"><a name="p26651427176"></a><a name="p26651427176"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p866516277712"><a name="p866516277712"></a><a name="p866516277712"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p15665122712718"><a name="p15665122712718"></a><a name="p15665122712718"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p176651271078"><a name="p176651271078"></a><a name="p176651271078"></a>Character spacing (px).</p>
</td>
</tr>
<tr id="row1266517271779"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p8666192719720"><a name="p8666192719720"></a><a name="p8666192719720"></a>font-style</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p06663271679"><a name="p06663271679"></a><a name="p06663271679"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p66668271711"><a name="p66668271711"></a><a name="p66668271711"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1966622718710"><a name="p1966622718710"></a><a name="p1966622718710"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p156661927476"><a name="p156661927476"></a><a name="p156661927476"></a>Font style. Available values are as follows:</p>
<a name="ul16666271173"></a><a name="ul16666271173"></a><ul id="ul16666271173"><li><strong id="b83400171541533"><a name="b83400171541533"></a><a name="b83400171541533"></a>normal</strong>: standard font style</li><li><strong id="b38004254941533"><a name="b38004254941533"></a><a name="b38004254941533"></a>italic</strong>: italic font style</li></ul>
</td>
</tr>
<tr id="row12666127173"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p2066662710710"><a name="p2066662710710"></a><a name="p2066662710710"></a>font-weight</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p366612271275"><a name="p366612271275"></a><a name="p366612271275"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p136664271275"><a name="p136664271275"></a><a name="p136664271275"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p366672716711"><a name="p366672716711"></a><a name="p366672716711"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1966612271713"><a name="p1966612271713"></a><a name="p1966612271713"></a>Font width. For the number type, the value ranges from 100 to 900. The default value is 400. A larger value indicates a larger font width.</p>
<div class="note" id="note36663271078"><a name="note36663271078"></a><a name="note36663271078"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p20666132718711"><a name="p20666132718711"></a><a name="p20666132718711"></a>The value must be an integer multiple of 100.</p>
</div></div>
<p id="p5666182717710"><a name="p5666182717710"></a><a name="p5666182717710"></a>The value of the string type can be <strong id="b132902811341533"><a name="b132902811341533"></a><a name="b132902811341533"></a>lighter</strong>, <strong id="b70405315341533"><a name="b70405315341533"></a><a name="b70405315341533"></a>normal</strong>, <strong id="b21613477941533"><a name="b21613477941533"></a><a name="b21613477941533"></a>bold</strong>, or <strong id="b161719670941533"><a name="b161719670941533"></a><a name="b161719670941533"></a>bolder</strong>.</p>
</td>
</tr>
<tr id="row766612271976"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p196661427579"><a name="p196661427579"></a><a name="p196661427579"></a>text-decoration</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p86662271373"><a name="p86662271373"></a><a name="p86662271373"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p066742714719"><a name="p066742714719"></a><a name="p066742714719"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p46671227774"><a name="p46671227774"></a><a name="p46671227774"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p166715271479"><a name="p166715271479"></a><a name="p166715271479"></a>Text decoration. Available values are as follows:</p>
<a name="ul2667127575"></a><a name="ul2667127575"></a><ul id="ul2667127575"><li><strong id="b81406780441533"><a name="b81406780441533"></a><a name="b81406780441533"></a>underline</strong>: An underline is used.</li><li><strong id="b83360459041533"><a name="b83360459041533"></a><a name="b83360459041533"></a>line-through</strong>: A strikethrough is used.</li><li><strong id="b155693540941533"><a name="b155693540941533"></a><a name="b155693540941533"></a>none</strong>: The standard text is used.</li></ul>
</td>
</tr>
<tr id="row2066710275712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p206671427577"><a name="p206671427577"></a><a name="p206671427577"></a>text-align</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p166713271273"><a name="p166713271273"></a><a name="p166713271273"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1366722713718"><a name="p1366722713718"></a><a name="p1366722713718"></a>start</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1366782713713"><a name="p1366782713713"></a><a name="p1366782713713"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p106677271479"><a name="p106677271479"></a><a name="p106677271479"></a>Text alignment mode. Available values are as follows:</p>
<a name="ul1466712710712"></a><a name="ul1466712710712"></a><ul id="ul1466712710712"><li><strong id="b68270085441533"><a name="b68270085441533"></a><a name="b68270085441533"></a>left</strong>: The text is left-aligned.</li><li><strong id="b159806762441533"><a name="b159806762441533"></a><a name="b159806762441533"></a>center</strong>: The text is center-aligned.</li><li><strong id="b169036087341533"><a name="b169036087341533"></a><a name="b169036087341533"></a>right</strong>: The text is right-aligned.</li><li><strong id="b195938376541533"><a name="b195938376541533"></a><a name="b195938376541533"></a>start</strong>: The text is aligned with the direction in which the text is written.</li><li><strong id="b73543552641533"><a name="b73543552641533"></a><a name="b73543552641533"></a>end</strong>: The text is aligned with the opposite direction in which the text is written. </li></ul>
<div class="note" id="note3668172719712"><a name="note3668172719712"></a><a name="note3668172719712"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p366818278713"><a name="p366818278713"></a><a name="p366818278713"></a>If the text width is not specified, the alignment effect may not be obvious when the text width is the same as the width of the parent container. </p>
</div></div>
</td>
</tr>
<tr id="row1666814271174"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p466814271271"><a name="p466814271271"></a><a name="p466814271271"></a>line-height</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p46686271711"><a name="p46686271711"></a><a name="p46686271711"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1866816277720"><a name="p1866816277720"></a><a name="p1866816277720"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p866814273713"><a name="p866814273713"></a><a name="p866814273713"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p126682027579"><a name="p126682027579"></a><a name="p126682027579"></a>Text line height. When this parameter is set to <strong id="b90821727741533"><a name="b90821727741533"></a><a name="b90821727741533"></a>0px</strong>, the text line height is not limited and the font size is adaptive.</p>
</td>
</tr>
<tr id="row16688275710"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p7668102717718"><a name="p7668102717718"></a><a name="p7668102717718"></a>text-overflow</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p1166816271176"><a name="p1166816271176"></a><a name="p1166816271176"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1466832717712"><a name="p1466832717712"></a><a name="p1466832717712"></a>clip</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p8668527276"><a name="p8668527276"></a><a name="p8668527276"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p116681327179"><a name="p116681327179"></a><a name="p116681327179"></a><span id="p5a4b24dbf2784092965d788cce471596"><a name="p5a4b24dbf2784092965d788cce471596"></a><a name="p5a4b24dbf2784092965d788cce471596"></a>Takes effect when the maximum number of lines is specified. </span>Available values are as follows:</p>
<a name="ul1668162716714"></a><a name="ul1668162716714"></a><ul id="ul1668162716714"><li><strong id="b8200292041533"><a name="b8200292041533"></a><a name="b8200292041533"></a>clip</strong>: The text is clipped and displayed based on the size of the parent container.</li><li><strong id="b159529937541533"><a name="b159529937541533"></a><a name="b159529937541533"></a>ellipsis</strong>: The text is displayed based on the size of the parent container. The text that cannot be displayed is replaced with ellipsis. This style must be used together with <strong id="b212203499741533"><a name="b212203499741533"></a><a name="b212203499741533"></a>max-lines</strong>.</li></ul>
</td>
</tr>
<tr id="row1066915272078"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1466914271711"><a name="p1466914271711"></a><a name="p1466914271711"></a>font-family</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p566920276718"><a name="p566920276718"></a><a name="p566920276718"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1366916271715"><a name="p1366916271715"></a><a name="p1366916271715"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1866982718716"><a name="p1866982718716"></a><a name="p1866982718716"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p56695278715"><a name="p56695278715"></a><a name="p56695278715"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font that exists in the system or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> in the family is selected as the font for the text. </p>
</td>
</tr>
<tr id="row20670142717711"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p967019271873"><a name="p967019271873"></a><a name="p967019271873"></a>max-lines</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p6670927478"><a name="p6670927478"></a><a name="p6670927478"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p156701327474"><a name="p156701327474"></a><a name="p156701327474"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p86701527470"><a name="p86701527470"></a><a name="p86701527470"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p567016271173"><a name="p567016271173"></a><a name="p567016271173"></a>Maximum number of lines in the text.</p>
</td>
</tr>
<tr id="row96703271573"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p867018271277"><a name="p867018271277"></a><a name="p867018271277"></a>min-font-size</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p106711627870"><a name="p106711627870"></a><a name="p106711627870"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p5671142714711"><a name="p5671142714711"></a><a name="p5671142714711"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p16711827779"><a name="p16711827779"></a><a name="p16711827779"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p467152714715"><a name="p467152714715"></a><a name="p467152714715"></a>Minimum font size in the text. This style must be used together with <strong id="b107353746741533"><a name="b107353746741533"></a><a name="b107353746741533"></a>max-font-size</strong>. The font size can be changed dynamically. After the maximum and minimum font sizes are set, <strong id="b116057394841533"><a name="b116057394841533"></a><a name="b116057394841533"></a>font-size</strong> does not take effect.</p>
</td>
</tr>
<tr id="row8671427875"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p7671627270"><a name="p7671627270"></a><a name="p7671627270"></a>max-font-size</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p367132713718"><a name="p367132713718"></a><a name="p367132713718"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p56711527973"><a name="p56711527973"></a><a name="p56711527973"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p167192710715"><a name="p167192710715"></a><a name="p167192710715"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p56711927074"><a name="p56711927074"></a><a name="p56711927074"></a>Maximum font size in the text. This style must be used together with <strong id="b141713431641533"><a name="b141713431641533"></a><a name="b141713431641533"></a>min-font-size</strong>. The font size can be changed dynamically. After the maximum and minimum font sizes are set, <strong id="b130346143141533"><a name="b130346143141533"></a><a name="b130346143141533"></a>font-size</strong> does not take effect.</p>
</td>
</tr>
<tr id="row56715276716"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p3671162714713"><a name="p3671162714713"></a><a name="p3671162714713"></a>font-size-step</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p66721027579"><a name="p66721027579"></a><a name="p66721027579"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p967218271371"><a name="p967218271371"></a><a name="p967218271371"></a>1px</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p116725271975"><a name="p116725271975"></a><a name="p116725271975"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1767210271875"><a name="p1767210271875"></a><a name="p1767210271875"></a>Step for dynamically adjusting the font size in the text. The minimum and maximum font sizes must be set.</p>
</td>
</tr>
<tr id="row5672122720713"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p136729271873"><a name="p136729271873"></a><a name="p136729271873"></a>prefer-font-sizes</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p367222719714"><a name="p367222719714"></a><a name="p367222719714"></a>&lt;array&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1167212719720"><a name="p1167212719720"></a><a name="p1167212719720"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p56724271375"><a name="p56724271375"></a><a name="p56724271375"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1167292716713"><a name="p1167292716713"></a><a name="p1167292716713"></a>Preset preferred font sizes. For dynamic font size adjustment, the preset sizes are used to match the maximum number of lines in the text. If the preferred font sizes were not set, the font size will be adjusted based on the maximum and minimum font sizes and the step you have set. If the maximum number of lines in the text cannot be met, <strong id="b191381972441533"><a name="b191381972441533"></a><a name="b191381972441533"></a>text-overflow</strong> is used to truncate the text. If this parameter is set, <strong id="b198803051641533"><a name="b198803051641533"></a><a name="b198803051641533"></a>font-size</strong>, <strong id="b39764528141533"><a name="b39764528141533"></a><a name="b39764528141533"></a>max-font-size</strong>, <strong id="b87795574141533"><a name="b87795574141533"></a><a name="b87795574141533"></a>min-font-size</strong>, and <strong id="b138745821741533"><a name="b138745821741533"></a><a name="b138745821741533"></a>font-size-step</strong> do not take effect.</p>
<p id="p146730271171"><a name="p146730271171"></a><a name="p146730271171"></a>Example values: <strong id="b585484815435"><a name="b585484815435"></a><a name="b585484815435"></a>12px,14px,16px</strong></p>
</td>
</tr>
</tbody>
</table>

## Events<a name="section57301035448"></a>

Not supported

## Methods<a name="section340215162812"></a>

Not supported

## Example Code<a name="section1018514431132"></a>

```
<!--xxx.hml -->
<div class="container">
  <div class="row">
    <label class="label" target="textId">input</label>
    <input class="input" id="textId" type="text"></input>
  </div>
  <div class="row">
    <label class="label" target="radioId">radio</label>
    <input class="input" id="radioId" type="radio" name="group" value="group"></input>
  </div>
  <div class="row">
    <label class="label" target="checkboxId">checkbox</label>
    <input class="input" id="checkboxId" type="checkbox"></input>
  </div>
</div>
```

```
/*xxx.css */
.container {
  flex-direction: column;
  align-items: center;
}
.row {
  flex-direction: row;
}
.label {
  width: 200px;
  margin-top: 50px;
}
.input {
  margin-left: 100px;
  margin-top: 50px;
}
```

![](figures/en-us_image_0000001152834002.png)

