# 测试子系统<a name="ZH-CN_TOPIC_0000001050883540"></a>

-   [简介](#section7375710115617)
-   [目录](#section102031353175317)
-   [约束](#section87444710110)
-   [安装](#section1347156474)
-   [编写测试用例](#section125411936102918)
-   [使用测试框架](#section75882026185016)
-   [测试结果与日志](#section414715805819)
-   [涉及仓](#section6299103515474)

## 简介<a name="section7375710115617"></a>

开发者基于系统新增特性可以通过开发者自己开发用例保证，对于系统已有特性的修改，也可通过修改项目中原有的测试用例保证，开发者测试旨在帮助开发者在开发阶段就能开发出高质量代码。

## 目录<a name="section102031353175317"></a>

```
test/
├── developertest             # 开发者测试框架
│   ├── aw                   # 测试框架的静态库
│   ├── config               # 测试框架配置
│   ├── examples             # 测试用例示例
│   ├── src                  # 测试框架源码
│   ├── third_party          # 测试框架依赖第三方组件适配
│   ├── start.bat            # 开发者测试入口（Windows）
│   ├── start.sh             # 开发者测试入口（Linux）
│   └── BUILD.gn             # 测试框架编译入口
├── xdevice                   # 测试框架基础组件
│   ├── config               # 框架配置文件
│   ├── extension            # 基础组件扩展仓
│   ├── resource             # 基础组件测试资源
│   └── src                  # 基础组件源码
└── xts                       # XTS认证套件
```

## 约束<a name="section87444710110"></a>

测试工具环境依赖

1.  python版本\>=3.7.5
2.  paramiko版本\>=2.7.1
3.  setuptools版本\>=40.8.0
4.  rsa版本\>=4.0
5.  NFS版本\>=V4，设备不支持hdc连接，支持串口时使用
6.  pyserial版本\>=3.3，设备不支持hdc连接，支持串口时使用
7.  运行操作系统：Windows版本\>=Win10，Linux为Ubuntu18.04

## 安装<a name="section1347156474"></a>

-   依赖python环境：
    1.  安装Linux扩展组件readline，

        执行如下命令如下：

        ```
        sudo apt-get install libreadline-dev
        ```

        安装成功提示

        ```
        Reading package lists... Done
        Building dependency tree
        Reading state information... Done
        libreadline-dev is already the newest version (7.0-3).
        0 upgraded, 0 newly installed, 0 to remove and 11 not upgraded.
        ```

    2.  安装setuptools插件，安装命令如下：

        ```
        pip3 install setuptools
        ```

        安装成功提示如下：

        ```
        Requirement already satisfied: setuptools in d:\programs\python37\lib\site-packages (41.2.0)
        ```

    3.  安装paramiko插件，安装命令如下：

        ```
        pip3 install paramiko
        ```

        安装成功提示如下：

        ```
        Installing collected packages: pycparser, cffi, pynacl, bcrypt, cryptography, paramiko
        Successfully installed bcrypt-3.2.0 cffi-1.14.4 cryptography-3.3.1 paramiko-2.7.2 pycparser-2.20 pynacl-1.4.0
        ```

    4.  安装python的rsa插件，安装命令如下：

        ```
        pip3 install rsa
        ```

        安装成功截图如下：

        ```
        Installing collected packages: pyasn1, rsa
        Successfully installed pyasn1-0.4.8 rsa-4.7
        ```

    5.  需要本地的python安装串口插件pyserial，安装命令如下：

        ```
        pip3 install pyserial
        ```

        安装成功提示如下：

        ```
        Requirement already satisfied: pyserial in d:\programs\python37\lib\site-packages\pyserial-3.4-py3.7.egg (3.4)
        ```

    6.  如果设备仅支持串口输出测试结果，则需要安装NFS Server

        windows环境下安装，例如安装haneWIN NFS Server1.2.50，下载地址：https://www.hanewin.net/nfs-e.htm。

        Linux环境下安装，安装命令如下：

        ```
        sudo apt install nfs-kernel-server
        ```

        安装成功提示如下：

        ```
        Reading package lists... Done
        Building dependency tree
        Reading state information... Done
        nfs-kernel-server is already the newest version (1:1.3.4-2.1ubuntu5.3).
        0 upgraded, 0 newly installed, 0 to remove and 11 not upgraded.
        ```



## 编写测试用例<a name="section125411936102918"></a>

-   测试用例规范
    -   命名规范

        测试用例源文件名称和测试套内容保持一致，测试套与用例之间关系1:N，测试套与测试源文件之间关系1:1，每个源文件全局唯一，格式：\[特性\]\_\[功能\]\_\[子功能1\]\_\[子功能1.1\]，子功能支持向下细分。

        文件命名采用全小写+下划线方式命名，以test结尾，如demo用例：developertest/examples。

    -   测试用例编码规范

        开发者测试用例原则上与特性代码编码规范保持一致，另外需要添加必要的用例描述信息，详见[•自测试用例模板](#li2069415903917)

    -   测试用例编译配置规范

        测试用例采用GN方式编译，配置遵循本开源项目的编译指导[使用](zh-cn_topic_0000001051580775.md)


-   <a name="li2069415903917"></a>测试用例模板

    详见测试demo用例：developertest/examples。

-   测试用例目录规划

    ```
    subsystem    # 子系统，系统组件
    ├── part    # 部件
    │     └── test    # 模块测试目录
    │             └── unittest    # 单元测试
    │                    ├── common    # 公共用例
    │                    ├── liteos    # 仅liteos核用例
    │                    └── linux     # 仅Linux核用例
    │             └── moduletest    # 模块测试
    │                    ├── common
    │                    ├── liteos
    │                    └── linux
    └── test    # 子系统测试目录
           └── unittest    # 单元测试
                 ├── common
                 ├── liteos
                 ├── linux
           └── moduletest    # 模块测试
                 ├── common
                 ├── liteos
                 ├── linux
    
    ```

    >![](public_sys-resources/icon-note.gif) **说明：** 
    >其中liteos和Linux仅不同设备形态举例，对于同一特性在不同开发板上，如果用例没有差异，则用例放置common目录下，如果同一特性，用例区分不同设备形态，可能包含内核差异，芯片平台差异，则用例以目录区分。

-   编写测试用例步骤
    1.  添加测试用例文件头注释信息。
    2.  引用gtest头文件和ext命名空间。
    3.  添加被测试类的头文件。
    4.  定义测试套（测试类）。
    5.  实现该测试套具体的测试用例，包括用例注释和用例逻辑实现。
    6.  编写测试用例编译配置。

        >![](public_sys-resources/icon-note.gif) **说明：** 
        >\*样例参考：
        >仅支持串口设备形态编译示例：developertest/examples/lite/cxx\_demo/test/unittest/common/calc\_subtraction\_test.cpp。
        >支持hdc连接的设备形态编译示例：developertest/examples/calculator/test/unittest/common/calculator\_add\_test.cpp。
        >注意点如下：
        >a、SetUp & TearDown是针对该测试套下每条用例执行前和执行后的处理逻辑。
        >b、SetUpTestCase & TearDownTestCase是针对该测试套下所有用例执行前和执行后的处理逻辑。
        >c、HWTEST的使用：特点：只适合做简单测试（执行不依赖Setup & Teardown）缺点：多个测试场景需要相同数据配置的情况不适用，测试用例之间可能相互影响，不具备独立性。
        >d、使用printf函数打印日志。


-   编写测试用例编译文件
    -   定义测试用例编译构建目标
        1.  添加测试用例编译文件头注释信息。
        2.  导入测试用例编译模板文件。
        3.  指定测试用例文件的输出路径。
        4.  配置测试用例编译依赖包含目录。
        5.  指定测试用例编译目标输出的文件名称。
        6.  编写具体的测试用例编译脚本（添加需要参与编译的源文件、配置和依赖 ）。
        7.  对目标测试用例文件进行条件分组（分组名称固定为：unittest/moduletest\)。

    -   如果存在多个测试套，定义公共编译配置。
    -   将测试用例添加到构建系统中。

        >![](public_sys-resources/icon-note.gif) **说明：** 
        >\*样例参考：
        >1、仅支持串口设备形态编译示例：
        >用例编译配置：developertest/examples/lite/cxx\_demo/test/unittest/common/BUILD.gn
        >编译入口配置：developertest/examples/lite/BUILD.gn
        >2、支持hdc连接的设备形态编译示例：
        >用例编译配置：developertest/examples/calculator/test/unittest/common/BUILD.gn
        >编译入口配置：developertest/examples/ohos.build


-   测试用例级别定义
    -   基本（Level1）
    -   重要（Level2）
    -   一般（Level3）
    -   生僻（Level4）


## 使用测试框架<a name="section75882026185016"></a>

-   安装xdevice基础框架
    1.  以Windows环境为例，打开xdevice安装目录：test/xdevice。
    2.  打开控制台窗口，执行如下命令：

        ```
        python setup.py install
        ```

        安装成功提示如下：

        ```
        Installed d:\programs\python37\lib\site-packages\xdevice-0.0.0-py3.7.egg
        Processing dependencies for xdevice==0.0.0
        Finished processing dependencies for xdevice==0.0.0
        ```


-   修改developertest组件配置
    1.  支持hdc连接的被测设备。

        \[device\]    \# 配置标签为usb-hdc的环境信息，测试设备的IP地址和hdc映射的端口号，例如：

        ```
        <device type="usb-hdc">
            <ip>192.168.1.1</ip>
            <port>9111</port>
            <sn></sn>
        </device>
        ```

    2.  仅支持串口的被测设备。

        \[device\]    \# 配置标签为ipcamera的串口信息，COM口和波特率，例如：

        ```
        <device type="com" label="ipcamera">
            <serial>
                <com>COM1</com>
                <type>cmd</type>
                <baud_rate>115200</baud_rate>
                <data_bits>8</data_bits>
                <stop_bits>1</stop_bits>
                <timeout>1</timeout>
            </serial>
        </device>
        ```


    -   修改developertest组件配置。可选，如果测试用例已完成编译，可以直接指定测试用例的编译输出路径，测试平台执行测试用例时即不会重新编译测试用例。

        文件：config/user\_config.xml。

        1.  \[test\_cases\]    \# 指定测试用例的输出路径，编译输出目录，例如：

            ```
            <test_cases>
                <dir>/home/source_code/out/release/tests</dir>
            </test_cases>
            ```

        2.  \[NFS\]    \# 被测设备仅支持串口时配置，指定NFS的映射路径，host\_dir为PC侧的NFS目录，board\_dir为板侧创建的目录，例如：

            ```
            <NFS>
                <host_dir>D:\nfs</host_dir>
                <board_dir>user</board_dir>
            </NFS>
            ```



-   执行测试用例前的环境检查
    -   系统镜像与文件系统已烧录进开发板，开发板上系统正常运行，在系统模式下，如shell登录时设备提示符OHOS\#。
    -   开发主机和开发板串口连接正常，网口连接正常。
    -   开发主机IP与开发板IP处在同一小网网段，相互可以ping通。
    -   开发主机侧创建空目录用于开发板通过NFS挂载测试用例，并且NFS服务启动正常。

-   运行测试套
    -   启动测试框架，打开test/developertest目录。
        1.  Windows环境启动测试框架

            ```
            start.bat
            ```

        2.  Linux环境启动测试框架

            ```
            ./strat.sh
            ```


    -   设备形态选择

        根据实际的开发板选择，设备形态配置：developertest/config/framework\_config.xml。

    -   执行测试指令
        1.  查询测试用例支持的子系统，模块，产品形态以及测试类型，使用show命令。

            ```
            usage: 
                show productlist      Querying Supported Product Forms
                show typelist         Querying the Supported Test Type
                show subsystemlist    Querying Supported Subsystems
                show modulelist       Querying Supported Modules
            ```

        2.  执行测试指令示例，其中-t为必选，-ss和-tm为可选字段。

            ```
            run -t ut -ss test -tm example
            ```

        3.  参数说明：指定参数可以执行特定特性、模块对应的测试套。

            ```
            usage: run [-h] [-p PRODUCTFORM] [-t [TESTTYPE [TESTTYPE ...]]]
                [-ss SUBSYSTEM] [-tm TESTMODULE] [-ts TESTSUIT]
                [-tc TESTCASE] [-tl TESTLEVEL] 
            
            optional arguments:
                -h, --help            show this help message and exit
                -p PRODUCTFORM, --productform PRODUCTFORM    Specified product form
                -t [TESTTYPE [TESTTYPE ...]], --testtype [TESTTYPE [TESTTYPE ...]]
                    Specify test type(UT,MST,ST,PERF,ALL)
                -ss SUBSYSTEM, --subsystem SUBSYSTEM    Specify test subsystem
                -tm TESTMODULE, --testmodule TESTMODULE    Specified test module
                -ts TESTSUIT, --testsuit TESTSUIT    Specify test suite
                -tc TESTCASE, --testcase TESTCASE    Specify test case
                -tl TESTLEVEL, --testlevel TESTLEVEL    Specify test level
            ```



-   测试框架帮助
    -   帮助指令，用于查询测试平台支持哪些测试指令。

        ```
        help
        ```



-   退出自测试平台
    -   退出自测试平台，使用如下命令退出测试平台。

        ```
        quit
        ```



## 测试结果与日志<a name="section414715805819"></a>

-   通过在测试框架中执行测试指令，即可以生成测试日志和测试报告。
-   测试结果
    -   测试用例的结果会直接显示在控制台上，执行一次的测试结果根路径如下：

        ```
        reports/xxxx-xx-xx-xx-xx-xx
        ```

    -   测试用例格式化结果

        ```
        result/
        ```

    -   测试用例日志

        ```
        log/plan_log_xxxx-xx-xx-xx-xx-xx.log
        ```

    -   测试报告概率

        ```
        summary_report.html
        ```

    -   测试报告详情

        ```
        details_report.html
        ```


-   测试框架日志

    ```
    reports/platform_log_xxxx-xx-xx-xx-xx-xx.log
    ```

-   最近一次测试报告

    ```
    reports/latest
    ```


## 涉及仓<a name="section6299103515474"></a>

**测试子系统**

[test\_developertest](https://gitee.com/openharmony/test_developertest/blob/master/README_zh.md)

[test\_xdevice](https://gitee.com/openharmony/test_xdevice/blob/master/README_zh.md)
